/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.wadmin.viewdata.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.wadmin.viewdata.JDBCTableModelAdapter;
import com.sas.wadmin.viewdata.ViewDataColumnsTab;
import com.sas.wadmin.viewdata.ViewDataFilterTab;
import com.sas.wadmin.viewdata.ViewDataSortTab;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ViewDataQueryOptionsDialog
extends WAPropertyDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataQueryOptionsDialog.class);
    public static final int TAB_SORT = 1;
    public static final int TAB_FILTER = 2;
    public static final int TAB_COLUMNS = 3;
    private JDBCTableModel m_model;
    private ColumnDisplayLabelHelper m_labelHelper;
    private ViewDataSortTab m_sortTab;
    private ViewDataFilterTab m_filterTab;
    private ViewDataColumnsTab m_columnsTab;
    private ArrayList m_queryOptionsActionListeners;
    PropertyChangeListener m_labelChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("DisplayFormat")) {
                ViewDataQueryOptionsDialog.this.m_sortTab.updateColumnLabels();
                ViewDataQueryOptionsDialog.this.m_filterTab.updateColumnLabels();
                ViewDataQueryOptionsDialog.this.m_columnsTab.updateColumnLabels();
            }
        }
    };

    public ViewDataQueryOptionsDialog(JDBCTableModel model, ColumnDisplayLabelHelper labelHelper) {
        super((Frame)Workspace.getWorkspace(), "", false);
        try {
            this.setTitle(bundle.formatString("ViewDataQueryOptionsDialog.Title.fmt.txt", (Object)model.getDataTable().getTableName()));
            this.m_model = model;
            this.m_labelHelper = labelHelper;
            this.m_labelHelper.addPropertyChangeListener(this.m_labelChangeListener);
            this.m_model.addModelListener(new ModelListener());
            this.m_queryOptionsActionListeners = new ArrayList();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void initialize() {
        super.initialize();
        this.setApplyButtonVisible(false);
        this.m_sortTab = new ViewDataSortTab(this.m_model);
        this.m_filterTab = new ViewDataFilterTab(this.m_model);
        this.m_columnsTab = new ViewDataColumnsTab(this.m_model);
        this.m_btnOk.setMnemonic(bundle.getString("ViewDataQueryOptionsDialog.OK.mnem").charAt(0));
        this.m_btnCancel.setMnemonic(bundle.getString("ViewDataQueryOptionsDialog.Cancel.mnem").charAt(0));
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        this.addTab(bundle.getString("ViewDataQueryOptionsDialog.SortTabTitle.txt"), this.m_sortTab);
        this.addTab(bundle.getString("ViewDataQueryOptionsDialog.FilterTabTitle.txt"), this.m_filterTab);
        this.addTab(bundle.getString("ViewDataQueryOptionsDialog.ColumnsTabTitle.txt"), this.m_columnsTab);
    }

    public void show(int tab) {
        this.show();
        switch (tab) {
            case 1: {
                this.showTab(this.m_sortTab);
                break;
            }
            case 2: {
                this.showTab(this.m_filterTab);
                break;
            }
            case 3: {
                this.showTab(this.m_columnsTab);
                break;
            }
            default: {
                this.showTab(this.m_sortTab);
            }
        }
    }

    public void cleanUp() {
        this.m_labelHelper.removePropertyChangeListener(this.m_labelChangeListener);
    }

    protected boolean onOK() {
        if (!super.onOK()) {
            return false;
        }
        boolean hasChanges = false;
        if (this.m_sortTab.hasClauseChanged()) {
            hasChanges = true;
        }
        if (this.m_filterTab.hasClauseChanged()) {
            this.m_filterTab.saveClause();
            hasChanges = true;
        }
        if (this.m_columnsTab.hasDisplayListChanged()) {
            this.m_columnsTab.saveDisplayList();
            hasChanges = true;
        }
        if (hasChanges) {
            this.notifyQueryOptionsActionListeners(null);
        }
        return true;
    }

    protected boolean onCancel() {
        this.m_sortTab.updateFromModel();
        this.m_columnsTab.updateFromModel();
        return super.onCancel();
    }

    public ArrayList getSortByColumns() {
        return this.m_sortTab.getSortByColumns();
    }

    public String getFilterClause() {
        return this.m_filterTab.getFilterClause();
    }

    public int[] getDisplayColumns() {
        return this.m_columnsTab.getSelectedColumns();
    }

    public void addQueryOptionsActionListener(ActionListener listener) {
        this.m_queryOptionsActionListeners.add(listener);
    }

    public void removeQueryOptionsListener(ActionListener listener) {
        this.m_queryOptionsActionListeners.remove(listener);
    }

    public void notifyQueryOptionsActionListeners(ActionEvent e) {
        for (int i = 0; i < this.m_queryOptionsActionListeners.size(); ++i) {
            ((ActionListener)this.m_queryOptionsActionListeners.get(i)).actionPerformed(e);
        }
    }

    protected class ModelListener
    extends JDBCTableModelAdapter {
        protected ModelListener() {
        }

        @Override
        public void fetchStarted() {
            try {
                ViewDataQueryOptionsDialog.this.m_btnOk.setEnabled(false);
                ViewDataQueryOptionsDialog.this.setTitle(bundle.formatString("ViewDataQueryOptionsDialog.FetchingDataTitle.fmt.txt", (Object)ViewDataQueryOptionsDialog.this.m_model.getDataTable().getTableName()));
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        @Override
        public void fetchSuccessful() {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ViewDataQueryOptionsDialog.this.m_sortTab.updateFromModel();
                    ViewDataQueryOptionsDialog.this.m_columnsTab.updateFromModel();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }

        @Override
        public void fetchComplete() {
            try {
                ViewDataQueryOptionsDialog.this.m_btnOk.setEnabled(true);
                ViewDataQueryOptionsDialog.this.setTitle(bundle.formatString("ViewDataQueryOptionsDialog.Title.fmt.txt", (Object)ViewDataQueryOptionsDialog.this.m_model.getDataTable().getTableName()));
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }
}

