/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.viewdata.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata.JDBCExternalTableTableModel;
import com.sas.wadmin.viewdata.JDBCPhysicalTableTableModel;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.wadmin.viewdata.JDBCTableModelAdapter;
import com.sas.wadmin.viewdata.JDBCTableModelException;
import com.sas.wadmin.viewdata.JDBCTableModelListener;
import com.sas.wadmin.viewdata.ViewDataFindComparable;
import com.sas.wadmin.viewdata.ViewDataFindDialog;
import com.sas.wadmin.viewdata.ViewDataQueryOptionsDialog;
import com.sas.wadmin.viewdata.ViewDataTable;
import com.sas.wadmin.visuals.PageScrollPane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsTablePrinter;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;

public class ViewDataPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataPanel.class);
    public static final String PROPERTY_METADATANAME = "ViewData.ShowMetadataNameInColumnHeader";
    public static final String PROPERTY_COLUMNNAME = "ViewData.ShowColumnNameInColumnHeader";
    public static final String PROPERTY_COLUMNDESCRIPTION = "ViewData.ShowDescriptionInColumnHeader";
    public static final String PROPERTY_FORMATTED = "ViewData.ShowFormattedData";
    private DataTable m_dataTable;
    private WsAppServer m_appServer;
    private ViewDataTable m_table;
    private JDBCTableModel m_model;
    private PageScrollPane m_pageScrollPane;
    private ViewDataToolBar m_toolBar;
    private boolean m_modalDialogs = false;
    private ColumnDisplayLabelHelper m_labelHelper;
    private ViewDataFindDialog m_findDialog;
    private ViewDataQueryOptionsDialog m_queryOptionsDialog;
    private RefreshAction m_actRefresh;
    private PageSetupAction m_actPageSetup;
    private PrintAction m_actPrint;
    private ViewDataMenuAction m_actViewDataMenu;
    private GoToRowAction m_actGoToRow;
    private NextPageAction m_actNextPage;
    private PreviousPageAction m_actPreviousPage;
    private FirstPageAction m_actFirstPage;
    private LastPageAction m_actLastPage;
    private FindAction m_actFind;
    private FindNextAction m_actFindNext;
    private SortByColumnsAction m_actSortByColumns;
    private FilterAction m_actFilter;
    private DisplayColumnsAction m_actDisplayColumns;
    private ShowMetadataNameAction m_actShowMetadataName;
    private ShowColumnsNameAction m_actShowColumnsName;
    private ShowDescriptionAction m_actShowDescription;
    private FormattedAction m_actFormatted;
    private boolean m_fetchedCols = false;
    private PropertyChangeListener m_pageNumberChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            int startrow = ViewDataPanel.this.m_model.getRowRange()[0];
            if (startrow != 0) {
                ViewDataPanel.this.m_toolBar.setData("refreshrow", new Integer(startrow));
            }
            if (ViewDataPanel.this.m_model.isFetchDataRunning()) {
                return;
            }
            ViewDataPanel.this.m_actFirstPage.setEnabled(!ViewDataPanel.this.m_table.isAtFirstPage());
            ViewDataPanel.this.m_actPreviousPage.setEnabled(!ViewDataPanel.this.m_table.isAtFirstPage());
            ViewDataPanel.this.m_actNextPage.setEnabled(!ViewDataPanel.this.m_table.isAtLastPage());
            ViewDataPanel.this.m_actLastPage.setEnabled(!ViewDataPanel.this.m_table.isAtLastPage());
        }
    };
    private ActionListener m_findActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.getFindDialog().setVisible(false);
            ViewDataPanel.this.find();
        }
    };
    private ActionListener m_queryOptionsActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String filter = ViewDataPanel.this.getQueryOptionsDialog().getFilterClause();
            int[] displayCols = ViewDataPanel.this.getQueryOptionsDialog().getDisplayColumns();
            ArrayList sortColumns = ViewDataPanel.this.getQueryOptionsDialog().getSortByColumns();
            int[] sortColumnIndexes = new int[sortColumns.size()];
            int[] sortColumnOrders = new int[sortColumns.size()];
            for (int i = 0; i < sortColumns.size(); ++i) {
                int[] row = (int[])sortColumns.get(i);
                sortColumnIndexes[i] = row[0];
                sortColumnOrders[i] = row[1];
            }
            int[] oldDisplayCols = ViewDataPanel.this.m_model.getDisplayColumns();
            ViewDataPanel.this.m_model.setWhereClause(filter);
            ViewDataPanel.this.m_model.setDisplayColumns(displayCols);
            ViewDataPanel.this.m_model.setSortedColumns(sortColumnIndexes, sortColumnOrders);
            try {
                if (ViewDataPanel.this.compareArrays(oldDisplayCols, displayCols) != 0) {
                    ViewDataPanel.this.m_model.moveDataToModel();
                    ViewDataPanel.this.m_fetchedCols = true;
                }
                if (ViewDataPanel.this.m_table.fetchData()) {
                    ViewDataPanel.this.m_table.getColumnHeader().setCellsToSizeCount(0);
                }
                ViewDataPanel.this.m_actFilter.setSelected(ViewDataPanel.this.m_model.getWhereClause() != null);
                ViewDataPanel.this.m_actDisplayColumns.setSelected(ViewDataPanel.this.m_model.getDisplayColumns().length != ViewDataPanel.this.m_model.getColumnMetadata().size());
            }
            catch (MdException e1) {
                ViewDataPanel.this.m_fetchedCols = false;
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                ViewDataPanel.this.m_table.clearSelection();
                ViewDataPanel.this.m_table.firePageNumberChange();
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    };
    private JDBCTableModelListener m_modelListener = new JDBCTableModelAdapter(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("CONNECTION_PROPERTY_APPLY_FORMATS")) {
                ViewDataPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (ViewDataPanel.this.m_table.fetchData()) {
                    ViewDataPanel.this.m_table.getColumnHeader().setCellsToSizeCount(0);
                }
            } else if (e.getPropertyName().equals("ROW_COUNT")) {
                ViewDataPanel.this.m_table.firePageNumberChange();
            }
        }

        @Override
        public void fetchStarted() {
            ViewDataPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            ViewDataPanel.this.enableUI(false);
        }

        @Override
        public void fetchComplete() {
            ViewDataPanel.this.setCursor(Cursor.getDefaultCursor());
            ViewDataPanel.this.enableUI(!ViewDataPanel.this.m_table.hasErrors());
            ViewDataPanel.this.updateActionsSelectedStates();
        }
    };

    public ViewDataPanel(DataTable oTable) {
        this(oTable, false);
    }

    public ViewDataPanel(DataTable oTable, boolean cacheColumnMetadata) {
        this(oTable, cacheColumnMetadata, null);
    }

    public ViewDataPanel(DataTable oTable, boolean cacheColumnMetadata, WsAppServer appServer) {
        this.m_dataTable = oTable;
        this.m_appServer = appServer;
        this.initialize(cacheColumnMetadata);
    }

    protected void initialize() {
        this.initialize(false);
    }

    protected void initialize(boolean cacheColumnMetadata) {
        try {
            this.setLayout(new BorderLayout());
            this.m_labelHelper = new ColumnDisplayLabelHelper();
            this.m_actRefresh = new RefreshAction();
            this.m_actPageSetup = new PageSetupAction();
            this.m_actPrint = new PrintAction();
            this.m_actViewDataMenu = new ViewDataMenuAction();
            this.m_actGoToRow = new GoToRowAction();
            this.m_actNextPage = new NextPageAction();
            this.m_actPreviousPage = new PreviousPageAction();
            this.m_actFirstPage = new FirstPageAction();
            this.m_actLastPage = new LastPageAction();
            this.m_actFind = new FindAction();
            this.m_actFindNext = new FindNextAction();
            this.m_actSortByColumns = new SortByColumnsAction();
            this.m_actFilter = new FilterAction();
            this.m_actDisplayColumns = new DisplayColumnsAction();
            this.m_actShowMetadataName = new ShowMetadataNameAction();
            this.m_actShowColumnsName = new ShowColumnsNameAction();
            this.m_actShowDescription = new ShowDescriptionAction();
            this.m_actFormatted = new FormattedAction();
            this.setActionDefaults();
            this.m_toolBar = this.getToolBarPanel();
            if (this.m_dataTable.getCMetadataType().equals("PhysicalTable")) {
                this.m_model = new JDBCPhysicalTableTableModel((PhysicalTable)this.m_dataTable);
            } else if (this.m_dataTable.getCMetadataType().equals("WorkTable")) {
                this.m_model = new JDBCPhysicalTableTableModel((PhysicalTable)this.m_dataTable, this.m_appServer);
            } else if (this.m_dataTable.getCMetadataType().equals("ExternalTable")) {
                this.m_model = new JDBCExternalTableTableModel((ExternalTable)this.m_dataTable, cacheColumnMetadata);
            }
            this.m_model.setColumnDisplayLabelHelper(this.m_labelHelper);
            this.applyFormats((Boolean)this.m_toolBar.getData("formatted"));
            this.m_model.addModelListener(this.m_modelListener);
            this.m_table = new ViewDataTable(this.m_model, this.m_labelHelper);
            this.m_table.setRowsReorderable(false);
            this.m_pageScrollPane = new PageScrollPane((Component)((Object)this.m_table));
            this.m_pageScrollPane.getVerticalScrollBar().setMaximum(this.m_model.getPreferredPageSize());
            this.add(this.m_toolBar, "North");
            this.add(this.m_pageScrollPane, "Center");
            this.setHelpProduct("wdb");
            this.setHelpTopic("view_data");
            this.m_table.addPropertyChangeListener("PageNumber", this.m_pageNumberChangeListener);
            this.m_table.setJPopupMenu(this.getTablePopupMenu());
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void setActionDefaults() {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        boolean value = file.getPropertyBoolean(PROPERTY_METADATANAME, false);
        this.m_actShowMetadataName.setSelected(value);
        value = file.getPropertyBoolean(PROPERTY_COLUMNNAME, false);
        this.m_actShowColumnsName.setSelected(value);
        value = file.getPropertyBoolean(PROPERTY_COLUMNDESCRIPTION, false);
        this.m_actShowDescription.setSelected(value);
        value = file.getPropertyBoolean(PROPERTY_FORMATTED, true);
        this.m_actFormatted.setSelected(value);
    }

    protected JPopupMenu getTablePopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add((Action)((Object)this.m_actNextPage));
        mnuPopup.add((Action)((Object)this.m_actPreviousPage));
        mnuPopup.add((Action)((Object)this.m_actFirstPage));
        mnuPopup.add((Action)((Object)this.m_actLastPage));
        mnuPopup.addSeparator();
        mnuPopup.add((Action)((Object)this.m_actFind));
        mnuPopup.add((Action)((Object)this.m_actFindNext));
        mnuPopup.addSeparator();
        mnuPopup.add((Action)((Object)this.m_actSortByColumns));
        mnuPopup.add((Action)((Object)this.m_actFilter));
        mnuPopup.add((Action)((Object)this.m_actDisplayColumns));
        mnuPopup.addSeparator();
        mnuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowColumnsName));
        mnuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowDescription));
        mnuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowMetadataName));
        mnuPopup.addSeparator();
        mnuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actFormatted));
        return mnuPopup;
    }

    public void showToolBar(boolean show) {
        this.m_toolBar.setVisible(show);
    }

    protected ViewDataToolBar getToolBarPanel() {
        return new ViewDataToolBar();
    }

    public void setDialogsModal(boolean modal) {
        this.m_modalDialogs = modal;
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_model.populateStore();
    }

    public void moveDataToView() {
        this.closeDialogs();
        try {
            this.m_table.reconstructModel();
            this.m_fetchedCols = true;
            if (this.m_table.fetchData()) {
                this.m_table.getColumnHeader().setCellsToSizeCount(0);
            }
        }
        catch (JDBCTableModelException e) {
            this.m_fetchedCols = false;
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            } else if (cause instanceof MdException) {
                MessageUtil.displayMetadataExceptionMessage((MdException)((MdException)cause), (String)"Accessing");
            } else {
                MessageUtil.displayMessage((String)cause.getMessage(), (int)0);
            }
            this.m_table.clearSelection();
            this.m_table.firePageNumberChange();
            return;
        }
    }

    public JDBCTableModel getJDBCTableModel() {
        return this.m_model;
    }

    protected void applyFormats(boolean apply) {
        try {
            this.m_model.setApplyFormats(apply);
            this.m_actFormatted.setSelected(apply);
        }
        catch (JDBCTableModelException jDBCTableModelException) {
            // empty catch block
        }
    }

    public void clear() {
        this.m_table.removeAllColumns();
    }

    protected void showMetadataName(boolean show) {
        this.m_labelHelper.showMetadataName(show);
        this.m_actShowMetadataName.setSelected(this.m_labelHelper.showMetadataName());
    }

    protected void showColumnName(boolean show) {
        this.m_labelHelper.showColumnName(show);
        this.m_actShowColumnsName.setSelected(this.m_labelHelper.showColumnName());
    }

    protected void showDescription(boolean show) {
        this.m_labelHelper.showDescription(show);
        this.m_actShowDescription.setSelected(this.m_labelHelper.showDescription());
    }

    protected void find() {
        this.find(true);
    }

    protected void find(boolean include) {
        int row = -1;
        int column = -1;
        if (this.m_table.getSelectedCells().length > 0) {
            row = this.m_model.convertToAbsoluteRowNumber(this.m_table.getSelectedCells()[0][0]);
            column = this.m_table.getSelectedCells()[0][1];
        }
        this.find(row, column, include);
    }

    protected void find(int startRow, int startColumn, boolean include) {
        if (!this.m_findDialog.hasFindCondition()) {
            if (this.m_findDialog.getSelectedColumns().length == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.FindNoColumns.txt"));
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.NoSearchCriteria.txt"));
            }
            return;
        }
        int[] viewColumnIndices = this.orderColumnsInViewOrder(this.m_findDialog.getSelectedColumns());
        if (viewColumnIndices.length == 0) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.FindNoColumns.txt"));
            return;
        }
        int searchDirection = this.m_findDialog.isForwardSearch() ? 2 : 1;
        ViewDataFindComparable comparable = this.m_findDialog.getFindComparable();
        try {
            int[] match = new int[]{-1, -1};
            int[] modelColumnIndices = this.m_table.convertToModelIndex(viewColumnIndices);
            if (startRow == -1 || startColumn == -1) {
                match = this.m_model.find(comparable, modelColumnIndices, searchDirection);
            } else {
                int tempStartColumn = this.getClosestColumn(startColumn, viewColumnIndices, searchDirection);
                if (tempStartColumn != startColumn) {
                    startColumn = tempStartColumn;
                    include = true;
                }
                if (startColumn == -1) {
                    if (searchDirection == 2) {
                        startColumn = viewColumnIndices[0];
                        ++startRow;
                    } else {
                        startColumn = viewColumnIndices[viewColumnIndices.length - 1];
                        --startRow;
                    }
                }
                if (startRow >= 0) {
                    match = this.m_model.find(comparable, modelColumnIndices, searchDirection, startRow, this.m_table.convertColumnIndexToModel(startColumn), include);
                }
            }
            if (match[0] == -1) {
                MessageUtil.displayMessage((String)bundle.formatString("ViewDataPanel.Warning.NoMatch.fmt.txt", (Object)comparable.getCompareString()), (int)2);
                this.m_actFindNext.setEnabled(false);
                return;
            }
            this.m_table.gotoCell(match[0], match[1]);
            this.m_actFindNext.setEnabled(true);
        }
        catch (JDBCTableModelException e) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.FindError.txt"), (int)0);
        }
        catch (SQLException e) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.FindError.txt"), (int)0);
        }
    }

    private int[] orderColumnsInViewOrder(Column[] columns) {
        int[] indices = new int[columns.length];
        int validIndexCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            int index = this.m_model.getColumnDisplayIndex(this.m_model.getColumnIndex(col));
            indices[i] = this.m_table.convertColumnIndexToView(index);
            if (indices[i] == -1) continue;
            ++validIndexCount;
        }
        this.sortArray(indices);
        int[] validViewIndices = new int[validIndexCount];
        int temp = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == -1) continue;
            validViewIndices[temp++] = indices[i];
        }
        return validViewIndices;
    }

    private void sortArray(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            for (int j = i + 1; j < columns.length; ++j) {
                if (columns[i] <= columns[j]) continue;
                int temp = columns[i];
                columns[i] = columns[j];
                columns[j] = temp;
            }
        }
    }

    private int getClosestColumn(int startColViewIndex, int[] viewColumnIndices, int direction) {
        for (int i = 0; i < viewColumnIndices.length; ++i) {
            if (direction == 2) {
                if (viewColumnIndices[i] < startColViewIndex) continue;
                return viewColumnIndices[i];
            }
            if (viewColumnIndices[viewColumnIndices.length - i - 1] > startColViewIndex) continue;
            return viewColumnIndices[viewColumnIndices.length - i - 1];
        }
        return -1;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_model.close();
        this.closeDialogs();
    }

    protected void closeDialogs() {
        if (this.m_findDialog != null) {
            this.m_findDialog.dispose();
            this.m_findDialog = null;
        }
        if (this.m_queryOptionsDialog != null) {
            this.m_queryOptionsDialog.cleanUp();
            this.m_queryOptionsDialog.dispose();
            this.m_queryOptionsDialog = null;
        }
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.m_toolBar.setCursor(cursor);
        this.m_table.setCursor(cursor);
    }

    public boolean canClose() {
        if (this.m_model.isFetchDataRunning()) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.Warning.CantClose.txt"));
            return false;
        }
        return true;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actRefresh.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actViewDataMenu.setActive(bActive);
        this.setActionsActive(bActive);
        if (bActive) {
            this.updateActionsSelectedStates();
        }
    }

    private void updateActionsEnabledStates() {
        this.m_actGoToRow.setEnabled(true);
        this.m_actFirstPage.setEnabled(!this.m_table.isAtFirstPage());
        this.m_actPreviousPage.setEnabled(!this.m_table.isAtFirstPage());
        this.m_actNextPage.setEnabled(!this.m_table.isAtLastPage());
        this.m_actLastPage.setEnabled(!this.m_table.isAtLastPage());
        this.m_actFind.setEnabled(this.m_model.getCurrentPageSize() != 0);
        this.m_actFindNext.setEnabled(this.m_findDialog != null ? this.m_findDialog.hasFindCondition() : false);
        this.m_actSortByColumns.setEnabled(true);
        this.m_actFilter.setEnabled(true);
        this.m_actDisplayColumns.setEnabled(true);
        this.m_actShowMetadataName.setEnabled(true);
        this.m_actShowColumnsName.setEnabled(true);
        this.m_actShowDescription.setEnabled(true);
        this.m_actFormatted.setEnabled(true);
        if (this.m_model instanceof JDBCPhysicalTableTableModel && ((JDBCPhysicalTableTableModel)this.m_model).getMetadataMode() == 2) {
            this.m_actSortByColumns.setEnabled(false);
            this.m_actFilter.setEnabled(false);
            this.m_actDisplayColumns.setEnabled(false);
            this.m_actFormatted.setEnabled(false);
        }
    }

    private void updateActionsSelectedStates() {
        this.m_actFilter.setSelected(this.m_model.getWhereClause() != null);
        this.m_actDisplayColumns.setSelected(this.m_model.getDisplayColumns().length != this.m_model.getColumnMetadata().size());
        this.m_actShowMetadataName.setSelected(this.m_labelHelper.showMetadataName());
        this.m_actShowColumnsName.setSelected(this.m_labelHelper.showColumnName());
        this.m_actShowDescription.setSelected(this.m_labelHelper.showDescription());
        this.m_actFormatted.setSelected(this.m_model.getApplyFormats());
    }

    private void enableUI(boolean enable) {
        this.setListeningForChanges(enable);
        if (enable) {
            this.updateActionsEnabledStates();
        } else {
            this.setActionsEnabled(false);
        }
        this.m_pageScrollPane.setEnabled(enable);
        this.m_table.setEnabled(enable);
    }

    public String getDisplayTitle() {
        String sName = this.m_model.getTableDisplayName();
        int[] range = this.m_model.getRowRange();
        if (this.m_model.isFetchDataRunning()) {
            return bundle.formatString("ViewDataPanel.Title.Loading.fmt.txt", (Object)sName);
        }
        if (this.m_table.hasErrors()) {
            return bundle.formatString("ViewDataPanel.Title.Error.fmt.txt", (Object)sName);
        }
        if (range[0] != 0 && range[0] != -1) {
            if (this.m_model.getWhereClause() == null) {
                int rowCount = this.m_model.getTotalRowCount();
                if (rowCount == -1) {
                    if (this.m_model.isDBMSView()) {
                        return bundle.formatString("ViewDataPanel.Title.Rows.View.fmt.txt", (Object)sName, (Object)new Integer(range[0]), (Object)new Integer(range[1]));
                    }
                    return bundle.formatString("ViewDataPanel.Title.Rows.CountUnknown.fmt.txt", (Object)sName, (Object)new Integer(range[0]), (Object)new Integer(range[1]));
                }
                return bundle.formatString("ViewDataPanel.Title.Rows.CountKnown.fmt.txt", (Object)sName, (Object)new Integer(range[0]), (Object)new Integer(range[1]), (Object)new Integer(rowCount));
            }
            return bundle.formatString("ViewDataPanel.Title.Filter.fmt.txt", (Object)sName, (Object)new Integer(range[0]), (Object)new Integer(range[1]));
        }
        if (range[0] == 0) {
            return bundle.formatString("ViewDataPanel.Title.NoRows.fmt.txt", (Object)sName);
        }
        if (this.m_fetchedCols && this.m_table.getModel().getColumnCount() == 0) {
            return bundle.formatString("ViewDataPanel.Title.NoColumns.fmt.txt", (Object)sName);
        }
        return bundle.formatString("ViewDataPanel.Title.Loading.fmt.txt", (Object)sName);
    }

    public ViewDataTable getViewDataTable() {
        return this.m_table;
    }

    public WsAppServer getAppServer() {
        return this.m_appServer;
    }

    public void setAppServer(WsAppServer appServer) {
        this.m_appServer = appServer;
    }

    private ViewDataFindDialog getFindDialog() {
        if (this.m_findDialog == null) {
            this.m_findDialog = new ViewDataFindDialog(this.m_model.getTableDisplayName(), this.m_model.getColumnMetadata(), this.m_labelHelper);
            this.m_findDialog.setResizable(true);
            this.m_findDialog.addFindActionListener(this.m_findActionListener);
            this.m_findDialog.setModal(this.m_modalDialogs);
        }
        return this.m_findDialog;
    }

    private ViewDataQueryOptionsDialog getQueryOptionsDialog() {
        if (this.m_queryOptionsDialog == null) {
            this.m_queryOptionsDialog = new ViewDataQueryOptionsDialog(this.m_model, this.m_labelHelper);
            this.m_queryOptionsDialog.setResizable(true);
            this.m_queryOptionsDialog.addQueryOptionsActionListener(this.m_queryOptionsActionListener);
            this.m_queryOptionsDialog.setModal(this.m_modalDialogs);
        }
        return this.m_queryOptionsDialog;
    }

    protected void onGoToRow(int row) {
        this.m_table.gotoRow(row);
    }

    protected void onFirstPage() {
        this.m_table.firstPage();
    }

    protected void onPreviousPage() {
        this.m_table.previousPage();
    }

    protected void onNextPage() {
        this.m_table.nextPage();
    }

    protected void onLastPage() {
        this.m_table.lastPage();
    }

    protected void onShowFindDialog() {
        this.getFindDialog().show();
    }

    protected void onShowSortByDialog() {
        this.getQueryOptionsDialog().show(1);
    }

    protected void onShowFilterDialog() {
        this.getQueryOptionsDialog().show(2);
    }

    protected void onShowDisplayColumnsDialog() {
        this.getQueryOptionsDialog().show(3);
    }

    protected void onShowColumnName() {
        this.showColumnName(!this.m_labelHelper.showColumnName());
    }

    protected void onShowMetadataName() {
        this.showMetadataName(!this.m_labelHelper.showMetadataName());
    }

    protected void onShowDescription() {
        this.showDescription(!this.m_labelHelper.showDescription());
    }

    protected void onApplyFormats() {
        this.applyFormats(!this.m_model.getApplyFormats());
    }

    private int compareArrays(int[] firstArray, int[] secondArray) {
        if (firstArray == null || secondArray == null) {
            return -1;
        }
        if (firstArray.length != secondArray.length) {
            return -1;
        }
        for (int i = 0; i < firstArray.length; ++i) {
            if (firstArray[i] == secondArray[i]) continue;
            return -1;
        }
        return 0;
    }

    protected void setActionsActive(boolean active) {
        this.m_actGoToRow.setActive(active);
        this.m_actNextPage.setActive(active);
        this.m_actPreviousPage.setActive(active);
        this.m_actFirstPage.setActive(active);
        this.m_actLastPage.setActive(active);
        this.m_actFind.setActive(active);
        this.m_actFindNext.setActive(active);
        this.m_actSortByColumns.setActive(active);
        this.m_actFilter.setActive(active);
        this.m_actDisplayColumns.setActive(active);
        this.m_actShowMetadataName.setActive(active);
        this.m_actShowColumnsName.setActive(active);
        this.m_actShowDescription.setActive(active);
        this.m_actFormatted.setActive(active);
    }

    protected void setActionsEnabled(boolean enabled) {
        this.m_actGoToRow.setEnabled(enabled);
        this.m_actNextPage.setEnabled(enabled);
        this.m_actPreviousPage.setEnabled(enabled);
        this.m_actFirstPage.setEnabled(enabled);
        this.m_actLastPage.setEnabled(enabled);
        this.m_actFind.setEnabled(enabled);
        this.m_actFindNext.setEnabled(enabled);
        this.m_actSortByColumns.setEnabled(enabled);
        this.m_actFilter.setEnabled(enabled);
        this.m_actDisplayColumns.setEnabled(enabled);
        this.m_actShowMetadataName.setEnabled(enabled);
        this.m_actShowColumnsName.setEnabled(enabled);
        this.m_actShowDescription.setEnabled(enabled);
        this.m_actFormatted.setEnabled(enabled);
    }

    protected class FormattedAction
    extends WsAbstractToggleAction {
        public FormattedAction() {
            super(bundle, "ViewDataPanel.ShowFormatted", 2);
            this.setMenuSupportId("showformatteddeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onApplyFormats();
        }
    }

    protected class ShowMetadataNameAction
    extends WsAbstractToggleAction {
        public ShowMetadataNameAction() {
            super(bundle, "ViewDataPanel.ShowMetadataName", 2);
            this.setMenuSupportId("shownamedeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onShowMetadataName();
        }
    }

    protected class ShowDescriptionAction
    extends WsAbstractToggleAction {
        public ShowDescriptionAction() {
            super(bundle, "ViewDataPanel.ShowDescription", 2);
            this.setMenuSupportId("showdescriptiondeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onShowDescription();
        }
    }

    protected class ShowColumnsNameAction
    extends WsAbstractToggleAction {
        public ShowColumnsNameAction() {
            super(bundle, "ViewDataPanel.ShowColumnName", 2);
            this.setMenuSupportId("showcolumnnamedeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onShowColumnName();
        }
    }

    protected class SortByColumnsAction
    extends WsAbstractAction {
        public SortByColumnsAction() {
            super(bundle, "ViewDataPanel.Sort", 2);
            this.setMenuSupportId("sortbycolumnsdeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onShowSortByDialog();
        }
    }

    protected class FindNextAction
    extends WsAbstractAction {
        public FindNextAction() {
            super(bundle, "ViewDataPanel.FindNext", 2);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.find(false);
        }
    }

    protected class FindAction
    extends WsAbstractAction {
        public FindAction() {
            super(bundle, "ViewDataPanel.Find", 2);
            this.setMenuSupportId("findreplace");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onShowFindDialog();
        }
    }

    protected class GoToRowAction
    extends WsAbstractAction {
        public GoToRowAction() {
            super(bundle, "ViewDataPanel.GoToRow", 32);
        }

        public void actionPerformed(ActionEvent e) {
            Integer i = (Integer)ViewDataPanel.this.m_toolBar.getData("refreshrow");
            if (i != null) {
                ViewDataPanel.this.onGoToRow((i != 0 ? i : 1) - 1);
            }
        }
    }

    protected class DisplayColumnsAction
    extends WsAbstractToggleAction {
        public DisplayColumnsAction() {
            super(bundle, "ViewDataPanel.Columns", 2);
            this.setMenuSupportId("displaycolumnsdeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(ViewDataPanel.this.m_model.getDisplayColumns().length != ViewDataPanel.this.m_model.getColumnMetadata().size());
            ViewDataPanel.this.onShowDisplayColumnsDialog();
        }
    }

    protected class FilterAction
    extends WsAbstractToggleAction {
        public FilterAction() {
            super(bundle, "ViewDataPanel.Filter", 2);
            this.setMenuSupportId("filterdeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(ViewDataPanel.this.m_model.getWhereClause() != null);
            ViewDataPanel.this.onShowFilterDialog();
        }
    }

    protected class LastPageAction
    extends WsAbstractAction {
        public LastPageAction() {
            super(bundle, "ViewDataPanel.LastPage", 2);
            this.setMenuSupportId("lastpagedeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onLastPage();
        }
    }

    protected class NextPageAction
    extends WsAbstractAction {
        public NextPageAction() {
            super(bundle, "ViewDataPanel.NextPage", 2);
            this.setMenuSupportId("nextpagedeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onNextPage();
        }
    }

    protected class PreviousPageAction
    extends WsAbstractAction {
        public PreviousPageAction() {
            super(bundle, "ViewDataPanel.PreviousPage", 2);
            this.setMenuSupportId("prevpagedeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onPreviousPage();
        }
    }

    protected class FirstPageAction
    extends WsAbstractAction {
        public FirstPageAction() {
            super(bundle, "ViewDataPanel.FirstPage", 2);
            this.setMenuSupportId("firstpagedeprecated");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.onFirstPage();
        }
    }

    protected class ViewDataToolBar
    extends JPanel {
        public static final String ID_REFRESHROW = "refreshrow";
        public static final String ID_METADATANAME = "metadataname";
        public static final String ID_COLUMNNAME = "columnname";
        public static final String ID_DESCRIPTION = "description";
        public static final String ID_FORMATTED = "formatted";
        private WAIntTextField m_txtStatingRow;
        private JButton m_btnGoToRow;
        private JButton m_btnFirstPage;
        private JButton m_btnPreviousPage;
        private JButton m_btnNextPage;
        private JButton m_btnLastPage;
        private JButton m_btnFind;
        private JButton m_btnFindNext;
        private JButton m_btnSort;
        private JButton m_btnFilter;
        private JButton m_btnDisplayColumns;
        private JButton m_btnMetadataName;
        private JButton m_btnColumnName;
        private JButton m_btnDescription;
        private JButton m_btnFormatted;

        protected ViewDataToolBar() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.setBorder(new EtchedBorder(1));
            this.m_txtStatingRow = new WAIntTextField(false);
            this.m_txtStatingRow.setColumns(5);
            this.m_txtStatingRow.setAction((Action)((Object)ViewDataPanel.this.m_actGoToRow));
            this.m_btnGoToRow = WsUIUtilities.createTextButton((WsAbstractAction)ViewDataPanel.this.m_actGoToRow);
            this.m_btnFirstPage = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actFirstPage);
            this.m_btnPreviousPage = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actPreviousPage);
            this.m_btnNextPage = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actNextPage);
            this.m_btnLastPage = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actLastPage);
            this.m_btnFind = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actFind);
            this.m_btnFindNext = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actFindNext);
            this.m_btnSort = WsUIUtilities.createFlatToolButton((WsAbstractAction)ViewDataPanel.this.m_actSortByColumns);
            this.m_btnFilter = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)ViewDataPanel.this.m_actFilter);
            this.m_btnDisplayColumns = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)ViewDataPanel.this.m_actDisplayColumns);
            this.m_btnColumnName = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)ViewDataPanel.this.m_actShowColumnsName);
            this.m_btnDescription = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)ViewDataPanel.this.m_actShowDescription);
            this.m_btnMetadataName = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)ViewDataPanel.this.m_actShowMetadataName);
            this.m_btnFormatted = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)ViewDataPanel.this.m_actFormatted);
            this.m_btnFilter.setEnabled(false);
            this.m_btnDisplayColumns.setEnabled(false);
            this.m_btnMetadataName.setEnabled(false);
            this.m_btnColumnName.setEnabled(false);
            this.m_btnDescription.setEnabled(false);
            this.m_btnFormatted.setEnabled(false);
            this.m_txtStatingRow.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Workspace.getWorkspace().getRootPane().setDefaultButton(ViewDataToolBar.this.m_btnGoToRow);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Workspace.getWorkspace().getRootPane().setDefaultButton(null);
                }
            });
            this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "findNext");
            this.getActionMap().put("findNext", (Action)((Object)ViewDataPanel.this.m_actFindNext));
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            JLabel lblStartingRow = new JLabel(bundle.getString("ViewDataPanel.StartingRow.txt"));
            lblStartingRow.setToolTipText(bundle.getString("ViewDataPanel.StartingRow.tip"));
            this.m_txtStatingRow.setMinimumSize(new Dimension(40, 0));
            this.m_txtStatingRow.setMaximumSize(new Dimension(40, 50));
            lblStartingRow.setLabelFor((Component)this.m_txtStatingRow);
            lblStartingRow.setDisplayedMnemonic(bundle.getString("ViewDataPanel.StartingRow.mnem").charAt(0));
            Dimension space = new Dimension(4, 0);
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createRigidArea(space));
            this.add(lblStartingRow);
            this.add(Box.createRigidArea(space));
            this.add((Component)this.m_txtStatingRow);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnGoToRow);
            this.add(Box.createRigidArea(space));
            this.add(this.getSeparator());
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnFirstPage);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnPreviousPage);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnNextPage);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnLastPage);
            this.add(Box.createRigidArea(space));
            this.add(this.getSeparator());
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnFind);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnFindNext);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnSort);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnFilter);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnDisplayColumns);
            this.add(Box.createRigidArea(space));
            this.add(this.getSeparator());
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnColumnName);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnDescription);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnMetadataName);
            this.add(Box.createRigidArea(space));
            this.add(this.getSeparator());
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnFormatted);
        }

        private JSeparator getSeparator() {
            JToolBar.Separator separator = new JToolBar.Separator();
            separator.setOrientation(1);
            return separator;
        }

        public Object getData(String id) {
            if (ID_REFRESHROW.equals(id) && !this.m_txtStatingRow.getText().equals("")) {
                return new Integer(this.m_txtStatingRow.getText());
            }
            if (ID_METADATANAME.equals(id)) {
                return this.m_btnMetadataName.isSelected();
            }
            if (ID_COLUMNNAME.equals(id)) {
                return this.m_btnColumnName.isSelected();
            }
            if (ID_DESCRIPTION.equals(id)) {
                return this.m_btnDescription.isSelected();
            }
            if (ID_FORMATTED.equals(id)) {
                return this.m_btnFormatted.isSelected();
            }
            return null;
        }

        public void setData(String id, Object o) {
            if (ID_REFRESHROW.equals(id)) {
                this.m_txtStatingRow.setText(String.valueOf((Integer)o));
            } else if (ID_METADATANAME.equals(id)) {
                this.m_btnMetadataName.setSelected((Boolean)o);
            } else if (ID_COLUMNNAME.equals(id)) {
                this.m_btnColumnName.setSelected((Boolean)o);
            } else if (ID_DESCRIPTION.equals(id)) {
                this.m_btnDescription.setSelected((Boolean)o);
            } else if (ID_FORMATTED.equals(id)) {
                this.m_btnFormatted.setSelected((Boolean)o);
            }
        }
    }

    protected class RefreshAction
    extends WsAbstractAction {
        public RefreshAction() {
            this.setMenuSupportId("refresh");
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataPanel.this.moveDataToView();
        }
    }

    protected class PageSetupAction
    extends WsAbstractAction {
        public PageSetupAction() {
            this.setMenuSupportId("pagesetup");
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(printJob)) {
                return;
            }
            printJob.pageDialog(ViewDataPanel.this.m_table.getPageFormat());
        }
    }

    protected class PrintAction
    extends WsAbstractAction {
        public PrintAction() {
            this.setMenuSupportId("print");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            String title = bundle.formatString("ViewDataPanel.Title.Print.fmt.txt", (Object)ViewDataPanel.this.m_model.getTableDisplayName());
            WsTablePrinter printer = new WsTablePrinter((JTable)((Object)ViewDataPanel.this.m_table), (PageFormat)new WsTitledPageFormat(title), false);
            try {
                PrinterJob pjob = PrinterJob.getPrinterJob();
                if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                    return;
                }
                pjob.setJobName(title);
                pjob.setPageable((Pageable)printer);
                if (pjob.printDialog()) {
                    pjob.print();
                }
            }
            catch (PrinterException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)"Print Error", (int)0);
            }
            finally {
                printer.dispose();
            }
        }
    }

    protected class ViewDataMenuAction
    extends WsAbstractAction {
        public ViewDataMenuAction() {
            this.setMenuSupportId("viewdatamenudeprecated");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

