/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ViewDataOptionsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataOptionsTab.class);
    private JCheckBox m_ckbColumnMDNameInHeader;
    private JCheckBox m_ckbColumnNameInHeader;
    private JCheckBox m_ckbDescriptionInHeader;
    private JCheckBox m_ckbFormattedData;

    public ViewDataOptionsTab() {
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        super.initialize();
        this.m_ckbColumnMDNameInHeader = new JCheckBox(bundle.getString("ViewDataOptionPanel.ColumnMDInHeader.txt"));
        this.m_ckbColumnMDNameInHeader.setMnemonic(bundle.getString("ViewDataOptionPanel.ColumnMDInHeader.mnem").charAt(0));
        this.m_ckbColumnMDNameInHeader.setToolTipText(bundle.getString("ViewDataOptionPanel.ColumnMDInHeader.tooltip.txt"));
        this.m_ckbColumnNameInHeader = new JCheckBox(bundle.getString("ViewDataOptionPanel.ColumnNameInHeader.txt"));
        this.m_ckbColumnNameInHeader.setMnemonic(bundle.getString("ViewDataOptionPanel.ColumnNameInHeader.mnem").charAt(0));
        this.m_ckbColumnNameInHeader.setToolTipText(bundle.getString("ViewDataOptionPanel.ColumnNameInHeader.tooltip.txt"));
        this.m_ckbDescriptionInHeader = new JCheckBox(bundle.getString("ViewDataOptionPanel.ColumnDescriptionInHeader.txt"));
        this.m_ckbDescriptionInHeader.setMnemonic(bundle.getString("ViewDataOptionPanel.ColumnDescriptionInHeader.mnem").charAt(0));
        this.m_ckbDescriptionInHeader.setToolTipText(bundle.getString("ViewDataOptionPanel.ColumnDescriptionInHeader.tooltip.txt"));
        this.m_ckbFormattedData = new JCheckBox(bundle.getString("ViewDataOptionPanel.FormattedData.txt"));
        this.m_ckbFormattedData.setMnemonic(bundle.getString("ViewDataOptionPanel.FormattedData.mnem").charAt(0));
        this.m_ckbFormattedData.setToolTipText(bundle.getString("ViewDataOptionPanel.FormattedData.tooltip.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("options_view_data");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        WAPanel pnlColumnHeaders = new WAPanel();
        pnlColumnHeaders.setLayout((LayoutManager)new GridBagLayout());
        pnlColumnHeaders.setBorder((Border)new TitledBorder(bundle.getString("ViewDataOptionPanel.ColumnHeadersPanel.txt")));
        pnlColumnHeaders.add((Component)this.m_ckbColumnNameInHeader, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        pnlColumnHeaders.add((Component)this.m_ckbDescriptionInHeader, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        pnlColumnHeaders.add((Component)this.m_ckbColumnMDNameInHeader, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)pnlColumnHeaders, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_ckbFormattedData, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 11, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        super.moveDataToStore();
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_ckbColumnMDNameInHeader.setSelected(file.getPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", false));
        this.m_ckbColumnNameInHeader.setSelected(file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true));
        this.m_ckbDescriptionInHeader.setSelected(file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false));
        this.m_ckbFormattedData.setSelected(file.getPropertyBoolean("ViewData.ShowFormattedData", true));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToView();
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        if (file.getPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", false) == this.m_ckbColumnMDNameInHeader.isSelected() && file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true) == this.m_ckbColumnNameInHeader.isSelected() && file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false) == this.m_ckbDescriptionInHeader.isSelected() && file.getPropertyBoolean("ViewData.ShowFormattedData", true) == this.m_ckbFormattedData.isSelected()) {
            return;
        }
        file.setPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", this.m_ckbColumnMDNameInHeader.isSelected());
        file.setPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", this.m_ckbColumnNameInHeader.isSelected());
        file.setPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", this.m_ckbDescriptionInHeader.isSelected());
        file.setPropertyBoolean("ViewData.ShowFormattedData", this.m_ckbFormattedData.isSelected());
    }
}

