/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAStatement;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.wadmin.viewdata.JDBCTableModelException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.EFIDataModel;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;

public class JDBCExternalTableTableModel
extends JDBCTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(JDBCExternalTableTableModel.class);
    private boolean m_cacheColumnMetadata = false;
    private DataManager m_dataManager;
    private boolean m_workTableCreated = false;
    private EFIDataModel m_efiModel;
    private int m_rowCount = -1;

    public JDBCExternalTableTableModel(ExternalTable table) {
        this(table, false);
    }

    public JDBCExternalTableTableModel(ExternalTable table, boolean cacheColumnMetadata) {
        super((DataTable)table);
        this.m_cacheColumnMetadata = cacheColumnMetadata;
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_cacheColumnMetadata) {
            this.setColumnMetadataList(this.getDataTable().getColumns().subList(0, this.getDataTable().getColumns().size()));
            this.setStorePopulated(true);
        } else {
            super.populateStore();
        }
    }

    @Override
    public void constructModel() throws JDBCTableModelException {
        this.removeAllColumns();
        try {
            if (this.m_cacheColumnMetadata) {
                this.setStorePopulated(false);
                this.populateStore();
            }
        }
        catch (MdException mde) {
            throw new JDBCTableModelException(mde);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        super.constructModel();
        this.m_workTableCreated = false;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.getResultSet() != null) {
            try {
                this.getResultSet().close();
            }
            catch (SQLException se) {
                Workspace.getDefaultLogger().warn((Object)se.getMessage());
            }
            this.setResultSet(null);
        }
    }

    @Override
    public void close() {
        if (this.m_dataManager != null) {
            this.m_dataManager.close();
        }
        super.close();
    }

    @Override
    public boolean isDBMSView() {
        return true;
    }

    @Override
    protected Runnable getDataFetchRunnable() throws JDBCTableModelException {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    JDBCExternalTableTableModel.this.fetchDataPreemptive();
                    JDBCExternalTableTableModel.this.fireDataFetchSuccess();
                }
                catch (SQLException e) {
                    JDBCExternalTableTableModel.this.fireDataFetchError(e);
                }
                catch (WsAppServerFailException e) {
                    JDBCExternalTableTableModel.this.fireDataFetchError((Exception)((Object)e));
                }
                catch (WsAppServerCodeException e) {
                    JDBCExternalTableTableModel.this.fireDataFetchError((Exception)((Object)e));
                }
                catch (MdException e) {
                    JDBCExternalTableTableModel.this.fireDataFetchError((Exception)((Object)e));
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (JDBCTableModelException e) {
                    JDBCExternalTableTableModel.this.fireDataFetchError(e);
                }
            }
        };
    }

    private void fetchDataPreemptive() throws SQLException, WsAppServerFailException, WsAppServerCodeException, MdException, RemoteException, JDBCTableModelException {
        this.clear();
        this.createWorkTable();
        this.m_dataManager.fetchResultSet();
    }

    private void createWorkTable() throws WsAppServerFailException, WsAppServerCodeException, MdException, RemoteException, JDBCTableModelException {
        if (this.m_workTableCreated) {
            return;
        }
        this.m_efiModel = new EFIDataModel();
        this.m_efiModel.setExternalTable((ExternalTable)this.getDataTable());
        this.m_efiModel.populateStore();
        if (EFIDataModel.isLegacyEFIObject((ExternalTable)this.m_efiModel.getExternalTable())) {
            throw new JDBCTableModelException(bundle.getString("JDBCExternalTableTableModel.legacyefierror.txt"));
        }
        StringBuffer datastep = this.m_efiModel.getDataStep("");
        if (this.isParameterized()) {
            datastep.insert(0, this.getParameterizedMacroDeclaration()).append("\n");
        }
        if (this.m_dataManager == null) {
            this.m_dataManager = new DataManager();
            this.setAppServer(this.m_efiModel.getAppServer());
        }
        this.clear();
        this.m_dataManager.submitSASCode(datastep.toString());
        this.m_workTableCreated = true;
    }

    @Override
    public int getTotalRowCount() {
        return this.m_rowCount;
    }

    @Override
    public String getTableDisplayName() {
        try {
            return this.getDataTable().getName();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    private boolean isQuotingRequired() {
        return this.m_efiModel.isCaseSensitiveColumnNamesEnabled() || this.m_efiModel.isSpecialCharactersInColumnNamesEnabled();
    }

    private String getSQLColumnName(Column column) throws MdException, RemoteException {
        if (this.isQuotingRequired()) {
            return DBMSNamesUtil.getQuotedString((String)column.getSASColumnName(), (boolean)false);
        }
        return column.getSASColumnName();
    }

    private String getSQLTableName() {
        if (this.m_efiModel.isUserWritten()) {
            return "&SYSLAST";
        }
        return "WORK.ETLS_EFITABLE";
    }

    private class DataManager {
        private MVAStatement m_statement;

        private DataManager() {
        }

        private MVAResultSet fetchResultSet() throws MdException, RemoteException, SQLException, WsAppServerFailException, WsAppServerCodeException, JDBCTableModelException {
            MVAResultSet resultSet = null;
            String query = this.getQuery();
            if (query == null) {
                return null;
            }
            if (JDBCExternalTableTableModel.this.isQuotingRequired()) {
                this.submitSASCode("options VALIDVARNAME=ANY;");
            }
            if (this.m_statement == null) {
                this.m_statement = (MVAStatement)JDBCExternalTableTableModel.this.getAppServer().openSQLConnection().createStatement(1004, 1007);
            }
            if ((resultSet = JDBCExternalTableTableModel.this.getAppServer().submitSQLStatement(query, this.m_statement, JDBCExternalTableTableModel.this.getFetchSize())) == null) {
                Workspace.getDefaultLogger().warn((Object)"Unable to fetch resultset.");
                throw new JDBCTableModelException(new Exception(bundle.getString("JDBCExternalTableTableModel.UnknownAppServerError.txt")));
            }
            JDBCExternalTableTableModel.this.setResultSet(resultSet);
            return resultSet;
        }

        private void submitSASCode(String code) throws WsAppServerFailException, WsAppServerCodeException {
            JDBCExternalTableTableModel.this.getAppServer().submitSASCode(code);
        }

        private String getQuery() throws MdException, RemoteException {
            StringBuffer query = new StringBuffer("SELECT ");
            this.appendColumnsClause(query);
            this.appendTableClause(query);
            this.appendWhereClause(query);
            this.appendOrderByClause(query);
            Workspace.getDefaultLogger().warn((Object)query.toString());
            return query.toString();
        }

        private void appendColumnsClause(StringBuffer query) throws MdException, RemoteException {
            List columns = JDBCExternalTableTableModel.this.getColumnMetadata();
            int cols = JDBCExternalTableTableModel.this.getDisplayColumns().length;
            for (int i = 0; i < cols; ++i) {
                int colIndex = JDBCExternalTableTableModel.this.getDisplayColumns()[i];
                Column column = (Column)columns.get(colIndex);
                String colName = JDBCExternalTableTableModel.this.getSQLColumnName(column);
                query.append(colName);
                String format = column.getSASFormat();
                if (format != null && format.length() > 0) {
                    query.append(" FORMAT=");
                    query.append(format);
                    if (format.indexOf(".") == -1) {
                        query.append(".");
                    }
                }
                if (i == cols - 1) continue;
                query.append(",");
            }
        }

        private void appendTableClause(StringBuffer query) throws MdException, RemoteException {
            query.append(" FROM ").append(JDBCExternalTableTableModel.this.getSQLTableName());
            this.appendTableOptions(query);
        }

        private void appendTableOptions(StringBuffer query) throws MdException, RemoteException {
            OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)JDBCExternalTableTableModel.this.getDataTable(), false);
            String dsOptions = OP.getOptionsString();
            if (dsOptions != null && !dsOptions.trim().equals("")) {
                query.append(" (").append(dsOptions).append(") ");
            }
        }

        private void appendWhereClause(StringBuffer query) {
            if (JDBCExternalTableTableModel.this.getWhereClause() != null) {
                query.append(" WHERE ");
                query.append(JDBCExternalTableTableModel.this.getWhereClause());
            }
        }

        private void appendOrderByClause(StringBuffer query) throws MdException, RemoteException {
            int[] sortColumns = JDBCExternalTableTableModel.this.getSortedColumns();
            if (sortColumns == null || sortColumns.length == 0) {
                return;
            }
            query.append(" ORDER BY ");
            int size = sortColumns.length;
            for (int i = 0; i < size; ++i) {
                String columnName = JDBCExternalTableTableModel.this.getSQLColumnName(JDBCExternalTableTableModel.this.getColumnMetadata(sortColumns[i]));
                query.append(columnName);
                if (JDBCExternalTableTableModel.this.getSortedColumnOrder()[i] == -1) {
                    query.append(" ").append("DESC");
                }
                if (i >= size - 1) continue;
                query.append(",");
            }
        }

        public void close() {
            if (JDBCExternalTableTableModel.this.getAppServer() != null) {
                JDBCExternalTableTableModel.this.getAppServer().dispose();
                JDBCExternalTableTableModel.this.setAppServer(null);
            }
            try {
                if (this.m_statement != null) {
                    this.m_statement.close();
                }
            }
            catch (SQLException e) {
                Workspace.getDefaultLogger().debug((Object)e.getMessage());
            }
            JDBCExternalTableTableModel.this.clearSortColumns();
        }
    }
}

