/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.validate;

import com.sas.editor.LogListHolder;
import com.sas.etl.models.IObject;
import com.sas.wadmin.jobeditor.LogParser;
import com.sas.wadmin.run.IResults;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;

public class ValidateResults
implements IResults {
    private static WAdminResource bundle = WAdminResource.getBundle(ValidateResults.class);
    public static final int SUCCESSFUL = 0;
    public static final int WARNINGS = 1;
    public static final int ERRORS = 2;
    public static final int STOPPED = 3;
    public static final String ERRORS_TAG = bundle.getString("ValidateResults.Error.txt");
    public static final String WARNINGS_TAG = bundle.getString("ValidateResults.Warning.txt");
    public static final String DETAILS_TAG = "ETLS_DIAG";
    private LogListHolder m_log;
    private LogListHolder m_output;
    private long m_timeStart;
    private long m_timeStop;
    private int m_eStatus;
    private int m_iLogLength;
    private String[] m_aWarnings;
    private String[] m_aErrors;
    private String[] m_aWarningsAndErrors;
    private String[] m_aDetails;
    private boolean m_bLogParsed;
    private IObject m_object;
    private String m_sPushDown;
    private String m_sPushDownDBMSType;
    private int[] m_aWarningsStartLineNumbers;
    private int[] m_aWarningsStartIndexes;
    private int[] m_aWarningsEndIndexes;
    private int[] m_aErrorsStartLineNumbers;
    private int[] m_aErrorsStartIndexes;
    private int[] m_aErrorsEndIndexes;
    private int[] m_aWarningsAndErrorsStartLineNumbers;
    private int[] m_aWarningsAndErrorsStartIndexes;
    private int[] m_aWarningsAndErrorsEndIndexes;
    private static String s_messageExpression;

    public ValidateResults() {
        if (s_messageExpression == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(".*(");
            sb.append(ERRORS_TAG);
            sb.append('|');
            sb.append(WARNINGS_TAG);
            sb.append('|');
            sb.append(DETAILS_TAG);
            sb.append(").*");
            s_messageExpression = sb.toString();
        }
    }

    public void setLog(LogListHolder log) {
        this.m_log = log;
        this.m_bLogParsed = false;
        this.m_eStatus = 0;
        this.m_aWarnings = new String[0];
        this.m_aErrors = new String[0];
        this.m_aDetails = new String[0];
    }

    @Override
    public LogListHolder getLog() {
        return this.m_log;
    }

    public void setOutput(LogListHolder output) {
        this.m_output = output;
    }

    @Override
    public LogListHolder getOutput() {
        return this.m_output;
    }

    public void setStatus(int eStatus) {
        this.m_eStatus = eStatus;
    }

    public String getPushDownDBMSType() {
        return this.m_sPushDownDBMSType;
    }

    public void setPushDownDBMSType(String sPushDownDBMSType) {
        this.m_sPushDownDBMSType = sPushDownDBMSType;
    }

    public String getPushDown() {
        return this.m_sPushDown;
    }

    public void setPushDown(String sPushDown) {
        this.m_sPushDown = sPushDown;
    }

    public int getStatus() {
        return this.m_eStatus;
    }

    public void setStartTime(long timeStart) {
        this.m_timeStart = timeStart;
    }

    public long getStartTime() {
        return this.m_timeStart;
    }

    public void setStopTime(long timeStop) {
        this.m_timeStop = timeStop;
    }

    public long getStopTime() {
        return this.m_timeStop;
    }

    public int getLogLength() {
        return this.m_iLogLength;
    }

    public String[] getWarnings() {
        return this.m_aWarnings;
    }

    public int[] getWarningsStartLineNumbers() {
        return this.m_aWarningsStartLineNumbers;
    }

    public int[] getWarningsStartIndexes() {
        return this.m_aWarningsStartIndexes;
    }

    public int[] getWarningsEndIndexes() {
        return this.m_aWarningsEndIndexes;
    }

    public String[] getErrors() {
        return this.m_aErrors;
    }

    public int[] getErrorsStartLineNumbers() {
        return this.m_aErrorsStartLineNumbers;
    }

    public int[] getErrorsStartIndexes() {
        return this.m_aErrorsStartIndexes;
    }

    public int[] getErrorsEndIndexes() {
        return this.m_aErrorsEndIndexes;
    }

    public String[] getWarningsAndErrors() {
        return this.m_aWarningsAndErrors;
    }

    public int[] getWarningsAndErrorsStartLineNumbers() {
        return this.m_aWarningsAndErrorsStartLineNumbers;
    }

    public int[] getWarningsAndErrorsStartIndexes() {
        return this.m_aWarningsAndErrorsStartIndexes;
    }

    public int[] getWarningsAndErrorsEndIndexes() {
        return this.m_aWarningsAndErrorsEndIndexes;
    }

    public String[] getDetails() {
        return this.m_aDetails;
    }

    public void setModelObject(IObject object) {
        this.m_object = object;
    }

    @Override
    public IObject getModelObject() {
        return this.m_object;
    }

    public void parseLog() {
        if (this.m_bLogParsed) {
            return;
        }
        String[] messages = LogParser.parse(s_messageExpression, this.m_log != null ? this.m_log.getLineArray() : new String[]{});
        int[] aMessageStartLineNumbers = LogParser.getStartLineNumbers();
        int[] aMessageStartIndexes = LogParser.getStartIndexes();
        int[] aMessageEndIndexes = LogParser.getEndIndexes();
        ArrayList<String> errorsList = new ArrayList<String>();
        ArrayList<String> warningsList = new ArrayList<String>();
        ArrayList<String> warningsAndErrorsList = new ArrayList<String>();
        ArrayList<String> detailsList = new ArrayList<String>();
        ArrayList<Integer> errorsStartLineNumbersList = new ArrayList<Integer>();
        ArrayList<Integer> errorsStartIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> errorsEndIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsStartLineNumbersList = new ArrayList<Integer>();
        ArrayList<Integer> warningsStartIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsEndIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsAndErrorsStartLineNumbersList = new ArrayList<Integer>();
        ArrayList<Integer> warningsAndErrorsStartIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsAndErrorsEndIndexesList = new ArrayList<Integer>();
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i].indexOf(ERRORS_TAG) == 0) {
                errorsList.add(messages[i]);
                errorsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                errorsStartIndexesList.add(aMessageStartIndexes[i]);
                errorsEndIndexesList.add(aMessageEndIndexes[i]);
                warningsAndErrorsList.add(messages[i]);
                warningsAndErrorsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                warningsAndErrorsStartIndexesList.add(aMessageStartIndexes[i]);
                warningsAndErrorsEndIndexesList.add(aMessageEndIndexes[i]);
                continue;
            }
            if (messages[i].indexOf(WARNINGS_TAG) == 0) {
                warningsList.add(messages[i]);
                warningsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                warningsStartIndexesList.add(aMessageStartIndexes[i]);
                warningsEndIndexesList.add(aMessageEndIndexes[i]);
                warningsAndErrorsList.add(messages[i]);
                warningsAndErrorsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                warningsAndErrorsStartIndexesList.add(aMessageStartIndexes[i]);
                warningsAndErrorsEndIndexesList.add(aMessageEndIndexes[i]);
                continue;
            }
            if (messages[i].indexOf(DETAILS_TAG) != 0) continue;
            detailsList.add(messages[i]);
        }
        this.m_iLogLength = LogParser.getParsedLength();
        this.m_aErrors = errorsList.toArray(new String[0]);
        this.m_aWarnings = warningsList.toArray(new String[0]);
        this.m_aWarningsAndErrors = warningsAndErrorsList.toArray(new String[0]);
        this.m_aDetails = detailsList.toArray(new String[0]);
        this.m_aWarningsStartLineNumbers = LogParser.convertToIntArray(warningsStartLineNumbersList);
        this.m_aWarningsStartIndexes = LogParser.convertToIntArray(warningsStartIndexesList);
        this.m_aWarningsEndIndexes = LogParser.convertToIntArray(warningsEndIndexesList);
        this.m_aErrorsStartLineNumbers = LogParser.convertToIntArray(errorsStartLineNumbersList);
        this.m_aErrorsStartIndexes = LogParser.convertToIntArray(errorsStartIndexesList);
        this.m_aErrorsEndIndexes = LogParser.convertToIntArray(errorsEndIndexesList);
        this.m_aWarningsAndErrorsStartLineNumbers = LogParser.convertToIntArray(warningsAndErrorsStartLineNumbersList);
        this.m_aWarningsAndErrorsStartIndexes = LogParser.convertToIntArray(warningsAndErrorsStartIndexesList);
        this.m_aWarningsAndErrorsEndIndexes = LogParser.convertToIntArray(warningsAndErrorsEndIndexesList);
        this.m_eStatus = this.m_aErrors.length > 0 ? 2 : (this.m_aWarnings.length > 0 ? 1 : 0);
        this.m_bLogParsed = true;
    }
}

