/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.tablemaintenance;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.transforms.tablemaintenance.TableStatement;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.tablemaintenance.StatementCodePane;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;

public class StatementCodePanel
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(StatementCodePanel.class);
    private IUserWrittenCodeContainer m_container;
    private CodePane m_pnlCodePane;
    protected StatementCodePane.EditorType m_editorType;
    private TableStatement m_statement;

    public StatementCodePanel(IUserWrittenCodeContainer container, StatementCodePane.EditorType type) {
        this.m_container = container;
        this.m_editorType = type;
        this.initialize();
        this.m_pnlCodePane.setCodeSource(container);
    }

    protected void initialize() {
        this.m_pnlCodePane = this.createCodePane();
        this.m_pnlCodePane.setBorder(BorderFactory.createEtchedBorder());
        this.layoutComponents();
    }

    protected CodePane createCodePane() {
        return new StatementCodePane(this.m_container, this.m_editorType);
    }

    public String getCode() {
        String code = "";
        this.m_pnlCodePane.save();
        try {
            code = this.m_pnlCodePane.getCodeSource().getCode();
        }
        catch (ServerException serverException) {
            // empty catch block
        }
        return code;
    }

    public void saveCode() {
        this.m_pnlCodePane.validateData();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_pnlCodePane.saveSettingsAndCleanUp();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlCodePane), new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() {
        this.updateActions();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlCodePane.setEditable(bEditable);
        this.updateActions();
    }

    private void updateActions() {
    }

    public boolean validateData() {
        return this.m_pnlCodePane.validateData();
    }

    public void setCodeSource(IUserWrittenCodeContainer source) {
        this.m_pnlCodePane.setCodeSource(source);
        this.updateActions();
    }

    public void setStatement(TableStatement statement) {
        this.m_statement = statement;
        ((StatementCodePane)this.m_pnlCodePane).setStatement(statement);
    }

    protected void handleModelChanged(ModelEvent ev) {
        String type = ev.getType();
    }

    private void handleApplyPressed() {
    }

    private void handleUserWrittenSourceCodeChanged() {
    }

    private class HadoopModelListener
    implements IModelListener {
        private HadoopModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!StatementCodePanel.this.isListeningForChanges()) {
                return;
            }
            String type = ev.getType();
            if (type == "ModelController:UnknownChanges") {
                StatementCodePanel.this.moveDataToView();
                return;
            }
            IObject object = ev.getModelObject();
        }
    }

    private class PigAction
    extends WsAbstractAction {
        public PigAction() {
            super(bundle, "HadoopCodePanel.Action.Pig", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("File:New:Transformation"));
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }
}

