/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.wadmin.transforms.sql.properties.BaseClausePropertiesModel;
import com.sas.wadmin.transforms.sql.properties.SQLPropertyUtil;
import com.sas.workspace.WAdminResource;
import java.util.Arrays;
import java.util.List;

public class SQLPropertiesModel
extends BaseClausePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(SQLPropertiesModel.class);
    private int m_iPassThrough;
    private int m_iUserWritten;
    private int m_iDebug;
    private int m_iSQLOptions;
    private int m_iCreateSYSLAST;
    private int m_iSystemOptions;
    private int m_iTargetPassThrough;
    private int m_iMagic;
    private int m_iBufferSize;
    private int m_iThreads;
    private int m_iInObs;
    private int m_iOutObs;
    private int m_iSPDSParallelJoin;
    private int m_iSPDSOptions;
    private int m_iPreTargetPassthruAction;
    private int m_iAutoJoin;
    private static final int PROPERTYCOUNT = 16;
    private static final String PASSTHROUGHNAME = bundle.getString("SQLPropertiesModel.Property.PassThrough.txt");
    private static final String USERWRITTENNAME = bundle.getString("SQLPropertiesModel.Property.UserWritten.txt");
    private static final String DEBUGNAME = bundle.getString("SQLPropertiesModel.Property.Debug.txt");
    private static final String SQLOPTIONSNAME = bundle.getString("SQLPropertiesModel.Property.SQLOptions.txt");
    private static final String CREATESYSLASTNAME = bundle.getString("SQLPropertiesModel.Property.CreateSYSLAST.txt");
    private static final String SYSTEMOPTIONSNAME = bundle.getString("SQLPropertiesModel.Property.SystemOptions.txt");
    private static final String TARGETPASSTHROUGHNAME = bundle.getString("SQLPropertiesModel.Property.TargetPassThrough.txt");
    private static final String TARGETPASSTHROUGHACTIONNAME = bundle.getString("SQLPropertiesModel.Property.TargetPassThroughAction.txt");
    private static final String MAGIC = bundle.getString("SQLPropertiesModel.Property.Magic.txt");
    private static final String BUFFERSIZE = bundle.getString("SQLPropertiesModel.Property.BufferSize.txt");
    private static final String INOBS = bundle.getString("SQLPropertiesModel.Property.InObs.txt");
    private static final String OUTOBS = bundle.getString("SQLPropertiesModel.Property.OutObs.txt");
    private static final String THREADS = bundle.getString("SQLPropertiesModel.Property.Threads.txt");
    private static final String SPDSPLLJOIN = bundle.getString("SQLPropertiesModel.Property.SPDSParallelJoin.txt");
    private static final String SPDSOPTIONS = bundle.getString("SQLPropertiesModel.Property.SPDSOptions.txt");
    private static final String AUTOJOIN = bundle.getString("SQLPropertiesModel.Property.AutoJoin.txt");
    private static final Integer NO_VALUE = new Integer(Integer.MIN_VALUE);
    private ISQLTransform m_mdlSQL;

    public SQLPropertiesModel(ISQLTransform mdlSQL) {
        super(mdlSQL, (IClause)mdlSQL);
        this.m_mdlSQL = mdlSQL;
        this.setProperty(this.m_iPassThrough, PASSTHROUGHNAME, mdlSQL.isPassThru(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iUserWritten, USERWRITTENNAME, mdlSQL.isUsingUserWrittenCode(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iDebug, DEBUGNAME, mdlSQL.isDebug(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iSQLOptions, SQLOPTIONSNAME, mdlSQL.getSQLOptions(), SQLPropertiesModel.getDefaultRenderer(), true, SQLPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iCreateSYSLAST, CREATESYSLASTNAME, mdlSQL.isSYSLASTVariableGenerationEnabled(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iSystemOptions, SYSTEMOPTIONSNAME, mdlSQL.getSystemOptions(), SQLPropertiesModel.getDefaultRenderer(), true, SQLPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iTargetPassThrough, TARGETPASSTHROUGHNAME, mdlSQL.isTargetPassThru(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iMagic, MAGIC, mdlSQL.isSuggestSortMergeJoin(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iBufferSize, BUFFERSIZE, mdlSQL.getBufferSize(), SQLPropertiesModel.getDefaultRenderer(), true, SQLPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iInObs, INOBS, mdlSQL.getMaxInputRows(), SQLPropertiesModel.getDefaultRenderer(), true, SQLPropertiesModel.getIntEditor(false, NO_VALUE));
        this.setProperty(this.m_iOutObs, OUTOBS, mdlSQL.getMaxOutputRows(), SQLPropertiesModel.getDefaultRenderer(), true, SQLPropertiesModel.getIntEditor(false, NO_VALUE));
        List<String> threads = Arrays.asList(ISQLTransform.THREAD_VALUES);
        List transThreads = SQLPropertyUtil.createTranslatedList("Threads", threads);
        this.setProperty(this.m_iThreads, THREADS, mdlSQL.getThreads(), SQLPropertiesModel.getListRenderer(transThreads, threads), true, SQLPropertiesModel.getListEditor(transThreads, threads));
        List<String> spdsParallel = Arrays.asList(ISQLTransform.SPDS_PARALLEL_VALUES);
        List transSPDSParallel = SQLPropertyUtil.createTranslatedList("SPDSParallelJoin", spdsParallel);
        this.setProperty(this.m_iSPDSParallelJoin, SPDSPLLJOIN, mdlSQL.getSPDSParallelJoin(), SQLPropertiesModel.getListRenderer(transSPDSParallel, spdsParallel), true, SQLPropertiesModel.getListEditor(transSPDSParallel, spdsParallel));
        this.setProperty(this.m_iSPDSOptions, SPDSOPTIONS, mdlSQL.getSPDSOptions(), SQLPropertiesModel.getDefaultRenderer(), true, SQLPropertiesModel.getDefaultEditor());
        List<String> targetPassThruAction = Arrays.asList(ISQLTransform.PRETARGET_PASSTHRU_VALUES);
        List transPassThruAction = SQLPropertyUtil.createTranslatedList("PRETargetPassthruAction", targetPassThruAction);
        this.setProperty(this.m_iPreTargetPassthruAction, TARGETPASSTHROUGHACTIONNAME, mdlSQL.getPreTargetPassThruAction(), SQLPropertiesModel.getListRenderer(transPassThruAction, targetPassThruAction), true, SQLPropertiesModel.getListEditor(transPassThruAction, targetPassThruAction));
        this.setProperty(this.m_iAutoJoin, AUTOJOIN, mdlSQL.isAutoJoinEnabled(), SQLPropertiesModel.getDefaultBooleanRenderer(), true, SQLPropertiesModel.getDefaultBooleanEditor());
        this.updateEditableProperties();
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iCreateSYSLAST = 0;
        this.m_iAutoJoin = 1;
        this.m_iSystemOptions = 2;
        this.m_iUserWritten = 3;
        this.m_iPassThrough = 4;
        this.m_iTargetPassThrough = 5;
        this.m_iPreTargetPassthruAction = 6;
        this.m_iDebug = 7;
        this.m_iMagic = 8;
        this.m_iBufferSize = 9;
        this.m_iInObs = 10;
        this.m_iOutObs = 11;
        this.m_iThreads = 12;
        this.m_iSQLOptions = 13;
        this.m_iSPDSParallelJoin = 14;
        this.m_iSPDSOptions = 15;
    }

    @Override
    public int getNumberOfProperties() {
        return 16;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iPassThrough) {
            this.m_mdlSQL.setPassThru(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iUserWritten) {
            this.m_mdlSQL.setUseUserWrittenCode(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iDebug) {
            this.m_mdlSQL.setIsDebug(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iSQLOptions) {
            this.m_mdlSQL.setSQLOptions((String)value);
        } else if (iProperty == this.m_iCreateSYSLAST) {
            this.m_mdlSQL.setSYSLASTVariableGenerationEnabled(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iSystemOptions) {
            this.m_mdlSQL.setSystemOptions((String)value);
        } else if (iProperty == this.m_iTargetPassThrough) {
            this.m_mdlSQL.setTargetPassThru(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iMagic) {
            this.m_mdlSQL.setSuggestSortMergeJoin(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iBufferSize) {
            this.m_mdlSQL.setBufferSize((String)value);
        } else if (iProperty == this.m_iInObs) {
            this.m_mdlSQL.setMaxInputRows(value.equals(NO_VALUE) ? "" : value.toString());
        } else if (iProperty == this.m_iOutObs) {
            this.m_mdlSQL.setMaxOutputRows(value.equals(NO_VALUE) ? "" : value.toString());
        } else if (iProperty == this.m_iThreads) {
            this.m_mdlSQL.setThreads((String)value);
        } else if (iProperty == this.m_iSPDSParallelJoin) {
            this.m_mdlSQL.setSPDSParallelJoin((String)value);
        } else if (iProperty == this.m_iSPDSOptions) {
            this.m_mdlSQL.setSPDSOptions((String)value);
        } else if (iProperty == this.m_iPreTargetPassthruAction) {
            this.m_mdlSQL.setPreTargetPassThruAction((String)value);
        } else if (iProperty == this.m_iAutoJoin) {
            this.m_mdlSQL.setAutoJoinEnabled(((Boolean)value).booleanValue());
        } else {
            throw new IllegalArgumentException("Invalid property specified: " + iProperty);
        }
    }

    @Override
    protected void handleChange(String sAction) {
        if ("SQLJoinTransformModel:PassThroughChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iPassThrough, this.m_mdlSQL.isPassThru());
        } else if ("IUserWrittenCode:activeChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iUserWritten, this.m_mdlSQL.isUsingUserWrittenCode());
        } else if (sAction.equals("SQLJoinTransformModel:DebugChanged")) {
            this.setPropertyValueImpl(this.m_iDebug, this.m_mdlSQL.isDebug());
        } else if ("SQLJoinTransformModel:SqlOptionsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iSQLOptions, this.m_mdlSQL.getSQLOptions());
        } else if ("DataTransform::GenerateSYSLASTChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iCreateSYSLAST, this.m_mdlSQL.isSYSLASTVariableGenerationEnabled());
        } else if ("ITransform:SystemOptionsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iSystemOptions, this.m_mdlSQL.getSystemOptions());
        } else if ("SQLJoinTransformModel:TargetPassThroughChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iTargetPassThrough, this.m_mdlSQL.isTargetPassThru());
        } else if ("SQLJoinTransformModel:SuggestSortMergeChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iMagic, this.m_mdlSQL.isSuggestSortMergeJoin());
        } else if ("SQLJoinTransformModel:BufferSizeChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iBufferSize, this.m_mdlSQL.getBufferSize());
        } else if ("SQLJoinTransformModel:InObsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iInObs, this.m_mdlSQL.getMaxInputRows());
        } else if ("SQLJoinTransformModel:OutobsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iOutObs, this.m_mdlSQL.getMaxOutputRows());
        } else if ("SQLJoinTransformModel:ThreadsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iThreads, this.m_mdlSQL.getThreads());
        } else if ("SQLJoinTransformModel:SpdsParallelJoinChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iSPDSParallelJoin, this.m_mdlSQL.getSPDSParallelJoin());
        } else if ("SQLJoinTransformModel:AdditionalSpdsOptionsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iSPDSOptions, this.m_mdlSQL.getSPDSOptions());
        } else if ("SQLJoinTransformModel:TargetPassThroughActionChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iPreTargetPassthruAction, this.m_mdlSQL.getPreTargetPassThruAction());
        } else if ("SQLJoinTransformModel:AutoJoinChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iAutoJoin, this.m_mdlSQL.isAutoJoinEnabled());
        } else if ("SQLJoinTransformModel:PassThruEnabledChanged".equals(sAction)) {
            this.updateEditableProperties();
        } else if ("SQLJoinTransformModel:TargetPassThruChanged".equals(sAction)) {
            this.updateEditableProperties();
        } else if ("SQLJoinTransformModel:SPDSSourceTablesChanged".equals(sAction)) {
            this.updateEditableProperties();
        }
    }

    private void updateEditableProperties() {
        this.setPropertyValueEditable(this.m_iPassThrough, this.m_mdlSQL.isPassThruEnabled());
        this.setPropertyValueEditable(this.m_iTargetPassThrough, this.m_mdlSQL.isTargetPassThruEnabled());
        this.setPropertyValueEditable(this.m_iPreTargetPassthruAction, this.m_mdlSQL.isTargetPassThruEnabled());
        this.setPropertyValueEditable(this.m_iSPDSOptions, this.m_mdlSQL.isSPDSQuery());
        this.setPropertyValueEditable(this.m_iSPDSParallelJoin, this.m_mdlSQL.isSPDSQuery());
    }
}

