/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class BaseClausePropertiesModel
extends AbstractPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BaseClausePropertiesModel.class);
    protected static final String DESCRIPTIONPROPERTY = bundle.getString("BaseClausePropertiesModel.Property.Description.txt");
    protected int m_iDescription;
    private static final int PROPERTYCOUNT = 1;
    private IClause m_clause;
    private ISQLTransform m_mdlSQL;
    private IModelListener m_lsnrSQLModel;

    public BaseClausePropertiesModel(IClause clause) {
        this(clause.getParentQuery().getTransformModel(), clause);
        this.setProperty(this.m_iDescription, DESCRIPTIONPROPERTY, clause.getDescription(), BaseClausePropertiesModel.getDefaultRenderer(), true, BaseClausePropertiesModel.getDefaultEditor());
    }

    public BaseClausePropertiesModel(ISQLTransform mdlSQL, IClause clause) {
        this.m_mdlSQL = mdlSQL;
        this.m_clause = clause;
        this.m_lsnrSQLModel = this.createListener();
        mdlSQL.getModel().addModelListener(this.m_lsnrSQLModel);
    }

    protected IModelListener createListener() {
        return new QueryModelListener();
    }

    @Override
    public int getNumberOfProperties() {
        return 1;
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iDescription = this.getNumberOfProperties() - 1;
    }

    @Override
    protected void initializeProperties() {
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty != this.m_iDescription) {
            throw new UnsupportedOperationException("Unknown property index: " + iProperty);
        }
        this.m_clause.setDescription((String)value);
    }

    protected void handleChange(String sAction) {
        if ("Object:DescriptionChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iDescription, this.m_clause.getDescription());
        }
    }

    @Override
    public void populate() throws MdException, RemoteException {
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException {
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
    }

    public void dispose() {
        this.m_mdlSQL.getModel().removeModelListener(this.m_lsnrSQLModel);
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sAction = ev.getType();
            if (sAction == null) {
                return;
            }
            BaseClausePropertiesModel.this.handleChange(sAction);
        }
    }
}

