/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.visuals.pfd.WsPFDIconNode;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class ClauseNode
extends WsPFDIconNode {
    private static WAdminResource bundle = WAdminResource.getBundle(ClauseNode.class);
    protected WsAbstractAction m_actEdit;
    protected WsAbstractAction m_actDelete;
    private static final Color CLAUSE_BORDER = new Color(0, 0, 132);
    private static final Color CLAUSE_FILL = new Color(198, 198, 255);
    private ClauseInterface m_clause;

    public ClauseNode(ClauseInterface clause) {
        super(DEFAULT_LOCATION, DEFAULT_SIZE, 3, clause.getIcon(), clause.getName());
        this.m_clause = clause;
        this.m_actEdit = this.createEditAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actDelete.setEnabled(this.isEditable() && !(this.m_clause instanceof SelectResults));
        this.setDeleteAction((Action)this.m_actDelete);
    }

    protected void initialize() {
        super.initialize();
        PFDDrawablePrimitive draw = this.getDrawable();
        draw.getPen().setLineWidth(3.0f);
        draw.getPen().setColor(CLAUSE_BORDER);
        draw.getBrush().setColor(CLAUSE_FILL);
    }

    public ClauseInterface getClause() {
        return this.m_clause;
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
        menuPopup.add((Action)this.m_actEdit);
        menuPopup.add((Action)this.m_actDelete);
    }

    public void setActive(boolean bActive) {
        super.setActive(bActive);
        this.m_actEdit.setActive(bActive);
        this.m_actDelete.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        if (lObjects.size() != 1) {
            return false;
        }
        return false;
    }

    public boolean drop(Point ptEvent, List lObjects) {
        if (lObjects.size() != 1) {
            return false;
        }
        return false;
    }

    protected WsAbstractAction createEditAction() {
        return new EditAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new DeleteAction();
    }

    private class EditAction
    extends WsAbstractAction {
        public EditAction() {
            super(bundle, "ClauseNode.Action.Edit", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            Action actDefault = ClauseNode.this.getDefaultAction();
            if (actDefault != null && actDefault.isEnabled()) {
                actDefault.actionPerformed(ev);
            }
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ClauseNode.Action.Delete", 258);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent ev) {
            if (ClauseNode.this.m_clause instanceof Where && ClauseNode.this.m_clause.getParentQuery().hasImplicitJoin() && ((Where)ClauseNode.this.m_clause).getExpressions().size() > 0) {
                String sTitle = this.getText();
                String sMessage = bundle.getString("ClauseNode.DeleteWhereWithImplicitJoinWarning.txt");
                int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)2);
                if (eAnswer != 0) {
                    return;
                }
            }
            ClauseNode.this.m_clause.getParentQuery().removeClause(ClauseNode.this.m_clause);
        }
    }
}

