/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.QueryTable;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class TableColumn
implements SQLObjectInterface {
    private AbstractTable m_parent;
    private Column m_column;
    private Column m_queryColumn;
    private String m_name;
    private String m_description;
    private int m_length;
    private String m_type;
    private String m_format;
    private String m_informat;
    private boolean m_isNullable;

    public TableColumn(Column column, AbstractTable parent) {
        this.m_column = column;
        this.m_parent = parent;
    }

    public TableColumn(String name, AbstractTable parent) {
        this.m_name = name;
        this.m_parent = parent;
    }

    public Column getColumn() {
        if (this.m_parent != null && this.m_parent.isAliased() && !(this.m_parent instanceof TargetTable)) {
            return this.m_queryColumn;
        }
        return this.m_column;
    }

    public Column getDataTableColumn() {
        return this.m_column;
    }

    public void setColumn(Column column) {
        this.m_column = column;
    }

    public boolean getIsNullable() {
        return this.m_isNullable;
    }

    public void setIsNullable(boolean isNullable) {
        this.m_isNullable = isNullable;
    }

    public AbstractTable getParent() {
        return this.m_parent;
    }

    public void setParent(AbstractTable table) {
        this.m_parent = table;
    }

    public boolean containsSourceTable(TableInterface table) {
        return this.m_parent == table;
    }

    public String getTableAlias() {
        if (this.m_parent != null) {
            if (this.m_parent instanceof SourceTable) {
                return ((SourceTable)this.m_parent).getAlias();
            }
            return "";
        }
        return "";
    }

    public void setName(String name) {
        if (this.m_parent instanceof TargetTable) {
            this.m_name = name;
        }
    }

    public String getName() {
        try {
            if (this.m_name == null || this.m_name.length() == 0) {
                return this.m_column.getSASColumnName();
            }
            return this.m_name;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public String getFullColumnName() {
        return this.m_parent.getDataTableName() + "." + this.getName();
    }

    public StringBuffer getCodegenColumnName(CodegenRequest cgReq, Query requestingQuery) {
        StringBuffer columnName = new StringBuffer();
        if (this.m_parent != null && !requestingQuery.getTargetTable().equals(this.m_parent)) {
            Query parentQuery = this.m_parent.getParentQuery();
            if (!parentQuery.equals(requestingQuery) && parentQuery instanceof SubQuery) {
                SubQuery sQuery = (SubQuery)parentQuery;
                if (sQuery.isAliased()) {
                    columnName.append(sQuery.getAlias()).append(".");
                }
            } else {
                columnName.append(this.m_parent.getDataTableName(cgReq)).append(".");
            }
        }
        columnName.append(this.getColumnName());
        return columnName;
    }

    public boolean isTargetSQLColumn() {
        boolean val = false;
        if (this.m_parent == this.m_parent.getParentQuery().getTargetTable()) {
            val = true;
        }
        return val;
    }

    public void setDescription(String desc) {
        if (this.m_parent instanceof TargetTable) {
            this.m_description = desc;
        }
    }

    public String getDescription() {
        try {
            if (this.m_column != null && (this.m_description == null || this.m_description.length() == 0)) {
                return this.m_column.getDesc();
            }
            return this.m_description;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public void setLength(int length) {
        if (this.m_parent instanceof TargetTable) {
            this.m_length = length;
        }
    }

    public int getLength() {
        try {
            if (this.m_length == 0) {
                return this.m_column.getSASColumnLength();
            }
            return this.m_length;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return 0;
        }
    }

    public void setType(String type) {
        if (this.m_parent instanceof TargetTable) {
            this.m_type = type;
        }
    }

    public String getType() {
        try {
            if (this.m_type == null || this.m_type.length() == 0) {
                return this.m_column.getSASColumnType();
            }
            return this.m_type;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public void setFormat(String format) {
        if (this.m_parent instanceof TargetTable) {
            this.m_format = format;
        }
    }

    public String getFormat() {
        try {
            if (this.m_format == null) {
                return this.m_column.getSASFormat();
            }
            return this.m_format;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public void setInformat(String informat) {
        if (this.m_parent instanceof TargetTable) {
            this.m_informat = informat;
        }
    }

    public String getInformat() {
        try {
            if (this.m_informat == null) {
                return this.m_column.getSASInformat();
            }
            return this.m_informat;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            String name = this.m_parent.toString();
            if (name.length() > 0) {
                sb.append(this.m_parent.toString()).append(".");
            }
            sb.append(this.m_column.getSASColumnName());
            return sb.toString();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public void moveDataToModel() throws MdException, RemoteException {
        QueryTable qTable;
        if (this.m_column != null) {
            this.m_name = this.m_column.getSASColumnName();
            this.m_description = this.m_column.getDesc();
            this.m_type = this.m_column.getSASColumnType();
            this.m_format = this.m_column.getSASFormat();
            this.m_informat = this.m_column.getSASInformat();
            this.m_length = this.m_column.getSASColumnLength();
            boolean bl = this.m_isNullable = this.m_column.getIsNullable() != 0;
        }
        if ((qTable = this.m_parent.getQueryTable()) != null) {
            try {
                AssociationList cols = qTable.getColumns();
                int size = cols.size();
                for (int i = 0; i < size; ++i) {
                    Column qColumn = (Column)cols.get(i);
                    if (!qColumn.getSASColumnName().equals(this.m_name)) continue;
                    this.m_queryColumn = qColumn;
                    break;
                }
            }
            catch (MdException exc) {
                if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_parent == null) {
            return;
        }
        MdObjectStore store = this.m_parent.getSQLModel().getObjectStore();
        String reposId = this.m_parent.getSQLModel().getRepositoryId();
        if (this.m_parent instanceof TargetTable) {
            if (this.m_column == null) {
                this.m_column = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, this.m_name, "Column", reposId);
                this.m_column.setTable(this.m_parent.getDataTable());
                this.m_column.setPublicType("Column");
                this.m_column.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            }
            if (this.m_name != null && this.m_name.length() > 0) {
                this.m_column.setName(this.m_name);
                this.m_column.setSASColumnName(this.m_name);
                this.m_column.setColumnName(this.m_name);
            }
            if (this.m_description != null) {
                this.m_column.setDesc(this.m_description);
            }
            if (this.m_type != null && this.m_type.length() > 0) {
                this.m_column.setSASColumnType(this.m_type);
            }
            if (this.m_format != null) {
                this.m_column.setSASFormat(this.m_format);
            }
            if (this.m_informat != null) {
                this.m_column.setSASInformat(this.m_informat);
            }
            this.m_column.setSASColumnLength(this.m_length);
            if (this.m_isNullable) {
                this.m_column.setIsNullable(1);
            } else {
                this.m_column.setIsNullable(0);
            }
        }
        if (this.m_parent.isAliased() && this.m_column != null && !(this.m_parent instanceof TargetTable)) {
            QueryTable qTable = this.m_parent.getQueryTable();
            if (qTable == null) {
                this.m_parent.moveDataToStore();
                qTable = this.m_parent.getQueryTable();
            }
            if (this.m_queryColumn == null) {
                this.m_queryColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, this.m_name, "Column", qTable.getRepositoryID());
                this.m_queryColumn.setTable((DataTable)qTable);
                this.m_queryColumn.setPublicType("Column");
                this.m_queryColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            }
            MdStoreUtil.copyObjectAttributes((CMetadata)this.m_column, (CMetadata)this.m_queryColumn);
        }
    }

    @Override
    public void dispose() {
        if (this.m_parent instanceof TargetTable) {
            try {
                DataTable table = this.m_parent.getDataTable();
                if (!table.getCMetadataType().equalsIgnoreCase("PhysicalTable") && this.m_column != null) {
                    this.m_parent.getSQLModel().getObjectStore().removeObjectFromStore((CMetadata)this.m_column, null);
                    this.m_column = null;
                }
                if (this.m_queryColumn != null) {
                    this.m_parent.getSQLModel().getObjectStore().removeObjectFromStore((CMetadata)this.m_queryColumn, null);
                    this.m_queryColumn = null;
                }
            }
            catch (MdException me) {
                if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(me.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        this.m_parent = null;
        this.m_name = null;
        this.m_description = null;
        this.m_type = null;
        this.m_format = null;
        this.m_informat = null;
    }

    public String getColumnName() {
        SQLModel model = this.m_parent.getSQLModel();
        String columnName = this.m_name;
        try {
            boolean tableQuoted = DBMSNamesUtil.isTableQuoted((DataTable)this.m_parent.getDataTable());
            if (this.m_parent instanceof SourceTable && ((SourceTable)this.m_parent).isMoveTableToUploadLibrary()) {
                SourceTable sTable = (SourceTable)this.m_parent;
                tableQuoted = sTable.isUploadTableCaseSensitive() || sTable.isUploadTableSpecialCharacters();
            }
            columnName = DBMSNamesUtil.getQuotedName((String)this.m_name, (boolean)tableQuoted, (boolean)model.getCodegenRequest().getQuoting(), (boolean)model.isPassThrough());
        }
        catch (MdException exc) {
            if (model.isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return columnName;
    }

    public boolean isNameIdentical(TableColumn compareColumn, CodegenRequest cgReq) {
        if (cgReq.getQuoting()) {
            return this.getName().equals(compareColumn.getName());
        }
        return this.getName().equalsIgnoreCase(compareColumn.getName());
    }

    public boolean isNameIdentical(TableColumn compareColumn, boolean quoted) {
        if (quoted) {
            return this.getName().equals(compareColumn.getName());
        }
        return this.getName().equalsIgnoreCase(compareColumn.getName());
    }

    public SQLModel getSQLModel() {
        return this.m_parent.getSQLModel();
    }

    public void copyAttributesFromColumn(Column oColumn) {
        try {
            if (oColumn != null) {
                this.m_name = oColumn.getSASColumnName();
                this.m_description = oColumn.getDesc();
                this.m_type = oColumn.getSASColumnType();
                this.m_format = oColumn.getSASFormat();
                this.m_informat = oColumn.getSASInformat();
                this.m_length = oColumn.getSASColumnLength();
                this.m_isNullable = oColumn.getIsNullable() != 0;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }
}

