/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class TableAlias
implements SQLObjectInterface {
    public static final String ALIASTRANSFORMROLE = "TableAlias";
    public static final String QUERYTABLEROLE = "Alias";
    private AbstractTable m_parent;
    private String m_aliasName = "";
    private DataTable m_dataTable;
    private ClassifierMap m_classifierMap;
    private QueryTable m_queryTable;

    public TableAlias(DataTable table, String alias) {
        this.m_aliasName = alias;
        this.m_dataTable = table;
    }

    public TableAlias(ClassifierMap classifierMap) {
        this.m_classifierMap = classifierMap;
    }

    public TableAlias(QueryTable queryTable) {
        this.m_queryTable = queryTable;
    }

    public TableAlias(DataTable table, QueryTable alias) {
        this.m_dataTable = table;
        this.m_queryTable = alias;
    }

    public DataTable getDataTable() {
        return this.m_dataTable;
    }

    public AbstractTable getParent() {
        return this.m_parent;
    }

    public String getAliasName() {
        return this.m_aliasName;
    }

    public void setDataTable(DataTable table) {
        this.m_dataTable = table;
    }

    public void setParent(AbstractTable parent) {
        this.m_parent = parent;
    }

    public void setAliasName(String aliasName) {
        if (aliasName == null) {
            aliasName = "";
        }
        this.m_aliasName = aliasName;
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    public void setClassifierMap(ClassifierMap classifierMap) {
        if (classifierMap == this.m_classifierMap) {
            return;
        }
        this.m_classifierMap = classifierMap;
    }

    public QueryTable getQueryTable() {
        return this.m_queryTable;
    }

    public void setQueryTable(QueryTable queryTable) {
        if (this.m_queryTable == queryTable) {
            return;
        }
        this.m_queryTable = queryTable;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        AssociationList tgtMaps;
        if (this.m_queryTable != null && !(tgtMaps = this.m_queryTable.getTargetClassifierMaps()).isEmpty()) {
            for (int i = 0; i < tgtMaps.size(); ++i) {
                ClassifierMap clsM = (ClassifierMap)tgtMaps.get(i);
                String role = clsM.getTransformRole();
                if (!role.equalsIgnoreCase(ALIASTRANSFORMROLE)) continue;
                this.m_classifierMap = clsM;
                break;
            }
        }
        if (this.m_classifierMap != null) {
            AssociationList alClassifierTargets;
            AssociationList alClassifierSources = this.m_classifierMap.getClassifierSources(true);
            if (!alClassifierSources.isEmpty()) {
                this.m_dataTable = (DataTable)alClassifierSources.get(0);
            }
            if (!(alClassifierTargets = this.m_classifierMap.getClassifierTargets(true)).isEmpty() && this.m_queryTable == null) {
                this.m_queryTable = (QueryTable)alClassifierTargets.get(0);
            }
            this.m_aliasName = this.m_queryTable.getTableName();
        } else {
            SQLModel model = this.m_parent.getSQLModel();
            MdObjectStore store = model.getObjectStore();
            String reposId = model.getRepositoryId();
            this.createNewMetadata(store, reposId);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        SQLModel model = this.m_parent.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        if (this.m_classifierMap == null) {
            this.createNewMetadata(store, reposId);
        }
        AssociationList clsSources = this.m_classifierMap.getClassifierSources();
        clsSources.removeAllElements();
        clsSources.flushAll();
        clsSources.add((Object)this.m_dataTable);
        AssociationList clsTargets = this.m_classifierMap.getClassifierTargets();
        clsTargets.removeAllElements();
        clsTargets.flushAll();
        if (this.m_queryTable == null) {
            this.createNewQueryTable(store, reposId);
        }
        if (this.m_queryTable != null) {
            String aliasName = "";
            aliasName = this.m_aliasName.length() > 0 ? this.m_aliasName : ALIASTRANSFORMROLE;
            this.m_queryTable.setName(aliasName);
            this.m_queryTable.setTableName(this.m_aliasName);
            clsTargets.add((Object)this.m_queryTable);
        }
    }

    private void createNewMetadata(MdObjectStore store, String reposId) throws MdException, RemoteException {
        if (this.m_dataTable == null) {
            return;
        }
        Query query = this.m_parent.getParentQuery();
        this.m_classifierMap = (ClassifierMap)Workspace.getMdFactory().createComplexMetadataObject(store, ALIASTRANSFORMROLE, "ClassifierMap", reposId);
        this.m_classifierMap.setTransformRole(ALIASTRANSFORMROLE);
        Select select = query.getSelectObject();
        select.getTransformationSources().add((Object)this.m_classifierMap);
        if (this.m_queryTable == null) {
            this.createNewQueryTable(store, reposId);
        }
        this.m_classifierMap.getClassifierTargets().add((Object)this.m_queryTable);
        this.m_classifierMap.getClassifierSources().add((Object)this.m_dataTable);
    }

    private void createNewQueryTable(MdObjectStore store, String reposId) throws MdException, RemoteException {
        String aliasName = "";
        aliasName = this.m_aliasName.length() > 0 ? this.m_aliasName : ALIASTRANSFORMROLE;
        this.m_queryTable = (QueryTable)Workspace.getMdFactory().createComplexMetadataObject(store, aliasName, "QueryTable", reposId);
        this.m_queryTable.setTableName(this.m_aliasName);
        this.m_queryTable.setName(aliasName);
        Role oRole = (Role)Workspace.getMdFactory().createComplexMetadataObject(store, QUERYTABLEROLE, "Role", reposId);
        oRole.setContext(QUERYTABLEROLE);
        oRole.setObjectRole(QUERYTABLEROLE);
        this.m_queryTable.getRoles().addElement((Object)oRole);
    }

    @Override
    public void dispose() {
        try {
            MdObjectStore store;
            if (this.m_classifierMap != null) {
                store = (MdObjectStore)this.m_classifierMap.getObjectStore();
                store.removeObjectFromStore((CMetadata)this.m_classifierMap, null);
                this.m_classifierMap = null;
            }
            if (this.m_queryTable != null) {
                store = (MdObjectStore)this.m_queryTable.getObjectStore();
                store.removeObjectFromStore((CMetadata)this.m_queryTable, null);
                this.m_queryTable = null;
            }
        }
        catch (MdException me) {
            if (this.m_parent.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_dataTable = null;
    }
}

