/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.GroupBy;
import com.sas.wadmin.transforms.sql.model.Having;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.OrderBy;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.TableAlias;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class SubQuery
extends Query
implements SourceTableInterface,
OperandInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(SubQuery.class);
    public static final String SELECTROLE = "SUBQUERY";
    public static final String QUERYTABLEROLE = "SubQuery";
    private static final String SUBQUERYNAME = bundle.getString("SubQuery.Name.txt");
    private static final String TARGETDEFAULTNAME = bundle.getString("SubQuery.DefaultName.txt");
    private SimpleExpressionInterface m_parent;

    public SubQuery() {
    }

    public SubQuery(Select transform) {
        super(transform);
    }

    public SubQuery(QueryTable table) {
        this.m_dataTable = table;
        this.m_targetTable = new TargetTable(this.m_dataTable);
        this.m_targetTable.setParent(this);
        this.m_targetTable.setParentQuery(this);
    }

    @Override
    public String getName() {
        return SUBQUERYNAME;
    }

    @Override
    public Icon getIcon() {
        return bundle.getImageIcon("SubQuery.node.image");
    }

    @Override
    public SourceTableInterface addSourceTable(DataTable table) {
        SourceTable srcTable = new SourceTable(table);
        srcTable.setParentQuery(this);
        srcTable.setSQLModel(this.getSQLModel());
        this.m_lSourceTables.add(srcTable);
        this.getSQLModel().getStatement().getQuery().addSubQuerySourceTable(srcTable);
        try {
            SQLModel model = this.getSQLModel();
            boolean enabledEvents = model.isFireEventsEnabled();
            if (enabledEvents) {
                model.setFireEventsEnabled(false);
            }
            srcTable.moveDataToModel();
            this.autoMap(table, this.m_dataTable);
            if (enabledEvents) {
                model.setFireEventsEnabledWithOutUnknownChangesEvent();
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return srcTable;
    }

    @Override
    protected void autoMap(DataTable source, DataTable target) throws MdException, RemoteException {
        if (this.m_selectResults != null && this.m_selectResults.useImplicit()) {
            this.m_selectResults.moveDataToStore();
            MappingUtil.createColumnMappings(source, target, (ClassifierMap)this.m_select);
            ((AbstractTable)this.m_targetTable).moveDataToModel();
            this.m_selectResults.moveDataToModel();
            Query parent = this.getParentQuery();
            if (parent instanceof SubQuery && !(this.getParentClause() instanceof SelectResults)) {
                ((SubQuery)parent).autoMap(target, parent.getTargetDataTable());
            }
        }
    }

    protected void addSourceTable(SourceTable srcTable) {
        srcTable.setParentQuery(this);
        this.m_lSourceTables.add(srcTable);
        this.getSQLModel().getStatement().getQuery().addSubQuerySourceTable(srcTable);
        try {
            if (this.m_selectResults != null && this.m_selectResults.useImplicit()) {
                DataTable table = srcTable.getDataTable();
                if (srcTable.isAliased() && srcTable.getQueryTable() == null) {
                    srcTable.moveDataToStore();
                }
                if (srcTable.isAliased()) {
                    table = srcTable.getQueryTable();
                }
                MappingUtil.createColumnMappings(table, this.m_dataTable, (ClassifierMap)this.m_select);
                ((AbstractTable)this.m_targetTable).moveDataToModel();
                this.m_selectResults.moveDataToModel();
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void removeSourceTable(SourceTable srcTable) {
        srcTable.cleanSourceMappings(this);
        this.m_lSourceTables.remove(srcTable);
        this.getSQLModel().getStatement().getQuery().removeSubQuerySourceTable(srcTable);
    }

    protected void removeAllSourceTablesFromParentQuery() {
        for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
            SourceTable table = (SourceTable)this.m_lSourceTables.get(i);
            this.getSQLModel().getStatement().getQuery().removeSubQuerySourceTable(table);
        }
    }

    protected void addAllSourceTablesToParentQuery() {
        for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
            SourceTable table = (SourceTable)this.m_lSourceTables.get(i);
            this.getSQLModel().getStatement().getQuery().addSubQuerySourceTable(table);
        }
    }

    @Override
    public List getAllSourceTables() {
        ArrayList<TargetTable> list = new ArrayList<TargetTable>();
        list.addAll(this.m_lSourceTables);
        List subqueries = this.m_from.getSubqueries();
        for (int i = 0; i < subqueries.size(); ++i) {
            SubQuery subquery = (SubQuery)subqueries.get(i);
            list.add(subquery.getTargetTable());
        }
        AbstractClause parent = (AbstractClause)this.getParentClause();
        if (parent instanceof Where || parent instanceof Having) {
            Query parentQuery = this.getParentQuery();
            list.addAll(parentQuery.getAllSourceTables());
        }
        return list;
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        this.getSQLCode(cgReq, resetPosition);
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
    }

    @Override
    public List getTableColumns() {
        ArrayList newList = new ArrayList();
        if (this.m_targetTable != null && this.m_parentClause instanceof From) {
            newList.addAll(this.m_targetTable.getTableColumns());
        }
        return newList;
    }

    @Override
    public boolean hasText() {
        return this.getStartingPosition() != this.getEndingPosition();
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        this.appendClauseCode(cgReq, resetPosition);
        return cgReq;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq, boolean resetPosition) {
        TableAlias alias;
        cgReq.addSourceCode("(\n").indent();
        String desc = this.getDescription();
        if (desc.length() > 0) {
            cgReq.addCommentLine(desc);
        }
        this.appendClauseCode(this.m_selectResults, cgReq, resetPosition);
        this.appendClauseCode(this.m_from, cgReq, resetPosition);
        this.appendClauseCode(this.m_where, cgReq, resetPosition);
        this.appendClauseCode(this.m_groupBy, cgReq, resetPosition);
        this.appendClauseCode(this.m_having, cgReq, resetPosition);
        this.appendClauseCode(this.m_orderBy, cgReq, resetPosition);
        cgReq.unIndent().addSourceCode(")");
        if ((this.m_parentClause instanceof From || this.m_parentClause instanceof Join) && (alias = this.m_targetTable.getTableAlias()) != null && alias.getAliasName().length() > 0) {
            cgReq.addSourceCode(this.getSQLModel().getTableAliasKeyword()).addSourceCode(this.getAlias());
        }
        return cgReq.getSource();
    }

    @Override
    public Root getMetadataObject() {
        return this.m_dataTable;
    }

    @Override
    public String getOperandType() {
        return "SubQueryOperand";
    }

    @Override
    public void setParent(SimpleExpressionInterface expression) {
        this.m_parent = expression;
    }

    public SimpleExpressionInterface getParentExpression() {
        return this.m_parent;
    }

    public boolean isAliased() {
        TableAlias alias = this.m_targetTable.getTableAlias();
        return alias != null && alias.getAliasName().length() > 0;
    }

    public void setAlias(String alias) {
        this.m_targetTable.setAlias(alias);
        this.getSQLModel().fireChangeEvent(this, "AliasChanged");
    }

    public String getAlias() {
        return this.m_targetTable.getAlias();
    }

    @Override
    public void remove() {
        this.getSQLModel().setFireEventsEnabled(false);
        this.getParentQuery().m_selectResults.removeResultsContainingTable(this.m_targetTable);
        this.getParentQuery().m_selectResults.removeExpressionsContainingQuery(this);
        this.getParentQuery().m_from.removeExpressionsContainingQuery(this);
        if (this.getParentQuery().m_where != null) {
            this.getParentQuery().m_where.removeExpressionsContainingSourceTable(this.m_targetTable);
            this.getParentQuery().m_where.removeExpressionsContainingQuery(this);
        }
        if (this.getParentQuery().m_having != null) {
            this.getParentQuery().m_having.removeExpressionsContainingSourceTable(this.m_targetTable);
            this.getParentQuery().m_having.removeExpressionsContainingQuery(this);
        }
        if (this.getParentQuery().m_orderBy != null) {
            this.getParentQuery().m_orderBy.removeOrderByColumnsAssociatedWithSourceTable(this.m_targetTable);
        }
        if (this.getParentQuery().m_groupBy != null) {
            this.getParentQuery().m_groupBy.removeGroupByColumnsAssociatedWithSourceTable(this.m_targetTable);
        }
        this.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
        this.setParent((ClauseInterface)null);
        this.dispose();
    }

    @Override
    public void setParent(ClauseInterface parent) {
        if (this.m_parentClause == parent) {
            return;
        }
        if (this.m_parentClause instanceof From) {
            ((From)this.m_parentClause).removeSource(this);
        } else if (this.m_parentClause instanceof Join) {
            ((Join)this.m_parentClause).removeSource(this);
        }
        this.m_parentClause = parent;
    }

    @Override
    public ClauseInterface getParent() {
        return this.m_parentClause;
    }

    public TableAlias getTableAlias() {
        return this.m_targetTable.getTableAlias();
    }

    @Override
    public boolean containsSourceTable(TableInterface table) {
        return false;
    }

    @Override
    public OperandInterface copyOperand() {
        return new SubQuery();
    }

    @Override
    public boolean hasOpenTemplates() {
        return this.m_from.hasOpenTemplates();
    }

    @Override
    public boolean hasMissingTokens() {
        return false;
    }

    @Override
    public List getSourceObjectsWithOpenTemplates() {
        ArrayList list = new ArrayList();
        list.addAll(this.m_from.getSourceObjectsWithOpenTemplates());
        return list;
    }

    @Override
    public List getSubqueries() {
        ArrayList<SubQuery> list = new ArrayList<SubQuery>();
        list.add(this);
        return list;
    }

    @Override
    public void removeExpressionsContainingQuery(Query query) {
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        OrderByClause orderBy;
        GroupByClause groupBy;
        MdObjectStore store = this.getSQLModel().getObjectStore();
        if (this.m_select == null) {
            if (this.m_dataTable != null) {
                boolean goToServer = store.getIsGoToServerForMetadata();
                if (!goToServer) {
                    store.setIsGotToServerForMetadata(true);
                }
                AssociationList targetCMs = this.m_dataTable.getTargetClassifierMaps();
                store.setIsGotToServerForMetadata(goToServer);
                if (!targetCMs.isEmpty()) {
                    for (int i = 0; i < targetCMs.size(); ++i) {
                        Root select = (Root)targetCMs.get(i);
                        String type = select.getCMetadataType();
                        if (!type.equalsIgnoreCase("Select")) continue;
                        this.m_select = (Select)select;
                    }
                } else {
                    this.m_select = this.createSelectMetadata();
                }
            } else {
                this.m_select = this.createSelectMetadata();
            }
        } else {
            AssociationList lTargets = this.m_select.getClassifierTargets();
            if (!lTargets.isEmpty()) {
                this.m_dataTable = (DataTable)lTargets.get(0);
            }
        }
        this.m_lSourceTables.clear();
        AssociationList lclsSources = this.m_select.getClassifierSources();
        for (int i = 0; i < lclsSources.size(); ++i) {
            DataTable source = (DataTable)lclsSources.get(i);
            String type = source.getCMetadataType();
            if (type.equalsIgnoreCase("QueryTable")) {
                AssociationList roles = source.getRoles();
                if (roles.isEmpty()) continue;
                boolean found = false;
                for (int j = 0; j < roles.size(); ++j) {
                    Role role = (Role)roles.get(j);
                    String roleType = role.getObjectRole();
                    if (!roleType.equalsIgnoreCase("Alias")) continue;
                    this.addSourceTable(source);
                    found = true;
                    break;
                }
                if (found) continue;
            }
            this.addSourceTable(source);
        }
        if (this.m_dataTable == null) {
            this.createTargetTableMetadata();
        }
        if (this.m_targetTable == null) {
            this.m_targetTable = new TargetTable(this.m_dataTable);
            this.m_targetTable.setParent(this);
            this.m_targetTable.setParentQuery(this);
        }
        this.m_targetTable.setSQLModel(this.getSQLModel());
        boolean goToServer = store.getIsGoToServerForMetadata();
        if (!goToServer) {
            store.setIsGotToServerForMetadata(true);
        }
        AssociationList clsTargets = this.m_dataTable.getSourceClassifierMaps(true);
        store.setIsGotToServerForMetadata(goToServer);
        for (int i = 0; i < clsTargets.size(); ++i) {
            AssociationList lQueryTarget;
            ClassifierMap map = (ClassifierMap)clsTargets.get(i);
            String role = map.getTransformRole();
            if (!role.equalsIgnoreCase("TableAlias") || (lQueryTarget = map.getClassifierTargets()).isEmpty()) continue;
            QueryTable qAlias = (QueryTable)lQueryTarget.get(0);
            this.m_targetTable.setTableAlias(new TableAlias(this.m_dataTable, qAlias));
            break;
        }
        this.m_targetTable.moveDataToModel();
        this.m_from = new From();
        this.addClauseImpl(this.m_from);
        this.m_from.moveDataToModel();
        AssociationList alTransSources = this.m_select.getTransformationSources();
        if (!alTransSources.isEmpty()) {
            for (int i = 0; i < alTransSources.size(); ++i) {
                Root source = (Root)alTransSources.get(i);
                if (!source.getCMetadataType().equalsIgnoreCase("ClassifierMap")) continue;
                if (((ClassifierMap)source).getTransformRole().equalsIgnoreCase("Where")) {
                    this.m_where = new Where((ClassifierMap)source);
                    this.addClauseImpl(this.m_where);
                    this.m_where.moveDataToModel();
                    continue;
                }
                if (!((ClassifierMap)source).getTransformRole().equalsIgnoreCase("Having")) continue;
                this.m_having = new Having((ClassifierMap)source);
                this.addClauseImpl(this.m_having);
                this.m_having.moveDataToModel();
            }
        }
        if ((groupBy = this.m_select.getGroupByForSelect()) != null) {
            this.m_groupBy = new GroupBy(groupBy);
            this.addClauseImpl(this.m_groupBy);
            this.m_groupBy.moveDataToModel();
        }
        if ((orderBy = this.m_select.getOrderByForSelect()) != null) {
            this.m_orderBy = new OrderBy(orderBy);
            this.addClauseImpl(this.m_orderBy);
            this.m_orderBy.moveDataToModel();
        }
        this.m_selectResults = new SelectResults((ClassifierMap)this.m_select);
        this.addClauseImpl(this.m_selectResults);
        this.m_selectResults.moveDataToModel();
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        AssociationList clsTargets = this.m_select.getClassifierTargets();
        clsTargets.removeAllElements();
        clsTargets.flushAll();
        clsTargets.add((Object)this.m_dataTable);
    }

    protected void resetTransformRole() {
        try {
            if (this.m_select != null) {
                this.m_select.setTransformRole(SELECTROLE);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void dispose() {
        try {
            Select parentSelect = this.getParentQuery().getSelectObject();
            AssociationList list = parentSelect.getTransformationSources();
            list.removeElement((Object)this.m_select);
            super.dispose();
            MdObjectStore store = this.getSQLModel().getObjectStore();
            store.removeObjectFromStore((CMetadata)this.m_dataTable, null);
            this.m_dataTable = null;
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private Select createSelectMetadata() throws MdException, RemoteException {
        MdObjectStore store = this.getSQLModel().getObjectStore();
        String reposId = this.getSQLModel().getRepositoryId();
        Select select = (Select)Workspace.getMdFactory().createComplexMetadataObject(store, SELECTROLE, "Select", reposId);
        select.setTransformRole(SELECTROLE);
        Select parentSelect = this.getParentQuery().getSelectObject();
        parentSelect.getTransformationSources().add((Object)select);
        return select;
    }

    private void createTargetTableMetadata() throws MdException, RemoteException {
        MdObjectStore store = this.getSQLModel().getObjectStore();
        String reposId = this.getSQLModel().getRepositoryId();
        if (this.m_dataTable == null) {
            String defaultText = WsMetadataNameUtil.getUniqueNameForType((String)"QueryTable", (String)TARGETDEFAULTNAME);
            defaultText = defaultText.replaceAll(" ", "_");
            this.m_dataTable = (QueryTable)Workspace.getMdFactory().createComplexMetadataObject(store, defaultText, "QueryTable", reposId);
            this.m_dataTable.setTableName(defaultText);
            Role oRole = (Role)Workspace.getMdFactory().createComplexMetadataObject(store, QUERYTABLEROLE, "Role", reposId);
            oRole.setContext(QUERYTABLEROLE);
            oRole.setObjectRole(QUERYTABLEROLE);
            this.m_dataTable.getRoles().addElement((Object)oRole);
            for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
                SourceTable srcTable = (SourceTable)this.m_lSourceTables.get(i);
                DataTable source = srcTable.getDataTable();
                if (srcTable.isAliased()) {
                    source = srcTable.getTableAlias().getQueryTable();
                }
                MappingUtil.createColumnMappings(source, this.m_dataTable, (ClassifierMap)this.m_select);
            }
        }
        this.m_select.getClassifierTargets().add((Object)this.m_dataTable);
    }
}

