/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.Loader;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.TableAlias;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SourceTable
extends AbstractTable
implements SourceTableInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(SourceTable.class);
    public static final String IDXWHERECHANGED = "idxWhereChanged";
    public static final String FIRSTOBSCHANGED = "firstObsChanged";
    public static final String OBSCHANGED = "obsChanged";
    public static final String READBUFFCHANGED = "readBuffChanged";
    public static final String DBMSLIBRARYCHANGED = "dbmsLibraryChanged";
    public static final String PREUPLOADACTIONCHANGED = "preUploadActionChanged";
    public static final String UPLOADBULKLOADCHANGED = "uploadBulkloadChanged";
    public static final String BULKLOADOPTIONSCHANGED = "bulkloadOptionsChanged";
    public static final String UPLOADOPTIONSCHANGED = "uploadOptionsChanged";
    public static final String UPLOADCASESENSITIVECHANGED = "uploadCaseSensitiveChanged";
    public static final String UPLOADSPECIALCHARACTERSCHANGED = "uploadSpecialCharactersChanged";
    private static final String PROPERTY_SET_ROLE = "SourceTableOptions";
    private static final String PROPERTY_NAME_IDXWHERE = "idxwhere";
    private static final String PROPERTY_NAME_FIRSTOBS = "firstobs";
    private static final String PROPERTY_NAME_OBS = "obs";
    private static final String PROPERTY_NAME_READBUFF = "readbuff";
    private static final String PROPERTY_NAME_DBMSLIBRRARY = "dbmsLibrary";
    private static final String PROPERTY_NAME_PREUPLOADACTION = "preUploadAction";
    private static final String PROPERTY_NAME_UPLOADBULKLOAD = "bulkload";
    private static final String PROPERTY_NAME_BULKLOADOPTIONS = "bl_options";
    private static final String PROPERTY_NAME_UPLOADOPTIONS = "uploadOptions";
    private boolean DEFAULT_IDXWHERE = false;
    private String DEFAULT_BLANK_STRING = "";
    private boolean m_idxWhere;
    private String m_obs;
    private String m_firstObs;
    private String m_readBuff;
    private SASLibrary m_uploadLibrary;
    private String m_preUploadAction;
    private boolean m_uploadWithBulkload;
    private String m_bulkloadOptions;
    private String m_uploadOptions;
    private boolean m_caseSensitiveUploadTable;
    private boolean m_specialCharactersUploadTable;
    private List m_preUploadTranslated = new ArrayList();
    private List m_preUploadUnTranslated = new ArrayList();
    private static String PREUPLOAD_DELETE = "delete";
    private static String PREUPLOAD_TRUNCATE = "truncate";
    private String DEFAULT_PREUPLOAD_ACTION = PREUPLOAD_DELETE;
    private boolean DEFAULT_UPLOAD_BULKLOAD = false;
    private MdObjectStore m_storeForMovetoDBMS;

    public SourceTable(DataTable table) {
        super(table);
        try {
            if (table.getCMetadataType().equalsIgnoreCase("QueryTable")) {
                this.m_alias = new TableAlias((QueryTable)table);
                this.m_alias.setParent(this);
                this.m_table = null;
            } else {
                this.m_alias = new TableAlias(table, "");
                this.m_alias.setParent(this);
            }
            try {
                this.m_caseSensitiveUploadTable = DBMSNamesPropertyHandler.getCasePropertyValue((Root)table).equals("Y");
                this.m_specialCharactersUploadTable = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)table).equals("Y");
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                }
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            this.m_idxWhere = this.DEFAULT_IDXWHERE;
            this.m_obs = this.DEFAULT_BLANK_STRING;
            this.m_firstObs = this.DEFAULT_BLANK_STRING;
            this.m_readBuff = this.DEFAULT_BLANK_STRING;
            this.m_uploadLibrary = null;
            this.m_preUploadAction = this.DEFAULT_PREUPLOAD_ACTION;
            this.m_uploadWithBulkload = this.DEFAULT_UPLOAD_BULKLOAD;
            this.m_bulkloadOptions = this.DEFAULT_BLANK_STRING;
            this.m_uploadOptions = this.DEFAULT_BLANK_STRING;
            this.m_preUploadUnTranslated.add(PREUPLOAD_DELETE);
            this.m_preUploadUnTranslated.add(PREUPLOAD_TRUNCATE);
            this.m_preUploadTranslated = this.createTranslatedList("PreUploadAction", this.m_preUploadUnTranslated);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public String getAdditionalUploadOptions() {
        return this.m_uploadOptions;
    }

    public void setAdditionalUploadOptions(String options) {
        if (this.m_uploadOptions.equalsIgnoreCase(options)) {
            return;
        }
        this.m_uploadOptions = options;
        this.m_model.fireChangeEvent(this, UPLOADOPTIONSCHANGED);
    }

    @Override
    public void setAlias(String alias) {
        if (super.getAlias().equals(alias)) {
            return;
        }
        super.setAlias(alias);
        this.getSQLModel().fireChangeEvent(this, "AliasChanged");
    }

    public String getBulkloadOptions() {
        return this.m_bulkloadOptions;
    }

    public void setBulkloadOptions(String options) {
        if (this.m_bulkloadOptions.equalsIgnoreCase(options)) {
            return;
        }
        this.m_bulkloadOptions = options;
        this.m_model.fireChangeEvent(this, BULKLOADOPTIONSCHANGED);
    }

    public boolean isUploadWithBulkload() {
        return this.m_uploadWithBulkload;
    }

    public void setUploadWithBulkload(boolean bulkload) {
        if (bulkload == this.m_uploadWithBulkload) {
            return;
        }
        this.m_uploadWithBulkload = bulkload;
        this.m_model.fireChangeEvent(this, UPLOADBULKLOADCHANGED);
    }

    public List getPreUploadTranslatedValues() {
        return this.m_preUploadTranslated;
    }

    public List getPreUploadUnTranslatedValues() {
        return this.m_preUploadUnTranslated;
    }

    public String getPreUploadAction() {
        return this.m_preUploadAction;
    }

    public void setPreUploadAction(String action) {
        if (action.equals(this.m_preUploadAction)) {
            return;
        }
        this.m_preUploadAction = action;
        this.m_model.fireChangeEvent(this, PREUPLOADACTIONCHANGED);
    }

    public List getDataTables() {
        ArrayList<DataTable> lTables = new ArrayList<DataTable>();
        lTables.add(this.m_table);
        return lTables;
    }

    @Override
    public List getSourceTables() {
        ArrayList<SourceTable> lsources = new ArrayList<SourceTable>();
        lsources.add(this);
        return lsources;
    }

    @Override
    public String getDataTableName() {
        String tableName = "";
        tableName = this.isAliased() ? this.m_alias.getAliasName() : super.getDataTableName();
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataTableName(CodegenRequest cgReq) {
        String tableName = "";
        if (this.isAliased()) {
            tableName = this.m_alias.getAliasName();
        } else if (this.m_table instanceof PhysicalTable && this.isMoveTableToUploadLibrary()) {
            try {
                DBMSSTORE tableCG = this.getDBMSStore(cgReq);
                tableName = tableCG.getTableName(cgReq, true, this.getSQLModel().isPassThrough());
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                }
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                this.cleanup(cgReq);
            }
        } else {
            tableName = super.getDataTableName(cgReq);
        }
        return tableName;
    }

    @Override
    public boolean hasImplicitJoin() {
        return false;
    }

    @Override
    public void remove() {
        this.setParent(null);
        this.getParentQuery().removeSourceTable(this);
        this.dispose();
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        QueryTable qTable;
        super.moveDataToModel();
        if (this.m_table == null) {
            this.m_table = this.m_alias.getDataTable();
        }
        if ((qTable = this.m_alias.getQueryTable()) != null) {
            PropertyHandler pHandler = this.createPropertyHandler();
            this.m_options = pHandler.getSpecificOptionValue("AdditionalOptions");
            this.m_idxWhere = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_IDXWHERE), this.DEFAULT_IDXWHERE);
            this.m_firstObs = pHandler.getSpecificOptionValue(PROPERTY_NAME_FIRSTOBS);
            this.m_obs = pHandler.getSpecificOptionValue(PROPERTY_NAME_OBS);
            this.m_readBuff = pHandler.getSpecificOptionValue(PROPERTY_NAME_READBUFF);
            this.m_uploadLibrary = (SASLibrary)pHandler.getPropertyMetadataObject(PROPERTY_NAME_DBMSLIBRRARY);
            this.m_preUploadAction = pHandler.getSpecificOptionValue(PROPERTY_NAME_PREUPLOADACTION, this.DEFAULT_PREUPLOAD_ACTION);
            this.m_uploadWithBulkload = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_UPLOADBULKLOAD), this.DEFAULT_UPLOAD_BULKLOAD);
            this.m_bulkloadOptions = pHandler.getSpecificOptionValue(PROPERTY_NAME_BULKLOADOPTIONS);
            this.m_uploadOptions = pHandler.getSpecificOptionValue(PROPERTY_NAME_UPLOADOPTIONS);
            if (DBMSNamesPropertyHandler.getDBMSNamesPropertySet((Root)qTable) != null) {
                this.m_caseSensitiveUploadTable = DBMSNamesPropertyHandler.getCasePropertyValue((Root)qTable).equals("Y");
                this.m_specialCharactersUploadTable = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)qTable).equals("Y");
            } else {
                this.m_caseSensitiveUploadTable = DBMSNamesPropertyHandler.getCasePropertyValue((Root)this.m_table).equals("Y");
                this.m_specialCharactersUploadTable = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)this.m_table).equals("Y");
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        QueryTable qTable = this.m_alias.getQueryTable();
        PropertyHandler pHandler = this.createPropertyHandler();
        pHandler.setSpecificProperty("AdditionalOptions", this.m_options, "AdditionalOptions", "", 1, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_IDXWHERE, pHandler.booleanToString(this.m_idxWhere), PROPERTY_NAME_IDXWHERE, "=", 0, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_FIRSTOBS, this.m_firstObs, PROPERTY_NAME_FIRSTOBS, "=", 0, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_OBS, this.m_obs, PROPERTY_NAME_OBS, "=", 0, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_READBUFF, this.m_readBuff, PROPERTY_NAME_READBUFF, "=", 0, null);
        pHandler.setPropertyMetadataObject((MdObjectStore)qTable.getObjectStore(), PROPERTY_NAME_DBMSLIBRRARY, (CMetadata)this.m_uploadLibrary);
        pHandler.setSpecificProperty(PROPERTY_NAME_PREUPLOADACTION, this.m_preUploadAction, PROPERTY_NAME_PREUPLOADACTION, "", 1, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_UPLOADBULKLOAD, pHandler.booleanToString(this.m_uploadWithBulkload), PROPERTY_NAME_UPLOADBULKLOAD, "=", 1, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_BULKLOADOPTIONS, this.m_bulkloadOptions, PROPERTY_NAME_BULKLOADOPTIONS, "", 1, null);
        pHandler.setSpecificProperty(PROPERTY_NAME_UPLOADOPTIONS, this.m_uploadOptions, PROPERTY_NAME_UPLOADOPTIONS, "", 1, null);
        DBMSNamesPropertyHandler.createDBMSNamesPropertySet((Root)qTable, (String)(this.m_caseSensitiveUploadTable ? "Y" : "N"), (String)(this.m_specialCharactersUploadTable ? "Y" : "N"));
    }

    private PropertyHandler createPropertyHandler() throws MdException, RemoteException {
        QueryTable queryTable = this.m_alias.getQueryTable();
        if (queryTable != null) {
            return new PropertyHandler((Root)queryTable, PROPERTY_SET_ROLE, true);
        }
        return null;
    }

    private PropertyHandler getPropertyHandler() throws MdException, RemoteException {
        QueryTable queryTable = this.m_alias.getQueryTable();
        return new PropertyHandler((Root)queryTable, PROPERTY_SET_ROLE, true);
    }

    @Override
    public void dispose() {
        if (this.m_columns != null) {
            for (int i = 0; i < this.m_columns.size(); ++i) {
                TableColumn qCol = (TableColumn)this.m_columns.get(i);
                qCol.dispose();
            }
            this.m_columns.clear();
        }
        try {
            QueryTable qTable;
            PropertyHandler pHandler = this.getPropertyHandler();
            PropertySet pSet = pHandler.getPropertySet();
            ArrayList<PropertySet> deleteObjects = new ArrayList<PropertySet>();
            if (pSet != null) {
                deleteObjects.add(pSet);
                deleteObjects.addAll((Collection<PropertySet>)pHandler.getPropertyList());
            }
            if ((qTable = this.getQueryTable()) != null) {
                List objects;
                PropertySet propSet = DBMSNamesPropertyHandler.getDBMSNamesPropertySet((Root)qTable);
                if (propSet != null) {
                    deleteObjects.add(propSet);
                }
                if ((objects = DBMSNamesPropertyHandler.getPropertyList((Root)qTable)) != null) {
                    deleteObjects.addAll(objects);
                }
            }
            if (this.m_table != null) {
                MdObjectStore store = (MdObjectStore)this.m_table.getObjectStore();
                store.removeObjectsFromStore(deleteObjects);
            }
        }
        catch (MdException exc) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (this.m_alias != null) {
            this.m_alias.dispose();
            this.m_alias = null;
        }
        this.m_table = null;
    }

    @Override
    public boolean hasOpenTemplates() {
        return false;
    }

    @Override
    public List getSourceObjectsWithOpenTemplates() {
        return new ArrayList();
    }

    @Override
    public List getSubqueries() {
        return new ArrayList();
    }

    @Override
    public void removeExpressionsContainingQuery(Query query) {
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        SQLModel model = this.getSQLModel();
        boolean passthru = model.isPassThrough();
        cgReq.addSourceCode(this.getDataTableLocation(cgReq, passthru));
        this.genTableOptions(cgReq);
        if (this.isAliased()) {
            cgReq.addSourceCode(model.getTableAliasKeyword());
            cgReq.addSourceCode(this.getAlias());
        }
    }

    @Override
    public void genTableOptions(CodegenRequest cgReq) {
        if (this.hasTableOptions()) {
            boolean passthru = this.m_model.isPassThrough();
            cgReq.addSourceCode("\n");
            cgReq.addSourceCode("(\n");
            cgReq.indent();
            if (this.m_idxWhere && !passthru) {
                cgReq.addSourceCode("idxwhere = yes\n");
            }
            if (this.m_obs.length() > 0 && !passthru) {
                cgReq.addSourceCode("obs = ").addSourceCode(this.m_obs).addSourceCode("\n");
            }
            if (this.m_firstObs.length() > 0 && !passthru) {
                cgReq.addSourceCode("firstobs = ").addSourceCode(this.m_firstObs).addSourceCode("\n");
            }
            if (this.m_readBuff.length() > 0 && !passthru) {
                cgReq.addSourceCode("readbuff = ").addSourceCode(this.m_readBuff).addSourceCode("\n");
            }
            if (this.m_options.length() > 0) {
                cgReq.addSourceCode(this.m_options).addSourceCode("\n");
            }
            cgReq.unIndent();
            cgReq.addSourceCode(")");
        }
    }

    @Override
    public boolean hasTableOptions() {
        boolean passthru = this.m_model.isPassThrough();
        if (super.hasTableOptions()) {
            return true;
        }
        if (this.m_idxWhere && !passthru) {
            return true;
        }
        if (!"".equals(this.m_obs) && !passthru) {
            return true;
        }
        if (!"".equals(this.m_firstObs) && !passthru) {
            return true;
        }
        return !"".equals(this.m_readBuff) && !passthru;
    }

    public void setIdxWhere(boolean idxWhere) {
        if (idxWhere == this.m_idxWhere) {
            return;
        }
        this.m_idxWhere = idxWhere;
        this.m_model.fireChangeEvent(this, IDXWHERECHANGED);
    }

    public boolean isIdxWhere() {
        return this.m_idxWhere;
    }

    public void setObs(String obs) {
        if (obs == this.m_obs) {
            return;
        }
        this.m_obs = obs;
        this.m_model.fireChangeEvent(this, OBSCHANGED);
    }

    public String getObs() {
        return this.m_obs;
    }

    public void setFirstObs(String firstObs) {
        if (firstObs == this.m_firstObs) {
            return;
        }
        this.m_firstObs = firstObs;
        this.m_model.fireChangeEvent(this, FIRSTOBSCHANGED);
    }

    public String getFirstObs() {
        return this.m_firstObs;
    }

    public void setReadBuff(String readBuff) {
        if (readBuff == this.m_readBuff) {
            return;
        }
        this.m_readBuff = readBuff;
        this.m_model.fireChangeEvent(this, READBUFFCHANGED);
    }

    public String getReadBuff() {
        return this.m_readBuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUploadLibrary(SASLibrary lib) {
        try {
            String mFQID = "";
            String lFQID = "";
            if (this.m_uploadLibrary != null) {
                mFQID = this.m_uploadLibrary.getFQID();
            }
            if (lib != null) {
                lFQID = lib.getFQID();
            }
            if (mFQID.equals(lFQID)) {
                return;
            }
            if (lib != null) {
                MdObjectStore lStore = (MdObjectStore)lib.getObjectStore();
                boolean gotoServer = lStore.getIsGoToServerForMetadata();
                if (!gotoServer) {
                    lStore.setIsGotToServerForMetadata(true);
                }
                try {
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)lib, null, null, "<SASLibrary Libref=\"\"></SASLibrary>", 12);
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                    } else {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                finally {
                    lStore.setIsGotToServerForMetadata(gotoServer);
                }
            }
            this.m_uploadLibrary = lib;
            this.m_model.fireChangeEvent(this, DBMSLIBRARYCHANGED);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public SASLibrary getUploadLibrary() {
        return this.m_uploadLibrary;
    }

    public boolean isMoveTableToUploadLibrary() {
        return this.m_table instanceof PhysicalTable && this.m_uploadLibrary != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTableToUploadLibrary(CodegenRequest cgReq) {
        if (this.isMoveTableToUploadLibrary()) {
            try {
                PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.m_table);
                boolean deleteTableAction = this.m_preUploadAction.equals(PREUPLOAD_DELETE);
                ArrayList<String> optionList = new ArrayList<String>();
                if (this.m_uploadWithBulkload) {
                    optionList.add("bulkload = yes");
                }
                if (this.m_bulkloadOptions.trim().length() > 0) {
                    optionList.add("bl_options = " + this.m_bulkloadOptions);
                }
                if (this.m_uploadOptions.trim().length() > 0) {
                    optionList.add(this.m_uploadOptions);
                }
                tableCG.moveTableToLibrary(cgReq, this.m_storeForMovetoDBMS, this.m_uploadLibrary, deleteTableAction, optionList, this.m_caseSensitiveUploadTable, this.m_specialCharactersUploadTable);
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                this.cleanup(cgReq);
            }
        }
    }

    public DataTable getTable(CodegenRequest cgReq) throws MdException, RemoteException {
        DataTable table = null;
        SourceTable movedSource = this.getSQLModel().getSourceDataTableMoved(this.m_table);
        if (this.isMoveTableToUploadLibrary() || movedSource != null) {
            if (this.m_storeForMovetoDBMS != null) {
                this.m_storeForMovetoDBMS.dispose();
                this.m_storeForMovetoDBMS = null;
            }
            SASLibrary uploadLib = this.m_uploadLibrary;
            boolean caseSens = this.m_caseSensitiveUploadTable;
            boolean specChar = this.m_specialCharactersUploadTable;
            if (!this.isMoveTableToUploadLibrary()) {
                uploadLib = movedSource.getUploadLibrary();
                caseSens = movedSource.isUploadTableCaseSensitive();
                specChar = movedSource.isUploadTableSpecialCharacters();
            }
            this.m_storeForMovetoDBMS = Workspace.getMdFactory().createObjectStore(this.m_table.getObjectStore(), "SourceTable: MoveToDBMS Store");
            PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.m_table);
            table = tableCG.getUploadTable(cgReq, this.m_storeForMovetoDBMS, uploadLib, caseSens, specChar);
        } else {
            table = this.m_table;
        }
        return table;
    }

    @Override
    public String getDataTableLocation(CodegenRequest cgReq, boolean passthru) {
        return this.getDataTableLocation(cgReq, passthru, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataTableLocation(CodegenRequest cgReq, boolean passthru, boolean ignoreMove) {
        try {
            String tableLocation = "";
            if (this.m_table == null) {
                return tableLocation;
            }
            MdObjectStore store = (MdObjectStore)this.m_table.getObjectStore();
            if (!ignoreMove && this.isMoveTableToUploadLibrary() || this.getSQLModel().getSourceDataTableMoved(this.m_table) != null) {
                try {
                    DBMSSTORE tableCG = this.getDBMSStore(cgReq);
                    tableLocation = tableCG.getDataLocation(cgReq, passthru, true);
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                finally {
                    try {
                        this.deleteWorkLibrary(cgReq, store);
                    }
                    catch (MdException exc) {
                        if (this.getSQLModel().isSilentModeEnabled()) {
                            System.out.print(exc.getLocalizedMessage());
                        }
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    this.cleanup(cgReq);
                }
            } else if (this.m_table instanceof PhysicalTable) {
                try {
                    PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.m_table);
                    tableLocation = tableCG.getDataLocation(cgReq, passthru, true);
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                    } else {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                }
                finally {
                    try {
                        this.deleteWorkLibrary(cgReq, store);
                    }
                    catch (MdException exc) {
                        if (this.getSQLModel().isSilentModeEnabled()) {
                            System.out.print(exc.getLocalizedMessage());
                        }
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                }
            }
            return tableLocation;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void cleanup(CodegenRequest cgReq) {
        try {
            if (this.m_storeForMovetoDBMS != null) {
                this.m_storeForMovetoDBMS.dispose();
                this.m_storeForMovetoDBMS = null;
                cgReq.removeObjectFromCache((CMetadata)this.getDataTable());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public CodegenRequest genCleanUpMovedTableCode(CodegenRequest cgReq) throws MdException, RemoteException {
        if (!this.getSQLModel().getStatement().getTargetTable().isTableAView()) {
            DBMSSTORE dStore = this.getDBMSStore(cgReq);
            if (this.m_preUploadAction.equals(PREUPLOAD_DELETE)) {
                dStore.drop(cgReq, false);
            } else {
                dStore.deleteAllRows(cgReq, true);
            }
        }
        this.cleanup(cgReq);
        return cgReq;
    }

    @Override
    public DBMSSTORE getDBMSStore(CodegenRequest cgReq) {
        DBMSSTORE sourceTableCG = null;
        try {
            sourceTableCG = new Loader(cgReq, (PhysicalTable)this.getTable(cgReq)).getDBMSSTORE();
        }
        catch (MdException exc) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return sourceTableCG;
    }

    public boolean isSourceDataTableEqual(SourceTable table) {
        return this.isSourceDataTableEqual(table.getDataTable());
    }

    public boolean isSourceDataTableEqual(DataTable table) {
        try {
            DataTable origTable = this.getDataTable();
            return origTable.getFQID().equals(table.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean isUploadTableCaseSensitive() {
        return this.m_caseSensitiveUploadTable;
    }

    public void setUploadTableCaseSensitive(boolean caseSensitive) {
        if (this.m_caseSensitiveUploadTable == caseSensitive) {
            return;
        }
        this.m_caseSensitiveUploadTable = caseSensitive;
        this.m_model.fireChangeEvent(this, UPLOADCASESENSITIVECHANGED);
    }

    public boolean isUploadTableSpecialCharacters() {
        return this.m_specialCharactersUploadTable;
    }

    public void setUploadTableSpecialCharacters(boolean specialCharacters) {
        if (this.m_specialCharactersUploadTable == specialCharacters) {
            return;
        }
        this.m_specialCharactersUploadTable = specialCharacters;
        this.m_model.fireChangeEvent(this, UPLOADSPECIALCHARACTERSCHANGED);
    }

    private List createTranslatedList(String keyPrefix, List untrans) {
        ArrayList<String> transValues = new ArrayList<String>(untrans.size());
        for (int i = 0; i < untrans.size(); ++i) {
            transValues.add(bundle.getString("SourceTable." + keyPrefix + "." + untrans.get(i) + ".txt"));
        }
        return transValues;
    }
}

