/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.ResultMapping;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;

public class SelectResults
extends AbstractClause {
    private static final WAdminResource bundle = WAdminResource.getBundle(SelectResults.class);
    public static final String USEIMPLICITCHANGED = "useImplicitChanged";
    public static final String USEDISTINCTCHANGED = "useDistinctChanged";
    public static final String SELECTCHANGED = "selectChanged";
    private static final String PROPERTY_SET_NAME_SELECT = "SelectProperties";
    private static final String PROPERTY_NAME_DISTINCT = "Distinct";
    private static final String PROPERTY_NAME_IMPLICIT = "Implicit";
    private boolean m_useImplicit = false;
    private boolean m_useDistinct = false;
    private List m_lResultMappings;
    private List m_featureMaps;
    private ClassifierMap m_classifierMap;

    public SelectResults() {
        this(null, false, false);
    }

    public SelectResults(ClassifierMap classifierMap) {
        this(classifierMap, false, false);
    }

    public SelectResults(ClassifierMap classifierMap, boolean useDistinct, boolean useImplicit) {
        this.m_classifierMap = classifierMap;
        this.m_useDistinct = useDistinct;
        this.m_useImplicit = useImplicit;
        this.m_lResultMappings = new ArrayList();
    }

    @Override
    public String getName() {
        return "Select";
    }

    @Override
    public Icon getIcon() {
        return bundle.getImageIcon("SelectResults.node.image");
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        String desc;
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        if ((desc = this.getDescription()).length() > 0) {
            cgReq.addCommentLine(desc);
        }
        cgReq.addSourceCode("select");
        if (this.useDistinct()) {
            cgReq.addSourceCode(" distinct");
        }
        if (this.useImplicit()) {
            cgReq.addSourceCode(" *\n");
        } else {
            cgReq.addSourceCode("\n").indent();
            List orList = this.getOrderedMappingList();
            int size = orList.size();
            if (!this.allUnMapped()) {
                for (int i = 0; i < size; ++i) {
                    ResultMapping mapping = (ResultMapping)orList.get(i);
                    mapping.appendCode(cgReq, resetPosition);
                    if (i != size - 1) {
                        cgReq.addSourceCode(",\n");
                        continue;
                    }
                    cgReq.addSourceCode("\n");
                }
            } else {
                cgReq.throwException(bundle.getString("SelectResults.NoColumnMappings.Error.txt"));
            }
            cgReq.unIndent();
        }
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
    }

    private boolean allUnMapped() {
        boolean unmapped = true;
        int size = this.m_lResultMappings.size();
        for (int i = 0; i < size; ++i) {
            ResultMapping rMap = (ResultMapping)this.m_lResultMappings.get(i);
            if (rMap.getRole().equals("UNMAPPED")) continue;
            return false;
        }
        return unmapped;
    }

    private List getOrderedMappingList() {
        int size = this.m_lResultMappings.size();
        ResultMapping[] orList = new ResultMapping[size];
        List targetColumns = this.getTargetTable().getTableColumns();
        for (int i = 0; i < size; ++i) {
            ResultMapping rMap = (ResultMapping)this.m_lResultMappings.get(i);
            TableColumn tColumn = rMap.getTargetColumn();
            orList[targetColumns.indexOf((Object)tColumn)] = rMap;
        }
        return Arrays.asList(orList);
    }

    public List getUnMappedColumns() {
        ArrayList<TableColumn> unMapped = new ArrayList<TableColumn>();
        int size = this.m_lResultMappings.size();
        for (int i = 0; i < size; ++i) {
            ResultMapping rMap = (ResultMapping)this.m_lResultMappings.get(i);
            if (!rMap.getRole().equals("UNMAPPED")) continue;
            unMapped.add(rMap.getTargetColumn());
        }
        return unMapped;
    }

    public List getResultMappingColumns() {
        ArrayList<TableColumn> resultColumns = new ArrayList<TableColumn>();
        if (this.m_lResultMappings != null) {
            for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
                ResultMapping mapping = (ResultMapping)this.m_lResultMappings.get(i);
                resultColumns.add(mapping.getTargetColumn());
            }
        }
        return resultColumns;
    }

    public boolean useDistinct() {
        return this.m_useDistinct;
    }

    public void setUseDistinct(boolean useDistinct) {
        if (this.m_useDistinct == useDistinct) {
            return;
        }
        this.m_useDistinct = useDistinct;
        this.getSQLModel().fireChangeEvent(this, USEDISTINCTCHANGED);
    }

    public boolean useImplicit() {
        return this.m_useImplicit;
    }

    public void setUseImplicit(boolean useImplicit) {
        if (this.m_useImplicit == useImplicit) {
            return;
        }
        this.m_useImplicit = useImplicit;
        this.getSQLModel().fireChangeEvent(this, USEIMPLICITCHANGED);
    }

    public List getSourceTables() {
        return this.getParentQuery().getAllSourceTables();
    }

    public TargetTable getTargetTable() {
        return this.getParentQuery().getTargetTable();
    }

    public DataTable getTargetDataTable() {
        return this.getParentQuery().getTargetDataTable();
    }

    public List getFeatureMaps() {
        return this.m_featureMaps;
    }

    public List getResultMappings() {
        return this.m_lResultMappings;
    }

    public boolean canDisplayInteger(TableColumn tblColumn) {
        ResultMapping map = this.findTargetResultMapping(tblColumn);
        if (map != null) {
            return true;
        }
        map = this.findOneToOneResultMappingUsingSourceColumn(tblColumn);
        return map != null;
    }

    public ResultMapping findOneToOneResultMappingUsingSourceColumn(TableColumn srcColumn) {
        for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            TableColumn qCol;
            List srcColumns;
            ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
            String type = map.getRole();
            if (!type.equalsIgnoreCase("ONETOONE") || (srcColumns = map.getSourceColumns()).isEmpty() || !(qCol = (TableColumn)srcColumns.get(0)).equals(srcColumn)) continue;
            return map;
        }
        return null;
    }

    public ResultMapping findResultMapping(Column column) {
        try {
            for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
                ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
                TableColumn mapColumn = map.getTargetColumn();
                Column targetCol = mapColumn.getColumn();
                if (!column.getFQID().equalsIgnoreCase(targetCol.getFQID())) continue;
                return map;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public ResultMapping findTargetResultMapping(TableColumn targetColumn) {
        for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
            TableColumn mapColumn = map.getTargetColumn();
            if (!targetColumn.equals(mapColumn)) continue;
            return map;
        }
        return null;
    }

    public List removeSourceFromResultMappings(TableColumn sourceColumn) {
        ArrayList<ResultMapping> updatedList = new ArrayList<ResultMapping>();
        for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
            List cols = map.getSourceColumns();
            if (!cols.contains(sourceColumn)) continue;
            map.removeSourceColumn(sourceColumn);
            updatedList.add(map);
        }
        return updatedList;
    }

    public void addMapping(int index, ResultMapping mapping) {
        if (mapping == null) {
            return;
        }
        if (this.m_lResultMappings == null) {
            this.m_lResultMappings = new Vector();
        }
        mapping.setParent(this);
        mapping.setSQLModel(this.getSQLModel());
        mapping.setParentQuery(this.getParentQuery());
        this.m_lResultMappings.add(index, mapping);
        this.getSQLModel().fireChangeEvent(this, SELECTCHANGED);
    }

    public void removeMapping(ResultMapping mapping) {
        this.m_lResultMappings.remove(mapping);
        mapping.dispose();
        mapping = null;
        this.getSQLModel().fireChangeEvent(this, SELECTCHANGED);
    }

    public void removeResultsContainingTable(TableInterface table) {
        block0: for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            ResultMapping result = (ResultMapping)this.m_lResultMappings.get(i);
            if (!result.containsTable(table)) continue;
            List sources = result.getSourceColumns();
            for (int j = 0; j < sources.size(); ++j) {
                TableColumn qCol = (TableColumn)sources.get(j);
                AbstractTable srcTable = qCol.getParent();
                if (srcTable != table) continue;
                if (this.getParentQuery() instanceof SubQuery && this.m_useImplicit && result.getRole().equalsIgnoreCase("ONETOONE")) {
                    TableColumn tgtColumn = result.getTargetColumn();
                    AbstractTable tgtTbl = tgtColumn.getParent();
                    if (tgtTbl != null) {
                        tgtTbl.removeTableColumn(tgtColumn);
                    }
                    this.removeMapping(result);
                    --i;
                    result.dispose();
                    continue block0;
                }
                result.removeSourceColumn(qCol);
                --j;
            }
        }
    }

    public void removeExpressionsContainingQuery(Query query) {
        this.getSQLModel().setFireEventsEnabled(false);
        for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            ResultMapping result = (ResultMapping)this.m_lResultMappings.get(i);
            if (!result.containsQuery(query)) continue;
            OperandInterface operand = result.getDerivedExpression();
            operand.dispose();
            result.setDerivedExpression(new TextOperand(null, ""));
            result.setRole("UNMAPPED");
        }
        this.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
    }

    public List getSubQueries() {
        ArrayList<OperandInterface> subQueries = new ArrayList<OperandInterface>();
        if (this.m_lResultMappings == null) {
            return subQueries;
        }
        for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            ResultMapping mapping = (ResultMapping)this.m_lResultMappings.get(i);
            OperandInterface derived = mapping.getDerivedExpression();
            if (derived == null || !derived.getOperandType().equalsIgnoreCase("SubQueryOperand")) continue;
            subQueries.add(derived);
        }
        return subQueries;
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        int i;
        Query query = this.getParentQuery();
        if (this.m_classifierMap == null) {
            this.m_classifierMap = query instanceof SubQuery ? query.getSelectObject() : this.getSQLModel().getClassifierMap();
        }
        this.m_lResultMappings.clear();
        TargetTable sqlTarget = query.getTargetTable();
        List qCols = sqlTarget.getTableColumns();
        for (i = 0; i < qCols.size(); ++i) {
            TableColumn qCol = (TableColumn)qCols.get(i);
            ResultMapping result = new ResultMapping(null, qCol, null, "UNMAPPED", this);
            this.addMapping(i, result);
        }
        this.m_featureMaps = this.m_classifierMap.getFeatureMaps();
        for (i = 0; i < this.m_featureMaps.size(); ++i) {
            Column col;
            ResultMapping map;
            AssociationList targets;
            FeatureMap fM = (FeatureMap)this.m_featureMaps.get(i);
            if (fM == null || (targets = fM.getFeatureTargets()).isEmpty() || (map = this.findResultMapping(col = (Column)targets.get(0))) == null) continue;
            map.setFeatureMap(fM);
            map.moveDataToModel();
        }
        Select select = query.getSelectObject();
        if (select != null) {
            PropertyHandler pHandler = this.createPropertyHandler(select);
            this.m_useDistinct = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_DISTINCT), false);
            boolean useDefault = false;
            if (query instanceof SubQuery) {
                useDefault = true;
            }
            this.m_useImplicit = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_IMPLICIT), useDefault);
            this.setDescription(select.getDesc());
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        AssociationList maps = this.m_classifierMap.getFeatureMaps();
        ArrayList<FeatureMap> fMapsToKeep = new ArrayList<FeatureMap>();
        for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
            ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
            map.moveDataToStore();
            FeatureMap fm = map.getFeatureMap();
            if (fm == null) continue;
            fMapsToKeep.add(fm);
        }
        ArrayList<FeatureMap> deleteList = new ArrayList<FeatureMap>();
        int size = maps.size();
        for (int i = 0; i < size; ++i) {
            FeatureMap fMap = (FeatureMap)maps.get(i);
            if (fMap == null || this.findResultMapping(fMap) != null) continue;
            deleteList.add(fMap);
        }
        size = deleteList.size();
        MdObjectStore store = (MdObjectStore)this.m_classifierMap.getObjectStore();
        for (int i = 0; i < size; ++i) {
            store.removeObjectFromStore((CMetadata)((FeatureMap)deleteList.get(i)), "<FeatureMap><SourceCode/><Extensions/><Notes/><Documents/><Properties/><SubstitutionVariables/><TransformationSources/><TransformationTargets><SourceCode/></TransformationTargets></FeatureMap>");
        }
        maps.removeAllElements();
        maps.flushAll();
        maps.addAll(fMapsToKeep);
        Query query = this.getParentQuery();
        Select select = query.getSelectObject();
        if (select != null) {
            PropertyHandler pHandler = this.createPropertyHandler(select);
            pHandler.setSpecificProperty(PROPERTY_NAME_DISTINCT, pHandler.booleanToString(this.m_useDistinct), PROPERTY_NAME_DISTINCT, "", 1, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_IMPLICIT, pHandler.booleanToString(this.m_useImplicit), PROPERTY_NAME_IMPLICIT, "", 1, null);
            select.setDesc(this.getDescription());
        }
    }

    public TableColumn findTableColumn(String columnName, AbstractTable table) {
        List columns = table.getTableColumns();
        for (int i = 0; i < columns.size(); ++i) {
            TableColumn qCol = (TableColumn)columns.get(i);
            if (!qCol.getName().equalsIgnoreCase(columnName)) continue;
            return qCol;
        }
        return null;
    }

    protected PropertyHandler createPropertyHandler(Select select) throws MdException, RemoteException {
        return new PropertyHandler((Root)select, PROPERTY_SET_NAME_SELECT, true);
    }

    @Override
    public void dispose() {
        Query query = this.getParentQuery();
        Select select = query.getSelectObject();
        if (this.m_lResultMappings != null) {
            for (int i = 0; i < this.m_lResultMappings.size(); ++i) {
                ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
                map.dispose();
            }
            this.m_lResultMappings.clear();
            this.m_lResultMappings = null;
        }
        String strTemplate = "<Select><PropertySets><Properties/><SetProperties/></PropertySets><Properties></Properties></Select>";
        try {
            if (select != null) {
                this.getSQLModel().getObjectStore().removeObjectFromStore((CMetadata)select, strTemplate);
                select = null;
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_classifierMap = null;
    }

    private ResultMapping findResultMapping(FeatureMap fMap) {
        try {
            int size = this.m_lResultMappings.size();
            for (int i = 0; i < size; ++i) {
                ResultMapping map = (ResultMapping)this.m_lResultMappings.get(i);
                FeatureMap mapFM = map.getFeatureMap();
                if (mapFM == null || !mapFM.getFQID().equals(fMap.getFQID())) continue;
                return map;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }
}

