/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsViewFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SQLUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePFDTables(SQLModel model, Query query) {
        ArrayList<DataTable> newPFDTables = new ArrayList<DataTable>();
        ArrayList<DataTable> removePFDTables = new ArrayList<DataTable>();
        ArrayList sourceTables = new ArrayList();
        sourceTables.addAll(query.getSourceTables());
        List queryTables = query.getSubQuerySourceTables();
        sourceTables.addAll(queryTables);
        try {
            int i;
            ClassifierMap mainCM = model.getClassifierMap();
            AssociationList pfdSourceTables = mainCM.getClassifierSources();
            int size = pfdSourceTables.size();
            boolean addAll = false;
            if (size == 0) {
                addAll = true;
            } else {
                for (i = 0; i < pfdSourceTables.size(); ++i) {
                    DataTable table = (DataTable)pfdSourceTables.get(i);
                    boolean found = false;
                    for (int j = 0; j < sourceTables.size(); ++j) {
                        AbstractTable srcTable = (AbstractTable)sourceTables.get(j);
                        if (srcTable instanceof TargetTable) continue;
                        DataTable srcDataTable = srcTable.getDataTable();
                        if (!table.getFQID().equalsIgnoreCase(srcDataTable.getFQID())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    removePFDTables.add(table);
                }
            }
            for (i = 0; i < sourceTables.size(); ++i) {
                DataTable newTable;
                int j;
                boolean doesExist;
                DataTable table;
                AbstractTable srcTable = (AbstractTable)sourceTables.get(i);
                if (srcTable instanceof TargetTable || (table = srcTable.getDataTable()) == null) continue;
                if (addAll) {
                    doesExist = false;
                    for (j = 0; j < newPFDTables.size(); ++j) {
                        newTable = (DataTable)newPFDTables.get(j);
                        if (!newTable.getFQID().equalsIgnoreCase(table.getFQID())) continue;
                        doesExist = true;
                        break;
                    }
                    if (doesExist) continue;
                    newPFDTables.add(table);
                    continue;
                }
                doesExist = false;
                for (j = 0; j < size; ++j) {
                    DataTable pfdTable = (DataTable)pfdSourceTables.get(j);
                    if (!pfdTable.getFQID().equals(table.getFQID())) continue;
                    doesExist = true;
                    break;
                }
                if (doesExist) continue;
                doesExist = false;
                for (int k = 0; k < newPFDTables.size(); ++k) {
                    newTable = (DataTable)newPFDTables.get(k);
                    if (!newTable.getFQID().equalsIgnoreCase(table.getFQID())) continue;
                    doesExist = true;
                    break;
                }
                if (doesExist) continue;
                newPFDTables.add(table);
            }
            TransformationStep transStep = model.getTransformationStep();
            PFDPanel parentPanel = SQLUtil.getPFDPanel(transStep);
            PFDUtil.enableOnBeforeDeleteEvent(false, transStep);
            try {
                if (parentPanel != null) {
                    for (int i2 = 0; i2 < removePFDTables.size(); ++i2) {
                        DataTable table = (DataTable)removePFDTables.get(i2);
                        if (parentPanel == null) continue;
                        ArrayList<DataTable> list = new ArrayList<DataTable>();
                        list.add(table);
                        pfdSourceTables.remove((Object)table);
                        parentPanel.pfdDeleteObjects(list, false);
                    }
                }
            }
            finally {
                PFDUtil.enableOnBeforeDeleteEvent(true, transStep);
            }
            for (int i3 = 0; i3 < newPFDTables.size(); ++i3) {
                DataTable table = (DataTable)newPFDTables.get(i3);
                boolean isAQueryTable = false;
                for (int j = 0; j < queryTables.size(); ++j) {
                    DataTable qTable;
                    AbstractTable qAbsTable = (AbstractTable)queryTables.get(j);
                    if (qAbsTable instanceof TargetTable || !(qTable = qAbsTable.getDataTable()).getFQID().equalsIgnoreCase(table.getFQID())) continue;
                    isAQueryTable = true;
                    break;
                }
                boolean isAutoMap = false;
                if (isAQueryTable && (isAutoMap = MappingUtil.isAutoMapEnabled(transStep))) {
                    MappingUtil.setAutomapEnabled(transStep, false);
                }
                PFDUtil.dropSourceObject(transStep, table, model.getObjectStore());
                if (!isAQueryTable || !isAutoMap) continue;
                MappingUtil.setAutomapEnabled(transStep, isAutoMap);
            }
            mainCM.updateMetadataAll();
            model.getObjectStore().flushUpdatesToParentStore();
        }
        catch (MdException me) {
            if (model.isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public static PFDPanel getPFDPanel(TransformationStep mdTS) throws MdException, RemoteException {
        Job mdJob = PFDUtil.getJobForTransformationStep(mdTS);
        WAPFDEditorOMAView omaView = (WAPFDEditorOMAView)WsViewFactory.findExistingView((CMetadata)mdJob, (String)WAPFDEditorOMAView.class.getName());
        return omaView != null ? omaView.getPFDPanel() : null;
    }
}

