/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.TransformationActivityCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.Expression;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SQLModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLModel.class);
    public static final String UNKNOWNCHANGES = "unknownChanges";
    public static final String PASSTHROUGHCHANGED = "passThroughChanged";
    public static final String TARGETPASSTHROUGHCHANGED = "targetPassThroughChanged";
    public static final String TARGETPASSTHROUGHACTIONCHANGED = "targetPassThroughActionChanged";
    public static final String SUGGESTSORTMERGEJOINCHANGED = "suggestSortMergeChanged";
    public static final String BUFFERSIZECHANGED = "bufferSizeChanged";
    public static final String INOBSCHANGED = "inObsChanged";
    public static final String OUTOBSCHANGED = "outobsChanged";
    public static final String THREADSCHANGED = "threadsChanged";
    public static final String SPDSPARALLELJOINCHANGED = "spdsParallelJoinChanged";
    public static final String USERWRITTENCHANGED = "userWrittenChanged";
    public static final String USERWRITTENCODECHANGED = "userWrittenCodeChanged";
    public static final String DEBUGCHANGED = "debugChanged";
    public static final String SQLOPTIONSCHANGED = "sqlOptionsChanged";
    public static final String CREATESYSLASTCHANGED = "createSyslastChanged";
    public static final String SYSTEMOPTIONSCHANGED = "systemOptionsChanged";
    public static final String SPDSOPTIONSCHANGED = "additionalSpdsOptionsChanged";
    private static final String SPDS_PARALLEL_SYSTEM_DEFAULT = "systemdefault";
    private static final String SPDS_PARALLEL_JOIN = "plljoin";
    private static final String SPDS_NOPARALLEL_JOIN = "noplljoin";
    private List m_spdsParallelTranslated = new ArrayList();
    private List m_spdsParallelUnTranslated = new ArrayList();
    private static final String THREADS_SYSTEM_DEFAULT = "systemdefault";
    private static final String THREADS_THREADS = "threads";
    private static final String THREADS_NOTHREADS = "nothreads";
    private List m_threadsTranslated = new ArrayList();
    private List m_threadsUnTranslated = new ArrayList();
    public static final String CREATESELECTROLE = "CreateSelect";
    public static final String SELECTROLE = "Select";
    private static final String PROPERTY_SET_ROLE = "SQLModelOptions";
    private static final String PROPERTY_NAME_PASSTHRU = "PASSTHRU";
    private static final String PROPERTY_NAME_TARGET_PASSTHRU = "TARGETPASSTHRU";
    private static final String PROPERTY_NAME_DEBUG = "DEBUG";
    private static final String PROPERTY_NAME_ADDITIONAL_SQL_OPTIONS = "ADDITIONALSQLOPTIONS";
    private static final String PROPERTY_NAME_MAGIC = "magic";
    private static final String PROPERTY_NAME_BUFFER_SIZE = "buffersize";
    private static final String PROPERTY_NAME_INOBS = "inobs";
    private static final String PROPERTY_NAME_OUTOBS = "outobs";
    private static final String PROPERTY_NAME_THREADS = "threads";
    private static final String PROPERTY_NAME_SPDSPARALLELJOIN = "plljoin";
    private static final String PROPERTY_NAME_SPDS_ADDITIONAL_SQL_OPTIONS = "AdditionalSPDSOptions";
    private static final String TS_PROPERTY_SET_ROLE = "OPTIONS";
    private static final String PROPERTY_NAME_SYSLAST = "SYSLAST";
    private static final String PROPERTY_NAME_PRETARGETPASSTHRUACTION = "preTargetPassthruAction";
    private List m_preTargetPassThruTranslated = new ArrayList();
    private List m_preTargetPassThruUnTranslated = new ArrayList();
    private static String PRETARGET_DELETE = "delete";
    private static String PRETARGET_TRUNCATE = "truncate";
    private String DEFAULT_PRETARGET_ACTION = PRETARGET_DELETE;
    private TransformationStep m_transformStep;
    private ClassifierMap m_classifierMap;
    private List m_transformSources;
    private MdObjectStore m_store;
    private String m_reposId;
    private SQLStatementInterface m_statement;
    private String m_defaultRole;
    protected boolean m_bCodeGenSelf = true;
    private boolean m_passThrough = false;
    private boolean m_userWritten = false;
    private String m_userWrittenCode;
    private boolean m_debug = false;
    private String m_sqlOptions = "";
    private boolean m_createSyslast = true;
    private String m_systemOptions = "";
    private boolean m_suggestSortMergeJoin = false;
    private String m_bufferSize = "";
    private String m_inObs = "";
    private String m_outObs = "";
    private String m_threads = "systemdefault";
    private String m_spdsParallelJoin = "systemdefault";
    private String m_spdsOptions = "";
    private boolean m_bViewWorkTables = false;
    private List m_lListeners = new ArrayList();
    private boolean m_fireEventsEnabled;
    private List m_lUndoableObjectList = new ArrayList();
    private CodegenRequest m_cgReq;
    private WsAppServer m_WsAppServer;
    private boolean m_targetIsPassThrough = true;
    private String m_targetPassThroughAction = this.DEFAULT_PRETARGET_ACTION;
    private boolean m_silentMode;
    private boolean m_firstTime;
    private static final boolean DEFAULT_PASSTHRU = false;
    private static final boolean DEFAULT_USER_WRITTEN = false;
    private static final boolean DEFAULT_DEBUG = false;
    private static final boolean DEFAULT_CREATE_SYSLAST = true;
    private static final boolean DEFAULT_TARGET_PASSTHRU = true;
    private static final boolean DEFAULT_MAGIC = false;
    private static final String DEFAULT_BLANK_STRING = "";
    private static final String DEFAULT_THREADS = "systemdefault";
    private static final String DEFAULT_SPDS_PARALLELJOIN = "systemdefault";
    private int m_sqlStartIndex = 0;
    private int m_sqlEndIndex = 0;
    private boolean m_runPriorSteps = true;
    private String m_tableAliasKeyword;
    private boolean m_bRunDefaultRelationships = true;

    public SQLModel() {
        this.m_threadsUnTranslated.add("systemdefault");
        this.m_threadsUnTranslated.add("threads");
        this.m_threadsUnTranslated.add(THREADS_NOTHREADS);
        this.m_threadsTranslated = this.createTranslatedList("Threads", this.m_threadsUnTranslated);
        this.m_spdsParallelJoin = "systemdefault";
        this.m_spdsParallelUnTranslated.add("systemdefault");
        this.m_spdsParallelUnTranslated.add("plljoin");
        this.m_spdsParallelUnTranslated.add(SPDS_NOPARALLEL_JOIN);
        this.m_spdsParallelTranslated = this.createTranslatedList("SPDSParallelJoin", this.m_spdsParallelUnTranslated);
        this.m_preTargetPassThruUnTranslated.add(PRETARGET_DELETE);
        this.m_preTargetPassThruUnTranslated.add(PRETARGET_TRUNCATE);
        this.m_preTargetPassThruTranslated = this.createTranslatedList("PRETargetPassthruAction", this.m_preTargetPassThruUnTranslated);
        this.m_tableAliasKeyword = " as ";
    }

    public SQLModel(TransformationStep metadata) {
        this(metadata, CREATESELECTROLE, null, false);
    }

    public SQLModel(TransformationStep metadata, CodegenRequest cgReq) {
        this(metadata, CREATESELECTROLE, cgReq, false);
    }

    public SQLModel(TransformationStep metadata, String defaultRole, CodegenRequest cgReq, boolean silentMode) {
        this();
        this.m_transformStep = metadata;
        this.m_defaultRole = defaultRole;
        this.m_cgReq = cgReq;
        this.m_silentMode = silentMode;
        this.m_firstTime = true;
        try {
            this.m_store = (MdObjectStore)this.m_transformStep.getObjectStore();
            this.m_reposId = this.m_transformStep.getRepositoryID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public List getTranslatedThreadsValues() {
        return this.m_threadsTranslated;
    }

    public List getUnTranslatedThreadsValues() {
        return this.m_threadsUnTranslated;
    }

    public List getTranslatedPreTargetPassthruValues() {
        return this.m_preTargetPassThruTranslated;
    }

    public List getUnTranslatedPreTargetPassthruValues() {
        return this.m_preTargetPassThruUnTranslated;
    }

    public List getTranslatedSPDSParallelValues() {
        return this.m_spdsParallelTranslated;
    }

    public List getUnTranslatedSPDSParallelValues() {
        return this.m_spdsParallelUnTranslated;
    }

    public void setRunPriorSteps(boolean runPrior) {
        this.m_runPriorSteps = runPrior;
    }

    public boolean getRunPriorSteps() {
        return this.m_runPriorSteps;
    }

    public String getTargetPassThruAction() {
        return this.m_targetPassThroughAction;
    }

    public void setTargetPassThroughAction(String targetPassthruAction) {
        if (this.m_targetPassThroughAction.equals(targetPassthruAction)) {
            return;
        }
        this.m_targetPassThroughAction = targetPassthruAction;
        this.fireChangeEvent(TARGETPASSTHROUGHACTIONCHANGED);
    }

    public String getName() {
        try {
            return this.m_transformStep.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return DEFAULT_BLANK_STRING;
        }
    }

    public void setPassThrough(boolean passThrough) {
        if (this.m_passThrough == passThrough) {
            return;
        }
        this.m_passThrough = passThrough;
        this.fireChangeEvent(PASSTHROUGHCHANGED);
    }

    public boolean isPassThrough() {
        return this.m_passThrough;
    }

    public void setSPDSParallelJoin(String spdsParallelJoin) {
        if (this.m_spdsParallelJoin.equals(spdsParallelJoin)) {
            return;
        }
        this.m_spdsParallelJoin = spdsParallelJoin;
        this.fireChangeEvent(SPDSPARALLELJOINCHANGED);
    }

    public String getSPDSParallelJoin() {
        return this.m_spdsParallelJoin;
    }

    public void setUserWritten(boolean userWritten) {
        if (this.m_userWritten == userWritten) {
            return;
        }
        if (!this.isUserWrittenChangeAcceptable()) {
            return;
        }
        this.m_userWritten = userWritten;
        if (this.m_userWritten) {
            try {
                Text userCode = this.m_classifierMap.getSourceCode();
                if (userCode != null && userCode instanceof File) {
                    this.m_store.removeObjectFromStore((CMetadata)userCode, null);
                }
            }
            catch (MdException exc) {
                if (this.isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        this.fireChangeEvent(USERWRITTENCHANGED);
    }

    private boolean isUserWrittenChangeAcceptable() {
        if (this.isSilentModeEnabled()) {
            return true;
        }
        String sTitle = bundle.getString("SQLModel.Title.UserWrittenPropertyChange.txt");
        String sMessage = this.isUserWritten() ? bundle.getString("SQLModel.Warning.UserWrittenCodeWillBeReplaced.txt") : bundle.getString("SQLModel.Warning.ChangesWillNotAffectCode.txt");
        int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)2);
        return eAnswer == 0;
    }

    public boolean isUserWritten() {
        return this.m_userWritten;
    }

    public void setUserWrittenCode(String code) {
        this.m_userWrittenCode = code;
        this.fireChangeEvent(USERWRITTENCODECHANGED);
    }

    public String getUserWrittenCode() {
        return this.m_userWrittenCode;
    }

    public void setDebug(boolean debug) {
        if (this.m_debug == debug) {
            return;
        }
        this.m_debug = debug;
        this.fireChangeEvent(DEBUGCHANGED);
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void setSQLOptions(String options) {
        if (this.m_sqlOptions == options) {
            return;
        }
        this.m_sqlOptions = options;
        this.fireChangeEvent(SQLOPTIONSCHANGED);
    }

    public String getSQLOptions() {
        return this.m_sqlOptions;
    }

    public void setSPDSOptions(String options) {
        if (this.m_spdsOptions.equalsIgnoreCase(options)) {
            return;
        }
        this.m_spdsOptions = options;
        this.fireChangeEvent(SPDSOPTIONSCHANGED);
    }

    public String getSPDSOptions() {
        return this.m_spdsOptions;
    }

    public String getBufferSize() {
        return this.m_bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        if (this.m_bufferSize.equals(bufferSize)) {
            return;
        }
        this.m_bufferSize = bufferSize;
        this.fireChangeEvent(BUFFERSIZECHANGED);
    }

    public String getThreads() {
        return this.m_threads;
    }

    public void setThreads(String threads) {
        if (this.m_threads.equals(threads)) {
            return;
        }
        this.m_threads = threads;
        this.fireChangeEvent(THREADSCHANGED);
    }

    public void setSystemOptions(String options) {
        if (this.m_systemOptions == options) {
            return;
        }
        this.m_systemOptions = options;
        this.fireChangeEvent(SYSTEMOPTIONSCHANGED);
    }

    public String getSystemOptions() {
        return this.m_systemOptions;
    }

    public void setCreateSyslast(boolean createSyslast) {
        if (this.m_createSyslast == createSyslast) {
            return;
        }
        this.m_createSyslast = createSyslast;
        this.fireChangeEvent(CREATESYSLASTCHANGED);
    }

    public boolean isCreateSyslast() {
        return this.m_createSyslast;
    }

    public CodegenRequest getCodegenRequest() {
        if (this.m_cgReq == null) {
            this.m_cgReq = this.createNewCodegenRequest();
        }
        return this.m_cgReq;
    }

    public WsAppServer getWsAppServer() {
        return this.m_WsAppServer;
    }

    public void setWsAppServer(WsAppServer appServer) {
        this.m_WsAppServer = appServer;
        if (this.m_cgReq != null) {
            this.m_cgReq.setCurrentServer((DeployedComponent)this.m_WsAppServer.getServerContext(), true);
        }
    }

    public CodegenRequest createNewCodegenRequest() {
        CodegenRequest cgReq = null;
        try {
            cgReq = new CodegenRequest((CMetadata)this.getTransformationStep(), this.m_WsAppServer, 1, true, (ParametersInterface)new ParametersModel());
            cgReq.setThrowExceptions(false);
            if (this.m_WsAppServer == null) {
                ServerContext server;
                ServerContext defaultServer = null;
                String defaultServerId = WsAppServer.getDefaultAppServerFQID();
                if (defaultServerId != null && defaultServerId.length() > 0) {
                    defaultServer = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, DEFAULT_BLANK_STRING, "ServerContext", defaultServerId);
                }
                if ((server = TransformationActivityCG.getServerForStep(this.m_transformStep, defaultServer, defaultServer, cgReq)) != null) {
                    this.m_WsAppServer = WsAppServer.createAppServer((ServerContext)server);
                } else if (defaultServer != null) {
                    this.m_WsAppServer = WsAppServer.createAppServer((ServerContext)defaultServer);
                }
            }
            if (this.m_WsAppServer != null) {
                cgReq.setHost(this.m_WsAppServer);
            }
            this.setValidVarName(cgReq);
        }
        catch (MdException exc) {
            if (this.isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return cgReq;
    }

    private void setValidVarName(CodegenRequest cgReq) throws MdException, RemoteException {
        ArrayList<DataTable> targetList = new ArrayList<DataTable>();
        ArrayList sourceList = new ArrayList();
        TransformationActivity ta = (TransformationActivity)this.m_transformStep.getActivities(false).get(0);
        TransformationActivityCG taCG = (TransformationActivityCG)CodeGenUtil.getCodeGenClass((CMetadata)ta);
        taCG.getSourceAndTargetTablesOnPriorSteps(this.m_transformStep, cgReq, sourceList);
        if (this.m_statement != null) {
            sourceList.addAll(this.m_statement.getSourceDataTables());
            targetList.add(this.m_statement.getTargetTable().getDataTable());
        }
        cgReq.genValidVarName(sourceList, targetList, false);
    }

    public void setCodegenRequest(CodegenRequest cgReq) {
        this.m_cgReq = cgReq;
    }

    public String getInObs() {
        return this.m_inObs;
    }

    public void setInObs(String inobs) {
        if (this.m_inObs.equals(inobs)) {
            return;
        }
        this.m_inObs = inobs;
        this.fireChangeEvent(INOBSCHANGED);
    }

    public String getOutObs() {
        return this.m_outObs;
    }

    public void setOutObs(String outobs) {
        if (this.m_outObs.equals(outobs)) {
            return;
        }
        this.m_outObs = outobs;
        this.fireChangeEvent(OUTOBSCHANGED);
    }

    public boolean isSuggestSortMergeJoin() {
        return this.m_suggestSortMergeJoin;
    }

    public void setSuggestSortMergeJoin(boolean suggestSortMerge) {
        if (this.m_suggestSortMergeJoin == suggestSortMerge) {
            return;
        }
        this.m_suggestSortMergeJoin = suggestSortMerge;
        this.fireChangeEvent(SUGGESTSORTMERGEJOINCHANGED);
    }

    public boolean isTargetPassThru() {
        return this.m_targetIsPassThrough;
    }

    public void setTargetPassThru(boolean targetPassthru) {
        if (this.m_targetIsPassThrough == targetPassthru) {
            return;
        }
        this.m_targetIsPassThrough = targetPassthru;
        this.fireChangeEvent(TARGETPASSTHROUGHCHANGED);
    }

    public void clearSQL() {
        if (this.m_cgReq != null) {
            this.m_cgReq.clearSourceCode();
        }
    }

    public void genSQL() throws MdException, RemoteException {
        this.genSQL(false);
    }

    public StringBuffer getAccessPathCode() {
        List sourceTables = this.m_statement.getAllSourceTables();
        CodegenRequest cgReq = this.createNewCodegenRequest();
        cgReq.setGenerateRCSetCalls(false);
        for (int i = 0; i < sourceTables.size(); ++i) {
            SourceTable table = (SourceTable)sourceTables.get(i);
            table.genAccessPath(cgReq);
        }
        TargetTable table = this.m_statement.getTargetTable();
        table.genAccessPath(cgReq);
        ArrayList<DataTable> tables = new ArrayList<DataTable>();
        tables.addAll(this.m_statement.getSourceDataTables());
        tables.add(table.getDataTable());
        try {
            for (int i = 0; i < tables.size(); ++i) {
                if (!DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)((Root)tables.get(i)), (String)"N").equals("Y")) continue;
                cgReq.addSourceCode("options VALIDVARNAME = ANY; \n\n");
                break;
            }
        }
        catch (MdException i) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return cgReq.getSourceBuffer();
    }

    public SourceTable getSourceDataTableMoved(DataTable table) {
        try {
            List sourceTables = this.m_statement.getAllSourceTables();
            for (int i = 0; i < sourceTables.size(); ++i) {
                DataTable srcDTable;
                SourceTable srcTable = (SourceTable)sourceTables.get(i);
                if (!srcTable.isMoveTableToUploadLibrary() || (srcDTable = srcTable.getDataTable()) == null || !srcDTable.getFQID().equals(table.getFQID())) continue;
                return srcTable;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public boolean isCodeGenSelfOnly() {
        return this.m_bCodeGenSelf;
    }

    public void genSQL(boolean initializeCodegenRequest) throws MdException, RemoteException {
        this.getCodegenRequest();
        boolean active = this.m_classifierMap.getIsActive() == 1;
        this.m_bCodeGenSelf = initializeCodegenRequest;
        if (!this.m_userWritten && active) {
            boolean hasSPDSOptions;
            ArrayList<DataTable> targetDataTables = new ArrayList<DataTable>();
            if (this.m_statement.getTargetTable() != null) {
                targetDataTables.add(this.m_statement.getTargetTable().getDataTable());
            }
            List sourceTables = this.m_statement.getAllSourceTables();
            if (this.m_bCodeGenSelf) {
                this.m_cgReq.setThrowExceptions(false);
                this.m_cgReq.setGenerateRCSetCalls(false);
                this.m_cgReq.genParameterDefaultValueCode((Root)this.m_transformStep);
                this.setValidVarName(this.m_cgReq);
            }
            ArrayList<AbstractTable> movedSourceTables = new ArrayList<AbstractTable>();
            for (int i = 0; i < sourceTables.size(); ++i) {
                SourceTable srcTable;
                AbstractTable table = (AbstractTable)sourceTables.get(i);
                if (table instanceof TargetTable || !(srcTable = (SourceTable)table).isMoveTableToUploadLibrary()) continue;
                srcTable.moveTableToUploadLibrary(this.m_cgReq);
                movedSourceTables.add(table);
            }
            boolean isDebug = this.isDebug();
            boolean isSPDSQuery = this.m_statement.isSourceDataTablesSPDS();
            boolean isSPDSParallelJoin = !this.getSPDSParallelJoin().equalsIgnoreCase("systemdefault");
            this.m_cgReq.genSystemOptions(this.getSystemOptions());
            TargetTable target = this.m_statement.getTargetTable();
            boolean passthru = this.m_passThrough;
            boolean targetPassthru = this.m_targetIsPassThrough;
            if (passthru) {
                this.m_passThrough = this.m_statement.isSourceTablesPassThruEnabled(this.m_cgReq);
                if (!this.m_passThrough && targetPassthru) {
                    this.m_targetIsPassThrough = false;
                }
            }
            if (targetPassthru) {
                this.m_targetIsPassThrough = this.m_statement.isTargetTablePassThruEnabled(this.m_cgReq);
            }
            DBMSSTORE sourceTableCG = this.getSingleSourceStore(this.m_cgReq);
            boolean targetIsView = target.isTableAView();
            DBMSSTORE targetStore = this.m_statement.getTargetTable().getDBMSStore(this.m_cgReq);
            if (this.m_targetIsPassThrough && !targetIsView) {
                this.m_cgReq.addSourceCode("%macro etls_prepareTarget();\n").indent();
                if (this.m_targetPassThroughAction.equals(PRETARGET_DELETE)) {
                    target.genDeleteTable(this.m_cgReq);
                    targetStore.create(this.m_cgReq, false, false, false, false);
                    this.m_cgReq.addSourceCode("%let etls_tableExist = 0;\n\n");
                } else {
                    targetStore.exist(this.m_cgReq);
                    targetStore.create(this.m_cgReq, true, false, false, false);
                    this.m_cgReq.addSourceCode("%else; \n").addSourceCode("%do;\n").indent();
                    targetStore.deleteAllRows(this.m_cgReq, true);
                    this.m_cgReq.unIndent().addSourceCode("%end;\n\n");
                }
                this.m_cgReq.unIndent().addSourceCode("%mend etls_prepareTarget;\n").addSourceCode("%etls_prepareTarget;\n\n");
            } else {
                target.genDeleteTable(this.m_cgReq);
            }
            boolean bl = hasSPDSOptions = isDebug || isSPDSParallelJoin || !DEFAULT_BLANK_STRING.equals(this.m_spdsOptions) || this.m_suggestSortMergeJoin || !DEFAULT_BLANK_STRING.equals(this.m_inObs) || !DEFAULT_BLANK_STRING.equals(this.m_outObs);
            if (isDebug) {
                this.m_cgReq.addSourceCode("%let etls_sasTrace = %sysfunc(getoption(sastrace));\n").addSourceCode("%let etls_fullSTimer = %sysfunc(getoption(fullstimer));\n").addSourceCode("options sastrace = ',,,sd' sastraceloc = saslog no$stsuffix fullstimer;\n\n");
            }
            if (!this.m_passThrough && isSPDSQuery && hasSPDSOptions) {
                this.m_cgReq.addSourceCode("%let spdssqlr = ");
                if (isDebug) {
                    this.m_cgReq.addSourceCode(" _method");
                }
                if (isSPDSParallelJoin) {
                    this.m_cgReq.addSourceCode(" ").addSourceCode(this.m_spdsParallelJoin);
                }
                if (!DEFAULT_BLANK_STRING.equals(this.m_inObs)) {
                    this.m_cgReq.addSourceCode(" inobs = ").addSourceCode(this.m_inObs);
                }
                if (!DEFAULT_BLANK_STRING.equals(this.m_outObs)) {
                    this.m_cgReq.addSourceCode(" outobs = ").addSourceCode(this.m_outObs);
                }
                if (this.m_suggestSortMergeJoin) {
                    this.m_cgReq.addSourceCode(" magic = 102");
                }
                if (!DEFAULT_BLANK_STRING.equals(this.m_spdsOptions)) {
                    this.m_cgReq.addSourceCode("\n").indent().addSourceCode(this.m_spdsOptions).addSourceCode("\n").unIndent();
                }
                this.m_cgReq.addSourceCode(";\n\n");
            } else if (!this.m_passThrough && isSPDSQuery && !hasSPDSOptions) {
                this.m_cgReq.addSourceCode("%let spdssqlr = ;\n\n");
            }
            List missingTargets = this.m_statement.getQuery().getUnMappedColumns();
            if (!missingTargets.isEmpty()) {
                StringBuffer targs = new StringBuffer();
                int size = missingTargets.size();
                for (int i = 0; i < size; ++i) {
                    targs.append(((TableColumn)missingTargets.get(i)).getName());
                    if (i >= size - 1) continue;
                    targs.append(", ");
                }
                this.m_cgReq.addSourceCode("data _null_; \n").indent().genPutStatement(bundle.formatString("SQLModel.MissingTargets.comment.notrans", (Object)targs.toString()), "NOTE:").unIndent().addSourceCode("run; \n\n");
            }
            this.m_sqlStartIndex = this.m_cgReq.getSourceBuffer().length();
            this.m_cgReq.addSourceCode("proc sql");
            if (isDebug) {
                this.m_cgReq.addSourceCode(" _method");
            }
            if (this.m_suggestSortMergeJoin) {
                this.m_cgReq.addSourceCode(" magic = 102");
            }
            if (!DEFAULT_BLANK_STRING.equals(this.m_bufferSize.trim())) {
                this.m_cgReq.addSourceCode(" buffersize = ").addSourceCode(this.m_bufferSize);
            }
            if (!DEFAULT_BLANK_STRING.equals(this.m_inObs)) {
                this.m_cgReq.addSourceCode(" inobs = ").addSourceCode(this.m_inObs);
            }
            if (!DEFAULT_BLANK_STRING.equals(this.m_outObs)) {
                this.m_cgReq.addSourceCode(" outobs = ").addSourceCode(this.m_outObs);
            }
            if (!"systemdefault".equalsIgnoreCase(this.m_threads)) {
                this.m_cgReq.addSourceCode(" ").addSourceCode(this.m_threads);
            }
            if (this.m_sqlOptions.trim().length() > 0) {
                this.m_cgReq.addSourceCode("\n").indent().addSourceCode(this.m_sqlOptions).addSourceCode("\n").unIndent();
            }
            this.m_cgReq.addSourceCode(";\n").indent();
            if (this.m_passThrough && sourceTableCG != null) {
                sourceTableCG.genConnect(this.m_cgReq);
            }
            this.m_tableAliasKeyword = sourceTableCG != null ? sourceTableCG.getTableAliasKeyword(this.m_passThrough) : " as ";
            if (sourceTableCG != null && this.m_passThrough && isSPDSQuery && hasSPDSOptions) {
                sourceTableCG.genExecuteBegin(this.m_cgReq, DEFAULT_BLANK_STRING);
                this.m_cgReq.addSourceCode("reset\n").indent();
                if (isDebug) {
                    this.m_cgReq.addSourceCode(" _method\n");
                }
                if (isSPDSParallelJoin) {
                    this.m_cgReq.addSourceCode(" ").addSourceCode(this.m_spdsParallelJoin).addSourceCode("\n");
                }
                if (!DEFAULT_BLANK_STRING.equals(this.m_inObs)) {
                    this.m_cgReq.addSourceCode(" inobs = ").addSourceCode(this.m_inObs).addSourceCode("\n");
                }
                if (!DEFAULT_BLANK_STRING.equals(this.m_outObs)) {
                    this.m_cgReq.addSourceCode(" outobs = ").addSourceCode(this.m_outObs).addSourceCode("\n");
                }
                if (!DEFAULT_BLANK_STRING.equals(this.m_spdsOptions)) {
                    this.m_cgReq.addSourceCode(" ").addSourceCode(this.m_spdsOptions).addSourceCode("\n");
                }
                if (this.m_suggestSortMergeJoin) {
                    this.m_cgReq.addSourceCode(" magic = 102\n");
                }
                this.m_cgReq.unIndent();
                sourceTableCG.genExecuteEnd(this.m_cgReq, DEFAULT_BLANK_STRING);
            }
            this.m_statement.appendClauseCode(this.m_cgReq, true);
            this.m_cgReq.unIndent().addSourceCode("quit;\n\n");
            this.m_sqlEndIndex = this.m_cgReq.getSourceBuffer().length();
            if (isDebug) {
                this.m_cgReq.addSourceCode("options sastrace = \"&etls_sasTrace\" &etls_fullSTimer ; \n\n");
            }
            this.m_cgReq.genRCSetCall("&sqlrc");
            this.m_passThrough = passthru;
            this.m_targetIsPassThrough = targetPassthru;
            for (int i = 0; i < movedSourceTables.size(); ++i) {
                SourceTable table = (SourceTable)movedSourceTables.get(i);
                table.genCleanUpMovedTableCode(this.m_cgReq);
            }
            if (this.m_targetPassThroughAction.equals(PRETARGET_DELETE) && !targetIsView) {
                this.m_cgReq.addSourceCode("%macro etls_completeTarget();\n").indent();
                targetStore.createIndexes2(this.m_cgReq);
                targetStore.createConstraints(this.m_cgReq);
                this.m_cgReq.unIndent().addSourceCode("%mend etls_completeTarget;\n").addSourceCode("%etls_completeTarget;\n\n");
            }
            this.m_userWrittenCode = this.m_cgReq.getSource();
        } else if (this.m_userWritten && active) {
            this.m_cgReq.addSourceCode(this.m_userWrittenCode);
        } else {
            this.m_cgReq.addCommentLine(bundle.formatString("SQLModel.SQLTransformDisabled.txt", (Object)this.m_transformStep.getName()));
        }
    }

    public String getTableAliasKeyword() {
        return this.m_tableAliasKeyword;
    }

    public String getSQLValidateCode() {
        StringBuffer code = new StringBuffer();
        code.append(this.m_cgReq.getSourceBuffer().substring(this.m_sqlStartIndex, this.m_sqlEndIndex));
        code.replace(0, 8, "proc sql noexec");
        return code.toString();
    }

    public DBMSSTORE getSingleSourceStore(CodegenRequest cgReq) {
        DBMSSTORE sourceTableCG = null;
        List sourceTables = this.m_statement.getAllSourceTables();
        SourceTable src = null;
        if (this.isPassThrough() && !sourceTables.isEmpty()) {
            src = (SourceTable)sourceTables.get(0);
            sourceTableCG = src.getDBMSStore(cgReq);
        }
        return sourceTableCG;
    }

    protected void addUndoableObject(SQLObjectInterface object) {
        this.m_lUndoableObjectList.add(object);
    }

    protected boolean removeUndoableObject(SQLObjectInterface object) {
        return this.m_lUndoableObjectList.remove(object);
    }

    protected void resetFirstTime() {
        this.m_firstTime = false;
    }

    protected boolean isFirstTime() {
        return this.m_firstTime;
    }

    public SQLStatementInterface getStatement() {
        return this.m_statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToModel() throws MdException, RemoteException {
        this.setFireEventsEnabled(false);
        try {
            AssociationList transList;
            if (this.m_transformStep == null) {
                return;
            }
            if (this.m_store == null) {
                this.m_store = (MdObjectStore)this.m_transformStep.getObjectStore();
            }
            if ((transList = this.m_transformStep.getTransformations()).isEmpty()) {
                throw new MdException(bundle.getString("SQLModel.NoClassifierMap.Error.txt"));
            }
            this.m_classifierMap = (ClassifierMap)transList.get(0);
            this.m_transformSources = this.m_classifierMap.getClassifierSources();
            AssociationList clsTargets = this.m_classifierMap.getClassifierTargets();
            DataTable table = null;
            if (!clsTargets.isEmpty()) {
                table = (DataTable)clsTargets.get(0);
            }
            AssociationList transformSources = this.m_classifierMap.getTransformationSources();
            ClassifierMap clsMap = null;
            if (transformSources.isEmpty()) {
                this.m_statement = this.getDefaultStatement(table);
            } else {
                clsMap = (ClassifierMap)transformSources.get(0);
                String role = clsMap.getTransformRole();
                if (role.equalsIgnoreCase(CREATESELECTROLE)) {
                    this.m_statement = new CreateSelect((Select)clsMap, table);
                }
            }
            this.m_statement.setSQLModel(this);
            PropertyHandler pHandler = this.createClassifierMapPropertyHandler();
            PropertyHandler opHandler = this.createTransformationStepPropertyHandler();
            this.m_createSyslast = opHandler.stringToBoolean(opHandler.getSpecificOptionValue(PROPERTY_NAME_SYSLAST), true);
            this.m_systemOptions = opHandler.getSpecificOptionValue("SystemOptions");
            this.m_passThrough = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_PASSTHRU), false);
            boolean bl = this.m_userWritten = this.m_classifierMap.getIsUserDefined() == 1;
            if (this.m_userWritten) {
                Text text = this.m_classifierMap.getSourceCode();
                String code = DEFAULT_BLANK_STRING;
                if (text != null && text instanceof TextStore) {
                    code = ((TextStore)text).getStoredText();
                } else if (text != null && text instanceof File) {
                    File file = (File)text;
                    SASCodeGeneration sasCodeGen = new SASCodeGeneration();
                    code = sasCodeGen.makeComment(bundle.formatString("SQLModel.UserWrittenFile.txt", (Object)file.getFileName()));
                }
                this.m_userWrittenCode = code;
            }
            this.m_targetIsPassThrough = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_TARGET_PASSTHRU), true);
            this.m_targetPassThroughAction = pHandler.getSpecificOptionValue(PROPERTY_NAME_PRETARGETPASSTHRUACTION, this.DEFAULT_PRETARGET_ACTION);
            this.m_debug = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_DEBUG), false);
            this.m_sqlOptions = pHandler.getSpecificOptionValue(PROPERTY_NAME_ADDITIONAL_SQL_OPTIONS);
            this.m_suggestSortMergeJoin = pHandler.stringToBoolean(pHandler.getSpecificOptionValue(PROPERTY_NAME_MAGIC), false);
            this.m_bufferSize = pHandler.getSpecificOptionValue(PROPERTY_NAME_BUFFER_SIZE);
            this.m_inObs = pHandler.getSpecificOptionValue(PROPERTY_NAME_INOBS);
            this.m_outObs = pHandler.getSpecificOptionValue(PROPERTY_NAME_OUTOBS);
            this.m_threads = pHandler.getSpecificOptionValue("threads", "systemdefault");
            this.m_spdsParallelJoin = pHandler.getSpecificOptionValue("plljoin", "systemdefault");
            this.m_spdsOptions = pHandler.getSpecificOptionValue(PROPERTY_NAME_SPDS_ADDITIONAL_SQL_OPTIONS);
            this.m_statement.moveDataToModel();
            this.setFireEventsEnabled(true);
        }
        finally {
            this.setFireEventsEnabledWithOutUnknownChangesEvent();
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            for (int i = 0; i < this.m_lUndoableObjectList.size(); ++i) {
                ((SQLObjectInterface)this.m_lUndoableObjectList.get(i)).dispose();
            }
            if (this.m_statement == null) {
                return;
            }
            PropertyHandler pHandler = this.createClassifierMapPropertyHandler();
            PropertyHandler opHandler = this.createTransformationStepPropertyHandler();
            opHandler.setSpecificProperty(PROPERTY_NAME_SYSLAST, opHandler.booleanToString(this.isCreateSyslast()));
            opHandler.setSpecificProperty("SystemOptions", this.getSystemOptions(), "SYSTEM", 12);
            pHandler.setSpecificProperty(PROPERTY_NAME_PASSTHRU, pHandler.booleanToString(this.m_passThrough), PROPERTY_NAME_PASSTHRU, DEFAULT_BLANK_STRING, 0, null);
            this.m_classifierMap.setIsUserDefined(this.m_userWritten ? 1 : 0);
            if (this.m_userWritten) {
                Text userCode = this.m_classifierMap.getSourceCode();
                if (userCode == null) {
                    userCode = (TextStore)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_classifierMap.getObjectStore(), null, bundle.getString("SQLModel.SQLSourceCode.txt"), "TextStore", this.m_classifierMap.getRepositoryID(), null);
                    this.m_classifierMap.setSourceCode(userCode);
                }
                if (userCode instanceof TextStore) {
                    ((TextStore)userCode).setStoredText(this.m_userWrittenCode);
                }
            }
            pHandler.setSpecificProperty(PROPERTY_NAME_TARGET_PASSTHRU, pHandler.booleanToString(this.m_targetIsPassThrough), PROPERTY_NAME_TARGET_PASSTHRU, DEFAULT_BLANK_STRING, 0, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_DEBUG, pHandler.booleanToString(this.m_debug), PROPERTY_NAME_DEBUG, DEFAULT_BLANK_STRING, 0, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_ADDITIONAL_SQL_OPTIONS, this.m_sqlOptions, PROPERTY_NAME_ADDITIONAL_SQL_OPTIONS, DEFAULT_BLANK_STRING, 1, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_MAGIC, pHandler.booleanToString(this.m_suggestSortMergeJoin), PROPERTY_NAME_MAGIC, DEFAULT_BLANK_STRING, 0, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_BUFFER_SIZE, this.m_bufferSize, PROPERTY_NAME_BUFFER_SIZE, "=", 0, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_INOBS, this.m_inObs, PROPERTY_NAME_INOBS, "=", 0, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_OUTOBS, this.m_outObs, PROPERTY_NAME_OUTOBS, "=", 0, null);
            pHandler.setSpecificProperty("threads", this.m_threads, "threads", DEFAULT_BLANK_STRING, 0, null);
            pHandler.setSpecificProperty("plljoin", this.m_spdsParallelJoin, "plljoin", DEFAULT_BLANK_STRING, 1, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_SPDS_ADDITIONAL_SQL_OPTIONS, this.m_spdsOptions, PROPERTY_NAME_SPDS_ADDITIONAL_SQL_OPTIONS, DEFAULT_BLANK_STRING, 1, null);
            pHandler.setSpecificProperty(PROPERTY_NAME_PRETARGETPASSTHRUACTION, this.m_targetPassThroughAction, PROPERTY_NAME_PRETARGETPASSTHRUACTION, DEFAULT_BLANK_STRING, 0, null);
            this.m_statement.moveDataToStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private PropertyHandler createClassifierMapPropertyHandler() throws MdException, RemoteException {
        if (this.m_classifierMap != null) {
            return new PropertyHandler((Root)this.m_classifierMap, PROPERTY_SET_ROLE, true);
        }
        return null;
    }

    private PropertyHandler createTransformationStepPropertyHandler() throws MdException, RemoteException {
        if (this.m_transformStep != null) {
            PropertyHandler opHandler = new PropertyHandler((Root)this.m_transformStep, true);
            opHandler.setSetRole(TS_PROPERTY_SET_ROLE);
            return opHandler;
        }
        return null;
    }

    public void dispose() {
        if (this.m_statement != null) {
            this.m_statement.dispose();
            this.m_statement = null;
        }
        if (this.m_cgReq != null) {
            this.m_cgReq.cleanUpWorkLibraries();
            this.m_cgReq.cleanupCodeGen();
        }
    }

    public void setTransformationStep(TransformationStep step) {
        try {
            if (step == null) {
                return;
            }
            this.m_transformStep = step;
            this.m_store = (MdObjectStore)this.m_transformStep.getObjectStore();
            this.m_reposId = this.m_transformStep.getRepositoryID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public TransformationStep getTransformationStep() {
        return this.m_transformStep;
    }

    public void setClassifierMap(ClassifierMap clsMap) {
        this.m_classifierMap = clsMap;
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    public List getTransformSources() {
        return this.m_transformSources;
    }

    public MdObjectStore getObjectStore() {
        return this.m_store;
    }

    public String getRepositoryId() {
        return this.m_reposId;
    }

    private List createTranslatedList(String keyPrefix, List untrans) {
        ArrayList<String> transValues = new ArrayList<String>(untrans.size());
        for (int i = 0; i < untrans.size(); ++i) {
            transValues.add(bundle.getString("SQLModel." + keyPrefix + "." + untrans.get(i) + ".txt"));
        }
        return transValues;
    }

    private SQLStatementInterface getDefaultStatement(DataTable table) {
        CreateSelect statement = null;
        if (this.m_defaultRole.equalsIgnoreCase(CREATESELECTROLE)) {
            statement = new CreateSelect(null, table);
        }
        return statement;
    }

    public void setFireEventsEnabled(boolean bEnabled) {
        if (this.m_fireEventsEnabled == bEnabled) {
            return;
        }
        this.m_fireEventsEnabled = bEnabled;
        if (bEnabled) {
            this.fireChangeEvent(UNKNOWNCHANGES);
        }
    }

    public void setFireEventsEnabledWithOutUnknownChangesEvent() {
        this.m_fireEventsEnabled = true;
    }

    public boolean isFireEventsEnabled() {
        return this.m_fireEventsEnabled;
    }

    public boolean isSilentModeEnabled() {
        return this.m_silentMode;
    }

    public void addChangeListener(QueryChangeListener listener) {
        this.m_lListeners.add(listener);
    }

    public void removeChangeListener(QueryChangeListener listener) {
        this.m_lListeners.remove(listener);
    }

    public void fireChangeEvent(String action) {
        if (!this.isFireEventsEnabled() || this.isNoListeners()) {
            return;
        }
        this.fireChangeEventImpl(new QueryChangeEvent((Object)this, (ClauseInterface)null, action));
    }

    protected void fireChangeEvent(ClauseInterface clause, String action) {
        if (!this.isFireEventsEnabled() || this.isNoListeners() || this.isSilentModeEnabled()) {
            return;
        }
        this.fireChangeEventImpl(new QueryChangeEvent((Object)this, clause, action));
    }

    protected void fireChangeEvent(ClauseInterface clause, String action, ClauseInterface clauseParent) {
        if (!this.isFireEventsEnabled() || this.isNoListeners() || this.isSilentModeEnabled()) {
            return;
        }
        this.fireChangeEventImpl(new QueryChangeEvent(this, clause, action, clauseParent));
    }

    protected void fireChangeEvent(TableInterface table, String action) {
        if (!this.isFireEventsEnabled() || this.isNoListeners() || this.isSilentModeEnabled()) {
            return;
        }
        this.fireChangeEventImpl(new QueryChangeEvent((Object)this, table, action));
    }

    protected void fireChangeEvent(Expression expression, String action) {
        if (!this.isFireEventsEnabled() || this.isNoListeners() || this.isSilentModeEnabled()) {
            return;
        }
        this.fireChangeEventImpl(new QueryChangeEvent((Object)this, expression, action));
    }

    private boolean isNoListeners() {
        return this.m_lListeners.isEmpty();
    }

    private void fireChangeEventImpl(QueryChangeEvent ev) {
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            QueryChangeListener listener = (QueryChangeListener)this.m_lListeners.get(iListener);
            listener.queryChanged(ev);
        }
    }

    public StringBuffer getPriorStepGeneratedCode() throws MdException, RemoteException, CodegenException {
        StringBuffer code = new StringBuffer();
        TransformationActivity act = (TransformationActivity)this.m_transformStep.getActivities(false).get(0);
        TransformationActivityCG actCG = (TransformationActivityCG)CodeGenUtil.getCodeGenClass((CMetadata)act);
        CodegenRequest cgReq = this.createNewCodegenRequest();
        cgReq.clearSourceCode();
        cgReq.setGenerateRCSetCalls(false);
        cgReq.setThrowExceptions(true);
        try {
            actCG.codeGenPriorSteps(this.m_transformStep, cgReq);
            code.append(cgReq.getSourceBuffer());
        }
        catch (CodegenException exc) {
            throw new CodegenException(cgReq.getCurrentTransformation().getName() + ": " + exc.getMessage());
        }
        finally {
            cgReq.cleanUpWorkLibraries();
            cgReq.clearSourceCode();
        }
        return code;
    }

    public boolean getRunDefaultRelationships() {
        return this.m_bRunDefaultRelationships;
    }

    public void setRunDefaultRelationships(boolean run) {
        this.m_bRunDefaultRelationships = run;
    }

    public void setViewWorkTables(boolean viewTables) {
        this.m_bViewWorkTables = viewTables;
    }

    public boolean getViewWorkTables() {
        return this.m_bViewWorkTables;
    }
}

