/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.GroupByColumn;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.workspace.PropertyHandler;
import java.rmi.RemoteException;

public class OrderByColumn
extends GroupByColumn {
    private String m_sortOrder;
    private static final String PROPERTY_NAME_SORT_ORDER = "SortOrder";
    private static final String ASCENDING = "asc";
    private static final String DESCENDING = "desc";

    public OrderByColumn(TableColumn tableColumn, AbstractTable table, AbstractClause parent) {
        this(tableColumn, table, ASCENDING, DISPLAY_INTEGER_DEFAULT, parent);
    }

    public OrderByColumn(TableColumn tableColumn, AbstractTable table, String sortOrder, boolean displayInteger, AbstractClause parentOrderBy) {
        super(tableColumn, table, displayInteger, parentOrderBy);
        this.m_sortOrder = sortOrder;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq) {
        StringBuffer sb = new StringBuffer(super.getSQLCode(cgReq));
        if (!this.m_sortOrder.equalsIgnoreCase(ASCENDING)) {
            sb.append(" ").append(DESCENDING);
        }
        return sb.toString();
    }

    public void setSortOrder(String sortOrder) {
        if (this.m_sortOrder.equals(sortOrder)) {
            return;
        }
        this.m_sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        super.moveDataToModel();
        if (this.m_parentObjectForPropertySet == null) {
            return;
        }
        PropertyHandler pHandler = this.createOrderByColumnPropertyHandler(false);
        this.m_sortOrder = pHandler.getSpecificOptionValue(PROPERTY_NAME_SORT_ORDER, ASCENDING);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        if (this.m_parentObjectForPropertySet == null) {
            return;
        }
        PropertyHandler pHandler = this.createOrderByColumnPropertyHandler(true);
        pHandler.setSpecificProperty(PROPERTY_NAME_SORT_ORDER, this.m_sortOrder, PROPERTY_NAME_SORT_ORDER, "", 1, null);
    }
}

