/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CreateSelect
extends AbstractClause
implements SQLStatementInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(CreateSelect.class);
    public static final String TABLETYPECHANGED = "tableTypeChanged";
    public static final String TARGETCHANGED = "targetChanged";
    public static final String TARGETREMOVED = "targetRemoved";
    public static final String TARGETOPTIONSCHANGED = "targetOptionsChanged";
    private DataTable m_table;
    private Select m_select;
    private Query m_query;
    private TargetTable m_targetTable;
    private String m_options = "";

    public CreateSelect() {
        this(null, null);
    }

    public CreateSelect(Select select, DataTable target) {
        this.m_select = select;
        this.m_table = target;
    }

    @Override
    public String getName() {
        return "Create";
    }

    @Override
    public boolean isSourceTablesPassThruEnabled(CodegenRequest cgReq) {
        return this.m_query.isSourceTablesPassThruEnabled(cgReq);
    }

    @Override
    public boolean isTargetTablePassThruEnabled(CodegenRequest cgReq) {
        return this.m_query.isTargetTablePassThruEnabled(cgReq);
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        boolean createView = true;
        SQLModel mdl = this.getSQLModel();
        boolean isTargetPassThru = mdl.isTargetPassThru();
        boolean isPassThru = mdl.isPassThrough();
        DBMSSTORE sourceTableCG = mdl.getSingleSourceStore(cgReq);
        if (isTargetPassThru) {
            sourceTableCG.genExecuteBegin(cgReq, "");
        }
        try {
            createView = this.m_targetTable.isTableAView();
            boolean useCreateSyntax = !isTargetPassThru || createView;
            String desc = this.getDescription();
            if (desc.length() > 0) {
                cgReq.addCommentLine(desc);
            }
            if (useCreateSyntax) {
                cgReq.addSourceCode("create ").addSourceCode(createView ? "view" : "table").addSourceCode(" ");
            } else {
                cgReq.addSourceCode("insert into ");
            }
            if (this.m_targetTable != null) {
                cgReq.addSourceCode(this.m_targetTable.getDataTableLocation(cgReq, isTargetPassThru));
                this.m_targetTable.genTableOptions(cgReq);
            } else {
                cgReq.addCommentLine(bundle.getString("CreateSelect.MissingTarget.Error.txt"));
            }
            if (useCreateSyntax) {
                cgReq.addSourceCode(" as");
            }
            cgReq.addSourceCode("\n").indent();
            if (sourceTableCG != null && mdl.isPassThrough() && !isTargetPassThru) {
                if (this.m_query != null) {
                    sourceTableCG.genBeginSelectAllFromConnect(cgReq, this.m_query.getSelectResultsForPassthru());
                } else {
                    sourceTableCG.genBeginSelectAllFromConnect(cgReq);
                }
            }
            if (this.m_query != null) {
                this.m_query.appendClauseCode(cgReq, resetPosition);
            }
            if (sourceTableCG != null && !isTargetPassThru) {
                sourceTableCG.genEndSelectAllFromConnect(cgReq);
            }
            if (isPassThru && isTargetPassThru && sourceTableCG != null) {
                cgReq.addSourceCode("\n");
                cgReq.unIndent();
                sourceTableCG.genExecuteEnd(cgReq, "");
            }
            if (isPassThru && sourceTableCG != null) {
                sourceTableCG.genExecuteCommit(cgReq, "");
                sourceTableCG.genDisconnect(cgReq);
            }
            if (!isPassThru) {
                cgReq.addSourceCode(";\n");
            }
            cgReq.unIndent();
            if (resetPosition) {
                this.setEndingPosition(cgReq.getSourceBuffer().length() - 3);
            }
        }
        catch (MdException exc) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public List getClauses() {
        ArrayList<CreateSelect> lClauses = new ArrayList<CreateSelect>(7);
        lClauses.add(this);
        lClauses.addAll(this.m_query.getClauses());
        return lClauses;
    }

    @Override
    public Query getQuery() {
        return this.m_query;
    }

    @Override
    public Query getParentQuery() {
        return this.m_query;
    }

    @Override
    public TargetTable getTargetTable() {
        return this.m_targetTable;
    }

    @Override
    public List getSourceTables() {
        ArrayList list = new ArrayList();
        if (this.m_query != null) {
            list.addAll(this.m_query.getSourceTables());
        }
        return list;
    }

    @Override
    public List getSourceDataTables() {
        return this.m_query.getSourceDataTables();
    }

    @Override
    public List getAllSourceTables() {
        ArrayList list = new ArrayList();
        list.addAll(this.m_query.getSourceTables());
        list.addAll(this.m_query.getSubQuerySourceTables());
        return list;
    }

    @Override
    public List findAllSourceTables(DataTable table) {
        return this.m_query.findAllSourceTables(table);
    }

    @Override
    public boolean isSourceDataTablesSPDS() {
        return this.m_query.isSourceDataTablesSPDS();
    }

    public void setTargetTable(DataTable table) {
        TargetTable tgtTable = new TargetTable(table);
        tgtTable.setSQLModel(this.getSQLModel());
        tgtTable.setParent(this);
        if (this.m_targetTable != null) {
            this.m_targetTable.remove();
        }
        this.m_targetTable = tgtTable;
        this.m_query.setTargetTable(this.m_targetTable);
        this.getSQLModel().fireChangeEvent(this, TARGETCHANGED);
    }

    protected void removeTargetTable() {
        this.m_query.setTargetTable(null);
        this.getSQLModel().fireChangeEvent(this, TARGETREMOVED);
    }

    public void setOptions(String options) {
        if (this.m_options == options) {
            return;
        }
        this.m_options = options;
        this.getSQLModel().fireChangeEvent(this, TARGETOPTIONSCHANGED);
    }

    public String getOptions() {
        return this.m_options;
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        SQLModel model = this.getSQLModel();
        if (this.m_select == null) {
            this.m_select = this.createDefaultSelectMetadata();
            List ltransSources = model.getTransformSources();
            AssociationList clsSources = this.m_select.getClassifierSources();
            for (int i = 0; i < ltransSources.size(); ++i) {
                clsSources.addElement(ltransSources.get(i));
            }
            ClassifierMap mainMap = model.getClassifierMap();
            mainMap.getTransformationSources().addElement((Object)this.m_select);
        }
        this.setDescription(model.getClassifierMap().getDesc());
        this.m_query = new Query(this.m_select);
        this.m_query.setParentClause(this);
        this.m_query.setSQLModel(model);
        if (this.m_table != null) {
            this.setTargetTable(this.m_table);
        }
        this.m_query.moveDataToModel();
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        SQLModel model = this.getSQLModel();
        ClassifierMap mainMap = model.getClassifierMap();
        AssociationList srcTrans = mainMap.getTransformationSources();
        srcTrans.removeAllElements();
        srcTrans.add((Object)this.m_select);
        this.m_query.moveDataToStore();
        mainMap.setDesc(this.getDescription());
    }

    @Override
    public void dispose() {
        this.m_query.dispose();
        this.m_query = null;
        try {
            this.getSQLModel().getObjectStore().removeObjectFromStore((CMetadata)this.m_select, null);
            this.m_select = null;
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public Select getSelect() {
        return this.m_select;
    }

    private Select createDefaultSelectMetadata() throws MdException, RemoteException {
        Select select = (Select)Workspace.getMdFactory().createComplexMetadataObject(this.getSQLModel().getObjectStore(), "CreateSelect", "Select", this.getSQLModel().getRepositoryId());
        select.setTransformRole("CreateSelect");
        return select;
    }
}

