/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.adapters.data.WorkTableAdapter;
import com.sas.wadmin.transforms.sql.editor.ISQLTableAdapter;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Window;

public class SQLWorkTableAdapter
extends WorkTableAdapter
implements ISQLTableAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLWorkTableAdapter.class);
    private ITable m_table;
    private IAliasTable m_aliasTable;

    public SQLWorkTableAdapter(ITable table) {
        super(table instanceof IAliasTable ? (IWorkTable)((IAliasTable)table).getAliasedTable() : (IWorkTable)table);
        this.m_aliasTable = table instanceof IAliasTable ? (IAliasTable)table : null;
        this.m_table = table;
    }

    @Override
    public String getName() {
        String sName = "";
        String sAlias = "";
        if (this.m_aliasTable != null) {
            IPhysicalTable aliasTable = (IPhysicalTable)this.m_aliasTable.getAliasedTable();
            sName = aliasTable.getName();
            sAlias = this.m_aliasTable.getTableName(false);
        } else if (this.m_table != null) {
            sName = this.m_table.getName();
            sAlias = this.m_table.getTableName(false);
        }
        if (DiagramPanel.isUserPreferenceToIncludePhysicalName()) {
            sName = bundle.formatString("SQLPhysicalTableAdapter.Name.txt", (Object)sName, (Object)sAlias);
        }
        return sName;
    }

    @Override
    public String getToolTipText() {
        String sName = "";
        String sAlias = "";
        if (this.m_aliasTable != null) {
            IPhysicalTable aliasTable = (IPhysicalTable)this.m_aliasTable.getAliasedTable();
            sName = aliasTable.getName();
            sAlias = this.m_aliasTable.getTableName(false);
        } else {
            sName = this.m_table.getName();
            sAlias = this.m_table.getTableName(false);
        }
        if (DiagramPanel.isUserPreferenceToIncludePhysicalName()) {
            sName = bundle.formatString("SQLPhysicalTableAdapter.Name.txt", (Object)sName, (Object)sAlias);
        }
        return sName;
    }

    @Override
    public int showPropertiesDialog(Window wdwParent) {
        WAPropertyTab[] aTabs = this.getPropertyTabs();
        if (aTabs == null) {
            return -1;
        }
        IWorkTable table = null;
        table = this.m_aliasTable != null ? (IWorkTable)this.m_aliasTable.getAliasedTable() : (IWorkTable)this.m_table;
        return ModelUIUtilities.showPropertiesDialog((IComplexPersistableObject)table, aTabs);
    }

    @Override
    public IObject getObject() {
        if (this.m_aliasTable != null) {
            return this.m_aliasTable;
        }
        return this.m_table;
    }

    @Override
    public IPhysicalTable getAliasedTable() {
        IWorkTable table = null;
        table = this.m_aliasTable != null ? (IWorkTable)this.m_aliasTable.getAliasedTable() : (IWorkTable)this.m_table;
        return table;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 && this.m_aliasTable == null && obj instanceof IClause;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IClause;
    }
}

