/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IHaving;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISetOperator;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.etl.models.job.transforms.sql.impl.SQLSetOperatorsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.editor.ExpressionPanel;
import com.sas.wadmin.transforms.sql.editor.SQLSetOperatorsListPanel;
import com.sas.wadmin.transforms.sql.editor.SQLSetOperatorsPanel;
import com.sas.wadmin.visuals.common.GroupByPanel;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.OrderByPanel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SQLSetOperatorsPropertyTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLSetOperatorsPropertyTab.class);
    private Map m_mapViews;
    private SQLSetOperatorsTransformModel m_mdlSetOperators;
    private Object m_selectedObject;
    private IModelListener m_modelListener = new QueryModelListener();
    private List<IObject> m_lObjectsWithQueryListeners = new ArrayList<IObject>();
    private JSplitPane m_spltPane;
    private SQLSetOperatorsListPanel m_pnlSetOperatorsList;
    private WATitledPane m_pnSetOperatorsList;
    private WATitledPane m_pnRightView;
    private ExpressionPanel m_pnlWhere;
    private ExpressionPanel m_pnlHaving;

    public SQLSetOperatorsPropertyTab(SQLSetOperatorsTransformModel oSetOperators) {
        this.setName(bundle.getString("SQLSetOperatorsPropertyTab.Name.txt"));
        this.m_mdlSetOperators = oSetOperators;
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("sql_set_operators");
        this.setHelpProduct("wdb");
    }

    protected void initialize() {
        this.m_mapViews = new HashMap();
        this.m_pnSetOperatorsList = this.createListPane();
        this.m_pnRightView = new WATitledPane(bundle.formatString("SQLSetOperatorsPropertyTab.RightSide.Title.txt", (Object)""), false, false, false, false);
        this.m_spltPane = this.createSplitPane(1, (JComponent)this.m_pnSetOperatorsList, (JComponent)this.m_pnRightView, 0.0);
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add(this.m_spltPane, "Center");
    }

    public boolean validateData() {
        return !(this.m_pnlWhere != null && !this.m_pnlWhere.validateData() || this.m_pnlHaving != null && !this.m_pnlHaving.validateData());
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_pnlSetOperatorsList.moveDataToView();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        List operators = this.m_mdlSetOperators.getSetOperatorsList();
        for (int iOperator = 0; iOperator < operators.size(); ++iOperator) {
            ISetOperator set = (ISetOperator)operators.get(iOperator);
            this.cleanUpQueryClauses(set.getFirstQuery());
            this.cleanUpQueryClauses(set.getSecondQuery());
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        for (int i = 0; i < this.m_lObjectsWithQueryListeners.size(); ++i) {
            IObject object = this.m_lObjectsWithQueryListeners.get(i);
            object.getModel().removeModelListener(this.m_modelListener);
        }
        Collection views = this.m_mapViews.values();
        for (WATitledPane pane : views) {
            WAPanel panel = (WAPanel)pane.getComponent(1);
            panel.saveSettingsAndCleanUp();
        }
        this.m_pnlSetOperatorsList.saveSettingsAndCleanUp();
    }

    private void cleanUpQueryClauses(IQuery query) {
        if (query == null) {
            return;
        }
    }

    private JSplitPane createSplitPane(int eOrientation, JComponent cmpOne, JComponent cmpTwo, double resize) {
        JSplitPane pane = new JSplitPane(eOrientation, cmpOne, cmpTwo);
        pane.setContinuousLayout(true);
        pane.setResizeWeight(resize);
        pane.setBorder(null);
        return pane;
    }

    private WATitledPane createListPane() {
        this.m_pnlSetOperatorsList = new SQLSetOperatorsListPanel(this.m_mdlSetOperators);
        this.m_pnlSetOperatorsList.addListSelectionListener(new ObjectSelectionListener());
        WATitledPane listPane = new WATitledPane(bundle.getString("SQLSetOperatorsPropertyTab.Queries.Title.txt"), false, false, false, false);
        listPane.setContents((Component)new JScrollPane((Component)((Object)this.m_pnlSetOperatorsList)));
        listPane.addPropertyChangeListener("active", (PropertyChangeListener)new ActivationListener());
        listPane.setInactiveBackground(UIManager.getColor("control"));
        return listPane;
    }

    private WATitledPane createNewTableExpressionTabs(IQuery oQuery) {
        WATitledPane pane = new WATitledPane();
        WATabbedPanel pnlTabs = new WATabbedPanel();
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setDragMultipleSourceColumnsEnabled(true);
        config.setUseSQLSyntax(true);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{5, 6});
        config.setHiddenExpressionActions(new int[]{2});
        config.setSettingsKeyPrefix("MappingsTab.SQLSetOperators");
        config.setSetOperatorSpecificsEnabled(true);
        MappingsTab tab = new MappingsTab((IMappingsContainer)oQuery.getSelectResults(), config);
        tab.setName(bundle.getString("SQLSetOperatorsPropertyTab.SelectTab.Title.txt"));
        pnlTabs.addTab((WAPropertyTab)tab);
        IWhere where = oQuery.getWhere();
        if (where == null) {
            where = oQuery.getModel().getObjectFactory().createNewSQLWhere(oQuery.getID());
        }
        where.getModel().addModelListener(this.m_modelListener);
        this.m_lObjectsWithQueryListeners.add((IObject)where);
        IHaving having = oQuery.getHaving();
        if (having == null) {
            having = oQuery.getModel().getObjectFactory().createNewSQLHaving(oQuery.getID());
        }
        having.getModel().addModelListener(this.m_modelListener);
        this.m_lObjectsWithQueryListeners.add((IObject)having);
        IOrderBy orderBy = oQuery.getOrderBy();
        if (orderBy == null) {
            orderBy = oQuery.getModel().getObjectFactory().createNewSQLOrderBy(oQuery.getID());
        }
        orderBy.getModel().addModelListener(this.m_modelListener);
        this.m_lObjectsWithQueryListeners.add((IObject)orderBy);
        IGroupBy groupBy = oQuery.getGroupBy();
        if (groupBy == null) {
            groupBy = oQuery.getModel().getObjectFactory().createNewSQLGroupBy(oQuery.getID());
        }
        groupBy.getModel().addModelListener(this.m_modelListener);
        this.m_lObjectsWithQueryListeners.add((IObject)groupBy);
        this.m_pnlWhere = new ExpressionPanel((ISQLBooleanExpressionContainer)where, false);
        this.m_pnlWhere.setName(bundle.getString("SQLSetOperatorsPropertyTab.WhereTab.Title.txt"));
        pnlTabs.addTab((WAPropertyTab)this.m_pnlWhere);
        this.m_pnlHaving = new ExpressionPanel((ISQLBooleanExpressionContainer)having, false);
        this.m_pnlHaving.setName(bundle.getString("SQLSetOperatorsPropertyTab.HavingTab.Title.txt"));
        pnlTabs.addTab((WAPropertyTab)this.m_pnlHaving);
        OrderByPanel orderByPanel = new OrderByPanel(orderBy, oQuery.getSourcesInFrom(), new ITable[]{oQuery.getTargetTable()});
        orderByPanel.setName(bundle.getString("SQLSetOperatorsPropertyTab.OrderByTab.Title.txt"));
        pnlTabs.addTab((WAPropertyTab)orderByPanel);
        GroupByPanel groupByPanel = new GroupByPanel(groupBy, oQuery.getSourcesInFrom(), new ITable[]{oQuery.getTargetTable()});
        groupByPanel.setName(bundle.getString("SQLSetOperatorsPropertyTab.GroupByTab.Title.txt"));
        pnlTabs.addTab((WAPropertyTab)groupByPanel);
        pane.setTitle(bundle.formatString("SQLSetOperatorsPropertyTab.RightSide.Title.txt", (Object)oQuery.getSelectResults().getSourceTables()[0].getName()));
        pane.add((Component)pnlTabs);
        pane.setActiveBackground(UIManager.getColor("control"));
        pane.setInactiveBackground(UIManager.getColor("control"));
        return pane;
    }

    private WATitledPane createNewSetOperatorsPane(ISetOperator operator) {
        WATitledPane pane = new WATitledPane();
        SQLSetOperatorsPanel panel = new SQLSetOperatorsPanel(operator);
        pane.setTitle(bundle.getString("SQLSetOperatorsPropertyTab.SetOperator.Title.txt"));
        pane.add((Component)((Object)panel));
        pane.setActiveBackground(UIManager.getColor("control"));
        pane.setInactiveBackground(UIManager.getColor("control"));
        return pane;
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String sType = event.getType();
            IObject obj = event.getModelObject();
            if (SQLSetOperatorsPropertyTab.this.m_selectedObject instanceof IQuery) {
                if ("Object:BooleanExpressionAdded".equals(sType) || "Sorting:ColumnAdded".equals(sType)) {
                    ((IQuery)SQLSetOperatorsPropertyTab.this.m_selectedObject).addClause((IClause)obj);
                } else if ("Object:BooleanExpressionRemoved".equals(sType)) {
                    if (((ISQLBooleanExpressionContainer)obj).size() == 0) {
                        ((IQuery)SQLSetOperatorsPropertyTab.this.m_selectedObject).removeClause((IClause)obj);
                    }
                } else if ("Sorting:ColumnRemoved".equals(sType) && ((ISorting)obj).size() == 0) {
                    ((IQuery)SQLSetOperatorsPropertyTab.this.m_selectedObject).removeClause((IClause)obj);
                }
            }
        }
    }

    private class ObjectSelectionListener
    implements ListSelectionListener {
        private ObjectSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object selectedItem = SQLSetOperatorsPropertyTab.this.m_pnlSetOperatorsList.getSelectedObject();
            if (selectedItem == null) {
                return;
            }
            SQLSetOperatorsPropertyTab.this.m_selectedObject = selectedItem;
            WATitledPane pane = null;
            if (SQLSetOperatorsPropertyTab.this.m_mapViews.get(selectedItem) != null) {
                pane = (WATitledPane)SQLSetOperatorsPropertyTab.this.m_mapViews.get(selectedItem);
                SQLSetOperatorsPropertyTab.this.m_spltPane.setRightComponent((Component)pane);
            } else {
                pane = selectedItem instanceof IQuery ? SQLSetOperatorsPropertyTab.this.createNewTableExpressionTabs((IQuery)selectedItem) : SQLSetOperatorsPropertyTab.this.createNewSetOperatorsPane((ISetOperator)selectedItem);
                SQLSetOperatorsPropertyTab.this.m_spltPane.setRightComponent((Component)pane);
                SQLSetOperatorsPropertyTab.this.m_mapViews.put(selectedItem, pane);
            }
            if (pane != null) {
                try {
                    WAPanel panel = (WAPanel)pane.getComponent(1);
                    panel.populateStore();
                    panel.moveDataToView();
                    panel.updateUI();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SQLSetOperatorsPropertyTab.this.m_spltPane.invalidate();
            SQLSetOperatorsPropertyTab.this.m_spltPane.updateUI();
        }
    }

    private class ActivationListener
    implements PropertyChangeListener {
        private ActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
        }
    }
}

