/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.PhysicalTableAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.AdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataNode;
import com.sas.wadmin.transforms.sql.editor.SQLPhysicalTableAdapter;
import java.awt.Point;
import java.util.List;

public class SQLPhysicalTableNode
extends DataNode {
    private IQuery m_query;

    public SQLPhysicalTableNode(PhysicalTableAdapter ad, IQuery query) {
        super(ad);
        this.setupNode(query);
        this.refresh();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SQLPhysicalTableNode(IQuery query, List lAttributes, List lValues) {
        this.setupNode(query);
        int xPos = 0;
        int yPos = 0;
        int iIndex = -1;
        boolean isTarget = false;
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.setId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                xPos = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                yPos = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("Index")) {
                iIndex = Integer.parseInt(sValue);
                continue;
            }
            if (!"IsTarget".equalsIgnoreCase(sAttribute)) continue;
            isTarget = Boolean.parseBoolean(sValue);
        }
        this.setSpotLocation(1, new Point(xPos, yPos));
        SQLPhysicalTableAdapter adapter = null;
        if (!isTarget) {
            List sources = this.m_query.getQuerySourceTableList();
            if (sources.size() <= iIndex) return;
            adapter = new SQLPhysicalTableAdapter((ITable)((IAliasTable)sources.get(iIndex)));
        } else {
            ITable target = this.m_query.getTargetTable();
            if (target == null || target instanceof IWorkTable) return;
            adapter = new SQLPhysicalTableAdapter(target);
        }
        this.setAdapterNode(new AdapterNode(adapter, this));
        this.refresh();
    }

    private void setupNode(IQuery query) {
        this.m_query = query;
        this.setNodeStyleContext("NodeStyle3");
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshNoteIndicator();
        this.setTitleText(this.getAdapter().getName());
    }

    @Override
    protected void refreshNoteIndicator() {
        IDiagramNodeAdapter adapter = this.getAdapter();
        String pNote = "";
        pNote = adapter instanceof SQLPhysicalTableAdapter ? ((SQLPhysicalTableAdapter)this.getAdapter()).getAliasedTable().getPrivateNote() : ((IPhysicalTable)((PhysicalTableAdapter)this.getAdapter()).getObject()).getPrivateNote();
        if (pNote == null || pNote.equals("")) {
            this.removeNote();
        } else {
            this.setNoteText(pNote);
            this.getNoteTextPane().setFocusable(false);
            this.getNoteTextPane().setEditable(false);
        }
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    @Override
    protected void setId(String sId) {
        this.m_sId = sId;
    }

    @Override
    public String writeToXML(IDesignTimeModel designModel) {
        IObject object;
        ISourceTable source;
        IClause srcParent;
        StringBuffer outXML = new StringBuffer();
        outXML.append("<SQLPhysicalTableNode>");
        outXML.append("<NodeId>");
        outXML.append(this.getId());
        outXML.append("</NodeId>");
        outXML.append("<Index>");
        outXML.append(this.m_query.getAllSourceTables().indexOf(this.getObject()));
        outXML.append("</Index>");
        Point point = this.getSpotLocation(1, null);
        outXML.append("<PositionX>");
        outXML.append(String.valueOf(point.x));
        outXML.append("</PositionX>");
        outXML.append("<PositionY>");
        outXML.append(String.valueOf(point.y));
        outXML.append("</PositionY>");
        outXML.append("<ShowColumns>");
        outXML.append(String.valueOf(this.isShowColumns()));
        outXML.append("</ShowColumns>");
        boolean isTarget = this.m_query.getTargetTable() == this.getAdapter().getObject();
        outXML.append("<IsTarget>").append(isTarget).append("</IsTarget>");
        String sJoin = "";
        if (!isTarget && (srcParent = (source = (ISourceTable)(object = this.getAdapter().getObject())).getParent()) instanceof IJoin) {
            sJoin = object == ((IJoin)srcParent).getLeftSide() ? "Left" : "Right";
        }
        outXML.append("<JoinSide>").append(sJoin).append("</JoinSide>");
        outXML.append("</SQLPhysicalTableNode>");
        return outXML.toString();
    }

    public String toString() {
        return this.getObject().toString();
    }
}

