/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.impl.Having;
import com.sas.wadmin.transforms.sql.editor.CaseStatementPanel;
import com.sas.wadmin.transforms.sql.editor.ColumnSelectorDialog;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class SQLExpressionActions {
    private static WAdminResource bundle = WAdminResource.getBundle(SQLExpressionActions.class);
    protected static String WHERE = "where";
    protected static String HAVING = "having";

    public static String showChooseColumnsDialog(TablesPaletteTreeModel viewModel) {
        return SQLExpressionActions.showChooseColumnsDialog(viewModel, true);
    }

    public static String showChooseColumnsDialog(TablesPaletteTreeModel viewModel, boolean bUseLongNames) {
        String[] names;
        ColumnSelectorDialog csDialog = new ColumnSelectorDialog(viewModel);
        csDialog.allowMultipleSelection();
        csDialog.setUseLongName(bUseLongNames);
        csDialog.setResizable(true);
        csDialog.show();
        if (csDialog.getReturnValue() == 1 && (names = csDialog.getSelectedTableColumnNames()) != null && names.length != 0) {
            return SQLExpressionActions.buildColumnsString(names);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showCaseDialog(ICaseStatement caseStatement, IClause clause, UndoManager mgrUndo) {
        CaseStatementPanel casePanel = new CaseStatementPanel(caseStatement, clause);
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("CaseStatementPanel.Title.txt"), true);
        dlg.setMainPanel((WAPanel)casePanel);
        dlg.setResizable(true);
        dlg.setEditable(caseStatement.getModel().isEditable());
        IModel mdl = caseStatement.getModel();
        UndoManager mgrOld = mdl.getUndoManager();
        dlg.setUndoManager(mgrUndo);
        mdl.setUndoManager(mgrUndo);
        try {
            dlg.show();
        }
        finally {
            mdl.setUndoManager(mgrOld);
        }
        return dlg.getReturnValue() == 1;
    }

    public static String showExpressionBuilder(IClause clause, String initialText) {
        return SQLExpressionActions.showExpressionBuilder(clause, initialText, null);
    }

    public static String showExpressionBuilder(IClause clause, String initialText, IMapping map) {
        IColumn[] aMapCols = new IColumn[]{};
        if (map != null) {
            aMapCols = map.getSources();
        }
        ITable[] aSourceTables = clause.getParentQuery().getSourcesInFrom();
        ExpressionBuilderTab expressionBuilderTab = new ExpressionBuilderTab(aMapCols, aSourceTables, true);
        expressionBuilderTab.setClause(clause instanceof Having ? HAVING : WHERE);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ExpressionBuilder.Title.txt"), true);
        dialog.setMainPanel((WAPanel)expressionBuilderTab);
        dialog.setResizable(true);
        if (initialText != null) {
            expressionBuilderTab.setExpression(initialText);
        }
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return expressionBuilderTab.getExpression();
        }
        return null;
    }

    protected static String buildColumnsString(String[] values) {
        StringBuffer sbText = new StringBuffer();
        int nOperands = values.length;
        for (int i = 0; i < nOperands; ++i) {
            sbText.append(values[i]);
            if (i >= nOperands - 1) continue;
            sbText.append(" ");
        }
        return sbText.toString();
    }

    public static String modifyOperand(JTextComponent cellEditor, String newText) {
        StringBuffer sbText = new StringBuffer(newText);
        String selText = cellEditor.getSelectedText();
        int caretPosition = cellEditor.getCaretPosition();
        int selectionStart = cellEditor.getSelectionStart();
        int selectionEnd = cellEditor.getSelectionEnd();
        try {
            if (selText != null) {
                if (selectionStart > 0 && cellEditor.getText(selectionStart - 1, 1) != " ") {
                    sbText.insert(0, " ");
                }
                if (selectionEnd < cellEditor.getText().length() && cellEditor.getText(selectionEnd, 1) != " ") {
                    sbText.append(" ");
                }
                cellEditor.replaceSelection(sbText.toString());
                cellEditor.requestFocus();
            } else {
                if (caretPosition > 0 && cellEditor.getText(caretPosition - 1, 1) != " ") {
                    sbText.insert(0, " ");
                }
                if (caretPosition < cellEditor.getText().length() && cellEditor.getText(caretPosition, 1) != " ") {
                    sbText.append(" ");
                }
                Document d = cellEditor.getDocument();
                d.insertString(caretPosition, sbText.toString(), null);
                cellEditor.requestFocus();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return cellEditor.getText();
    }
}

