/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.editor.CodeEditorPane;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.IHaving;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLCreateStatement;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.job.transforms.sql.ITargetTableOptionsContainer;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.JoinType;
import com.sas.etl.models.job.transforms.sql.impl.SQLJoinTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppFrameworkManager;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.drill.DrillComponent;
import com.sas.wadmin.jobeditor.JobEditorPanel;
import com.sas.wadmin.jobeditor.JobLogTab;
import com.sas.wadmin.jobeditor.diagram.ISASApplicationServerDiagramPanel;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.transforms.sql.TableColumnPropertiesModel;
import com.sas.wadmin.transforms.sql.editor.ExpressionPanel;
import com.sas.wadmin.transforms.sql.editor.INavigationListener;
import com.sas.wadmin.transforms.sql.editor.JoinDiagramModel;
import com.sas.wadmin.transforms.sql.editor.JoinDiagramTab;
import com.sas.wadmin.transforms.sql.editor.JoinPaletteTree;
import com.sas.wadmin.transforms.sql.editor.JoinPaletteTreeModel;
import com.sas.wadmin.transforms.sql.editor.JoinVisualsTab;
import com.sas.wadmin.transforms.sql.editor.NavigationEvent;
import com.sas.wadmin.transforms.sql.editor.NavigatorTree;
import com.sas.wadmin.transforms.sql.editor.NavigatorTreeModel;
import com.sas.wadmin.transforms.sql.editor.SQLProcessTab;
import com.sas.wadmin.transforms.sql.properties.AbstractExpressionPropertiesModel;
import com.sas.wadmin.transforms.sql.properties.BaseClausePropertiesModel;
import com.sas.wadmin.transforms.sql.properties.ColumnPropertiesModel;
import com.sas.wadmin.transforms.sql.properties.CreatePropertiesModel;
import com.sas.wadmin.transforms.sql.properties.JoinPropertiesModel;
import com.sas.wadmin.transforms.sql.properties.SQLPropertiesModel;
import com.sas.wadmin.transforms.sql.properties.SelectPropertiesModel;
import com.sas.wadmin.transforms.sql.properties.SourceTablePropertiesModel;
import com.sas.wadmin.transforms.sql.properties.SubqueryPropertiesModel;
import com.sas.wadmin.transforms.sql.properties.TablePropertiesModel;
import com.sas.wadmin.transforms.sql.properties.TargetTablePropertiesModel;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.ColumnsTab;
import com.sas.wadmin.visuals.common.GroupByPanel;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.OrderByPanel;
import com.sas.wadmin.visuals.common.SettingsToolbarItems;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.wadmin.visuals.common.TablesPaletteTreePanel;
import com.sas.wadmin.visuals.properties.EmptyPropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesTable;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsSplittableTabbedPane2;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class JoinEditorPanel
extends WAPropertyTab
implements DrillComponent,
WsSelectionProvider,
ISASApplicationServerDiagramPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(JoinEditorPanel.class);
    private static final String CREATE_STATEMENT = "Create";
    private ISQLTransform m_model;
    private WsUndoManager m_mgrUndo;
    private IDesignTimeModel m_designModel;
    private RunModel m_mdlRun;
    private RunSQLModelListener m_lstRunSQL;
    private JSplitPane m_spltMain;
    private JSplitPane m_spltTopRight;
    private JSplitPane m_spltBottomRight;
    private NavigatorTree m_treeNavigator;
    private NavigatorTreeModel m_mdlNavigator;
    private WATitledPane m_pnlNavigator;
    private JoinPaletteTreeModel m_mdlClausesPalette;
    private JoinPaletteTree m_treeClausesPalette;
    private WATitledPane m_pnlClausesPalette;
    private TablesPaletteTreeModel m_mdlTablesPalette;
    private TablesPaletteTreePanel m_treeTablesPalette;
    private WATitledPane m_pnlTablesPalette;
    private PropertiesTable m_tblProperties;
    private WATitledPane m_pnlProperties;
    private WsSplittableTabbedPane2 m_tabsMain;
    private JoinVisualsTab m_visualsTab;
    private SQLProcessTab m_tabCode;
    private JobLogTab m_tabLog;
    private JoinDiagramTab m_diagramTab;
    private JToolBar m_toolbar;
    private WAPropertyTab m_activeTab;
    private JComponent m_activePalette;
    private IObject m_activeObject;
    private boolean m_bActive;
    private Object[] m_aSelectedObjects;
    private Object m_selectedObject;
    private Object m_selectedDiagramObject;
    private Object m_selectedNavigatorObject;
    private boolean m_bPropertiesVisible;
    private boolean m_bIgnoreSelectionEvents;
    private boolean m_bCodeNeedsGenerating;
    private boolean m_bNavigatorActive;
    private Map m_mapTabs;
    private INavigationListener m_lsnrNavigation;
    private IModelListener m_lsnrModel;
    private ChangeListener m_lsnrUndo;
    private WsSelectionChangedListener m_lsnrDiagramSelection;
    private WsSelectionChangedListener m_lsnrTablesTree;
    private WsAbstractAction m_actRunTo;
    private WsAbstractAction m_actRun;
    private WsAbstractAction m_actStop;
    private WsAbstractAction m_actGenerateCode;
    private WsAbstractAction m_actValidate;
    private WsAbstractAction m_actRunAutoJoin;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractAction m_actFindInCode;
    private WsAbstractAction m_actProperties;
    private WsAbstractAction m_actDelete;
    private WsAbstractToggleAction m_actCreateAsView;
    private WsAbstractAction m_actSaveAsLocal;
    private WsAbstractAction m_actSaveAsRemote;
    private WsAbstractAction m_actDefaultPalette;
    private WsDropMenuAction m_actSettings;
    private WsAbstractToggleAction m_actShowPropertiesPane;
    private List m_lReferences;

    public JoinEditorPanel(ISQLTransform model) {
        this.m_model = model;
        this.initialize();
    }

    protected void initialize() {
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_create");
        this.setName(this.m_model.getName());
        this.m_mapTabs = new HashMap();
        this.m_aSelectedObjects = new Object[0];
        this.m_designModel = (IDesignTimeModel)this.m_model.getModel();
        this.m_lsnrModel = new JoinModelListener();
        this.m_model.getModel().addModelListener(this.m_lsnrModel);
        this.createActions();
        this.initializeUndo();
        this.setSASAppServer(this.m_designModel.getSASAppServer());
        this.m_tabsMain = this.createTabs();
        this.m_pnlNavigator = this.createNavigatorPanel();
        this.m_pnlClausesPalette = this.createClausesPalettePanel();
        this.m_pnlTablesPalette = this.createTablesPalettePanel();
        this.m_pnlProperties = this.createPropertiesPanel();
        this.m_spltBottomRight = this.createSplitPane(0, this.m_activePalette, (JComponent)this.m_pnlProperties, 0.5);
        this.m_spltTopRight = this.createSplitPane(0, (JComponent)this.m_pnlNavigator, this.m_spltBottomRight, 0.5);
        this.m_spltMain = this.createSplitPane(1, (JComponent)this.m_tabsMain, this.m_spltTopRight, 0.785);
        this.m_lstRunSQL = new RunSQLModelListener();
        this.setPropertiesVisible(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("JoinEditorPanel.PropertiesVisible", true));
        this.m_toolbar = this.createToolBar();
        this.setLayout(new BorderLayout());
        this.add(this.m_toolbar, "North");
        this.add(this.m_spltMain, "Center");
        this.m_lsnrNavigation = new NavigateToListener();
        this.m_lsnrDiagramSelection = new DiagramSelectionListener();
        this.m_lReferences = new ArrayList();
    }

    private void createActions() {
        this.m_actRunTo = new RunToSelectedTransformation();
        this.m_actRun = new RunAction();
        this.m_actStop = new StopAction();
        this.m_actValidate = new ValidateAction();
        this.m_actGenerateCode = new GenerateCodeAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actProperties = new PropertiesAction();
        this.m_actDelete = new DeleteAction();
        this.m_actFindInCode = new FindInCodeAction();
        this.m_actRunAutoJoin = new RunAutoJoinAction();
        this.m_actCreateAsView = new CreateAsViewAction();
        this.m_actDefaultPalette = new DefaultPaletteAction();
        this.m_actSettings = new SettingsAction();
        this.m_actShowPropertiesPane = new ShowPropertiesAction();
        this.m_actSaveAsLocal = new SaveAsLocalAction();
        this.m_actSaveAsRemote = new SaveAsRemoteAction();
    }

    private void initializeUndo() {
        this.m_mgrUndo = (WsUndoManager)this.m_designModel.getUndoManager();
        this.m_lsnrUndo = new UndoManagerListener();
        this.m_mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(this.m_mgrUndo.canUndo());
        this.m_actRedo.setEnabled(this.m_mgrUndo.canRedo());
    }

    public void setRunModel(RunModel mdl) {
        this.m_mdlRun = mdl;
        this.m_mdlRun.setSASAppServer(this.getSASAppServer());
        this.m_mdlRun.addListener(this.m_lstRunSQL);
    }

    private WsSplittableTabbedPane2 createTabs() {
        WsSplittableTabbedPane2 tabs = new WsSplittableTabbedPane2(3, false);
        this.m_visualsTab = new JoinVisualsTab();
        tabs.addTab("", (Component)((Object)this.m_visualsTab));
        this.m_tabCode = new SQLProcessTab((ICodeGenerator)this.m_model);
        tabs.addTab(bundle.getString("JoinEditorPanel.CodeTab.Title.txt"), (Component)((Object)this.m_tabCode));
        this.m_tabLog = new JobLogTab(1);
        this.m_tabLog.setHelpProduct("texteditor");
        this.m_tabLog.setHelpTopic("logspace");
        tabs.addTab(bundle.getString("JoinEditorPanel.LogTab.Title.txt"), (Component)((Object)this.m_tabLog));
        tabs.addChangeListener((ChangeListener)new TabSelectionListener());
        Dimension minimumSize = tabs.getMinimumSize();
        minimumSize.width = 0;
        tabs.setMinimumSize(minimumSize);
        try {
            this.setActiveTab(this.m_visualsTab);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (CodegenException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        return tabs;
    }

    private WATitledPane createNavigatorPanel() {
        this.m_mdlNavigator = new NavigatorTreeModel(this.m_model);
        this.m_treeNavigator = new NavigatorTree(this.m_mdlNavigator);
        this.m_treeNavigator.addTreeSelectionListener(new NavigatorSelectionListener());
        this.m_treeNavigator.setDeleteAction(this.m_actDelete);
        WATitledPane pnlNavigator = new WATitledPane(bundle.getString("JoinEditorPanel.Navigator.Title.txt"), false, false, false, false);
        pnlNavigator.setContents((Component)new JScrollPane((Component)((Object)this.m_treeNavigator)));
        pnlNavigator.addPropertyChangeListener("active", (PropertyChangeListener)new ActivationListener());
        return pnlNavigator;
    }

    private WATitledPane createClausesPalettePanel() {
        this.m_mdlClausesPalette = new JoinPaletteTreeModel();
        this.m_treeClausesPalette = new JoinPaletteTree((ITreeModel)this.m_mdlClausesPalette);
        this.m_treeClausesPalette.setExpandsSelectedPaths(true);
        this.m_treeClausesPalette.setScrollsOnExpand(true);
        this.m_treeClausesPalette.setEditable(false);
        this.m_treeClausesPalette.getSelectionModel().setSelectionMode(1);
        this.m_treeClausesPalette.setUserDefaultAction((Action)this.m_actDefaultPalette);
        WATitledPane pnlPalette = new WATitledPane(bundle.getString("JoinEditorPanel.Palette.Title.txt"), false, false, false, false);
        pnlPalette.setContents((Component)new JScrollPane((Component)((Object)this.m_treeClausesPalette)));
        return pnlPalette;
    }

    private WATitledPane createTablesPalettePanel() {
        IQuery query = this.m_model.getQuery();
        this.m_mdlTablesPalette = new TablesPaletteTreeModel(query.getSourcesInFrom(), new ITable[]{query.getTargetTable()});
        this.m_treeTablesPalette = new TablesPaletteTreePanel(this.m_mdlTablesPalette);
        this.m_treeTablesPalette.allowMultipleSelection();
        this.m_lsnrTablesTree = new TablesTreeSelectionListener();
        this.m_treeTablesPalette.addTreeSelectionListener(this.m_lsnrTablesTree);
        WATitledPane pnlPalette = new WATitledPane(bundle.getString("JoinEditorPanel.TablesPalette.Title.txt"), false, false, false, false);
        pnlPalette.setContents((Component)((Object)this.m_treeTablesPalette));
        return pnlPalette;
    }

    private WATitledPane createPropertiesPanel() {
        this.m_tblProperties = new PropertiesTable();
        JScrollPane scrProperties = new JScrollPane((Component)((Object)this.m_tblProperties));
        WsUIUtilities.adjustPreferredScrollableViewportSize((JTable)((Object)this.m_tblProperties), (int)6);
        WATitledPane pnlProperties = new WATitledPane(bundle.formatString("JoinEditorPanel.Properties.Title.fmt.txt", (Object)""), false, false, false, true);
        pnlProperties.setContents((Component)scrProperties);
        pnlProperties.getCloseButton().addActionListener(new ClosePropertiesActionListener());
        return pnlProperties;
    }

    private JSplitPane createSplitPane(int eOrientation, JComponent cmpOne, JComponent cmpTwo, double resize) {
        JSplitPane pane = new JSplitPane(eOrientation, cmpOne, cmpTwo);
        pane.setContinuousLayout(true);
        pane.setResizeWeight(resize);
        pane.setBorder(null);
        return pane;
    }

    private JToolBar createToolBar() {
        JToolBar bar = WsUIUtilities.createToolBar();
        bar.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actRun));
        bar.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actStop));
        bar.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actRunTo));
        bar.addSeparator();
        bar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actValidate));
        bar.addSeparator();
        bar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actGenerateCode));
        bar.addSeparator();
        bar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actSettings));
        bar.addSeparator();
        bar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRunAutoJoin));
        bar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actProperties));
        return bar;
    }

    private JPopupMenu createSettingsDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        if (this.getActiveVisualsTab() instanceof SettingsToolbarItems) {
            JMenuItem[] aItems = ((SettingsToolbarItems)this.getActiveVisualsTab()).getMenuItems();
            for (int i = 0; i < aItems.length; ++i) {
                mnuDrop.add(aItems[i]);
            }
        }
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowPropertiesPane));
        return mnuDrop;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tabCode.setEditable(bEditable);
        Object[] aTabs = this.m_mapTabs.values().toArray();
        for (int iTab = 0; iTab < aTabs.length; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)aTabs[iTab];
            tab.setEditable(bEditable);
        }
        this.m_tblProperties.setEditable(bEditable);
        this.m_treeNavigator.setEditable(bEditable);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        AppFrameworkManager.getInstance().setSelectionProvider((WsSelectionProvider)(bActive ? this : null));
        this.m_bActive = bActive;
        if (this.m_activeTab != null) {
            this.m_activeTab.updateWorkspaceUIComponents(bActive);
        }
        this.m_actProperties.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actCreateAsView.setActive(bActive);
        this.m_actRunTo.setActive(bActive);
        this.m_actRun.setActive(bActive);
        this.m_actStop.setActive(bActive);
        this.m_actValidate.setActive(bActive);
        this.m_actFindInCode.setActive(bActive);
        this.m_actGenerateCode.setActive(bActive);
        this.m_actUndo.setActive(bActive);
        this.m_actRedo.setActive(bActive);
        this.m_actRunAutoJoin.setActive(bActive);
        this.m_actSaveAsLocal.setActive(bActive);
        this.m_actSaveAsRemote.setActive(bActive);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_tabCode.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlNavigator.populate();
        this.m_treeNavigator.expand();
        this.m_treeNavigator.setSelectedNode((AbstractTreeNode)this.m_mdlNavigator.getRoot());
        this.m_tabCode.populateStore();
        this.m_tabCode.moveDataToView();
        this.setActivePropertiesModel(this.m_model.getName(), this.getPropertiesModel(this.m_model));
        this.setSelectedObject(this.m_model);
    }

    public boolean validateData() {
        WAPropertyTab tabCurrent = this.getActiveVisualsTab();
        if (tabCurrent != null) {
            return tabCurrent.validateData();
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.disposeActivePropertiesModel();
        this.m_treeTablesPalette.removeTreeSelectionListener(this.m_lsnrTablesTree);
        this.m_visualsTab.saveSettingsAndCleanUp();
        this.m_tabCode.saveSettingsAndCleanUp();
        this.m_tabLog.saveSettingsAndCleanUp();
        this.m_treeClausesPalette.dispose();
        this.m_treeTablesPalette.dispose();
        this.m_treeNavigator.dispose();
        Object[] aTabs = this.m_mapTabs.values().toArray();
        for (int iTab = 0; iTab < aTabs.length; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)aTabs[iTab];
            if (tab instanceof MappingsTab) {
                ((MappingsTab)tab).removeSQLNavigationListener(this.m_lsnrNavigation);
            } else if (tab instanceof ExpressionPanel) {
                ((ExpressionPanel)tab).removeSQLNavigationListener(this.m_lsnrNavigation);
            }
            tab.saveSettingsAndCleanUp();
        }
        this.m_mgrUndo.removeChangeListener(this.m_lsnrUndo);
        if (this.m_mdlRun != null) {
            this.m_mdlRun.removeListener(this.m_lstRunSQL);
        }
        this.m_model.getModel().removeModelListener(this.m_lsnrModel);
        super.saveSettingsAndCleanUp();
    }

    @Override
    public WAPanel getPanel() {
        return this;
    }

    @Override
    public JToolBar getToolBar() {
        return this.m_toolbar;
    }

    @Override
    public WsAbstractAction[] getSharedActions() {
        return new WsAbstractAction[0];
    }

    @Override
    public void addReference(Object referrer) {
        this.m_lReferences.add(referrer);
        Workspace.getDefaultLogger().debug((Object)("Reference added to " + this + ": " + referrer));
    }

    @Override
    public void removeReference(Object referrer) {
        if (!this.m_lReferences.remove(referrer)) {
            throw new IllegalStateException("Attempt to remove a reference that does not exist: " + referrer);
        }
        Workspace.getDefaultLogger().debug((Object)("Reference removed from " + this + ": " + referrer));
        if (this.m_lReferences.isEmpty()) {
            this.saveSettingsAndCleanUp();
        }
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    private void fireSelectionChangedEvent() {
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    private void setSelectedNavigatorObject(Object object) {
        if (this.m_selectedNavigatorObject == object) {
            return;
        }
        this.m_selectedNavigatorObject = object;
        if (this.m_bNavigatorActive) {
            this.setSelectedObject(object);
        }
    }

    private Object getSelectedNavigatorObject() {
        return this.m_selectedNavigatorObject;
    }

    private void setSelectedDiagramObject(Object object) {
        if (this.m_selectedDiagramObject == object) {
            return;
        }
        this.m_selectedDiagramObject = object;
        if (!this.m_bNavigatorActive) {
            this.setSelectedObject(object);
        }
    }

    private Object getSelectedDiagramObject() {
        return this.m_selectedDiagramObject;
    }

    private void setSelectedObject(Object object) {
        Object[] objectArray;
        if (this.m_selectedObject == object) {
            return;
        }
        this.m_selectedObject = object;
        if ((object = this.convertObject(object)) == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        this.m_aSelectedObjects = objectArray;
        this.fireSelectionChangedEvent();
        this.updateActions();
    }

    private Object getSelectedObject() {
        return this.m_selectedObject;
    }

    private Object convertObject(Object object) {
        ITable table;
        if (object == this.m_model.getQuery()) {
            object = this.m_model;
        } else if (object instanceof IAliasTable && (table = ((IAliasTable)object).getAliasedTable()) != null) {
            object = table;
        }
        return object;
    }

    private void updateActions() {
        int eRunState = this.m_mdlRun != null ? this.m_mdlRun.getRunState() : 0;
        this.m_actRun.setEnabled(eRunState == 0);
        this.m_actStop.setEnabled(eRunState == 1);
        this.m_actValidate.setEnabled(eRunState == 0 && !this.m_model.isUsingUserWrittenCode());
        this.m_actRunTo.setEnabled(eRunState == 0 || eRunState == 2);
        Object object = this.convertObject(this.m_selectedObject);
        this.m_actFindInCode.setEnabled(object instanceof IClause && object != this.m_model);
        this.m_actProperties.setEnabled(object instanceof IPhysicalTable || object instanceof SQLJoinTransformModel);
        boolean bEditable = this.isEditable();
        this.m_actRunAutoJoin.setEnabled(bEditable && object instanceof IJoin);
        this.m_actDelete.setEnabled(bEditable && this.isDeleteValid());
        this.m_actCreateAsView.setEnabled(bEditable && !(this.m_selectedObject instanceof ISourceTable) && object instanceof IWorkTable);
        if (object instanceof IPhysicalTable) {
            this.m_actCreateAsView.setSelected(((IPhysicalTable)object).isView());
        }
        this.updateSaveActions();
    }

    private void updateSaveActions() {
        if (this.m_mdlRun == null || this.m_mdlRun.getRunState() == 0) {
            if (this.m_activeTab != null) {
                this.m_actSaveAsLocal.setEnabled(this.m_activeTab == this.m_tabCode && !this.m_model.isUsingUserWrittenCode() || this.m_activeTab == this.m_tabLog);
                this.m_actSaveAsRemote.setEnabled(this.m_activeTab == this.m_tabCode && this.m_model.isUsingUserWrittenCode());
            } else {
                this.m_actSaveAsLocal.setEnabled(false);
                this.m_actSaveAsRemote.setEnabled(false);
            }
        } else {
            this.m_actSaveAsLocal.setEnabled(false);
            this.m_actSaveAsRemote.setEnabled(false);
        }
    }

    private boolean isDeleteValid() {
        Object object = this.getSelectedObject();
        return object != this.m_model && object != this.m_model.getDataTarget() && !(object instanceof ISubqueryTargetTable) && !(object instanceof ISelectResultsContainer) && (!(object instanceof IQuery) || object instanceof ISubquery);
    }

    private boolean isContextForMainSQL(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        return aObjects.length == 1 && aObjects[0] == this.m_model;
    }

    private boolean isContextForType(WsActionContextInterface context, String sRequiredType) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!(aObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            if (sRequiredType.equals(((SimpleObject)aObjects[iObject]).getPublicType())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveObject(IObject object, String sName) {
        if (object instanceof ISQLTransform) {
            if (!sName.equals("Select")) {
                object = ((ISQLTransform)object).getQuery();
            }
        } else if (object instanceof IJoin) {
            IJoin join = (IJoin)object;
            String sType = join.getJoinType();
            if (join.useImplicit()) {
                IQuery query = join.getParentQuery();
                object = query.getClause(ClauseType.WHERE);
                if (object == null) {
                    object = query;
                }
            } else if (sType.equals("Cross") || sType.equals("Union")) {
                object = ((IClause)object).getParentQuery();
            }
        }
        if (object == this.m_activeObject) {
            this.m_tabsMain.setSelectedTab((Component)((Object)this.m_visualsTab));
            return;
        }
        WAPropertyTab tabCurrent = this.m_activeTab;
        if (tabCurrent instanceof JoinVisualsTab && (tabCurrent = ((JoinVisualsTab)tabCurrent).getContents()) instanceof JoinDiagramTab) {
            this.m_diagramTab.getDiagramToolBar().setVisible(false);
        }
        if (tabCurrent != null) {
            if (!tabCurrent.validateData()) {
                return;
            }
            try {
                tabCurrent.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        this.m_activeObject = object;
        WAPropertyTab tabNew = (WAPropertyTab)this.m_mapTabs.get(object);
        if (tabNew instanceof JoinDiagramTab) {
            this.m_diagramTab.getDiagramToolBar().setVisible(true);
        }
        if (tabNew == null) {
            try {
                SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
                tabNew = this.createVisualTab(object);
                tabNew.setEditable(this.isEditable());
                tabNew.moveDataToView();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            finally {
                SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
            }
            this.m_mapTabs.put(object, tabNew);
        }
        String sTabName = object.getName();
        if (object instanceof ISelectResultsContainer) {
            sTabName = "Select";
        } else if (object instanceof IQuery) {
            sTabName = bundle.getString("JoinEditorPanel.DiagramTab.Title.txt");
        }
        this.m_selectedDiagramObject = null;
        this.setActiveVisualsTab(sTabName, tabNew);
        if (object instanceof ISelectResultsContainer || object instanceof ISQLBooleanExpressionContainer || object instanceof IGroupBy || object instanceof IOrderBy || object instanceof ISQLCreateStatement && sName.equals("Select") || object instanceof ITable) {
            this.m_mdlTablesPalette.removeAllChildren((ITreeNode)this.m_mdlTablesPalette.getRoot());
            IQuery query = this.m_model.getQuery();
            if (object instanceof IClause) {
                query = ((IClause)object).getParentQuery();
            } else if (object instanceof ISourceTable) {
                IClause clause = ((ISourceTable)object).getParent();
                query = clause.getParentQuery();
            }
            this.m_mdlTablesPalette.addSourceAndTargetTables(query.getSourcesInFrom(), new ITable[]{query.getTargetTable()});
            this.setActivePalette((JComponent)this.m_pnlTablesPalette);
            this.m_treeTablesPalette.expand();
        } else {
            this.setActivePalette((JComponent)this.m_pnlClausesPalette);
        }
    }

    private void setActiveTab(WAPropertyTab activeTab) throws RemoteException, MdException, CodegenException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException {
        if (activeTab == this.m_activeTab) {
            return;
        }
        if (this.m_activeTab == this.m_tabCode) {
            this.m_tabCode.moveDataToStore();
        }
        if (this.m_activeTab != null && this.m_bActive) {
            this.m_activeTab.updateWorkspaceUIComponents(false);
        }
        this.m_activeTab = activeTab;
        if (this.m_activeTab == this.m_visualsTab) {
            if (this.m_visualsTab.m_tabContents != null) {
                this.setHelpProduct(this.m_visualsTab.m_tabContents.getHelpProduct());
                this.setHelpTopic(this.m_visualsTab.m_tabContents.getHelpTopic());
            }
        } else {
            this.setHelpProduct(this.m_activeTab.getHelpProduct());
            this.setHelpTopic(this.m_activeTab.getHelpTopic());
        }
        if (this.m_activeTab != null && this.m_bActive) {
            this.m_activeTab.updateWorkspaceUIComponents(true);
        }
        this.updateSaveActions();
        if (activeTab == this.m_tabCode && this.m_mdlRun.getRunState() == 0 && this.m_bCodeNeedsGenerating) {
            this.generateCode();
            this.m_bCodeNeedsGenerating = false;
        }
    }

    private void setActiveVisualsTab(String sTitle, WAPropertyTab tab) {
        this.m_tabsMain.setTitle((Component)((Object)this.m_visualsTab), sTitle);
        this.m_visualsTab.setContents(tab);
        this.setHelpProduct(tab.getHelpProduct());
        this.setHelpTopic(tab.getHelpTopic());
        this.m_tabsMain.setSelectedTab((Component)((Object)this.m_visualsTab));
        this.m_actSettings.setDropMenu(this.createSettingsDropMenu());
    }

    private WAPropertyTab getActiveVisualsTab() {
        return this.m_visualsTab.getContents();
    }

    private void setActivePalette(JComponent palette) {
        if (this.m_activePalette == palette) {
            return;
        }
        this.m_activePalette = palette;
        int yBottom = this.m_spltBottomRight.getDividerLocation();
        int yTop = this.m_spltTopRight.getDividerLocation();
        if (this.m_bPropertiesVisible) {
            this.m_spltBottomRight.setTopComponent(this.m_activePalette);
        } else {
            this.m_spltTopRight.setBottomComponent(this.m_activePalette);
        }
        this.validate();
        this.m_spltTopRight.setDividerLocation(yTop);
        this.m_spltBottomRight.setDividerLocation(yBottom);
    }

    private void setActivePropertiesModel(String sTitle, PropertiesModel mdl) {
        if (!this.m_tblProperties.stopCellEditing()) {
            return;
        }
        this.disposeActivePropertiesModel();
        this.m_pnlProperties.setTitle(bundle.formatString("JoinEditorPanel.Properties.Title.fmt.txt", (Object)sTitle));
        this.m_tblProperties.setPropertiesModel(mdl);
        this.m_tblProperties.scrollRectToVisible(this.m_tblProperties.getCellRect(0, 0, true));
    }

    private void disposeActivePropertiesModel() {
        PropertiesModel mdlProperties = this.m_tblProperties.getPropertiesModel();
        if (mdlProperties instanceof BaseClausePropertiesModel) {
            ((BaseClausePropertiesModel)mdlProperties).dispose();
        } else if (mdlProperties instanceof TablePropertiesModel) {
            ((TablePropertiesModel)mdlProperties).dispose();
        } else if (mdlProperties instanceof TableColumnPropertiesModel) {
            ((TableColumnPropertiesModel)mdlProperties).dispose();
        }
    }

    private WAPropertyTab createVisualTab(IObject object) {
        WAPropertyTab tab = new WAPropertyTab();
        if (object instanceof ISelectResultsContainer) {
            tab = this.createSelectTab((ISelectResultsContainer)object);
        } else if (object instanceof IQuery) {
            tab = this.createQueryTab((IQuery)object);
        } else if (object instanceof IJoin) {
            tab = new ExpressionPanel((ISQLBooleanExpressionContainer)((IJoin)object));
            ((ExpressionPanel)tab).addSQLNavigationListener(this.m_lsnrNavigation);
        } else if (object instanceof IWhere) {
            tab = new ExpressionPanel((ISQLBooleanExpressionContainer)((IWhere)object));
            ((ExpressionPanel)tab).addSQLNavigationListener(this.m_lsnrNavigation);
        } else if (object instanceof IHaving) {
            tab = new ExpressionPanel((ISQLBooleanExpressionContainer)((IHaving)object));
            ((ExpressionPanel)tab).addSQLNavigationListener(this.m_lsnrNavigation);
        } else if (object instanceof IGroupBy) {
            IGroupBy groupBy = (IGroupBy)object;
            tab = new GroupByPanel(groupBy, groupBy.getParentQuery().getSourcesInFrom(), new ITable[]{groupBy.getParentQuery().getTargetTable()});
        } else if (object instanceof IOrderBy) {
            IOrderBy orderBy = (IOrderBy)object;
            tab = new OrderByPanel(orderBy, orderBy.getParentQuery().getSourcesInFrom(), new ITable[]{orderBy.getParentQuery().getTargetTable()});
        } else if (object instanceof ITable) {
            ColumnsTab.Configuration config = new ColumnsTab.Configuration();
            config.setHiddenActions(new int[]{10});
            tab = new ColumnsTab((ITable)object, config);
        }
        tab.setEditable(this.isEditable());
        return tab;
    }

    private WAPropertyTab createQueryTab(IQuery query) {
        this.m_diagramTab = new JoinDiagramTab(this.m_designModel, query);
        this.m_diagramTab.addSelectionChangedListener(this.m_lsnrDiagramSelection);
        this.m_diagramTab.addNavigationListener(this.m_lsnrNavigation);
        this.m_diagramTab.setDeleteAction(this.m_actDelete);
        JToolBar barDiagram = this.m_diagramTab.getDiagramToolBar();
        barDiagram.setBorder(null);
        this.m_toolbar.add(barDiagram);
        return this.m_diagramTab;
    }

    private WAPropertyTab createSelectTab(ISelectResultsContainer select) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setMultipleSourceTablesEnabled(true);
        config.setDragMultipleSourceColumnsEnabled(true);
        config.setUseSQLSyntax(true);
        config.setHiddenColumnsInSourceColumnsTable(new int[0]);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{5, 6});
        config.setHiddenExpressionActions(new int[0]);
        config.setSettingsKeyPrefix("MappingsTab.SQLJoinTransform");
        IQuery parent = select.getParentQuery();
        if (parent instanceof ISubquery) {
            config.setPropagationActionsVisible(1);
            config.setSettingsActionVisible(false);
        }
        MappingsTab tab = new MappingsTab((IMappingsContainer)select, config);
        tab.addSQLNavigationListener(this.m_lsnrNavigation);
        return tab;
    }

    private PropertiesModel getPropertiesModel(Object object) {
        return this.getPropertiesModel(object, null);
    }

    private PropertiesModel getPropertiesModel(Object object, String type) {
        PropertiesModel mdl = this.createPropertiesModel(object, type);
        mdl.setDisplayErrors(false);
        return mdl;
    }

    private PropertiesModel createPropertiesModel(Object object, String type) {
        if (object instanceof ISQLTransform && !CREATE_STATEMENT.equals(type)) {
            return new SQLPropertiesModel((ISQLTransform)object);
        }
        if (object instanceof ISQLCreateStatement) {
            return new CreatePropertiesModel((ISQLCreateStatement)object);
        }
        if (object instanceof ISelectResultsContainer) {
            return new SelectPropertiesModel(((ISelectResultsContainer)object).getParentQuery());
        }
        if (object instanceof IJoin) {
            return new JoinPropertiesModel((IJoin)object);
        }
        if (object instanceof ITable) {
            return this.createTablePropertiesModel((ITable)object);
        }
        if (object instanceof ISQLBooleanExpressionContainer) {
            return new AbstractExpressionPropertiesModel((ISQLBooleanExpressionContainer)object);
        }
        if (object instanceof ISubquery) {
            return new SubqueryPropertiesModel((ISubquery)object);
        }
        if (object instanceof IFromContainer) {
            return new EmptyPropertiesModel();
        }
        if (object instanceof IClause) {
            return new BaseClausePropertiesModel((IClause)object);
        }
        if (object instanceof IColumn) {
            return new ColumnPropertiesModel((IColumn)object);
        }
        throw new UnsupportedOperationException("Invalid type from properties model" + object.getClass());
    }

    private PropertiesModel createTablePropertiesModel(ITable table) {
        TablePropertiesModel mdl = table instanceof ISourceTable ? new SourceTablePropertiesModel((ISourceTable)table) : (table instanceof IPhysicalTable ? new TargetTablePropertiesModel((IPhysicalTable)table, (ITargetTableOptionsContainer)this.m_model.getQuery()) : new TablePropertiesModel(table));
        return mdl;
    }

    private void undo() {
        this.m_mgrUndo.undo();
    }

    private void redo() {
        this.m_mgrUndo.redo();
    }

    private void navigateToNode(IObject object) {
        NavigatorTreeModel.ElementNode node = this.m_mdlNavigator.findNode(object);
        if (node != null) {
            this.m_treeNavigator.setSelectedNode(node);
        }
    }

    private void findInCode(IObject obj) {
        this.m_tabsMain.setSelectedTab((Component)((Object)this.m_tabCode));
        this.m_tabsMain.validate();
        JComponent cmp = (JComponent)this.m_tabCode.getDefaultFocusComponent();
        if (cmp != null) {
            cmp.requestFocusInWindow();
        }
        this.m_tabCode.getCodePane().setSelectedModelObject(obj);
    }

    private void setPropertiesVisible(boolean bVisible) {
        if (this.m_bPropertiesVisible == bVisible) {
            return;
        }
        this.m_bPropertiesVisible = bVisible;
        this.m_actShowPropertiesPane.setSelected(bVisible);
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean("JoinEditorPanel.PropertiesVisible", bVisible);
        if (bVisible) {
            int yOuter = this.m_spltTopRight.getDividerLocation();
            this.m_spltBottomRight.setTopComponent(this.m_activePalette);
            this.m_spltTopRight.setBottomComponent(this.m_spltBottomRight);
            this.m_spltTopRight.setDividerLocation(yOuter);
            this.m_spltBottomRight.setDividerLocation(this.m_spltBottomRight.getDividerLocation());
        } else {
            int y = this.m_spltTopRight.getDividerLocation();
            this.m_spltTopRight.setBottomComponent(this.m_activePalette);
            this.m_spltTopRight.setDividerLocation(y);
        }
    }

    private void showPropertiesDialog() {
        IObject obj = (IObject)this.getSelectedObject();
        IAliasTable table = null;
        if (obj == null || obj instanceof IQuery) {
            obj = this.m_model;
        } else if (obj instanceof IAliasTable) {
            if (((IAliasTable)obj).getAliasedTable() != null) {
                table = (IAliasTable)obj;
                obj = ((IAliasTable)obj).getAliasedTable();
            } else {
                return;
            }
        }
        IDiagramNodeAdapter adapter = null;
        WAPropertyTab tab = this.getActiveVisualsTab();
        if (tab instanceof JoinDiagramTab) {
            IObject object = obj;
            if (table != null) {
                object = table;
            }
            adapter = this.m_diagramTab.getDiagramPanel().getDiagramModel().getAdapter(object);
        } else {
            adapter = DiagramNodeAdapterFactory.getInstance().createAdapter(obj);
        }
        if (adapter == null) {
            adapter = DiagramNodeAdapterFactory.getInstance().createAdapter(obj);
        }
        adapter.showPropertiesDialog((Window)Workspace.getWorkspace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        block32: {
            IModel jobModel = this.m_model.getModel();
            jobModel.startCompoundUndoable();
            try {
                Object object = this.getSelectedObject();
                if (object instanceof IClause) {
                    IQuery query = ((IClause)object).getParentQuery();
                    if (object instanceof IWhere && query.hasImplicitJoin() && ((IWhere)object).getBooleanExpressionsList().size() > 0) {
                        String sTitle = bundle.getString("ActionFactory.Action.Delete.txt");
                        String sMessage = bundle.getString("ActionFactory.Warning.DeleteWhereWithImplicitJoin.txt");
                        int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)2);
                        if (eAnswer != 0) {
                            return;
                        }
                        query.removeClause((IClause)object);
                    } else if (object instanceof IJoin) {
                        IJoin join = (IJoin)object;
                        ISQLSource srcLeft = join.getLeftSide();
                        ISQLSource srcRight = join.getRightSide();
                        if (srcLeft != null) {
                            join.setLeftSide(null);
                        }
                        if (srcRight != null) {
                            join.setRightSide(null);
                        }
                        query.removeClause((IClause)object);
                    } else if (object instanceof ISubquery) {
                        IClause parent = ((ISubquery)object).getParent();
                        if (parent != null) {
                            ((ISubquery)object).setParent(null);
                            query.removeInlineSubquery((ISubquery)object);
                        } else if (query.getInlineSubqueryList().contains(object)) {
                            query.removeInlineSubquery((ISubquery)object);
                        } else {
                            IQuery parentQuery = ((ISubquery)object).getParentQuery();
                            parentQuery.removeSubqueryFromExpression((ISubquery)object);
                            query.removeClause((IClause)object);
                        }
                    } else {
                        query.removeClause((IClause)object);
                    }
                    break block32;
                }
                if (object instanceof ISourceTable) {
                    ColumnsTab columnsTab;
                    IQuery query;
                    IClause parent = ((ISourceTable)object).getParent();
                    if (parent == null) {
                        query = this.m_model.getQuery();
                        List lSources = query.getQuerySourceTableList();
                        if (lSources.contains(object)) {
                            query.removeQuerySourceTable((ISourceTable)object);
                        } else {
                            List lSubqueries = query.getSubqueryList();
                            for (int index = 0; index < lSubqueries.size(); ++index) {
                                IQuery subQuery = (IQuery)lSubqueries.get(index);
                                List lSubSources = subQuery.getQuerySourceTableList();
                                if (!lSubSources.contains(object)) continue;
                                subQuery.removeQuerySourceTable((ISourceTable)object);
                                break;
                            }
                        }
                    } else {
                        query = null;
                        query = parent instanceof IQuery ? (IQuery)parent : parent.getParentQuery();
                        if (query != null) {
                            query.removeQuerySourceTable((ISourceTable)object);
                        }
                    }
                    if (this.getActiveVisualsTab() instanceof ColumnsTab && (columnsTab = (ColumnsTab)this.getActiveVisualsTab()).getTableModel().getTable() == object) {
                        this.setActiveObject((IObject)this.m_model, "");
                    }
                    break block32;
                }
                if (object instanceof IDiagramStickyNote) {
                    this.m_diagramTab.getDiagramPanel().getDiagramModel().removePrimitive((PFDPrimitive)object);
                } else if (object instanceof IDiagramLink) {
                    IDiagramLink link = (IDiagramLink)object;
                    IDiagramNode nodeTo = (IDiagramNode)link.getToNode();
                    IDiagramNode nodeFrom = (IDiagramNode)link.getFromNode();
                    if (nodeTo.getObject() instanceof IPhysicalTable) {
                        return;
                    }
                    IObject target = nodeTo.getObject();
                    IObject source = nodeFrom.getObject();
                    if (target instanceof IJoin || target instanceof ISelectResultsContainer) {
                        this.m_diagramTab.getDiagramPanel().getDiagramModel().removeLink(link);
                        ((ISQLSource)source).setParent(null);
                    }
                }
            }
            finally {
                jobModel.endCompoundUndoable();
            }
        }
    }

    private void setIgnoreSelectionEvents(boolean bIgnoreSelectionEvents) {
        this.m_bIgnoreSelectionEvents = bIgnoreSelectionEvents;
    }

    private boolean ignoreSelectionEvents() {
        return this.m_bIgnoreSelectionEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubqueryNode(ClauseType clauseType) {
        IModel jobModel = this.m_model.getModel();
        jobModel.startCompoundUndoable();
        try {
            WAPropertyTab tab = this.getActiveVisualsTab();
            if (!(tab instanceof JoinDiagramTab)) {
                return;
            }
            JoinDiagramModel diagramModel = (JoinDiagramModel)this.m_diagramTab.getDiagramPanel().getPFDModel();
            IDiagramNode node = diagramModel.addNodeAtPosition(clauseType, new Point(0, 0));
            Object object = this.getSelectedDiagramObject();
            if (!(object instanceof IJoin)) {
                return;
            }
            IJoin join = (IJoin)object;
            if (join.getLeftSide() == null) {
                join.setLeftSide((ISQLSource)node.getAdapter().getObject());
            } else if (join.getRightSide() == null) {
                join.setRightSide((ISQLSource)node.getAdapter().getObject());
            }
        }
        finally {
            jobModel.endCompoundUndoable();
        }
    }

    @Override
    public WsAppServer getSASAppServer() {
        return this.m_designModel.getSASAppServer();
    }

    private void setSASAppServer(WsAppServer server) {
        this.m_designModel.setSASAppServer(server);
        if (this.m_mdlRun != null) {
            this.m_mdlRun.setSASAppServer(server);
        }
    }

    private boolean verifySASAppServerSelected() {
        WsAppServer appServer = this.getSASAppServer();
        try {
            IServer server = ModelUIUtilities.getServerForAppServer(this.m_model.getModel(), appServer);
            IServer stepServer = this.m_model.getServerForStep(server);
            if (stepServer == null) {
                this.setSASAppServer(WsAppServer.createDefaultAppServer());
            }
            if (server != stepServer) {
                this.setSASAppServer(WsAppServer.createAppServer((String)stepServer.getID()));
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        return this.getSASAppServer() != null;
    }

    private boolean saveAllTabs() {
        boolean bReturn = true;
        if (this.m_tabCode.hasDataChanged()) {
            bReturn = this.m_tabCode.save();
            if (bReturn) {
                bReturn = this.m_diagramTab.save();
            }
        } else if (this.m_mgrUndo.canUndo()) {
            bReturn = this.m_diagramTab.save();
        }
        return bReturn;
    }

    private boolean verifySASAppServerReadyForRunningCode() {
        if (!this.verifySASAppServerSelected()) {
            return false;
        }
        if (!this.getSASAppServer().isSASCodeSessionOpen()) {
            try {
                this.getSASAppServer().openSASCodeSession();
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                return false;
            }
        }
        return true;
    }

    private void runSQL(boolean bValidate) throws RemoteException, MdException, ServerException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        if (!this.m_tabCode.validateData()) {
            return;
        }
        try {
            this.m_tabCode.moveDataToStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        if (this.m_bCodeNeedsGenerating) {
            this.generateCode();
            this.m_bCodeNeedsGenerating = false;
        }
        if (!this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        ICodeGenerationEnvironment environment = CodeGenerationEnvironmentFactory.getInstance().createCodeGenerationEnvironment(this.m_model.getJob(), ModelUIUtilities.getServerForAppServer((IModel)this.m_designModel, this.getSASAppServer()));
        environment.setGenerateRCSetCalls(false);
        environment.setRunStatisticsEnabled(false);
        environment.setRunTableStatisticsEnabled(false);
        ICodeSegment codeSegment = environment.createNewCodeSegment((IObject)this.m_model);
        if (this.m_model.isComplete()) {
            this.m_model.getGeneratedDefaultParameterCode(codeSegment);
            this.m_model.getTransformSetup(codeSegment, false, bValidate);
            this.m_model.getGeneratedCode(codeSegment, bValidate);
        } else {
            List inc = this.m_model.getReasonsIncomplete();
            for (int i = 0; i < inc.size(); ++i) {
                codeSegment.addCommentLine(inc.get(i).toString());
            }
            codeSegment.addSourceCode("\n");
        }
        this.m_mdlRun.setCodeSegments(new ICodeSegment[]{codeSegment});
        this.m_mdlRun.run();
        if (bValidate) {
            this.m_tabsMain.setSelectedTab((Component)((Object)this.m_tabLog));
            CodeEditorPane pane = this.m_tabLog.getEditorPane();
            int len = pane.getText().length();
            if (len > 0) {
                pane.setCaretPosition(pane.getText().length() - 1);
            }
        }
    }

    private void runTo(ITransform xfm) throws MdException, RemoteException, ServerException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        int index;
        if (this.m_mdlRun.getRunState() == 0 && !this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        ITransform[] allTransforms = this.m_model.getJob().getControlOrderedTransformsAndOthers();
        List<ITransform> transforms = Arrays.asList(allTransforms);
        List<ITransform> txfms = transforms.subList(0, (index = transforms.indexOf(xfm)) + 1);
        ICodeSegment[] aSegments = this.generateCodeSegments(txfms.toArray(new ITransform[txfms.size()]));
        if (aSegments != null && aSegments.length > 0) {
            this.m_mdlRun.setCodeSegments(aSegments);
            this.m_mdlRun.run();
            return;
        }
        throw new IllegalStateException("Unable to run from transformation because the transformation was not found in the code.");
    }

    private ICodeSegment[] generateCodeSegments(ITransform[] transforms) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException, CodegenException {
        IJob job = this.m_model.getJob();
        if (this.m_designModel.isEditable()) {
            job.addAllUnorderedTransformsToControlOrder();
        }
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        ICodeGenerationEnvironment environment = factory.createCodeGenerationEnvironment(job, ModelUIUtilities.getServerForAppServer((IModel)this.m_designModel, this.getSASAppServer()));
        ArrayList<Object> gSegments = new ArrayList<Object>();
        if (transforms != null && transforms.length > 0) {
            ITransform first;
            ITransform[] jobTransforms = job.getControlOrderedTransformsAndOthers();
            if (jobTransforms[0] == (first = transforms[0])) {
                gSegments.add(job.getPreJobCode(environment));
            }
            ICodeSegment[] segments = job.getTransformCodeSegments(environment, transforms);
            for (int i = 0; i < segments.length; ++i) {
                gSegments.add(segments[i]);
            }
        } else {
            gSegments.add(job.getCodeSegments(environment));
        }
        return gSegments.toArray(new ICodeSegment[gSegments.size()]);
    }

    private void generateCode() throws RemoteException, MdException, ServerException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        Workspace.getDefaultLogger().debug((Object)"Generating code");
        if (!this.verifySASAppServerSelected()) {
            return;
        }
        this.m_tabCode.updateView();
        Workspace.getDefaultLogger().debug((Object)"Code generated");
    }

    private void stopSQL() {
        this.m_mdlRun.stop();
    }

    private class JoinModelListener
    implements IModelListener {
        private JoinModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String eventType = event.getType();
            if (eventType.equalsIgnoreCase("SQLObject:QueryTableAdded") || eventType.equalsIgnoreCase("SQLObject:QueryTableRemoved") || eventType.equalsIgnoreCase("SQL:ClauseAdded") || eventType.equalsIgnoreCase("SQL:ClauseRemoved") || eventType.equalsIgnoreCase("Join:LeftSideChanged") || eventType.equalsIgnoreCase("Join:RightSideChanged") || eventType.equalsIgnoreCase("SQLFrom:SourceOfFromChanged") || eventType.equalsIgnoreCase("SQLAlias:AliasChanged") || eventType.equalsIgnoreCase("BooleanExpression.SubqueryRemoved") || eventType.equalsIgnoreCase("SelectResultsContainer:SubqueryRemovedFromMapping")) {
                Object obj;
                if (JoinEditorPanel.this.m_mdlNavigator != null) {
                    JoinEditorPanel.this.m_mdlNavigator.populate();
                    JoinEditorPanel.this.m_treeNavigator.expand();
                }
                if (eventType.equalsIgnoreCase("SQL:ClauseRemoved") && (obj = event.getData()) == JoinEditorPanel.this.m_activeObject) {
                    JoinEditorPanel.this.setActiveObject((IObject)JoinEditorPanel.this.m_model, "");
                    JoinEditorPanel.this.m_treeNavigator.setSelectedNode((AbstractTreeNode)JoinEditorPanel.this.m_mdlNavigator.getRoot());
                }
            }
            JoinEditorPanel.this.m_bCodeNeedsGenerating = true;
            if (JoinEditorPanel.this.m_model == event.getModelObject() && "IUserWrittenCode:activeChanged".equals(event.getType())) {
                JoinEditorPanel.this.m_actGenerateCode.setEnabled(!JoinEditorPanel.this.m_model.isUsingUserWrittenCode());
            }
            JoinEditorPanel.this.updateActions();
        }
    }

    private class RunSQLModelListener
    implements RunModelListener {
        private RunSQLModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
            String sType = ev.getType();
            if (sType == "RunStateChanged") {
                JoinEditorPanel.this.updateActions();
            }
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            String sType = ev.getType();
            if (sType == "RunStarted") {
                JoinEditorPanel.this.m_designModel.setEditable(false);
                if (JobEditorPanel.isUserPreferenceToClearLogAndOutput()) {
                    JoinEditorPanel.this.m_tabLog.clear();
                }
            } else if (sType != "SegmentStarted") {
                WsAppServerFailException ex;
                if (sType == "SegmentCompleted") {
                    JoinEditorPanel.this.m_tabLog.appendResults(ev.getResults());
                } else if ((sType == "RunAborted" || sType == "RunCompleted" || sType == "RunStopped") && sType == "RunAborted" && (ex = ev.getException()) != null) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    Workspace.getDefaultLogger().error((Object)"Run aborted", (Throwable)ex);
                }
            }
        }
    }

    private class NavigateToListener
    implements INavigationListener {
        private NavigateToListener() {
        }

        @Override
        public void navigationChanged(NavigationEvent ev) {
            IObject object = ev.getModelObject();
            if (object != null) {
                JoinEditorPanel.this.m_mdlNavigator.populate();
                JoinEditorPanel.this.navigateToNode(object);
                JoinEditorPanel.this.m_treeNavigator.expand();
            }
        }
    }

    private class DiagramSelectionListener
    implements WsSelectionChangedListener {
        private DiagramSelectionListener() {
        }

        public void selectionChanged(WsSelectionChangedEvent ev) {
            Object object;
            Object source = ev.getSource();
            Object[] aObjects = ((WsSelectionProvider)source).getSelectedObjects();
            Object object2 = object = aObjects.length == 1 ? aObjects[0] : null;
            if (object instanceof IObject) {
                JoinEditorPanel.this.setActivePropertiesModel(((IObject)object).getName(), JoinEditorPanel.this.getPropertiesModel(object));
            }
            JoinEditorPanel.this.setSelectedDiagramObject(object);
        }
    }

    private class RunToSelectedTransformation
    extends WsAbstractAction {
        public RunToSelectedTransformation() {
            super(bundle, "JoinEditorPanel.RunToSelectedTransformation", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Debug:RunToSelectedTransformation"));
            this.setMenuSupportId("Debug:RunToSelectedTransformation");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JoinEditorPanel.this.runTo((ITransform)JoinEditorPanel.this.m_model);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class RunAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RunAction() {
            super(bundle, "JoinEditorPanel.Action.Run", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Run"));
            this.setMenuSupportId("Common:Run");
        }

        public void actionPerformed(ActionEvent event) {
            try {
                JoinEditorPanel.this.runSQL(false);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (CodegenException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JoinEditorPanel.this.isContextForMainSQL(context);
        }
    }

    private class StopAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public StopAction() {
            super(bundle, "JoinEditorPanel.Action.Stop", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Stop"));
            this.setMenuSupportId("Common:Stop");
        }

        public void actionPerformed(ActionEvent e) {
            int stopPrompt = MessageUtil.displayMessage((String)bundle.getString("JoinEditorPanel.StopAction.prompt.txt"), (String)bundle.formatString("JoinEditorPanel.StopAction.prompt.title.fmt", (Object)JoinEditorPanel.this.m_model.getName()), (int)3, (int)0);
            if (stopPrompt == 0) {
                JoinEditorPanel.this.stopSQL();
                WsAppServer server = JoinEditorPanel.this.m_designModel.getSASAppServer();
                if (server != null) {
                    server.dispose();
                    Object var3_3 = null;
                }
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JoinEditorPanel.this.isContextForMainSQL(context);
        }
    }

    private class ValidateAction
    extends WsAbstractAction {
        public ValidateAction() {
            super(bundle, "JoinActionsManager.Action.ActionsValidate", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Validate"));
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                JoinEditorPanel.this.runSQL(true);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (CodegenException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class GenerateCodeAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public GenerateCodeAction() {
            super(bundle, "JoinEditorPanel.Action.GenerateCode", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:GenerateCode"));
            this.setMenuSupportId("Actions:GenerateCode");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.m_bCodeNeedsGenerating = true;
            if (JobEditorPanel.isUserPreferenceToShowCode()) {
                JoinEditorPanel.this.m_tabsMain.setSelectedTab((Component)((Object)JoinEditorPanel.this.m_tabCode));
            }
            if (JoinEditorPanel.this.m_bCodeNeedsGenerating) {
                try {
                    JoinEditorPanel.this.generateCode();
                    JoinEditorPanel.this.m_bCodeNeedsGenerating = false;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (CodegenException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage());
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                catch (BadServerDefinitionException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                catch (ServerException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JoinEditorPanel.this.isContextForMainSQL(context);
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setEnabled(false);
            this.setMenuSupportId("Common:Undo");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.undo();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setEnabled(false);
            this.setMenuSupportId("Common:Redo");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.redo();
        }
    }

    private class PropertiesAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public PropertiesAction() {
            super(bundle, "JoinEditorPanel.Action.Properties", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Properties"));
            this.setMenuSupportId("Edit:Properties");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.showPropertiesDialog();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (aObjects[iObject] instanceof SimpleObject) continue;
                return false;
            }
            return true;
        }
    }

    private class DeleteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public DeleteAction() {
            super(bundle, "JoinEditorPanel.Action.Delete", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Delete"));
            this.setMenuSupportId("Common:Delete");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.delete();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            return JoinEditorPanel.this.isDeleteValid();
        }
    }

    private class FindInCodeAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FindInCodeAction() {
            this.setMenuSupportId("Edit:FindIn:Code");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.findInCode((IObject)JoinEditorPanel.this.getSelectedObject());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            return aObjects.length == 1 && aObjects[0] instanceof IClause && aObjects[0] != JoinEditorPanel.this.m_model && aObjects[0] != JoinEditorPanel.this.m_model.getQuery();
        }
    }

    private class RunAutoJoinAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RunAutoJoinAction() {
            super(bundle, "JoinEditorPanel.Action.RunAutoJoin", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("AutoJoin"));
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.m_model.getModel().startCompoundUndoable();
            try {
                IJoin join = (IJoin)JoinEditorPanel.this.getSelectedObject();
                join.runAutoJoinAction();
            }
            finally {
                JoinEditorPanel.this.m_model.getModel().endCompoundUndoable();
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (aObjects[iObject] instanceof IJoin) continue;
                return false;
            }
            return true;
        }
    }

    private class CreateAsViewAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public CreateAsViewAction() {
            this.setMenuSupportId("Context:CreateAsView");
        }

        public void actionPerformed(ActionEvent ev) {
            IWorkTable table = (IWorkTable)JoinEditorPanel.this.getSelectedObject();
            table.setView(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JoinEditorPanel.this.isContextForType(context, "WorkTable");
        }
    }

    private class DefaultPaletteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private DefaultPaletteAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            Object object = ev.getSource();
            JoinEditorPanel.this.m_model.getModel().startCompoundUndoable();
            try {
                if (object instanceof JoinPaletteTree) {
                    JoinPaletteTree tree = (JoinPaletteTree)((Object)object);
                    IDataTreeNode node = tree.getSelectedDataNode();
                    if (!(JoinEditorPanel.this.m_activeObject instanceof IQuery)) {
                        return;
                    }
                    IQuery query = (IQuery)JoinEditorPanel.this.m_activeObject;
                    Object source = JoinEditorPanel.this.getSelectedDiagramObject();
                    if (node != null) {
                        Object data = node.getData();
                        if (data instanceof ClauseType) {
                            ClauseType type = (ClauseType)data;
                            if (type == ClauseType.SUBQUERY) {
                                JoinEditorPanel.this.addSubqueryNode(type);
                            } else {
                                IClause clause = query.addClause(type);
                                if (clause != null) {
                                    JoinEditorPanel.this.m_diagramTab.selectClause(clause);
                                }
                            }
                        } else if (data instanceof JoinType) {
                            String type = ((JoinType)data).getJoinType();
                            IJoin join = null;
                            join = source instanceof IJoin ? query.createAndInsertAJoinInFrom(type, (ISQLSource)source) : (source instanceof ISelectResultsContainer || source == null || source == JoinEditorPanel.this.m_model ? query.createAndInsertAJoinInFrom(type, query.getSourceOfFrom()) : (source instanceof ISQLSource ? query.createAndInsertAJoinInFrom(type, (ISQLSource)source) : query.createAJoin(null, null, "Inner")));
                            if (join != null) {
                                JoinEditorPanel.this.m_diagramTab.selectClause((IClause)join);
                            }
                        }
                    }
                }
            }
            finally {
                JoinEditorPanel.this.m_model.getModel().endCompoundUndoable();
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (aObjects[iObject] instanceof IDataTreeNode) continue;
                return false;
            }
            return true;
        }
    }

    private class SettingsAction
    extends WsDropMenuAction {
        public SettingsAction() {
            super(bundle, "JoinEditorPanel.Action.Settings", 272);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("OptionsDropMenu"));
        }
    }

    private class ShowPropertiesAction
    extends WsAbstractToggleAction {
        public ShowPropertiesAction() {
            super(bundle, "JoinEditorPanel.Action.ShowPropertiesPane", 257);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Properties"));
        }

        public void actionPerformed(ActionEvent ev) {
            JoinEditorPanel.this.setPropertiesVisible(this.isSelected());
        }
    }

    private class SaveAsLocalAction
    extends WsAbstractAction {
        public SaveAsLocalAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:SaveAs:Local");
        }

        public void actionPerformed(ActionEvent ev) {
            if (JoinEditorPanel.this.m_activeTab == JoinEditorPanel.this.m_tabCode) {
                JoinEditorPanel.this.m_tabCode.getCodePane().saveAsLocal();
            } else if (JoinEditorPanel.this.m_activeTab == JoinEditorPanel.this.m_tabLog) {
                ((JobLogTab)JoinEditorPanel.this.m_activeTab).saveAs();
            } else {
                throw new UnsupportedOperationException("save as - local is not supported for the active tab: " + JoinEditorPanel.this.m_activeTab.getName());
            }
        }
    }

    private class SaveAsRemoteAction
    extends WsAbstractAction {
        public SaveAsRemoteAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:SaveAs:Remote");
        }

        public void actionPerformed(ActionEvent ev) {
            if (JoinEditorPanel.this.m_activeTab == JoinEditorPanel.this.m_tabCode) {
                if (JoinEditorPanel.this.m_tabCode.getCodePane().saveAs()) {
                    JoinEditorPanel.this.saveAllTabs();
                }
            } else {
                throw new UnsupportedOperationException("save as - remote is not supported for the active tab: " + JoinEditorPanel.this.m_activeTab.getName());
            }
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            boolean bChanged;
            boolean bl = bChanged = JoinEditorPanel.this.m_mgrUndo.canUndo() || JoinEditorPanel.this.m_tabCode.hasDataChanged();
            if (JoinEditorPanel.this.m_activeTab != null && JoinEditorPanel.this.m_activeTab != JoinEditorPanel.this.m_tabCode) {
                JoinEditorPanel.this.m_activeTab.setDataChanged(JoinEditorPanel.this.m_mgrUndo.canUndo());
            }
            JoinEditorPanel.this.setDataChanged(bChanged);
            JoinEditorPanel.this.m_actUndo.setEnabled(JoinEditorPanel.this.m_mgrUndo.canUndo());
            JoinEditorPanel.this.m_actRedo.setEnabled(JoinEditorPanel.this.m_mgrUndo.canRedo());
        }
    }

    private class TabSelectionListener
    implements ChangeListener {
        private TabSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            try {
                JoinEditorPanel.this.setActiveTab((WAPropertyTab)JoinEditorPanel.this.m_tabsMain.getSelectedTab());
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (CodegenException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class NavigatorSelectionListener
    implements TreeSelectionListener {
        private NavigatorSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            if (JoinEditorPanel.this.ignoreSelectionEvents()) {
                return;
            }
            try {
                IObject oElement;
                JoinEditorPanel.this.setIgnoreSelectionEvents(true);
                IDataTreeNode node = (IDataTreeNode)JoinEditorPanel.this.m_treeNavigator.getSelectedNode();
                if (node == null) {
                    JoinEditorPanel.this.setSelectedNavigatorObject(null);
                    return;
                }
                if (((JoinEditorPanel)JoinEditorPanel.this).m_visualsTab.m_tabContents instanceof JoinDiagramTab) {
                    JoinEditorPanel.this.m_diagramTab.getDiagramPanel().clearSelections();
                }
                if ((oElement = (IObject)node.getData()) instanceof IClause) {
                    String type = oElement instanceof ISQLCreateStatement && node != JoinEditorPanel.this.m_treeNavigator.getModel().getRoot() ? JoinEditorPanel.CREATE_STATEMENT : null;
                    String sName = node.getName();
                    JoinEditorPanel.this.setActiveObject(oElement, sName);
                    JoinEditorPanel.this.setActivePropertiesModel(sName, JoinEditorPanel.this.getPropertiesModel(oElement, type));
                } else if (oElement instanceof ITable) {
                    JoinEditorPanel.this.setActiveObject(oElement, node.getName());
                    JoinEditorPanel.this.setActivePropertiesModel(node.getName(), JoinEditorPanel.this.getPropertiesModel(oElement));
                } else if (node == JoinEditorPanel.this.m_treeNavigator.getModel().getRoot()) {
                    JoinEditorPanel.this.setActiveObject((IObject)JoinEditorPanel.this.m_model.getQuery(), "");
                    JoinEditorPanel.this.setActivePropertiesModel(JoinEditorPanel.this.m_model.getName(), JoinEditorPanel.this.getPropertiesModel(JoinEditorPanel.this.m_model));
                }
                JoinEditorPanel.this.m_treeNavigator.setSelectedNode((AbstractTreeNode)node);
                JoinEditorPanel.this.setSelectedNavigatorObject(oElement);
            }
            finally {
                JoinEditorPanel.this.setIgnoreSelectionEvents(false);
            }
        }
    }

    private class ActivationListener
    implements PropertyChangeListener {
        private ActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            JoinEditorPanel.this.m_bNavigatorActive = JoinEditorPanel.this.m_pnlNavigator.isActive();
            if (JoinEditorPanel.this.m_bNavigatorActive) {
                JoinEditorPanel.this.setSelectedObject(JoinEditorPanel.this.getSelectedNavigatorObject());
            } else if (JoinEditorPanel.this.getSelectedDiagramObject() != null) {
                JoinEditorPanel.this.setSelectedObject(JoinEditorPanel.this.getSelectedDiagramObject());
            }
        }
    }

    private class TablesTreeSelectionListener
    implements WsSelectionChangedListener {
        private TablesTreeSelectionListener() {
        }

        public void selectionChanged(WsSelectionChangedEvent event) {
            Object object;
            WsSelectionProvider selectionProvider = (WsSelectionProvider)event.getSource();
            Object[] selectedObjects = selectionProvider.getSelectedObjects();
            Object object2 = object = selectedObjects.length == 1 ? selectedObjects[0] : null;
            if (object instanceof IObject) {
                JoinEditorPanel.this.setActivePropertiesModel(((IObject)object).getName(), JoinEditorPanel.this.getPropertiesModel(object));
            }
        }
    }

    private class ClosePropertiesActionListener
    implements ActionListener {
        private ClosePropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JoinEditorPanel.this.setPropertiesVisible(false);
        }
    }
}

