/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.JoinType;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.metadata.remote.CMetadata;
import com.sas.wadmin.jobeditor.diagram.WADiagramModel;
import com.sas.wadmin.jobeditor.diagram.WADiagramPanel;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramPersistable;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.IPersistableShape;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import com.sas.wadmin.transforms.sql.editor.JoinDiagramModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public class JoinDiagramPanel
extends WADiagramPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(JoinDiagramPanel.class);
    private PFDViewListener m_diagramListener = new DiagramListener();
    private JoinDiagramModel m_joinDiagramModel;

    public JoinDiagramPanel(JoinDiagramModel joinDiagramModel) {
        super(joinDiagramModel);
        this.m_joinDiagramModel = joinDiagramModel;
        this.addPFDViewListener(this.m_diagramListener);
        this.m_joinDiagramModel.addPFDModelListener(new DiagramModelListener());
    }

    @Override
    public boolean isDropValid(Point location, List objects) {
        for (int index = 0; index < objects.size(); ++index) {
            String type;
            Object object = objects.get(index);
            if (object instanceof CMetadata) {
                try {
                    type = ((CMetadata)object).getCMetadataType();
                    if (!type.equals("PhysicalTable")) continue;
                    return true;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                    return false;
                }
            }
            if (object instanceof SimpleObject) {
                type = ((SimpleObject)object).getPublicType();
                if (!type.equals("Table")) continue;
                return true;
            }
            if (object instanceof ClauseType) {
                ClauseType clause = (ClauseType)object;
                if (clause.equals(ClauseType.WHERE) || clause.equals(ClauseType.HAVING) || clause.equals(ClauseType.GROUPBY) || clause.equals(ClauseType.ORDERBY)) {
                    return !this.m_joinDiagramModel.contains(clause);
                }
                return true;
            }
            if (!(object instanceof JoinType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean drop(Point position, List objects) {
        for (int index = 0; index < objects.size(); ++index) {
            Object object = objects.get(index);
            ((JoinDiagramModel)this.getDiagramModel()).addNodeAtPosition(object, position);
        }
        return true;
    }

    @Override
    public void setNodesLocation(IPersistableShape[] aNodes) {
        WADiagramModel mdl = this.getDiagramModel();
        IModel jobMdl = mdl.getObjectModel();
        if (jobMdl != null && mdl != null) {
            jobMdl.startCompoundUndoable();
            for (int iNode = 0; iNode < aNodes.length; ++iNode) {
                IPersistableShape node = aNodes[iNode];
                if (node == null) continue;
                Point oldLocation = this.getDragNodeLocation(node.getId());
                Point newLocation = node.getSpotLocation(1, null);
                mdl.setLocation(node, oldLocation, newLocation);
                this.getDragNodeMap().remove(node.getId());
            }
            jobMdl.endCompoundUndoable();
        }
    }

    @Override
    public void saveNodesLocation(IPersistableShape[] aNodes) {
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            IPersistableShape node = aNodes[iNode];
            if (node == null) continue;
            this.getDragNodeMap().put(node.getId(), node.getSpotLocation(1, null));
        }
    }

    @Override
    protected boolean save() {
        if (this.m_joinDiagramModel == null) {
            return false;
        }
        return this.m_joinDiagramModel.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        JoinDiagramModel mdl = (JoinDiagramModel)this.getDiagramModel();
        IModel jobModel = mdl.getObjectModel();
        jobModel.startCompoundUndoable();
        try {
            PFDPrimitive prim;
            int iPrimitive;
            PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
            this.setHoldDisplay(true);
            for (iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                prim = aSelectedPrimitives[iPrimitive];
                if (!(prim instanceof PFDLink)) continue;
                IDiagramNode toNode = (IDiagramNode)((PFDLink)prim).getToNode();
                IDiagramNode fromNode = (IDiagramNode)((PFDLink)prim).getFromNode();
                if (toNode instanceof IWorkTableNode) break;
                IObject object = toNode.getObject();
                IObject source = fromNode.getObject();
                if (!(object instanceof IJoin) && !(object instanceof ISelectResultsContainer)) continue;
                mdl.removeLink((IDiagramLink)prim);
                ((ISQLSource)source).setParent(null);
                ISourceTable[] sources = ((ISQLSource)source).getSQLSourceTables();
                for (int index = 0; index < sources.length; ++index) {
                    mdl.getQuery().getTransformModel().removeDataSource((IDataObject)sources[index].getAliasedTable());
                }
            }
            for (iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                prim = aSelectedPrimitives[iPrimitive];
                IQuery query = this.m_joinDiagramModel.getQuery();
                if (prim instanceof IDiagramNode) {
                    IObject obj = ((IDiagramNode)prim).getObject();
                    if (obj != null && obj instanceof IClause) {
                        if (obj instanceof IWhere && query.hasImplicitJoin() && ((IWhere)obj).getBooleanExpressionsList().size() > 0) {
                            String sTitle = bundle.getString("ActionFactory.Action.Delete.txt");
                            String sMessage = bundle.getString("ActionFactory.Warning.DeleteWhereWithImplicitJoin.txt");
                            int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)2);
                            if (eAnswer != 0) {
                                return;
                            }
                        } else if (obj instanceof IJoin) {
                            IJoin join = (IJoin)obj;
                            ISQLSource srcLeft = join.getLeftSide();
                            ISQLSource srcRight = join.getRightSide();
                            if (srcLeft != null) {
                                join.setLeftSide(null);
                            }
                            if (srcRight != null) {
                                join.setRightSide(null);
                            }
                        } else if (obj instanceof ISubquery) {
                            IClause parent = ((ISubquery)obj).getParent();
                            if (parent != null) {
                                ((ISubquery)obj).setParent(null);
                                query.removeInlineSubquery((ISubquery)obj);
                            } else {
                                IQuery parentQuery = ((ISubquery)obj).getParentQuery();
                                parentQuery.removeSubqueryFromExpression((ISubquery)obj);
                            }
                        }
                        query.removeClause((IClause)obj);
                        continue;
                    }
                    if (!(obj instanceof ISourceTable)) continue;
                    query.removeQuerySourceTable((ISourceTable)obj);
                    continue;
                }
                if (!(prim instanceof IDiagramStickyNote)) continue;
                mdl.removePrimitive(prim);
            }
            this.clearSelections();
            this.setHoldDisplay(false);
        }
        finally {
            jobModel.endCompoundUndoable();
        }
    }

    public boolean isDeleteValid() {
        boolean valid = true;
        PFDPrimitive[] prims = this.getSelectedPrimitives();
        for (int i = 0; i < prims.length; ++i) {
            PFDPrimitive prim = prims[i];
            if (prim instanceof IDiagramLink) {
                IDiagramLink link = (IDiagramLink)prim;
                IDiagramNode fromNode = (IDiagramNode)link.getFromNode();
                IDiagramNode toNode = (IDiagramNode)link.getToNode();
                if (fromNode == null || toNode == null) continue;
                if (JoinDiagramModel.isFixedClause(fromNode.getObject()) && JoinDiagramModel.isFixedClause(toNode.getObject())) {
                    return false;
                }
                if (toNode.getObject() != this.m_joinDiagramModel.getQuery().getTargetTable()) continue;
                return false;
            }
            if (!(prim instanceof IDiagramNode)) continue;
            IDiagramNode node = (IDiagramNode)prim;
            IObject obj = node.getObject();
            if (this.m_joinDiagramModel.getQuery().getTargetTable() == obj) {
                return false;
            }
            if (!(obj instanceof ISelectResultsContainer)) continue;
            return false;
        }
        return valid;
    }

    private class DiagramListener
    implements PFDViewListener {
        private DiagramListener() {
        }

        public void viewChanged(PFDViewEvent event) {
            switch (event.getType()) {
                case 9: {
                    this.onLinkAdded(event);
                    break;
                }
                case 10: {
                    this.onLinkRedirected(event);
                    break;
                }
                case 8: {
                    this.onPrimitiveDeleted(event);
                    break;
                }
                case 1: {
                    this.onDragStarted(event);
                    break;
                }
                case 2: {
                    this.onDragEnded(event);
                    break;
                }
                case 12: {
                    this.onPendingLayoutAction(event);
                    break;
                }
                case 3: {
                    this.onLayoutAction(event);
                    break;
                }
                default: {
                    Workspace.getDefaultLogger().info((Object)("Unhandled event type: " + event.getType() + " in Join Diagram"));
                }
            }
        }

        private void onPendingLayoutAction(PFDViewEvent ev) {
            WADiagramModel mdl = (WADiagramModel)JoinDiagramPanel.this.getPFDModel();
            IModel jobMdl = mdl.getObjectModel();
            if (jobMdl != null && mdl != null && JoinDiagramPanel.this.getDoLayout()) {
                Vector vNodes;
                Vector vLinks = JoinDiagramPanel.this.getDiagramModel().getAllLinks();
                if (vLinks.size() > 0) {
                    JoinDiagramPanel.this.saveLinksLocations(vLinks.toArray(new PFDLink[vLinks.size()]));
                }
                if ((vNodes = JoinDiagramPanel.this.getDiagramModel().getAllNodes()).size() > 0) {
                    JoinDiagramPanel.this.saveNodesLocation(vNodes.toArray(new IPersistableShape[vNodes.size()]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onLayoutAction(PFDViewEvent ev) {
            WADiagramModel mdl = (WADiagramModel)JoinDiagramPanel.this.getPFDModel();
            IModel jobMdl = mdl.getObjectModel();
            if (jobMdl != null && mdl != null && JoinDiagramPanel.this.getDoLayout()) {
                try {
                    Vector vNewNodes;
                    jobMdl.startCompoundUndoable();
                    Vector vNewLinks = JoinDiagramPanel.this.getDiagramModel().getAllLinks();
                    if (vNewLinks.size() > 0) {
                        JoinDiagramPanel.this.setLinksLocations(vNewLinks.toArray(new PFDLink[vNewLinks.size()]));
                    }
                    if ((vNewNodes = JoinDiagramPanel.this.getDiagramModel().getAllNodes()).size() > 0) {
                        JoinDiagramPanel.this.setNodesLocation(vNewNodes.toArray(new IPersistableShape[vNewNodes.size()]));
                    }
                }
                finally {
                    jobMdl.endCompoundUndoable();
                }
            }
        }

        private void onPrimitiveDeleted(PFDViewEvent ev) {
            Workspace.getDefaultLogger().debug((Object)ev);
        }

        private void onDragStarted(PFDViewEvent ev) {
            PFDPrimitive[] prims = JoinDiagramPanel.this.getSelectedPrimitives();
            IPersistableShape[] nodes = new IPersistableShape[prims.length];
            PFDLink[] links = new PFDLink[prims.length];
            for (int iNode = 0; iNode < prims.length; ++iNode) {
                PFDLink link;
                if (prims[iNode] instanceof IPersistableShape) {
                    IPersistableShape shape;
                    nodes[iNode] = shape = (IPersistableShape)prims[iNode];
                    continue;
                }
                if (!(prims[iNode] instanceof IDiagramLink)) continue;
                links[iNode] = link = (PFDLink)prims[iNode];
            }
            JoinDiagramPanel.this.saveNodesLocation(nodes);
            if (links.length > 0) {
                JoinDiagramPanel.this.saveLinksLocations(links);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDragEnded(PFDViewEvent ev) {
            IModel jobMdl;
            PFDPrimitive[] prims = JoinDiagramPanel.this.getSelectedPrimitives();
            if (prims.length == 0) {
                return;
            }
            if (prims.length == 1 && prims[0] instanceof IDiagramLink) {
                return;
            }
            IPersistableShape[] nodes = new IPersistableShape[prims.length];
            PFDLink[] links = new PFDLink[prims.length];
            WADiagramModel mdl = (WADiagramModel)JoinDiagramPanel.this.getPFDModel();
            PFDPrimitive prim = prims[0];
            if (prim instanceof IPersistableShape) {
                IPersistableShape shape = (IPersistableShape)prim;
                Point oldLocation = JoinDiagramPanel.this.getDragNodeLocation(shape.getId());
                if (prim.getSpotLocation((int)1, null).x == oldLocation.x && prim.getSpotLocation((int)1, null).y == oldLocation.y) {
                    return;
                }
            }
            if ((jobMdl = mdl.getObjectModel()) != null && mdl != null) {
                try {
                    jobMdl.startCompoundUndoable();
                    for (int iNode = 0; iNode < prims.length; ++iNode) {
                        PFDLink link;
                        if (prims[iNode] instanceof IPersistableShape) {
                            IPersistableShape shape;
                            nodes[iNode] = shape = (IPersistableShape)prims[iNode];
                            continue;
                        }
                        if (!(prims[iNode] instanceof PFDLink)) continue;
                        links[iNode] = link = (PFDLink)prims[iNode];
                    }
                    JoinDiagramPanel.this.setNodesLocation(nodes);
                    if (links.length > 0) {
                        JoinDiagramPanel.this.setLinksLocations(links);
                    }
                }
                finally {
                    jobMdl.endCompoundUndoable();
                }
            }
        }

        private void onLinkAdded(PFDViewEvent event) {
            PFDLink link = event.getLink();
            PFDPort fromPort = link.getFromPort();
            IDiagramNode fromNode = (IDiagramNode)event.getNewFromNode();
            if (fromNode == null) {
                fromNode = (IDiagramNode)fromPort.getParentNode();
            }
            IDiagramNode toNode = (IDiagramNode)event.getNewToNode();
            if (fromNode == null || toNode == null) {
                return;
            }
            JoinDiagramPanel.this.m_joinDiagramModel.linkAdded(link, fromNode, toNode);
            IQuery query = JoinDiagramPanel.this.m_joinDiagramModel.getQuery();
            ISQLTransform mdl = query.getTransformModel();
            IObject object = fromNode.getObject();
            if (object instanceof ISourceTable) {
                ISourceTable source = (ISourceTable)object;
                ITable table = source.getAliasedTable();
                if (!(query instanceof ISubquery) && mdl != null && mdl.getJob().isPropagatingAutomatically()) {
                    if (mdl.getJob().getAutomaticPropagationDirection() == 0) {
                        ((DesignTimeJobModel)mdl.getJob().getModel()).propagateFromBeginningToEnd(table, (IDataTransform)mdl);
                    } else {
                        ((DesignTimeJobModel)mdl.getJob().getModel()).propagateFromEndToBeginning(table, (IDataTransform)mdl);
                    }
                }
            }
        }

        private void onLinkRedirected(PFDViewEvent event) {
            PFDPort portNewTo = event.getNewToPort();
            IDiagramNode nodeOldFrom = (IDiagramNode)event.getOldFromNode();
            IDiagramNode nodeOldTo = (IDiagramNode)event.getOldToNode();
            IDiagramNode nodeNewFrom = (IDiagramNode)event.getNewFromNode();
            IDiagramNode nodeNewTo = (IDiagramNode)event.getNewToNode();
            IObject objOldFrom = nodeOldFrom.getObject();
            IObject objOldTo = nodeOldTo.getObject();
            IObject objNewFrom = nodeNewFrom.getObject();
            IObject objNewTo = nodeNewTo.getObject();
            int portIndexNewTo = nodeNewTo.getInputPortIndex(portNewTo);
            if (objOldFrom instanceof ISQLSource) {
                ((ISQLSource)objOldFrom).setParent(null);
            }
            if (objNewTo instanceof IJoin) {
                if (portIndexNewTo == 0) {
                    ((IJoin)objNewTo).setLeftSide((ISQLSource)objNewFrom);
                } else {
                    ((IJoin)objNewTo).setRightSide((ISQLSource)objNewFrom);
                }
            } else if (objNewTo instanceof ISelectResultsContainer) {
                JoinDiagramPanel.this.m_joinDiagramModel.getQuery().setSourceOfFrom((ISQLSource)objNewFrom);
            }
            JoinDiagramPanel.this.m_joinDiagramModel.removeObjectShape(objOldFrom, (IDiagramPersistable)event.getLink());
            JoinDiagramPanel.this.m_joinDiagramModel.putObjectShape(objNewFrom, (IDiagramPersistable)event.getLink());
            ((IDiagramLink)event.getLink()).setToNodeId(nodeNewTo.getId());
            ((IDiagramLink)event.getLink()).setToNodePortIndex(portIndexNewTo);
            JoinDiagramPanel.this.m_joinDiagramModel.removeObjectShape(objOldTo, (IDiagramPersistable)event.getLink());
            JoinDiagramPanel.this.m_joinDiagramModel.putObjectShape(objNewTo, (IDiagramPersistable)event.getLink());
            nodeOldFrom.refresh();
            nodeOldTo.refresh();
            nodeNewFrom.refresh();
            nodeNewTo.refresh();
        }
    }

    private class DiagramModelListener
    implements PFDModelListener {
        private DiagramModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(PFDModelEvent ev) {
            WADiagramModel mdl = JoinDiagramPanel.this.getDiagramModel();
            if (!mdl.isIgnoreEvents() && ev.getType() == 5) {
                IModel mdlJob = mdl.getObjectModel();
                if (ev.getPrimitive() instanceof IDiagramStickyNote) {
                    JoinDiagramPanel.this.removeStickyNote((IDiagramStickyNote)ev.getPrimitive());
                } else if (ev.getPrimitive() instanceof PFDLink) {
                    PFDLink link = (PFDLink)ev.getPrimitive();
                    if (link.isCollapsed()) {
                        return;
                    }
                    if (mdl.getLink(((BaseLink)link).getId()) == null || link.getFromNode() == null || link instanceof IControlLink || link.getToNode() == null) {
                        return;
                    }
                    mdlJob.startCompoundUndoable();
                    try {
                        IDiagramNode nodeOldFrom = (IDiagramNode)link.getFromNode();
                        IDiagramNode nodeOldTo = (IDiagramNode)link.getToNode();
                        PFDPort portOldFrom = link.getFromPort();
                        PFDPort portOldTo = link.getToPort();
                        IObject objFrom = ((IDiagramNode)link.getFromNode()).getObject();
                        IObject objTo = ((IDiagramNode)link.getToNode()).getObject();
                        if (objFrom instanceof IDataObject) {
                            ((IDataObject)objFrom).setChangedNodeId(((IDiagramNode)link.getFromNode()).getId());
                        }
                        if (objTo instanceof IDataObject) {
                            ((IDataObject)objTo).setChangedNodeId(((IDiagramNode)link.getToNode()).getId());
                        }
                        int portIndexOldFrom = nodeOldFrom.getOutputPortIndex(portOldFrom);
                        int portIndexOldTo = nodeOldTo.getInputPortIndex(portOldTo);
                        IDiagramNodeAdapter adapterOldFrom = nodeOldFrom.getAdapter();
                        IDiagramNodeAdapter adapterOldTo = nodeOldTo.getAdapter();
                        boolean bToDisconnectSuccess = adapterOldTo.disconnectFromInput(objFrom, portIndexOldTo);
                        boolean bFromDisconnectSuccess = adapterOldFrom.disconnectFromOutput(objTo, portIndexOldFrom);
                        if (bFromDisconnectSuccess && bToDisconnectSuccess) {
                            Workspace.getDefaultLogger().debug((Object)(objFrom.getName() + " disconnected successful from " + objTo.getName()));
                        } else {
                            Workspace.getDefaultLogger().debug((Object)(objFrom.getName() + " was unsuccessful disconnecting from " + objTo.getName()));
                        }
                    }
                    finally {
                        mdlJob.endCompoundUndoable();
                    }
                }
            }
        }
    }
}

