/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.IHaving;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.JoinType;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.jobeditor.diagram.WADiagramModel;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.IDataNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramPersistable;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramParserException;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramUtil;
import com.sas.wadmin.transforms.sql.AliasNameDialog;
import com.sas.wadmin.transforms.sql.editor.SQLClauseAdapter;
import com.sas.wadmin.transforms.sql.editor.SQLClauseNode;
import com.sas.wadmin.transforms.sql.editor.SQLDiagramContentHandler;
import com.sas.wadmin.transforms.sql.editor.SQLPhysicalTableAdapter;
import com.sas.wadmin.transforms.sql.editor.SQLPhysicalTableNode;
import com.sas.wadmin.transforms.sql.editor.SQLWorkTableAdapter;
import com.sas.wadmin.transforms.sql.editor.SQLWorkTableNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.models.SimpleObject;
import java.awt.Point;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class JoinDiagramModel
extends WADiagramModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(JoinDiagramModel.class);
    private static String SHOW_COLUMNS = "QueryTab.ShowColumns";
    private IQuery m_query;
    private IModelListener m_queryModelListener = new QueryModelListener();
    private boolean m_bIgnoreEvents;
    private boolean m_bShowColumns;
    private static final String LAYOUT_DIRECTION = "LayoutDirection";
    public static final int JOIN_LEFT_SIDE = 0;
    public static final int JOIN_RIGHT_SIDE = 1;
    private ClauseNodeMap m_clauseNodeMap = new ClauseNodeMap();
    private WsAbstractAction m_deleteAction;

    public JoinDiagramModel(IQuery query) {
        this.setQuery(query);
        this.m_clauseNodeMap.put(ClauseType.SELECT, null);
        this.m_clauseNodeMap.put(ClauseType.WHERE, null);
        this.m_clauseNodeMap.put(ClauseType.GROUPBY, null);
        this.m_clauseNodeMap.put(ClauseType.HAVING, null);
        this.m_clauseNodeMap.put(ClauseType.ORDERBY, null);
        this.m_bShowColumns = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_COLUMNS, false);
        this.m_bIgnoreEvents = false;
    }

    public void setDeletePrimitiveAction(WsAbstractAction action) {
        this.m_deleteAction = action;
    }

    @Override
    public void putNode(IObject obj, IDiagramNode node) {
        if (node instanceof IDataNode) {
            ((IDataNode)node).setShowColumns(this.isShowColumns());
        }
        super.putNode(obj, node);
        if (JoinDiagramModel.isFixedClause(obj)) {
            this.m_clauseNodeMap.put(((IClause)obj).getClauseType(), node);
        }
    }

    @Override
    protected IDiagramNode addNode(IObject element) {
        IDiagramNode node = null;
        ArrayList nodes = null;
        if (!this.getIgnoreDeletedNodes() && (nodes = (ArrayList)this.getDeletedNodes(element)) != null && !nodes.isEmpty()) {
            node = (IDiagramNode)nodes.get(0);
        }
        if (node == null) {
            node = this.acquireNode(element);
        }
        this.removeDeletedNode(element, node);
        this.putNode(element, node);
        this.addPrimitive((PFDPrimitive)((PFDAbstractNode)node));
        return node;
    }

    @Override
    protected void removeObjectShape(IObject obj, IDiagramPersistable shape) {
        super.removeObjectShape(obj, shape);
    }

    @Override
    protected void putObjectShape(IObject obj, IDiagramPersistable shape) {
        super.putObjectShape(obj, shape);
    }

    protected IDiagramNode addFragmentNode(IObject element) {
        IDiagramNode node = this.addNode(element);
        if (element instanceof IJoin) {
            IJoin join = (IJoin)element;
            ISQLSource source = join.getLeftSide();
            if (source != null) {
                this.addNode((IObject)source, node, 0);
            }
            if ((source = join.getRightSide()) != null) {
                this.addNode((IObject)source, node, 1);
            }
        }
        return node;
    }

    protected IDiagramNode addNode(IObject element, IDiagramNode target, int port) {
        IDiagramNode node = this.addNode(element);
        this.addLink(node, target, port);
        return node;
    }

    protected IDiagramNode addNode(IDiagramNode source, IObject element) {
        IDiagramNode node = this.addNode(element);
        if (source != null) {
            this.addLink(source, node, 0);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkAdded(PFDLink link, IDiagramNode fromNode, IDiagramNode toNode) {
        if (!(fromNode.getAdapter().getObject() instanceof ISQLSource)) {
            throw new IllegalArgumentException("Invalid argument for JoinDiagramModel.linkAdded: " + fromNode.getAdapter().getObject().getClass().getName() + " is not an instance of ISQLSource");
        }
        ISQLSource source = (ISQLSource)fromNode.getAdapter().getObject();
        if (source instanceof IAliasTable) {
            ((IAliasTable)source).getAliasedTable().setChangedNodeId(fromNode.getId());
            ((ITable)source).setChangedNodeId(fromNode.getId());
            this.m_query.setLastChangeNodeId(fromNode.getId());
        }
        IObject target = toNode.getAdapter().getObject();
        this.m_query.getModel().startCompoundUndoable();
        try {
            int numInputPorts = toNode.getNumInputPorts();
            PFDPort toPort = link.getToPort();
            if (numInputPorts == 0) {
                return;
            }
            if (target instanceof ISelectResultsContainer) {
                ISelectResultsContainer select = (ISelectResultsContainer)target;
                select.getParentQuery().setSourceOfFrom(source);
            } else if (toPort == toNode.getInputPort(0)) {
                this.addSourceToJoin(fromNode, 0, toNode);
            } else if (toPort == toNode.getInputPort(1)) {
                this.addSourceToJoin(fromNode, 1, toNode);
            } else {
                throw new UnsupportedOperationException("Links between ports > 2 not supported for Join Diagram");
            }
            this.putLink((IDiagramLink)link);
        }
        finally {
            this.m_query.getModel().endCompoundUndoable();
        }
    }

    public void addLink(IDiagramNode fromNode, IDiagramNode toNode, int port) {
        PFDPort outputPort = fromNode.getOutputPort(0);
        int numPorts = toNode.getNumInputPorts();
        if (port >= numPorts) {
            return;
        }
        PFDPort inputPort = toNode.getInputPort(port);
        Vector fromLinks = outputPort.getFromLinks();
        int lSize = fromLinks.size();
        for (int i = 0; i < lSize; ++i) {
            DataLink link = (DataLink)fromLinks.get(i);
            if (link.getToNode() != toNode) continue;
            return;
        }
        DataLink link = new DataLink();
        link.setFromPort(outputPort);
        link.setFromNodeId(fromNode.getId());
        if (JoinDiagramModel.isFixedClause(fromNode.getObject())) {
            link.setSelectable(false);
        }
        link.setToPort(inputPort);
        link.setToNodeId(toNode.getId());
        this.addLink(link);
    }

    @Override
    protected void putLink(IDiagramLink link) {
        super.putLink(link);
        ((PFDLink)link).setAction("ACTION_DELETE", (Action)this.m_deleteAction);
    }

    public void addSourceToJoin(IDiagramNode sourceNode, int side, IDiagramNode joinNode) {
        ISQLSource source = (ISQLSource)sourceNode.getAdapter().getObject();
        IJoin join = (IJoin)joinNode.getAdapter().getObject();
        if (side == 0) {
            join.setLeftSide(source);
        } else if (side == 1) {
            join.setRightSide(source);
        } else {
            throw new IllegalArgumentException("Invalid side specified for JoinDiagramModel.addSourceToJoin: " + side);
        }
    }

    public IDiagramNode acquireNode(IObject element) {
        IDiagramNode node = this.getNode(element);
        if (node == null) {
            if (element instanceof IAliasTable && ((IAliasTable)element).getAliasedTable() != null) {
                ITable table = ((IAliasTable)element).getAliasedTable();
                if (table instanceof IWorkTable) {
                    SQLWorkTableAdapter ad = new SQLWorkTableAdapter((ITable)((IAliasTable)element));
                    node = new SQLWorkTableNode(ad, this.m_query);
                } else if (table instanceof IPhysicalTable) {
                    SQLPhysicalTableAdapter ad = new SQLPhysicalTableAdapter((ITable)((IAliasTable)element));
                    node = new SQLPhysicalTableNode(ad, this.m_query);
                }
            } else if (element instanceof IPhysicalTable) {
                if (element instanceof IWorkTable) {
                    SQLWorkTableAdapter ad = new SQLWorkTableAdapter((ITable)((IWorkTable)element));
                    node = new SQLWorkTableNode(ad, this.m_query);
                } else {
                    SQLPhysicalTableAdapter ad = new SQLPhysicalTableAdapter((ITable)((IPhysicalTable)element));
                    node = new SQLPhysicalTableNode(ad, this.m_query);
                }
            } else if (element != null) {
                SQLClauseAdapter adapter = new SQLClauseAdapter((IClause)element);
                node = new SQLClauseNode(adapter, this.m_query);
            }
        }
        return node;
    }

    public IObject createElementForObject(Object object) {
        IJoin element = null;
        String id = this.m_query.getID();
        IObjectFactory factory = this.m_query.getModel().getObjectFactory();
        if (object instanceof JoinType) {
            element = factory.createNewSQLJoin(id);
            element.setJoinType(((JoinType)object).getJoinType());
        } else if (object instanceof SimpleObject) {
            ISourceTable[] aSources;
            SimpleObject simpleObject = (SimpleObject)object;
            if (!simpleObject.getMetadataType().equals("PhysicalTable")) {
                throw new IllegalArgumentException("Objects of type " + simpleObject.getMetadataType() + " cannot be added to the SQL diagram.");
            }
            IPhysicalTable table = this.acquireTableForObject(simpleObject);
            String aliasName = "";
            ISQLTransform sqlModel = this.m_query.getTransformModel();
            if (sqlModel != null && (aSources = sqlModel.getQuery().findInAllQuerySourceTables((ITable)table)).length > 0) {
                AliasNameDialog dlg = new AliasNameDialog();
                dlg.setDefault(table);
                if (dlg.showDialog() == 0) {
                    aliasName = dlg.getAliasText();
                }
            }
            ISourceTable source = factory.createNewSQLSourceTable(id);
            source.setAliasedTable((ITable)table);
            source.setAliasName(aliasName);
            element = source;
        } else if (object instanceof ClauseType) {
            ClauseType clauseType = (ClauseType)object;
            if (clauseType.getType().equalsIgnoreCase("Subquery")) {
                element = factory.createNewSQLSubquery(id);
            } else if (clauseType.getType().equalsIgnoreCase("Where")) {
                element = factory.createNewSQLWhere(id);
            } else if (clauseType.getType().equalsIgnoreCase("Having")) {
                element = factory.createNewSQLHaving(id);
            } else if (clauseType.getType().equalsIgnoreCase("Order by")) {
                element = factory.createNewSQLOrderBy(id);
            } else if (clauseType.getType().equalsIgnoreCase("Group by")) {
                element = factory.createNewSQLGroupBy(id);
            }
        } else {
            throw new IllegalArgumentException("Objects of type " + object.getClass().getName() + " cannot be added to the SQL diagram.");
        }
        return element;
    }

    @Override
    public IDiagramNodeAdapter getAdapter(IObject obj) {
        IDiagramNode node = this.getNode(obj);
        if (node != null) {
            return node.getAdapter();
        }
        return null;
    }

    public void addElementToModel(IObject element) {
        if (element instanceof IJoin) {
            this.m_query.addJoin((IJoin)element);
        } else if (element instanceof ISourceTable) {
            this.m_query.addANewSourceTableAndAddToJob((ISourceTable)element);
        } else if (element instanceof ISubquery) {
            this.m_query.addInlineSubquery((ISubquery)element);
        } else if (element instanceof IClause) {
            this.m_query.addClause((IClause)element);
        } else {
            throw new IllegalArgumentException("Objects of type " + element.getClass().getName() + " cannot be added to the SQL model.");
        }
    }

    public IDiagramNode getNode(IObject obj) {
        List nodes = this.getNodes(obj);
        if (nodes == null) {
            return null;
        }
        for (int index = 0; index < nodes.size(); ++index) {
            IDiagramNode dnode = (IDiagramNode)nodes.get(index);
            if (dnode.getAdapter().getObject() != obj) continue;
            return dnode;
        }
        return null;
    }

    public boolean contains(ClauseType clauseType) {
        Vector nodes = this.getAllNodes();
        for (int index = 0; index < nodes.size(); ++index) {
            IClause clause;
            IDiagramNode node = (IDiagramNode)nodes.get(index);
            IObject element = node.getAdapter().getObject();
            if (!(element instanceof IClause) || !(clause = (IClause)element).getName().equals(clauseType.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean addLinksFromXML() {
        List lLinks = this.getLinksList();
        if (lLinks == null || lLinks.isEmpty()) {
            return false;
        }
        for (int iLink = 0; iLink < lLinks.size(); ++iLink) {
            IDiagramLink link = (IDiagramLink)lLinks.get(iLink);
            if (link == null) continue;
            IDiagramNode nodeFrom = this.getNode(link.getFromNodeId());
            IDiagramNode nodeTo = this.getNode(link.getToNodeId());
            if (nodeFrom == null || nodeTo == null) continue;
            IObject fromObject = nodeFrom.getAdapter().getObject();
            IObject toObject = nodeTo.getAdapter().getObject();
            if (toObject instanceof ISelectResultsContainer) {
                ISQLSource sourceOfFrom = this.m_query.getSourceOfFrom();
                if (sourceOfFrom != fromObject) {
                    continue;
                }
            } else if (toObject instanceof IJoin) {
                IJoin join = (IJoin)toObject;
                int iPort = link.getToNodePortIndex();
                ISQLSource joinSource = null;
                joinSource = iPort == 0 ? join.getLeftSide() : join.getRightSide();
                if (joinSource != fromObject) continue;
            }
            PFDPort portOutputFrom = nodeFrom.getOutputPort(link.getFromNodePortIndex());
            PFDPort portInputTo = link.getToNodePortIndex() <= nodeFrom.getNumInputPorts() ? nodeTo.getInputPort(link.getToNodePortIndex()) : nodeTo.getInputPort(nodeFrom.getObject());
            link.setLinkSupportedValidation(false);
            ((PFDLink)link).setFromPort(portOutputFrom);
            ((PFDLink)link).setToPort(portInputTo);
            link.setLinkSupportedValidation(true);
            if (JoinDiagramModel.isFixedClause(nodeFrom.getObject())) {
                ((PFDLink)link).setSelectable(false);
            }
            if (this.getLink(fromObject, toObject) != null) continue;
            this.addLink((PFDLink)link);
        }
        return true;
    }

    @Override
    protected boolean addNodesFromXML() {
        super.addNodesFromXML();
        List lNodes = this.getNodesList();
        if (lNodes == null || lNodes.isEmpty()) {
            return false;
        }
        for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
            IDiagramNode node = (IDiagramNode)lNodes.get(iNode);
            if (node == null || node.getObject() == null) continue;
            this.putNode(node.getObject(), node);
            this.addPrimitive((PFDPrimitive)((PFDAbstractNode)node));
        }
        return true;
    }

    public IDiagramNode addNodes(List elements) {
        IDiagramNode node = null;
        for (int index = 0; index < elements.size(); ++index) {
            IObject element = (IObject)elements.get(index);
            if (this.getNode(element) == null) {
                node = this.addNode(element);
            }
            if (!JoinDiagramModel.isFixedClause(element)) continue;
            this.m_clauseNodeMap.put(((IClause)element).getClauseType(), node);
        }
        return node;
    }

    @Override
    protected boolean createNodesNotExistingInXML() {
        ITable targetTable;
        boolean bNoAutoLayout = true;
        ArrayList<ISourceTable> clauses = new ArrayList<ISourceTable>();
        clauses.addAll(this.m_query.getAllClauses());
        ISourceTable[] sources = this.m_query.getQueryOnlySourceTables();
        if (sources.length > 0) {
            clauses.addAll(Arrays.asList(sources));
        }
        ArrayList<IObject> clList = new ArrayList<IObject>();
        for (int i = 0; i < clauses.size(); ++i) {
            IObject object = (IObject)clauses.get(i);
            if (object instanceof IFromContainer && !(object instanceof ISubquery) && ((object = ((IFromContainer)object).getSourceOfFrom()) == null || !(object instanceof IJoin)) || this.getNode(object) != null) continue;
            clList.add(object);
            bNoAutoLayout = false;
        }
        this.addNodes(clList);
        if (!(this.m_query instanceof ISubquery) && (targetTable = this.m_query.getTargetTable()) != null && this.getNode((IObject)targetTable) == null) {
            this.addNode((IObject)targetTable);
            bNoAutoLayout = false;
        }
        List fragments = this.m_query.getFragmentedSourceObjects();
        for (int i = 0; i < fragments.size(); ++i) {
            IObject obj = (IObject)fragments.get(i);
            if (this.getNode(obj) != null) continue;
            this.addNode(obj);
            bNoAutoLayout = false;
        }
        return bNoAutoLayout;
    }

    @Override
    protected void createLinksNotExistingInXML() {
        ArrayList lNodes = new ArrayList(this.getNodes());
        for (int index = 0; index < lNodes.size(); ++index) {
            IDiagramNode node = (IDiagramNode)lNodes.get(index);
            IObject object = node.getObject();
            if (object instanceof ISQLSource) {
                IDiagramLink link;
                IDiagramNode toNode;
                IClause parent = ((ISQLSource)object).getParent();
                if (parent == null) continue;
                if (parent == this.m_query) {
                    parent = this.m_query.getSelectResults();
                }
                if ((toNode = this.getNode((IObject)parent)) == null) {
                    toNode = this.addNode((IObject)parent);
                }
                if ((link = this.getLink(object, (IObject)parent)) != null) continue;
                if (parent instanceof IJoin) {
                    if (((IJoin)parent).getLeftSide() == object) {
                        this.addLink(node, toNode, 0);
                        continue;
                    }
                    this.addLink(node, toNode, 1);
                    continue;
                }
                this.addLink(node, toNode, 0);
                continue;
            }
            if (JoinDiagramModel.isFixedClause(object)) {
                IClause clause = (IClause)object;
                if (clause instanceof ISelectResultsContainer) continue;
                this.connectToClauses(node, false);
                continue;
            }
            if (!(object instanceof IPhysicalTable)) continue;
            int mapIndex = this.m_clauseNodeMap.size();
            while (mapIndex-- >= 0 && this.m_clauseNodeMap.get(mapIndex) == null) {
            }
            IDiagramNode fromNode = this.m_clauseNodeMap.get(mapIndex);
            IObject fromObject = fromNode.getObject();
            IDiagramLink link = this.getLink(fromObject, object);
            if (link != null) continue;
            this.addLink(fromNode, node, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinksForNode(IDiagramNode node) {
        this.m_query.getModel().startCompoundUndoable();
        try {
            List links = super.getLinks(node.getObject());
            IDiagramNode fromNode = null;
            IDiagramNode toNode = null;
            for (int index = 0; index < links.size(); ++index) {
                IDiagramNode tNode;
                IDiagramLink link = (IDiagramLink)links.get(index);
                IDiagramNode fNode = this.getNode(link.getFromNodeId());
                if (fNode != node) {
                    fromNode = fNode;
                }
                if ((tNode = this.getNode(link.getToNodeId())) != node) {
                    toNode = tNode;
                }
                this.removeLink((IDiagramLink)links.get(index));
            }
            if (node instanceof SQLClauseNode && !(node.getObject() instanceof ISubquery) && !(node.getObject() instanceof IJoin) && fromNode != null && toNode != null) {
                this.addLink(fromNode, toNode, 0);
            }
        }
        finally {
            this.m_query.getModel().endCompoundUndoable();
        }
    }

    public void loadLayoutDirection() {
        String layoutDirection = this.m_query.getUserProperty(LAYOUT_DIRECTION);
        if (layoutDirection != null && layoutDirection.length() > 0) {
            this.setFlowDirection(layoutDirection);
            return;
        }
    }

    private void setQuery(IQuery query) {
        if (this.m_query == query) {
            return;
        }
        if (this.m_query != null) {
            this.m_query.getModel().removeModelListener(this.m_queryModelListener);
        }
        this.m_query = query;
        if (this.m_query != null) {
            this.m_query.getModel().addModelListener(this.m_queryModelListener);
        }
    }

    public IQuery getQuery() {
        return this.m_query;
    }

    protected boolean isIgnoreModelEvents() {
        return this.m_bIgnoreEvents;
    }

    protected void setIgnoreModelEvents(boolean value) {
        this.m_bIgnoreEvents = value;
    }

    public static boolean isFixedClause(IObject element) {
        return element instanceof IWhere || element instanceof IOrderBy || element instanceof IHaving || element instanceof IGroupBy || element instanceof ISelectResultsContainer;
    }

    public static boolean isTargetTable(IObject element) {
        return element instanceof ITable && !(element instanceof IAliasTable);
    }

    public boolean isShowColumns() {
        return this.m_bShowColumns;
    }

    public void setShowColumns(boolean bShowColumns) {
        if (this.m_bShowColumns == bShowColumns) {
            return;
        }
        this.m_bShowColumns = bShowColumns;
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_COLUMNS, bShowColumns);
        this.updateTableNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDiagramNode addNodeAtPosition(Object object, Point position) {
        try {
            this.setIgnoreModelEvents(true);
            this.m_query.getModel().startCompoundUndoable();
            IObject element = this.createElementForObject(object);
            this.addElementToModel(element);
            IDiagramNode node = this.addNode(element);
            node.setLocation(position.x, position.y);
            if (JoinDiagramModel.isFixedClause(element)) {
                this.connectToClauses(node, false);
            }
            IDiagramNode iDiagramNode = node;
            return iDiagramNode;
        }
        finally {
            this.m_query.getModel().endCompoundUndoable();
            this.setIgnoreModelEvents(false);
        }
    }

    public void connectToClauses(IDiagramNode node, boolean updatePosition) {
        DataLink toLink;
        IObject element = node.getObject();
        if (!(element instanceof IClause)) {
            throw new IllegalArgumentException("Invalid node with SQL element " + element.getClass().getName() + " to connect in join diagram; must be a clause node");
        }
        if (!JoinDiagramModel.isFixedClause(element)) {
            throw new IllegalArgumentException("Invalid clause node to connect; valid clause types are WHERE, GROUPBY, HAVING, and ORDERBY");
        }
        IClause clause = (IClause)element;
        int index = this.m_clauseNodeMap.indexOf(clause.getClauseType());
        while (index-- >= 0 && this.m_clauseNodeMap.get(index) == null) {
        }
        IDiagramNode fromNode = this.m_clauseNodeMap.get(index);
        PFDPort outPort = fromNode.getOutputPort(0);
        DataLink fromLink = null;
        Vector fromLinks = outPort.getFromLinks();
        IDiagramNode toNode = null;
        if (fromLinks.size() > 0) {
            fromLink = (DataLink)fromLinks.get(0);
            toNode = (IDiagramNode)fromLink.getToNode();
            if (toNode == node) {
                return;
            }
            this.removeObjectShape(toNode.getObject(), fromLink);
            fromLink.setToPort(node.getInputPort(0));
            fromLink.setToNodeId(node.getId());
            fromLink.setSelectable(false);
            this.putObjectShape(node.getObject(), fromLink);
            toLink = new DataLink();
            toLink.setSelectable(false);
            toLink.setFromPort(node.getOutputPort(0));
            toLink.setFromNodeId(node.getId());
            toLink.setToPort(toNode.getInputPort(0));
            toLink.setToNodeId(toNode.getId());
            this.addLink(toLink);
        } else {
            toLink = new DataLink();
            toLink.setSelectable(false);
            toLink.setFromPort(fromNode.getOutputPort(0));
            toLink.setFromNodeId(fromNode.getId());
            toLink.setToPort(node.getInputPort(0));
            toLink.setToNodeId(node.getId());
            this.addLink(toLink);
        }
        if (updatePosition) {
            double y;
            double x;
            Point fromLocation = null;
            fromLocation = fromNode.getSpotLocation(1, fromLocation);
            Point toLocation = null;
            if (toNode != null) {
                toLocation = toNode.getSpotLocation(1, toLocation);
            }
            if (this.getFlowDirection() == "Right") {
                x = toLocation == null ? Math.abs(fromLocation.getX() + 45.0) : Math.abs((fromLocation.getX() + toLocation.getX()) / 2.0);
                y = Math.abs(fromLocation.getY() + 45.0);
            } else {
                y = toLocation == null ? Math.abs(fromLocation.getY() + 45.0) : Math.abs((fromLocation.getY() + toLocation.getY()) / 2.0);
                x = Math.abs(fromLocation.getX() + 45.0);
            }
            Point newPoint = new Point();
            newPoint.setLocation(x, y);
            this.setLocation(node, node.getLocation(), newPoint);
        }
    }

    @Override
    public void setMainObject(IPersistableObject object) {
        super.setMainObject(object);
        this.setQuery((IQuery)object);
    }

    @Override
    protected boolean parseDiagramXML() {
        String shapes = this.getDiagramXML();
        if (shapes == null) {
            shapes = this.m_query.getUserProperty("DiagramXML");
        }
        if (shapes != null) {
            try {
                List links = this.getLinksList();
                List nodes = this.getNodesList();
                List notes = this.getStickyNoteList();
                DiagramUtil.getObjectsFromXML(new SQLDiagramContentHandler(this.m_query, links, nodes, notes, (IDesignTimeModel)this.getMainObject().getModel()), shapes);
            }
            catch (SAXException se) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)se.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (IOException ioe) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)ioe.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (ParserConfigurationException pce) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)pce.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (DiagramParserException dpe) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)dpe.getMessage(), (String)bundle.getString("JoinDiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isDropValid(Point location, List objects) {
        for (int index = 0; index < objects.size(); ++index) {
            String type;
            Object object = objects.get(index);
            if (object instanceof CMetadata) {
                try {
                    type = ((CMetadata)object).getCMetadataType();
                    if (!type.equals("PhysicalTable")) continue;
                    return true;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                    return false;
                }
            }
            if (!(object instanceof SimpleObject ? (type = ((SimpleObject)object).getPublicType()).equals("Table") : object instanceof ClauseType || object instanceof JoinType)) continue;
            return true;
        }
        return false;
    }

    public boolean drop(Point position, List objects) {
        for (int index = 0; index < objects.size(); ++index) {
            this.addNodeAtPosition(objects.get(index), position);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPhysicalTable acquireTableForObject(SimpleObject object) {
        block9: {
            IPhysicalTable iPhysicalTable;
            block8: {
                IObject obj = this.m_query.getModel().getObject(object.getID());
                if (obj != null && obj instanceof IPhysicalTable) {
                    return (IPhysicalTable)obj;
                }
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "JoinDiagramModel.createTableForObject");
                try {
                    Root metadata = ObjectConverter.getInstance().convertToJOMAObject(store, object);
                    IPhysicalTable table = this.m_query.getModel().getObjectFactory().createPhysicalTable(metadata.getFQID());
                    this.m_query.getModel().loadFromOMR((IOMRPersistable)table, Workspace.getMdFactory());
                    iPhysicalTable = table;
                    if (store == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                        break block9;
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    }
                }
                store.dispose();
            }
            return iPhysicalTable;
        }
        return null;
    }

    protected void updateTableNodes() {
        Vector nodes = this.getAllNodes();
        for (int index = 0; index < nodes.size(); ++index) {
            IDiagramNode node = (IDiagramNode)nodes.get(index);
            IObject object = node.getObject();
            if (!(object instanceof ITable) || !(node instanceof DataNode)) continue;
            ((IDataNode)node).setShowColumns(this.isShowColumns());
        }
    }

    public void dispose() {
        Vector nodes = this.getAllNodes();
        for (int index = 0; index < nodes.size(); ++index) {
            IDiagramNode node = (IDiagramNode)nodes.get(index);
            IObject object = node.getObject();
            if (!(object instanceof ITable) || !(node.getAdapter() instanceof IDataNodeAdapter)) continue;
            IDataNodeAdapter adapter = (IDataNodeAdapter)node.getAdapter();
            adapter.disposeTableComponent();
        }
        this.m_query.getModel().removeModelListener(this.m_queryModelListener);
        super.dispose();
    }

    @Override
    public IDiagramNode removeNode(String id) {
        IDiagramNode node = this.getNode(id);
        if (node != null) {
            if (JoinDiagramModel.isFixedClause(node.getObject())) {
                IClause clause = (IClause)node.getObject();
                this.m_clauseNodeMap.put(clause.getClauseType(), null);
            }
            this.removeNode(node);
            this.removeObjectShape(node.getObject(), node);
            this.putDeletedNode(node.getObject(), node);
            this.removePrimitive((PFDPrimitive)((PFDAbstractNode)node));
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save() {
        String flowDirection = this.getFlowDirection();
        IPersistableObject jobModel = this.getMainObject();
        if (jobModel != null) {
            jobModel.getModel().startCompoundUndoable();
            try {
                jobModel.setUserProperty("FlowDirection", flowDirection);
                String sXML = this.createDiagramXML();
                if (sXML != null) {
                    jobModel.setUserProperty("DiagramXML", sXML.toString());
                } else {
                    jobModel.setUserProperty("DiagramXML", "");
                }
            }
            finally {
                jobModel.getModel().endCompoundUndoable();
            }
            return true;
        }
        return false;
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            if (!JoinDiagramModel.this.m_bIgnoreEvents) {
                String sType = event.getType();
                IObject obj = event.getModelObject();
                Object data = event.getData();
                if (obj == JoinDiagramModel.this.m_query) {
                    IDiagramNode node;
                    if ("SQL:ClauseRemoved".equals(sType) || "SQLObject:QueryTableRemoved".equals(sType)) {
                        node = JoinDiagramModel.this.getNode((IObject)data);
                        if (node == null) {
                            return;
                        }
                        JoinDiagramModel.this.removeLinksForNode(node);
                        JoinDiagramModel.this.removeNode(node.getId());
                    } else if ("SQL:ClauseAdded".equals(sType) || "SQLObject:QueryTableAdded".equals(sType)) {
                        List subqueries;
                        if (data instanceof ISubquery && !(subqueries = JoinDiagramModel.this.m_query.getInlineSubqueryList()).contains(data)) {
                            return;
                        }
                        node = JoinDiagramModel.this.addNode((IObject)data);
                        if (JoinDiagramModel.isFixedClause((IObject)data)) {
                            JoinDiagramModel.this.connectToClauses(node, true);
                        }
                        node.refresh();
                    } else if ("SQLFrom:SourceOfFromChanged".equals(sType)) {
                        ISelectResultsContainer select = JoinDiagramModel.this.m_query.getSelectResults();
                        IDiagramNode toNode = JoinDiagramModel.this.getNode((IObject)select);
                        List lLinks = JoinDiagramModel.this.getLinks((IObject)select);
                        if (lLinks == null) {
                            return;
                        }
                        IDiagramNode fromNode = null;
                        for (int index = 0; index < lLinks.size(); ++index) {
                            IDiagramLink link = (IDiagramLink)lLinks.get(index);
                            IDiagramNode tNode = JoinDiagramModel.this.getNode(link.getFromNodeId());
                            if (select == tNode.getObject()) continue;
                            fromNode = tNode;
                            break;
                        }
                        if (fromNode != null) {
                            JoinDiagramModel.this.removeLink(fromNode.getObject(), (IObject)select);
                            if (data == null) {
                                return;
                            }
                            fromNode = JoinDiagramModel.this.getNode((IObject)data);
                            if (fromNode == null) {
                                fromNode = JoinDiagramModel.this.acquireNode((IObject)data);
                            }
                        } else {
                            if (data == null) {
                                return;
                            }
                            fromNode = JoinDiagramModel.this.acquireNode((IObject)data);
                        }
                        JoinDiagramModel.this.addLink(fromNode, toNode, 0);
                    }
                } else if (obj instanceof IJoin && ((IJoin)obj).getParentQuery() == JoinDiagramModel.this.m_query) {
                    Vector lLinks;
                    PFDLink link;
                    PFDPort port;
                    IDiagramNode joinNode;
                    if ("Join:LeftSideChanged".equals(sType)) {
                        joinNode = JoinDiagramModel.this.getNode(obj);
                        port = joinNode.getInputPort(0);
                        link = null;
                        lLinks = port.getToLinks();
                        if (!lLinks.isEmpty()) {
                            link = (PFDLink)lLinks.get(0);
                        }
                        if (link != null) {
                            IDiagramNode fromNode = (IDiagramNode)link.getFromNode();
                            if (fromNode.getObject() == data) {
                                return;
                            }
                            JoinDiagramModel.this.removeLink((IDiagramLink)link);
                        }
                        if (data != null && data instanceof ISQLSource) {
                            IDiagramNode node = JoinDiagramModel.this.getNode((IObject)data);
                            if (node == null) {
                                node = JoinDiagramModel.this.addNode((IObject)data);
                            }
                            JoinDiagramModel.this.addLink(node, joinNode, 0);
                        }
                    } else if ("Join:RightSideChanged".equals(sType)) {
                        joinNode = JoinDiagramModel.this.getNode(obj);
                        port = joinNode.getInputPort(1);
                        link = null;
                        lLinks = port.getToLinks();
                        if (!lLinks.isEmpty()) {
                            link = (PFDLink)lLinks.get(0);
                        }
                        if (link != null) {
                            IDiagramNode fromNode = (IDiagramNode)link.getFromNode();
                            if (fromNode.getObject() == data) {
                                return;
                            }
                            JoinDiagramModel.this.removeLink((IDiagramLink)link);
                        }
                        if (data != null && data instanceof ISQLSource) {
                            IDiagramNode node = JoinDiagramModel.this.getNode((IObject)data);
                            if (node == null) {
                                node = JoinDiagramModel.this.addNode((IObject)data);
                            }
                            JoinDiagramModel.this.addLink(node, joinNode, 1);
                        }
                    }
                }
                if ("SQLJoinTransformModel:QueryChanged".equals(sType) || "PhysicalTable:LibraryChanged".equals(sType) || "NotesContainer:PrivateNoteChanged".equals(sType) || "Object:UserWrittenIndicatorChanged".equals(sType) || "Object:BooleanExpressionChanged".equals(sType) || "ModelController:UnknownChanges".equals(sType)) {
                    Vector lNodes = JoinDiagramModel.this.getAllNodes();
                    for (int index = 0; index < lNodes.size(); ++index) {
                        IDiagramNode node = (IDiagramNode)lNodes.get(index);
                        if (node == null) continue;
                        node.refresh();
                    }
                }
            }
        }
    }

    private static class ClauseNodeMap {
        private Map m_map = new HashMap();
        private List m_keyList = new ArrayList();

        public ClauseNodeMap() {
            this.m_map.put(ClauseType.SELECT, null);
            this.m_keyList.add(ClauseType.SELECT);
            this.m_map.put(ClauseType.WHERE, null);
            this.m_keyList.add(ClauseType.WHERE);
            this.m_map.put(ClauseType.GROUPBY, null);
            this.m_keyList.add(ClauseType.GROUPBY);
            this.m_map.put(ClauseType.HAVING, null);
            this.m_keyList.add(ClauseType.HAVING);
            this.m_map.put(ClauseType.ORDERBY, null);
            this.m_keyList.add(ClauseType.ORDERBY);
        }

        public void put(ClauseType clauseType, IDiagramNode node) {
            if (!this.m_keyList.contains(clauseType)) {
                throw new IllegalArgumentException("Invalid key for clause map; valid clause types are SELECT, WHERE, GROUPBY, HAVING, and ORDERBY");
            }
            this.m_map.put(clauseType, node);
        }

        public IDiagramNode get(int index) {
            if (index < 0 || index > 4) {
                throw new IndexOutOfBoundsException("Index " + index + " out of bounds; must be between 0 and 4");
            }
            ClauseType clauseType = (ClauseType)this.m_keyList.get(index);
            if (clauseType == null) {
                throw new IllegalStateException("Null clause key encountered in clause node map at position: " + index);
            }
            return this.get(clauseType);
        }

        public IDiagramNode get(ClauseType clauseType) {
            if (!this.m_keyList.contains(clauseType)) {
                throw new IllegalArgumentException("Invalid key for clause map; valid clause types are SELECT, WHERE, GROUPBY, HAVING, and ORDERBY");
            }
            return (SQLClauseNode)this.m_map.get(clauseType);
        }

        public int indexOf(ClauseType clauseType) {
            for (int index = 0; index < this.m_keyList.size(); ++index) {
                ClauseType type = (ClauseType)this.m_keyList.get(index);
                if (!type.equals(clauseType)) continue;
                return index;
            }
            return -1;
        }

        public int size() {
            return this.m_map.size();
        }
    }
}

