/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IReflectiveObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.ICaseExpression;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.sql.editor.ChooseValuesPanel;
import com.sas.wadmin.transforms.sql.editor.ColumnSelectorDialog;
import com.sas.wadmin.transforms.sql.editor.SQLExpressionActions;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDropMenuTableCellEditor;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CaseStatementPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(CaseStatementPanel.class);
    private static final int SCROLL_PANE_WIDTH = 400;
    private static final int SCROLL_PANE_HEIGHT = 150;
    private static final int WhenColumn = 0;
    private static final int ThenColumn = 1;
    private static final int ObjectColumn = 2;
    private WsTable m_caseTable;
    private CaseTableModel m_caseTableModel;
    private WATextField m_operandField;
    private WATextField m_elseField;
    private WsAbstractAction m_chooseColumnAction;
    private WsAbstractAction m_newAction;
    private WsAbstractAction m_deleteAction;
    private WsAbstractAction m_moveUpAction;
    private WsAbstractAction m_moveDownAction;
    private WsAbstractAction m_advancedExpressionAction;
    private WsAbstractAction m_advancedElseAction;
    private WsAbstractAction m_chooseValuesAction;
    private TableSelectionListener m_caseTableSelectionListener;
    private OperandFieldListener m_operandFieldListener;
    private RowModelListener m_caseTableRowModelListener;
    private IModelListener m_lsnrModel;
    private boolean m_ignoreCellEditing;
    private String m_settingsPrefix;
    protected ICaseStatement m_caseStatement;
    private IClause m_clause;

    public CaseStatementPanel(ICaseStatement caseStatement, IClause clause) {
        this.m_caseStatement = caseStatement;
        this.m_clause = clause;
        this.m_ignoreCellEditing = false;
        this.m_settingsPrefix = "SQL.CaseStatementPanel";
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_case");
        this.initialize();
    }

    protected void initialize() {
        this.m_operandField = new WATextField();
        this.m_operandField.setToolTipText(bundle.getString("CaseStatementPanel.Operand.tip"));
        JLabel operandLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_operandField, (String)bundle.getString("CaseStatementPanel.Operand.txt"));
        this.m_operandFieldListener = new OperandFieldListener();
        this.m_operandField.addActionListener((ActionListener)this.m_operandFieldListener);
        this.m_operandField.addFocusListener((FocusListener)this.m_operandFieldListener);
        this.m_chooseColumnAction = new ChooseColumnAction();
        JButton columnButton = WsUIUtilities.createTextButton((WsAbstractAction)this.m_chooseColumnAction);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(10, 10));
        topPanel.add((Component)operandLabel, "West");
        topPanel.add((Component)this.m_operandField, "Center");
        topPanel.add((Component)columnButton, "East");
        this.m_caseTableModel = new CaseTableModel();
        this.m_caseTable = new CaseTable(this.m_caseTableModel);
        JScrollPane caseTablePane = new JScrollPane((Component)this.m_caseTable);
        caseTablePane.setPreferredSize(new Dimension(400, 150));
        caseTablePane.setVerticalScrollBarPolicy(22);
        this.m_caseTable.setColumnHidingEnabled(false);
        this.m_caseTable.setColumnHoldingEnabled(false);
        this.m_caseTable.setColumnsReorderable(false);
        this.m_caseTable.setSortingEnabled(false);
        this.m_caseTable.setColumnHeaderVisible(true);
        this.m_caseTable.setRowHeaderVisible(true);
        this.m_caseTable.setRowHoldingEnabled(false);
        this.m_caseTable.setViewportPopupMenuEnabled(false);
        this.m_caseTable.setOriginPopupMenuEnabled(false);
        this.m_caseTable.setCellSelectionEnabled(true);
        this.m_caseTable.setColumnSelectionAllowed(false);
        this.m_caseTable.setRowSelectionAllowed(false);
        this.m_caseTable.setAutoResizeMode(1);
        this.m_caseTable.setSelectionMode(2);
        this.m_caseTable.setEditable(true);
        this.m_caseTable.setToolTipText(bundle.getString("CaseStatementPanel.CaseTable.ToolTip.txt"));
        this.m_caseTable.setUndoManager((UndoManager)this.waum);
        this.m_caseTableRowModelListener = new RowModelListener();
        ((WsDefaultTableRowModel)this.m_caseTable.getRowModel()).addRowModelListener((WsTableRowModelListener)this.m_caseTableRowModelListener);
        this.m_caseTableSelectionListener = new TableSelectionListener();
        this.m_caseTable.getSelectionModel().addListSelectionListener(this.m_caseTableSelectionListener);
        WsDropMenuTableCellEditor expressionMenuCellEditor = new WsDropMenuTableCellEditor();
        expressionMenuCellEditor.setDropMenu(this.createExpressionMenu());
        this.m_caseTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)expressionMenuCellEditor);
        this.m_caseTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)expressionMenuCellEditor);
        this.m_caseTable.restoreSettings(this.getSettingsPrefix());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout(10, 10));
        this.m_moveUpAction = new MoveUpAction();
        JButton upButton = new JButton((Action)this.m_moveUpAction);
        upButton.setPreferredSize(new Dimension(25, 25));
        this.m_moveDownAction = new MoveDownAction();
        JButton downButton = new JButton((Action)this.m_moveDownAction);
        downButton.setPreferredSize(new Dimension(25, 25));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout(10, 0));
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout((LayoutManager)new WsButtonsLayout());
        JPanel middleButtonPanel = new JPanel();
        middleButtonPanel.setLayout((LayoutManager)new WsButtonsLayout());
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout((LayoutManager)new WsButtonsLayout());
        leftButtonPanel.add(upButton);
        leftButtonPanel.add(downButton);
        this.m_chooseValuesAction = new ChooseValuesAction();
        JButton chooseValuesButton = WsUIUtilities.createTextButton((WsAbstractAction)this.m_chooseValuesAction);
        chooseValuesButton.setVisible(true);
        this.m_newAction = new NewAction();
        JButton newFilterButton = WsUIUtilities.createTextButton((WsAbstractAction)this.m_newAction);
        this.m_deleteAction = new DeleteAction();
        JButton deleteButton = WsUIUtilities.createTextButton((WsAbstractAction)this.m_deleteAction);
        this.m_caseTable.getActionMap().put(this.m_deleteAction, (Action)this.m_deleteAction);
        this.m_caseTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_deleteAction);
        rightButtonPanel.add(chooseValuesButton);
        rightButtonPanel.add(newFilterButton);
        rightButtonPanel.add(deleteButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)middleButtonPanel, "Center");
        buttonPanel.add((Component)rightButtonPanel, "East");
        this.setLayout(new BorderLayout(10, 10));
        JPanel bottomPanel = new JPanel(new BorderLayout(10, 10));
        bottomPanel.add((Component)buttonPanel, "North");
        tablePanel.add((Component)caseTablePane, "Center");
        tablePanel.add((Component)bottomPanel, "South");
        JPanel elsePanel = new JPanel(new BorderLayout(10, 10));
        this.m_elseField = new WATextField();
        this.m_elseField.setToolTipText(bundle.getString("CaseStatementPanel.Else.tip"));
        JLabel elseLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_elseField, (String)bundle.getString("CaseStatementPanel.Else.txt"));
        elsePanel.add((Component)elseLabel, "West");
        elsePanel.add((Component)this.m_elseField, "Center");
        this.m_elseField.addActionListener((ActionListener)this.m_operandFieldListener);
        this.m_elseField.addFocusListener((FocusListener)this.m_operandFieldListener);
        this.m_advancedElseAction = new AdvancedElseAction();
        JButton advancedButton = WsUIUtilities.createTextButton((WsAbstractAction)this.m_advancedElseAction);
        elsePanel.add((Component)advancedButton, "East");
        this.m_lsnrModel = new CaseModelListener();
        this.m_caseStatement.getModel().addModelListener(this.m_lsnrModel);
        this.add(topPanel, "North");
        this.add(tablePanel, "Center");
        this.add(elsePanel, "South");
    }

    protected JPopupMenu createExpressionMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.m_advancedExpressionAction = new AdvancedExpressionAction();
        menu.add(new JMenuItem((Action)this.m_advancedExpressionAction));
        return menu;
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_caseTableModel.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        IExpression caseOperand = this.m_caseStatement.getCaseOperand();
        if (caseOperand != null) {
            if (caseOperand instanceof ICaseStatement) {
                this.m_operandField.setText(bundle.getString("ExpressionPanel.CaseText.txt"));
            } else if (caseOperand instanceof ISubquery) {
                this.m_operandField.setText(bundle.getString("ExpressionPanel.SubqueryText.txt"));
            } else if (caseOperand instanceof ITextOperand) {
                this.m_operandField.setText(this.getTextFromOperand(caseOperand));
            } else {
                this.m_operandField.setText(caseOperand.toString());
            }
        }
        this.m_caseTableModel.moveDataToModel();
        IExpression elseOperand = this.m_caseStatement.getElseOperand();
        if (elseOperand != null) {
            if (elseOperand instanceof ICaseStatement) {
                this.m_elseField.setText(bundle.getString("ExpressionPanel.CaseText.txt"));
            } else if (elseOperand instanceof ISubquery) {
                this.m_elseField.setText(bundle.getString("ExpressionPanel.SubqueryText.txt"));
            } else if (elseOperand instanceof ITextOperand) {
                this.m_elseField.setText(this.getTextFromOperand(elseOperand));
            } else {
                this.m_elseField.setText(elseOperand.toString());
            }
        }
        if (this.m_caseTable.getRowCount() > 0) {
            this.m_caseTable.selectRow(0);
        }
        this.updateActions();
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setDataChanged(false);
    }

    private boolean validateOperand(IExpression operand) {
        if (operand == null) {
            return true;
        }
        if (operand instanceof ITextOperand) {
            return ((ITextOperand)operand).isComplete();
        }
        if (operand instanceof ICaseStatement) {
            return ((ICaseStatement)operand).validateExpression();
        }
        return true;
    }

    protected String getTextFromOperand(IExpression operand) {
        String sExpression = "";
        if (operand instanceof ITextOperand) {
            ITextExpression exp = ((ITextOperand)operand).getTextExpression();
            exp.setUseSQLSyntax(true);
            ISQLTransform transform = this.m_clause.getParentQuery().getTransformModel();
            try {
                sExpression = exp.getText(null, transform.isQuotingNeeded(), transform.isPassThru());
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
        }
        return sExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewExpression() {
        if (!this.m_caseTable.stopCellEditing()) {
            return;
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            int iRow = this.m_caseTable.getLastSelectedRow();
            int iColumn = iRow == -1 ? this.m_caseStatement.getExpressions().length - 1 : this.m_caseStatement.getExpressionsAsList().indexOf(this.m_caseTableModel.getValueAt(iRow, 2));
            this.m_caseTable.clearSelection();
            ICaseExpression expNew = this.m_caseStatement.getModel().getObjectFactory().createNewSQLCaseExpression(this.m_caseStatement.getID(), this.m_caseStatement);
            this.m_caseStatement.addExpression(iColumn + 1, expNew);
            this.m_caseTable.selectRow(iRow + 1);
            this.m_caseStatement.getModel().undoableEditHappened((UndoableEdit)new SelectExpressionsUndoable(expNew, false, true));
            int iEditColumn = Math.max(this.m_caseTable.convertColumnIndexToView(this.m_caseTableModel.getDefaultEditColumnIndex()), 0);
            this.m_caseTable.editCellAt(iRow + 1, iEditColumn);
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewExpressionsFromValues(List lValues) {
        if (!this.m_caseTable.stopCellEditing()) {
            return;
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            int iRow = this.m_caseTable.getLastSelectedRow();
            int iColumn = iRow == -1 ? this.m_caseStatement.getExpressions().length - 1 : this.m_caseStatement.getExpressionsAsList().indexOf(this.m_caseTableModel.getValueAt(iRow, 2));
            this.m_caseTable.clearSelection();
            int iTotal = lValues.size();
            for (int iExp = 0; iExp < iTotal; ++iExp) {
                ICaseExpression expNew = this.m_caseStatement.getModel().getObjectFactory().createNewSQLCaseExpression(this.m_caseStatement.getID(), this.m_caseStatement);
                String val = this.changeValue((String)lValues.get(iExp));
                expNew.setWhenOperand(this.createTextOperand(val));
                this.m_caseStatement.addExpression(iColumn + 1 + iExp, expNew);
            }
            this.m_caseTable.selectRows(iRow + 1, iRow + iTotal);
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
    }

    protected String changeValue(String val) {
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedExpressions() {
        int iRow;
        if (!this.m_caseTable.stopCellEditing()) {
            return;
        }
        int[] aRows = this.m_caseTable.getSelectedRowsFromSelectedCells();
        ICaseExpression[] aExps = new ICaseExpression[aRows.length];
        for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
            int iModelRow = this.m_caseTable.convertRowIndexToModel(aRows[iRow]);
            aExps[iRow] = (ICaseExpression)this.m_caseTableModel.getValueAt(iModelRow, 2);
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            for (int iExp = 0; iExp < aExps.length; ++iExp) {
                this.m_caseStatement.removeExpression(aExps[iExp]);
            }
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
        iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_caseTable.getRowCount() - 1);
        if (iRow >= 0) {
            this.m_caseTable.selectRow(iRow);
        }
    }

    public boolean validateData() {
        this.m_caseTable.stopCellEditing();
        if (this.m_caseTableModel.getRowCount() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("CaseStatementPanel.Error.NoExpressions.txt"), (int)0);
            return false;
        }
        for (int row = 0; row < this.m_caseTableModel.getRowCount(); ++row) {
            String whenOperand = (String)this.m_caseTableModel.getValueAt(row, 0);
            String thenOperand = (String)this.m_caseTableModel.getValueAt(row, 1);
            if (whenOperand == null || whenOperand.length() <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("CaseStatementPanel.Error.EmptyWhenOperand.txt"), (int)0);
                this.m_caseTable.selectCell(row, 0);
                return false;
            }
            if (thenOperand != null && thenOperand.length() > 0) continue;
            MessageUtil.displayMessage((String)bundle.getString("CaseStatementPanel.Error.EmptyThenOperand.txt"), (int)0);
            this.m_caseTable.selectCell(row, 1);
            return false;
        }
        IExpression caseOperand = this.m_caseStatement.getCaseOperand();
        if (!this.validateOperand(caseOperand)) {
            MessageUtil.displayMessage((String)bundle.formatString("CaseStatementPanel.Error.InvalidCaseOperand.txt", (Object)Integer.toString(255)), (int)0);
            return false;
        }
        IExpression elseOperand = this.m_caseStatement.getElseOperand();
        if (!this.validateOperand(elseOperand)) {
            MessageUtil.displayMessage((String)bundle.formatString("CaseStatementPanel.Error.InvalidElseOperand.txt", (Object)Integer.toString(255)), (int)0);
            return false;
        }
        if (!this.m_caseStatement.validateExpression()) {
            List badExpressions = this.m_caseStatement.getInvalidExpressionPositions();
            int[] rows = new int[badExpressions.size()];
            StringBuffer list = new StringBuffer();
            for (int i = 0; i < badExpressions.size(); ++i) {
                Integer row = (Integer)badExpressions.get(i);
                int value = row + 1;
                list.append(value);
                if (i < badExpressions.size() - 1) {
                    list.append(", ");
                }
                rows[i] = row;
            }
            MessageUtil.displayMessage((String)bundle.formatString("CaseStatementPanel.Error.InvalidOperand.txt", (Object)list.toString(), (Object)Integer.toString(255)), (int)0);
            this.m_caseTable.selectRows(rows);
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.updateComponents();
    }

    protected void updateActions() {
        int[] selectedRows = this.m_caseTable.getSelectedRowsFromSelectedCells();
        boolean firstRowSelected = false;
        boolean lastRowSelected = false;
        boolean rowsReorderable = this.m_caseTable.isRowsReorderable();
        for (int index = 0; index < selectedRows.length; ++index) {
            if (selectedRows[index] == 0) {
                firstRowSelected = true;
            }
            if (selectedRows[index] != this.m_caseTable.getRowCount() - 1) continue;
            lastRowSelected = true;
        }
        this.m_newAction.setEnabled(this.isEditable());
        this.m_deleteAction.setEnabled(this.isEditable() && selectedRows.length > 0);
        this.m_moveUpAction.setEnabled(this.isEditable() && selectedRows.length > 0 && !firstRowSelected && rowsReorderable);
        this.m_moveDownAction.setEnabled(this.isEditable() && selectedRows.length > 0 && !lastRowSelected && rowsReorderable);
        this.m_chooseValuesAction.setEnabled(this.isEditable());
    }

    private void updateComponents() {
        this.m_caseTable.setEnabled(this.isEditable());
    }

    public void updateWorkspaceUIComponents(boolean active) {
        super.updateWorkspaceUIComponents(active);
        this.m_newAction.setActive(active);
        this.m_deleteAction.setActive(active);
    }

    public void setInitialSelection() {
        if (this.m_caseTable.getRowCount() > 0) {
            this.m_caseTable.selectRow(0);
        }
    }

    public void setWAUndoManager(WAUndoManager undoManager) {
        super.setWAUndoManager(undoManager);
        this.m_caseTable.setUndoManager((UndoManager)undoManager);
    }

    public boolean ignoreCellEditing() {
        return this.m_ignoreCellEditing;
    }

    public void setOperand(String value) {
        if (value.equals(this.m_operandField.getText())) {
            return;
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            ITextOperand textOp = this.createTextOperand(value);
            this.m_operandField.setText(this.getTextFromOperand((IExpression)textOp));
            this.m_caseStatement.setCaseOperand((IExpression)textOp);
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
    }

    private void setOperandInModel(String value) {
        if (this.getTextFromOperand(this.m_caseStatement.getCaseOperand()).equals(value)) {
            return;
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            this.m_caseStatement.setCaseOperand((IExpression)this.createTextOperand(value));
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
    }

    private void setElseInModel(String value) {
        if (this.getTextFromOperand(this.m_caseStatement.getElseOperand()).equals(value)) {
            return;
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            this.m_caseStatement.setElseOperand((IExpression)this.createTextOperand(value));
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITextOperand createTextOperand(String text) {
        ITextOperand textOperand = null;
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            textOperand = this.m_caseStatement.getModel().getObjectFactory().createNewSQLTextOperand(this.m_caseStatement.getID(), this.m_clause.getParentQuery());
            ITextExpression operandExpression = this.m_caseStatement.getModel().getObjectFactory().createNewSQLTextExpression(textOperand.getID(), this.m_clause.getParentQuery());
            operandExpression.setUseSQLSyntax(true);
            ITable[] aSourceTables = this.m_clause.getParentQuery().getSourcesInFrom();
            ArrayList<IColumn> alCols = new ArrayList<IColumn>();
            for (int i = 0; i < aSourceTables.length; ++i) {
                alCols.addAll(Arrays.asList(aSourceTables[i].getColumns()));
            }
            ITable target = this.m_clause.getParentQuery().getTargetTable();
            if (target != null) {
                alCols.addAll(Arrays.asList(target.getColumns()));
            }
            operandExpression.setText(text, (IObject[])alCols.toArray(new IColumn[0]));
            textOperand.setTextExpression(operandExpression);
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
        return textOperand;
    }

    public String getElse() {
        return this.m_elseField.getText();
    }

    public void setElse(String value) {
        if (value.equals(this.m_elseField.getText())) {
            return;
        }
        this.m_caseStatement.getModel().startCompoundUndoable();
        try {
            this.m_elseField.setText(value);
            this.m_caseStatement.setElseOperand((IExpression)this.createTextOperand(value));
        }
        finally {
            this.m_caseStatement.getModel().endCompoundUndoable();
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_caseTable.saveSettings(this.getSettingsPrefix());
        this.m_operandField.removeActionListener((ActionListener)this.m_operandFieldListener);
        this.m_operandField.removeFocusListener((FocusListener)this.m_operandFieldListener);
        ((WsDefaultTableRowModel)this.m_caseTable.getRowModel()).removeRowModelListener((WsTableRowModelListener)this.m_caseTableRowModelListener);
        this.m_caseTable.getSelectionModel().removeListSelectionListener(this.m_caseTableSelectionListener);
        this.m_elseField.removeActionListener((ActionListener)this.m_operandFieldListener);
        this.m_elseField.removeFocusListener((FocusListener)this.m_operandFieldListener);
        this.m_caseStatement.getModel().removeModelListener(this.m_lsnrModel);
    }

    public String getSettingsPrefix() {
        return this.m_settingsPrefix;
    }

    public void setSettingsPrefix(String prefix) {
        this.m_settingsPrefix = prefix;
    }

    public void displayCaseStatement() {
        System.out.println("Saving:");
        IExpression operand = this.m_caseStatement.getCaseOperand();
        System.out.println("CASE " + (operand != null ? operand.toString() : ""));
        List expressions = this.m_caseStatement.getExpressionsAsList();
        for (int index = 0; expressions != null && index < expressions.size(); ++index) {
            ICaseExpression expression = (ICaseExpression)expressions.get(index);
            System.out.println("WHEN " + expression.getWhenOperand().toString() + " THEN " + expression.getThenOperand().toString());
        }
        IExpression elseOperand = this.m_caseStatement.getElseOperand();
        if (elseOperand != null && elseOperand.toString().length() > 0) {
            System.out.println("ELSE " + elseOperand.toString());
        }
    }

    private void selectExpressions(ICaseExpression[] expressions) {
        this.m_caseTable.stopCellEditing();
        this.m_caseTable.clearSelection();
        for (int expressionIndex = 0; expressionIndex < expressions.length; ++expressionIndex) {
            int rowIndex = this.m_caseTableModel.getIndexForExpression(expressions[expressionIndex]);
            if (rowIndex == -1) continue;
            this.m_caseTable.addRowToSelection(this.m_caseTable.convertRowIndexToView(rowIndex));
        }
    }

    protected void onSelectColumn() {
        TablesPaletteTreeModel mdlTableView = new TablesPaletteTreeModel(this.m_clause.getParentQuery().getSourcesInFrom(), new ITable[]{this.m_clause.getParentQuery().getTargetTable()});
        ColumnSelectorDialog csDialog = new ColumnSelectorDialog(mdlTableView);
        csDialog.setResizable(true);
        csDialog.show();
        if (csDialog.getReturnValue() == 1) {
            String name = csDialog.getSelectedTableColumnName();
            this.setOperand(name);
        }
    }

    private class CaseTableModel
    extends WsAbstractTableModel {
        protected static final int TOTAL_COLUMNS = 3;
        protected static final int HIDDEN_COLUMNS = 1;

        public CaseTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[3];
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(0);
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CaseStatementPanel.CaseTable.WhenColumn.txt"), 300);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CaseStatementPanel.CaseTable.ThenColumn.txt"), 300);
            this.m_aColumns[2] = new WsObjectTableColumn();
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void moveDataToModel() throws MdException, RemoteException {
            List expressions = CaseStatementPanel.this.m_caseStatement.getExpressionsAsList();
            if (expressions == null) {
                return;
            }
            for (int index = 0; index < expressions.size(); ++index) {
                ITextOperand thenOperand;
                ICaseExpression expression = (ICaseExpression)expressions.get(index);
                ArrayList<String> row = new ArrayList<String>();
                ITextOperand whenOperand = expression.getWhenOperand();
                if (whenOperand instanceof ITextOperand) {
                    String text = CaseStatementPanel.this.getTextFromOperand((IExpression)whenOperand);
                    row.add(text != null ? text : "");
                }
                if ((thenOperand = expression.getThenOperand()) instanceof ITextOperand) {
                    String text = CaseStatementPanel.this.getTextFromOperand((IExpression)thenOperand);
                    row.add(text != null ? text : "");
                }
                row.add((String)expression);
                this.m_lData.add(row);
            }
            this.fireTableModelPopulated();
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public int getColumnCount() {
            return this.m_aColumns.length - 1;
        }

        public List createDefaultRowValues() {
            List values = super.createDefaultRowValues();
            values.set(0, "");
            values.set(1, "");
            return values;
        }

        public Object getValueAt(int row, int column) {
            List expressions = CaseStatementPanel.this.m_caseStatement.getExpressionsAsList();
            ICaseExpression expression = (ICaseExpression)expressions.get(row);
            switch (column) {
                case 0: {
                    ITextOperand object = expression.getWhenOperand();
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof ICaseStatement) {
                        return bundle.getString("ExpressionPanel.Case.txt");
                    }
                    if (object instanceof ISubquery) {
                        return bundle.getString("ExpressionPanel.Subquery.txt");
                    }
                    if (object instanceof ITextOperand) {
                        return CaseStatementPanel.this.getTextFromOperand((IExpression)object);
                    }
                    return object.toString();
                }
                case 1: {
                    ITextOperand object = expression.getThenOperand();
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof ICaseStatement) {
                        return bundle.getString("ExpressionPanel.Case.txt");
                    }
                    if (object instanceof ISubquery) {
                        return bundle.getString("ExpressionPanel.Subquery.txt");
                    }
                    if (object instanceof ITextOperand) {
                        return CaseStatementPanel.this.getTextFromOperand((IExpression)object);
                    }
                    return object.toString();
                }
            }
            return super.getValueAt(row, column);
        }

        public void setValueAt(Object value, int row, int column) {
            this.updateCaseExpression(value, row, column);
            super.setValueAt(value, row, column);
            CaseStatementPanel.this.updateActions();
            CaseStatementPanel.this.updateComponents();
        }

        public void addExpression(ICaseExpression expression) {
            if (this.getIndexForExpression(expression) != -1) {
                return;
            }
            int iIndex = CaseStatementPanel.this.m_caseStatement.getExpressionsAsList().indexOf(expression);
            this.insertRow(iIndex - 1, this.createRowValues(expression));
        }

        private List createRowValues(ICaseExpression expression) {
            ArrayList<String> lValues = new ArrayList<String>();
            lValues.add(CaseStatementPanel.this.getTextFromOperand((IExpression)expression.getWhenOperand()));
            lValues.add(CaseStatementPanel.this.getTextFromOperand((IExpression)expression.getThenOperand()));
            lValues.add((String)expression);
            return lValues;
        }

        public void removeExpression(ICaseExpression expression) {
            int iIndex = this.getIndexForExpression(expression);
            if (iIndex != -1) {
                this.deleteRow(this.getIndexForExpression(expression));
            }
        }

        private int getIndexForExpression(ICaseExpression expression) {
            for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
                List lValues = (List)this.m_lData.get(iRow);
                if (lValues.get(2) != expression) continue;
                return iRow;
            }
            return -1;
        }

        public void addExpression(int index, List values) {
            ICaseExpression expression = CaseStatementPanel.this.m_caseStatement.getModel().getObjectFactory().createNewSQLCaseExpression(CaseStatementPanel.this.m_caseStatement.getID(), CaseStatementPanel.this.m_caseStatement);
            expression.setWhenOperand(CaseStatementPanel.this.createTextOperand((String)values.get(0)));
            expression.setThenOperand(CaseStatementPanel.this.createTextOperand((String)values.get(1)));
            CaseStatementPanel.this.m_caseStatement.addExpression(index + 1, expression);
            CaseStatementPanel.this.setDataChanged(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCaseExpression(Object value, int row, int column) {
            List expressions = CaseStatementPanel.this.m_caseStatement.getExpressionsAsList();
            ICaseExpression expression = (ICaseExpression)expressions.get(row);
            switch (column) {
                case 0: {
                    expression.getModel().startCompoundUndoable();
                    try {
                        expression.setWhenOperand(CaseStatementPanel.this.createTextOperand(value.toString()));
                        break;
                    }
                    finally {
                        expression.getModel().endCompoundUndoable();
                    }
                }
                case 1: {
                    expression.getModel().startCompoundUndoable();
                    try {
                        expression.setThenOperand(CaseStatementPanel.this.createTextOperand(value.toString()));
                        break;
                    }
                    finally {
                        expression.getModel().endCompoundUndoable();
                    }
                }
            }
            CaseStatementPanel.this.setDataChanged(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveExpression(int oldIndex, int newIndex) {
            CaseStatementPanel.this.m_caseStatement.getModel().startCompoundUndoable();
            try {
                List caseExpressions = CaseStatementPanel.this.m_caseStatement.getExpressionsAsList();
                ICaseExpression expression = (ICaseExpression)caseExpressions.remove(oldIndex);
                caseExpressions.add(newIndex, expression);
            }
            finally {
                CaseStatementPanel.this.m_caseStatement.getModel().endCompoundUndoable();
            }
        }

        public void loadDemoData() {
            CaseStatementPanel.this.m_operandField.setText("CUSTOMER.Country");
            String[][] data = new String[][]{{"'United States'", "'North America'"}, {"'China'", "'Asia'"}, {"'Brazil'", "'South America'"}, {"'Germany'", "'Europe'"}, {"'Australia'", "'Australia'"}};
            for (int i = 0; i < data.length; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 0; j < data[i].length; ++j) {
                    if (data[i][j] != null) {
                        row.add(data[i][j]);
                        continue;
                    }
                    row.add("");
                }
                this.m_lData.add(row);
            }
        }
    }

    protected class OperandFieldListener
    implements ActionListener,
    FocusListener {
        protected OperandFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == CaseStatementPanel.this.m_operandField) {
                CaseStatementPanel.this.m_caseStatement.setCaseOperand((IExpression)CaseStatementPanel.this.createTextOperand(CaseStatementPanel.this.m_operandField.getText()));
            } else if (source == CaseStatementPanel.this.m_elseField) {
                CaseStatementPanel.this.m_caseStatement.setElseOperand((IExpression)CaseStatementPanel.this.createTextOperand(CaseStatementPanel.this.m_elseField.getText()));
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Component source = event.getComponent();
            if (source == CaseStatementPanel.this.m_operandField) {
                CaseStatementPanel.this.setOperandInModel(CaseStatementPanel.this.m_operandField.getText());
            } else if (source == CaseStatementPanel.this.m_elseField) {
                CaseStatementPanel.this.setElseInModel(CaseStatementPanel.this.m_elseField.getText());
            }
        }
    }

    protected class ChooseColumnAction
    extends WsAbstractAction {
        public ChooseColumnAction() {
            super(bundle, "CaseStatementPanel.ChooseColumn", 0);
        }

        public void actionPerformed(ActionEvent e) {
            CaseStatementPanel.this.m_caseTable.stopCellEditing();
            CaseStatementPanel.this.onSelectColumn();
        }
    }

    protected class CaseTable
    extends WsTable {
        public CaseTable(WsAbstractTableModel model) {
            super(model);
        }

        protected void insertRowImpl(int row, List rowValues) {
            CaseStatementPanel.this.m_caseTableModel.addExpression(row, rowValues);
            super.insertRowImpl(row, rowValues);
            CaseStatementPanel.this.updateComponents();
        }

        protected void deleteRowImpl(int row) {
            CaseStatementPanel.this.m_caseStatement.getExpressionsAsList().remove(row);
            super.deleteRowImpl(row);
            CaseStatementPanel.this.updateComponents();
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)CaseStatementPanel.this.m_caseTable.getRowModel();
            mdlRows.clearRowMoves();
            int oldIndex = ev.getFromIndex();
            int newIndex = ev.getToIndex();
            if (!CaseStatementPanel.this.m_caseTable.stopCellEditing()) {
                return;
            }
            CaseStatementPanel.this.m_caseStatement.getModel().startCompoundUndoable();
            try {
                CaseStatementPanel.this.m_caseTable.clearSelection();
                ICaseExpression expression = (ICaseExpression)CaseStatementPanel.this.m_caseTableModel.getValueAt(oldIndex, 2);
                CaseStatementPanel.this.m_caseStatement.removeExpression(expression);
                CaseStatementPanel.this.m_caseStatement.addExpression(newIndex, expression);
                CaseStatementPanel.this.m_caseTable.selectRow(newIndex);
            }
            finally {
                CaseStatementPanel.this.m_caseStatement.getModel().endCompoundUndoable();
            }
        }

        public void rowsRemapped(ChangeEvent ev) {
            CaseStatementPanel.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private int m_runs = 0;

        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (this.m_runs++ < 2) {
                CaseStatementPanel.this.setInitialSelection();
            }
            CaseStatementPanel.this.updateActions();
        }
    }

    protected class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "CaseStatementPanel.MoveUp", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent e) {
            CaseStatementPanel.this.m_caseTable.undoableMoveSelectedRows(-1);
        }
    }

    protected class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "CaseStatementPanel.MoveDown", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent e) {
            CaseStatementPanel.this.m_caseTable.undoableMoveSelectedRows(1);
        }
    }

    protected class ChooseValuesAction
    extends WsAbstractAction {
        public ChooseValuesAction() {
            super(bundle, "CaseStatementPanel.ChooseValues.Import", 0);
        }

        public void actionPerformed(ActionEvent e) {
            List selValues;
            IExpression op = CaseStatementPanel.this.m_caseStatement.getCaseOperand();
            if (op == null || !(op instanceof ITextOperand)) {
                MessageUtil.displayMessage((String)bundle.getString("CaseStatementPanel.ColumnNotDetermined.Error.txt"), (int)0);
                return;
            }
            ITextOperand textOp = (ITextOperand)op;
            IColumn col = null;
            int i = 0;
            IObject[] aObject = textOp.getSources();
            int size = aObject.length;
            if (i < size) {
                col = (IColumn)aObject[i];
            }
            if (col == null) {
                MessageUtil.displayMessage((String)bundle.getString("CaseStatementPanel.ColumnNotDetermined.Error.txt"), (int)0);
                return;
            }
            if (col instanceof IReflectiveObject) {
                col = (IColumn)((IReflectiveObject)col).getOMRObject();
            }
            WsAppServer appServer = WsAppServer.createDefaultAppServer((boolean)true);
            if (col != null && appServer != null && (selValues = ChooseValuesPanel.showChooseValuesDialog(appServer, col, "sql_import_values")) != null) {
                CaseStatementPanel.this.createNewExpressionsFromValues(selValues);
            }
        }
    }

    protected class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "CaseStatementPanel.New", 0);
        }

        public void actionPerformed(ActionEvent e) {
            CaseStatementPanel.this.createNewExpression();
        }
    }

    protected class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "CaseStatementPanel.Delete", 0);
        }

        public void actionPerformed(ActionEvent e) {
            CaseStatementPanel.this.deleteSelectedExpressions();
        }
    }

    protected class AdvancedElseAction
    extends WsAbstractAction {
        public AdvancedElseAction() {
            super(bundle, "CaseStatementPanel.Advanced", 0);
        }

        public void actionPerformed(ActionEvent e) {
            String text = CaseStatementPanel.this.getElse();
            String newExpression = SQLExpressionActions.showExpressionBuilder(CaseStatementPanel.this.m_clause, text);
            if (newExpression != null) {
                CaseStatementPanel.this.setElse(newExpression);
            }
        }
    }

    protected class CaseModelListener
    implements IModelListener {
        protected CaseModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String sType = event.getType();
            if (sType.equalsIgnoreCase("CaseStatement:CaseOperandChanged")) {
                CaseStatementPanel.this.setOperand(CaseStatementPanel.this.getTextFromOperand(CaseStatementPanel.this.m_caseStatement.getCaseOperand()));
                CaseStatementPanel.this.setDataChanged(true);
                CaseStatementPanel.this.m_caseTable.repaint();
            } else if (sType.equalsIgnoreCase("CaseStatement:ElseOperandChanged")) {
                CaseStatementPanel.this.setElse(CaseStatementPanel.this.getTextFromOperand(CaseStatementPanel.this.m_caseStatement.getElseOperand()));
                CaseStatementPanel.this.setDataChanged(true);
                CaseStatementPanel.this.m_caseTable.repaint();
            } else if (sType.equalsIgnoreCase("CaseExpression:WhenOperandChanged")) {
                CaseStatementPanel.this.setDataChanged(true);
                CaseStatementPanel.this.m_caseTable.repaint();
            } else if (sType.equalsIgnoreCase("CaseExpression:ThenOperandChanged")) {
                CaseStatementPanel.this.setDataChanged(true);
                CaseStatementPanel.this.m_caseTable.repaint();
            } else if (sType.equalsIgnoreCase("Object:CaseExpressionAdded")) {
                CaseStatementPanel.this.m_caseTableModel.addExpression((ICaseExpression)event.getData());
                CaseStatementPanel.this.m_caseTable.repaint();
            } else if (sType.equalsIgnoreCase("Object:CaseExpressionRemoved")) {
                CaseStatementPanel.this.m_caseTableModel.removeExpression((ICaseExpression)event.getData());
                CaseStatementPanel.this.m_caseTable.repaint();
            }
        }
    }

    protected class AdvancedExpressionAction
    extends WsAbstractAction {
        public AdvancedExpressionAction() {
            super(bundle, "CaseStatementPanel.AdvancedMenu", 0);
        }

        public void actionPerformed(ActionEvent e) {
            int row = CaseStatementPanel.this.m_caseTable.getCurrentRow();
            int column = CaseStatementPanel.this.m_caseTable.getCurrentColumn();
            CaseStatementPanel.this.m_caseTable.stopCellEditing();
            String text = (String)CaseStatementPanel.this.m_caseTable.getValueAt(row, column);
            String newExpression = SQLExpressionActions.showExpressionBuilder(CaseStatementPanel.this.m_clause, text);
            if (newExpression != null) {
                CaseStatementPanel.this.m_caseTable.setValueAt((Object)newExpression, row, column);
            }
        }
    }

    private class SelectExpressionsUndoable
    extends AbstractUndoableEdit {
        private ICaseExpression[] m_undoExpressions;
        private boolean m_onUndo;
        private boolean m_onRedo;

        public SelectExpressionsUndoable(ICaseExpression expression, boolean onUndo, boolean onRedo) {
            this(new ICaseExpression[]{expression}, onUndo, onRedo);
        }

        public SelectExpressionsUndoable(ICaseExpression[] expressions, boolean onUndo, boolean onRedo) {
            this.m_undoExpressions = expressions;
            this.m_onUndo = onUndo;
            this.m_onRedo = onRedo;
        }

        @Override
        public void undo() {
            CaseStatementPanel.this.m_caseTable.stopCellEditing();
            super.undo();
            if (this.m_onUndo) {
                CaseStatementPanel.this.selectExpressions(this.m_undoExpressions);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_onRedo) {
                CaseStatementPanel.this.selectExpressions(this.m_undoExpressions);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_undoExpressions, null);
        }
    }

    protected class EnumeratedTableCellEditor
    extends WsDefaultCellEditor {
        protected WAComboBox m_comboBox = new WAComboBox();
        protected WsDefaultCellEditor.cEditorDelegate m_textFieldDelegate;
        protected WsDefaultCellEditor.cEditorDelegate m_comboBoxDelegate = new WsDefaultCellEditor.cComboBoxDelegate((WsDefaultCellEditor)this, (JComboBox)this.m_comboBox);

        public EnumeratedTableCellEditor() {
            this.m_comboBox.setEditable(true);
            this.initialize((JComboBox)this.m_comboBox, this.m_comboBoxDelegate);
            this.m_cmpEditor = this.m_comboBox;
            this.m_delegate = this.m_comboBoxDelegate;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean bSelected, int iRow, int iColumn) {
            this.m_delegate.setValue(value);
            return this.m_cmpEditor;
        }
    }

    protected class CenteredCellRenderer
    extends DefaultTableCellRenderer {
        public CenteredCellRenderer() {
            this.setHorizontalAlignment(0);
        }
    }
}

