/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLCreateStatement;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.wadmin.transforms.sql.editor.JoinEditorIcons;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsUIUtilities;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class ActionFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(ActionFactory.class);
    private static ActionFactory s_instance;

    private ActionFactory() {
    }

    public static ActionFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ActionFactory();
        }
        return s_instance;
    }

    public Action[] createClauseActions(IClause clause, boolean bEditable) {
        if (clause instanceof IJoin) {
            return this.createJoinActions((IJoin)clause, bEditable);
        }
        if (clause instanceof ISelectResultsContainer) {
            return this.createSelectActions((ISelectResultsContainer)clause, bEditable);
        }
        if (clause instanceof ISQLCreateStatement || clause instanceof IFromContainer) {
            return new Action[0];
        }
        return new Action[0];
    }

    public Action[] createSelectActions(ISelectResultsContainer select, boolean bEditable) {
        Action[] aActions = new Action[]{new DistinctAction(select), new SelectStarAction(select)};
        if (!bEditable) {
            this.disableActions(aActions);
        }
        return aActions;
    }

    public Action[] createJoinActions(IJoin join, boolean bEditable) {
        Action[] aActions = new Action[]{new SwapInputsAction(join), null, new InnerJoinAction(join), new FullJoinAction(join), new LeftJoinAction(join), new RightJoinAction(join), new CrossJoinAction(join), new UnionJoinAction(join), null, new ImplicitAction(join), new ParenthesesAction(join)};
        if (!bEditable) {
            this.disableActions(aActions);
        }
        return aActions;
    }

    public static void addActionsToPopupMenu(JPopupMenu menuPopup, Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) {
                menuPopup.addSeparator();
                continue;
            }
            if (aActions[iAction] instanceof WsAbstractToggleAction) {
                menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)((WsAbstractToggleAction)aActions[iAction])));
                continue;
            }
            menuPopup.add(aActions[iAction]);
        }
    }

    private void disableActions(Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) continue;
            aActions[iAction].setEnabled(false);
        }
    }

    private static class DistinctAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private ISelectResultsContainer m_select;

        public DistinctAction(ISelectResultsContainer select) {
            super(bundle, "ActionFactory.Action.SelectDistinct", 257);
            this.m_select = select;
            IQuery query = select.getParentQuery();
            this.setSelected(query.useDistinct());
        }

        public void actionPerformed(ActionEvent ev) {
            IQuery query = this.m_select.getParentQuery();
            query.setUseDistinct(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof ISelectResultsContainer)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SelectStarAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private ISelectResultsContainer m_select;

        public SelectStarAction(ISelectResultsContainer select) {
            super(bundle, "ActionFactory.Action.SelectStar", 257);
            this.m_select = select;
            IQuery query = this.m_select.getParentQuery();
            this.setSelected(query.useImplicit());
        }

        public void actionPerformed(ActionEvent ev) {
            IQuery query = this.m_select.getParentQuery();
            query.setUseImplicit(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof ISelectResultsContainer)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SwapInputsAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public SwapInputsAction(IJoin join) {
            super(bundle, "ActionFactory.Action.SwapInputs", 257);
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.swapLeftAndRightSides();
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class InnerJoinAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public InnerJoinAction(IJoin join) {
            super(bundle, "ActionFactory.Action.InnerJoin", 256);
            this.setIcon(JoinEditorIcons.getIcon("Inner"));
            this.setSelected(join.getJoinType().equals("Inner"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Inner");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class FullJoinAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public FullJoinAction(IJoin join) {
            super(bundle, "ActionFactory.Action.FullJoin", 256);
            this.setIcon(JoinEditorIcons.getIcon("Full"));
            this.setSelected(join.getJoinType().equals("Full"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Full");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class LeftJoinAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public LeftJoinAction(IJoin join) {
            super(bundle, "ActionFactory.Action.LeftJoin", 256);
            this.setIcon(JoinEditorIcons.getIcon("Left"));
            this.setSelected(join.getJoinType().equals("Left"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Left");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RightJoinAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public RightJoinAction(IJoin join) {
            super(bundle, "ActionFactory.Action.RightJoin", 256);
            this.setIcon(JoinEditorIcons.getIcon("Right"));
            this.setSelected(join.getJoinType().equals("Right"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Right");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CrossJoinAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public CrossJoinAction(IJoin join) {
            super(bundle, "ActionFactory.Action.CrossJoin", 256);
            this.setIcon(JoinEditorIcons.getIcon("Cross"));
            this.setSelected(join.getJoinType().equals("Cross"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Cross");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnionJoinAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public UnionJoinAction(IJoin join) {
            super(bundle, "ActionFactory.Action.UnionJoin", 256);
            this.setIcon(JoinEditorIcons.getIcon("Union"));
            this.setSelected(join.getJoinType().equals("Union"));
            this.m_join = join;
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setJoinType("Union");
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ImplicitAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public ImplicitAction(IJoin join) {
            super(bundle, "ActionFactory.Action.Implicit", 257);
            this.m_join = join;
            this.setSelected(join.useImplicit());
            this.setEnabled(join.getJoinType().equals("Inner"));
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setImplicit(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ParenthesesAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        private IJoin m_join;

        public ParenthesesAction(IJoin join) {
            super(bundle, "ActionFactory.Action.Parentheses", 257);
            this.m_join = join;
            this.setSelected(join.useParentheses());
            if (this.m_join.useImplicit()) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent ev) {
            this.m_join.setParentheses(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aObjects = context.getSelectedObjects();
            if (aObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aObjects.length; ++i) {
                Object obj = aObjects[i];
                if (!(obj instanceof IJoin)) continue;
                return true;
            }
            return false;
        }
    }
}

