/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class TableViewerPanel
extends WAPanel {
    protected WsTree m_treeTables;
    protected JScrollPane m_scrTablesTree;
    protected TableViewTreeModel m_mdlTableView;
    protected JCheckBox m_ckbSortColumns;
    private static WAdminResource bundle = WAdminResource.getBundle(TableViewerPanel.class);

    public TableViewerPanel(TableViewTreeModel mdlTableView) {
        this.m_mdlTableView = mdlTableView;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("select_column_win");
    }

    protected void initialize() {
        this.m_treeTables = this.createTablesTree();
        this.m_scrTablesTree = new JScrollPane((Component)this.m_treeTables);
        this.m_mdlTableView.addListenersToTree((JTree)this.m_treeTables);
        this.m_treeTables.getSelectionModel().setSelectionMode(1);
        this.m_ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"TableViewerPanel.Checkbox.SortColumns");
        this.m_ckbSortColumns.addActionListener(new cSortColumnsListener());
    }

    public void allowMultipleSelection() {
        this.m_treeTables.getSelectionModel().setSelectionMode(4);
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add(this.m_scrTablesTree, "Center");
        this.add(this.m_ckbSortColumns, "South");
    }

    public void setDefaultAction(Action actDefault) {
        this.m_treeTables.setUserDefaultAction((AbstractAction)actDefault);
    }

    protected WsTree createTablesTree() {
        WsTree treeTables = new WsTree((DefaultTreeModel)((Object)this.m_mdlTableView));
        treeTables.setScrollsOnExpand(true);
        treeTables.setPopupMenuEnabled(false);
        treeTables.setEditable(false);
        treeTables.setRootVisible(false);
        treeTables.setDraggingEnabled(true);
        return treeTables;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlTableView.moveDataToModel();
        this.m_treeTables.expand();
    }

    public void expand() {
        this.m_treeTables.expand();
    }

    public Column getSelectedColumn() {
        Column selobj = (Column)this.m_treeTables.getSelectedNode().getMetadata();
        return selobj;
    }

    public Column[] getSelectedColumns() {
        WsTreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        Column[] columns = new Column[aNodes.length];
        for (int i = 0; i < aNodes.length; ++i) {
            Column oColumn;
            columns[i] = oColumn = (Column)aNodes[i].getMetadata();
        }
        return columns;
    }

    public String getSelectedTableColumnName() {
        return this.getNodeColumnName(this.m_treeTables.getSelectedNode());
    }

    public WsTreeNode getSelectedNode() {
        return this.m_treeTables.getSelectedNode();
    }

    public void setSelectedNode(WsTreeNode nodeSelected) {
        this.m_treeTables.setSelectedNode(nodeSelected);
    }

    public String[] getSelectedTableColumnNames() {
        WsTreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        String[] s_tableAndColumnNames = new String[aNodes.length];
        for (int i = 0; i < aNodes.length; ++i) {
            s_tableAndColumnNames[i] = this.getNodeColumnName(aNodes[i]);
        }
        return s_tableAndColumnNames;
    }

    private String getNodeColumnName(WsTreeNode node) {
        return ((TableViewTreeModel.cColumnTreeNode)node).getTableColumn().getFullColumnName();
    }

    public boolean validateData() {
        String sErrorMessage = null;
        WsTreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        if (aNodes.length == 0) {
            sErrorMessage = bundle.getString("TableViewerPanel.NoColumnSelected.txt");
        } else {
            for (int i = 0; i < aNodes.length; ++i) {
                if (aNodes[i] instanceof TableViewTreeModel.cColumnTreeNode) continue;
                sErrorMessage = bundle.getString("TableViewerPanel.OnlyColumns.txt");
                break;
            }
        }
        if (sErrorMessage != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), sErrorMessage, bundle.getString("TableViewerPanel.Title.ErrorMessage.txt"), 0);
            return false;
        }
        return true;
    }

    public boolean isValidNode() {
        WsTreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        if (aNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < aNodes.length; ++i) {
            if (aNodes[i] instanceof TableViewTreeModel.cColumnTreeNode) continue;
            return false;
        }
        return true;
    }

    protected class cSortColumnsListener
    implements ActionListener {
        protected cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableViewerPanel.this.m_mdlTableView.setSortColumns(TableViewerPanel.this.m_ckbSortColumns.isSelected());
        }
    }
}

