/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.WorkTable;
import com.sas.services.ServiceException;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.properties.PhysicalTablePropertiesModel;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.metadata.WsMetadataPhysicalTableUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;

public class TablePropertiesModel
extends PhysicalTablePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TablePropertiesModel.class);
    protected static final int TABLEPROPERTYCOUNT = 17;
    protected int m_iOptions;
    protected int m_iCreateView;
    private static final String OPTIONSPROPERTY = bundle.getString("TablePropertiesModel.Property.Options.txt");
    protected static final String CREATEVIEWNAME = bundle.getString("TablePropertiesModel.Property.CreateView.txt");
    private TableInterface m_table;
    private QueryChangeListener m_lsnrSQLModel;
    protected WsAppServer m_WsAppServer = null;

    public TablePropertiesModel(TableInterface table) {
        this(table, null);
    }

    public TablePropertiesModel(TableInterface table, WsAppServer wsAppServer) {
        super((PhysicalTable)table.getDataTable());
        this.m_aTempValues = new Object[this.getNumberOfProperties()];
        this.m_table = table;
        this.m_WsAppServer = wsAppServer;
        this.m_lsnrSQLModel = new QueryModelListener();
        this.m_table.getSQLModel().addChangeListener(this.m_lsnrSQLModel);
        this.setProperty(this.m_iOptions, OPTIONSPROPERTY, table.getOptions(), TablePropertiesModel.getDefaultRenderer(), true, TablePropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iCreateView, CREATEVIEWNAME, this.m_table.isTableAView(), TablePropertiesModel.getDefaultBooleanRenderer());
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iTableName = 4;
        this.m_iCreateView = 5;
        this.m_iLibrary = 6;
        this.m_iDBMS = 7;
        this.m_iNumberOfRows = 8;
        this.m_iNumberOfColumns = 9;
        this.m_iLastModifiedBy = 10;
        this.m_iDateUpdated = 11;
        this.m_iDateCreated = 12;
        this.m_iOptions = 13;
        this.m_iLogicalType = 14;
        this.m_iMetadataID = 15;
        this.m_iUsageVersion = 16;
    }

    @Override
    public int getNumberOfProperties() {
        return 17;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iOptions) {
            this.m_table.setOptions((String)value);
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        this.m_aTempValues[this.m_iOptions] = this.m_table.getOptions();
        this.m_aTempValues[this.m_iCreateView] = this.m_table.isTableAView();
    }

    protected int getRowCount(PhysicalTable table) throws MdException, RemoteException, WsAppServerFailException, WsAppServerLibraryException, SQLException, WsAppServerCodeException {
        if (table instanceof WorkTable) {
            return WsMetadataPhysicalTableUtil.getRowCount((PhysicalTable)table, (WsAppServer)this.m_WsAppServer, (ParametersInterface)new ParametersModel());
        }
        return WsMetadataPhysicalTableUtil.getRowCount((PhysicalTable)table, (ParametersInterface)new ParametersModel());
    }

    protected void handleChange(String sAction) {
        if (sAction.equals("OptionsChanged")) {
            this.setPropertyValueImpl(this.m_iOptions, this.m_table.getOptions());
        }
    }

    public void dispose() {
        this.m_table.getSQLModel().removeChangeListener(this.m_lsnrSQLModel);
    }

    private class QueryModelListener
    implements QueryChangeListener {
        private QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            if (ev.getTable() != TablePropertiesModel.this.m_table) {
                return;
            }
            String sAction = ev.getAction();
            if (sAction == null) {
                return;
            }
            TablePropertiesModel.this.handleChange(sAction);
        }
    }
}

