/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.UniqueKey;
import com.sas.services.ServiceException;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.visuals.properties.ColumnPropertiesModel;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import java.text.NumberFormat;

public class TableColumnPropertiesModel
extends ColumnPropertiesModel {
    protected TableColumn m_column;
    protected AbstractTable m_table;
    private QueryChangeListener m_lsnrSQLModel;

    public TableColumnPropertiesModel(TableColumn col) {
        super(col.getColumn());
        this.m_column = col;
        this.m_table = col.getParent();
        this.m_lsnrSQLModel = new QueryModelListener();
        this.m_column.getSQLModel().addChangeListener(this.m_lsnrSQLModel);
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        Column col = this.m_column.getColumn();
        if (col != null) {
            super.loadPropertyValues();
        }
        NumberFormat nf = NumberFormat.getIntegerInstance();
        boolean hasUniqueKey = false;
        boolean hasIndex = false;
        if (col != null) {
            AssociationList lKeys = col.getKeys();
            for (int i = 0; i < lKeys.size(); ++i) {
                UniqueKey uniqueKey;
                Key key = (Key)lKeys.get(i);
                if (!(key instanceof UniqueKey) || (uniqueKey = (UniqueKey)key).getIsPrimary() != 1) continue;
                hasUniqueKey = true;
            }
            AssociationList lIndexes = col.getIndexes();
            if (lIndexes.size() > 0) {
                hasIndex = true;
            }
        }
        this.m_aTempValues[this.m_iName] = this.m_column.getName();
        this.m_aTempValues[this.m_iSASColumnName] = this.m_column.getName();
        this.m_aTempValues[this.m_iDescription] = this.m_column.getDescription();
        this.m_aTempValues[this.m_iSASColumnLength] = nf.format(this.m_column.getLength());
        this.m_aTempValues[this.m_iType] = WsColumnMetadataUtil.getColumnViewTypeString((String)this.m_column.getType());
        this.m_aTempValues[this.m_iInformat] = this.m_column.getInformat();
        this.m_aTempValues[this.m_iFormat] = this.m_column.getFormat();
        this.m_aTempValues[this.m_iIsNullable] = this.m_column.getIsNullable();
        this.m_aTempValues[this.m_iPrimaryKey] = hasUniqueKey;
        this.m_aTempValues[this.m_iIndex] = hasIndex;
    }

    protected void handleChange(String sAction) {
    }

    public void dispose() {
        this.m_table.getSQLModel().removeChangeListener(this.m_lsnrSQLModel);
    }

    private class QueryModelListener
    implements QueryChangeListener {
        private QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            if (ev.getTable() != TableColumnPropertiesModel.this.m_table) {
                return;
            }
            String sAction = ev.getAction();
            if (sAction == null) {
                return;
            }
            TableColumnPropertiesModel.this.handleChange(sAction);
        }
    }
}

