/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.ResultMapping;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SQLTargetColumnsTableModel
extends TransformationTargetColumnsTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(SQLTargetColumnsTableModel.class);
    private SelectResults m_select;
    protected TableModelListener m_lsnrTableModel;
    private boolean m_eventsEnabled = true;
    public static final int TABLECOLUMN_COLUMN = 14;
    public static final int RESULTMAPPING_COLUMN = 15;
    protected static final int SQL_HIDDEN_COLUMNS = 5;
    public static String CASE_LABEL = bundle.getString("SQLMappingsPropertyTab.CASE.txt");
    public static String SUBQUERY_LABEL = bundle.getString("SQLMappingsPropertyTab.Subquery.txt");

    public SQLTargetColumnsTableModel(SelectResults select) {
        this.m_select = select;
        this.m_lsnrTableModel = this.createTableModelListener();
        this.addTableModelListener(this.m_lsnrTableModel);
    }

    @Override
    protected void createColumnDefinitions() {
        super.createColumnDefinitions();
        this.m_aColumns[14] = new WsObjectTableColumn();
        this.m_aColumns[15] = new WsObjectTableColumn();
    }

    @Override
    public int getHiddenColumnCount() {
        return 5;
    }

    public Object getValueAt(int iRow, int iCol) {
        Object obj = super.getValueAt(iRow, iCol);
        if (iCol == 1 && obj != null) {
            if (obj instanceof CaseStatement) {
                return CASE_LABEL;
            }
            if (obj instanceof SubQuery) {
                return SUBQUERY_LABEL;
            }
        }
        return obj;
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        this.m_select.getSQLModel().setFireEventsEnabled(false);
        String sNone = WsColumnMetadataUtil.NONE;
        this.clear();
        TargetTable target = this.m_select.getTargetTable();
        int size = target.getTableColumns().size();
        for (int i = 0; i < size; ++i) {
            TableColumn tCol = (TableColumn)target.getTableColumns().get(i);
            ResultMapping rMap = this.m_select.findTargetResultMapping(tCol);
            int eMappingType = 0;
            String sTransformRole = rMap.getRole();
            eMappingType = sTransformRole.equalsIgnoreCase("ONETOONE") ? 1 : (sTransformRole.equalsIgnoreCase("DERIVED") ? 2 : (sTransformRole.equalsIgnoreCase("UNMAPPED") ? 0 : -1));
            OperandInterface operand = rMap.getDerivedExpression();
            Object sExpression = "";
            if (operand instanceof CaseStatement || operand instanceof SubQuery) {
                sExpression = operand;
            }
            if (operand instanceof TextOperand) {
                sExpression = ((TextOperand)operand).getFullNamedText();
            }
            String sInformat = tCol.getInformat();
            String sFormat = tCol.getFormat();
            ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(tCol.getName());
            alRow.add(sExpression);
            alRow.add(tCol.getDescription());
            alRow.add(tCol.getParent().getDisplayTableName());
            alRow.add(tCol.getParent().getDataTable().getDesc());
            alRow.add(new Boolean(false));
            alRow.add(SQLTargetColumnsTableModel.getViewMappingTypeString(eMappingType));
            alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((String)tCol.getType()));
            alRow.add(new Integer(tCol.getLength()));
            alRow.add(sInformat.length() == 0 ? sNone : sInformat);
            alRow.add(sFormat.length() == 0 ? sNone : sFormat);
            alRow.add(tCol.getColumn());
            alRow.add(rMap.getFeatureMap());
            alRow.add(new Boolean(tCol.getIsNullable()));
            alRow.add(tCol);
            alRow.add(rMap);
            this.m_lData.add(alRow);
        }
        int nDataTables = this.m_lDataTables.size();
        String[] saDataTables = new String[nDataTables];
        for (int iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(iDataTable);
            saDataTables[iDataTable] = SQLTargetColumnsTableModel.getDataTableDisplayName(oDataTable);
        }
        WsEnumeratedTableColumn colTableName = (WsEnumeratedTableColumn)this.m_aColumns[3];
        if (nDataTables > 0) {
            colTableName.setPossibleValues(saDataTables);
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(0);
            WsStringTableColumn colTableDescr = (WsStringTableColumn)this.m_aColumns[4];
            colTableDescr.setDefaultValue(oDataTable.getDesc());
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size();
        this.m_select.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int iColumn = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
            this.updateColumn(iColumn);
        }
    }

    public boolean validateColumnNameUniqueness(TableColumn testColumn, int iTestRow) {
        boolean bCaseSensitive = false;
        try {
            bCaseSensitive = DBMSNamesPropertyHandler.needQuotes((DataTable)testColumn.getParent().getDataTable()) || DBMSNamesPropertyHandler.needQuotes((DataTable)this.m_select.getTargetDataTable());
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            TableColumn tColumn;
            if (iRow == iTestRow || !(tColumn = (TableColumn)this.getValueAt(iRow, 14)).isNameIdentical(testColumn, bCaseSensitive)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getRowValuesForColumn(Column oColumn, DataTable oTable) {
        try {
            List lRowValues = super.getRowValuesForColumn(oColumn, oTable);
            TargetTable target = this.m_select.getTargetTable();
            TableColumn tableColumn = new TableColumn(oColumn.getSASColumnName(), (AbstractTable)target);
            tableColumn.copyAttributesFromColumn(oColumn);
            lRowValues.add(tableColumn);
            ResultMapping rMap = new ResultMapping(new ArrayList(), tableColumn, null, "UNMAPPED", this.m_select);
            this.m_select.getResultMappings().add(rMap);
            lRowValues.add(rMap);
            return lRowValues;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public List createRowValuesFromColumn(TableColumn oNewColumn, int insertLocation) {
        List lRowValues = this.createDefaultRowValues();
        String sNone = WsColumnMetadataUtil.NONE;
        String sInformat = oNewColumn.getInformat();
        String sFormat = oNewColumn.getFormat();
        lRowValues.set(0, oNewColumn.getName());
        lRowValues.set(2, oNewColumn.getDescription());
        lRowValues.set(7, WsColumnMetadataUtil.getColumnViewTypeString((String)oNewColumn.getType()));
        lRowValues.set(8, new Integer(oNewColumn.getLength()));
        lRowValues.set(3, this.m_select.getTargetTable().getDataTableName());
        lRowValues.set(9, sInformat.length() == 0 ? sNone : sInformat);
        lRowValues.set(10, sFormat.length() == 0 ? sNone : sFormat);
        lRowValues.set(13, new Boolean(oNewColumn.getIsNullable()));
        TargetTable target = this.m_select.getTargetTable();
        TableColumn tableColumn = new TableColumn(oNewColumn.getName(), (AbstractTable)target);
        target.getTableColumns().add(insertLocation + 1, tableColumn);
        lRowValues.set(14, tableColumn);
        ResultMapping rMap = new ResultMapping(new ArrayList(), tableColumn, null, "UNMAPPED", this.m_select);
        this.m_select.getResultMappings().add(rMap);
        lRowValues.set(15, rMap);
        return lRowValues;
    }

    @Override
    public Column updateColumn(int iColumn) {
        ResultMapping rMap;
        String sNone = WsColumnMetadataUtil.NONE;
        String sName = (String)this.getValueAt(iColumn, 0);
        TableColumn tableColumn = (TableColumn)this.getValueAt(iColumn, 14);
        if (tableColumn == null) {
            this.m_eventsEnabled = false;
            TargetTable target = this.m_select.getTargetTable();
            tableColumn = new TableColumn(sName, (AbstractTable)target);
            target.getTableColumns().add(iColumn, tableColumn);
            this.setValueAt(tableColumn, iColumn, 14);
            this.m_eventsEnabled = true;
        }
        if ((rMap = (ResultMapping)this.getValueAt(iColumn, 15)) == null) {
            this.m_eventsEnabled = false;
            rMap = new ResultMapping(new ArrayList(), tableColumn, null, "UNMAPPED", this.m_select);
            this.m_select.getResultMappings().add(rMap);
            this.setValueAt(rMap, iColumn, 15);
            this.m_eventsEnabled = true;
        }
        tableColumn.setName(sName);
        String sDescription = (String)this.getValueAt(iColumn, 2);
        tableColumn.setDescription(sDescription);
        String sViewType = (String)this.getValueAt(iColumn, 7);
        tableColumn.setType(WsColumnMetadataUtil.convertColumnTypeToData((String)sViewType));
        Integer iLength = (Integer)this.getValueAt(iColumn, 8);
        tableColumn.setLength(iLength);
        String sInformat = (String)this.getValueAt(iColumn, 9);
        if (sInformat.equalsIgnoreCase(sNone)) {
            sInformat = "";
        }
        tableColumn.setInformat(sInformat);
        String sFormat = (String)this.getValueAt(iColumn, 10);
        if (sFormat.equalsIgnoreCase(sNone)) {
            sFormat = "";
        }
        tableColumn.setFormat(sFormat);
        Boolean isNullable = (Boolean)this.getValueAt(iColumn, 13);
        tableColumn.setIsNullable(isNullable);
        return null;
    }

    public void setTableChangeEnable(boolean enabled) {
        this.m_eventsEnabled = enabled;
    }

    public void replaceOperand(List values, int row, int column) {
        int nOperands = values.size();
        if (nOperands < 1) {
            return;
        }
        StringBuffer sbText = new StringBuffer();
        for (int i = 0; i < nOperands; ++i) {
            if (i > 0) {
                sbText.append("  ");
            }
            sbText.append((String)values.get(i));
        }
        switch (column) {
            case 1: {
                this.setValueAt(sbText.toString(), row, column);
            }
        }
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (SQLTargetColumnsTableModel.this.m_eventsEnabled) {
                if (e.getType() != -1) {
                    SQLTargetColumnsTableModel.this.updateColumn(e.getLastRow());
                }
                SQLTargetColumnsTableModel.this.m_select.getSQLModel().fireChangeEvent("selectChanged");
            }
        }
    }
}

