/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class SQLCodegen {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLCodegen.class);

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        TransformationStep transStep = (TransformationStep)classifierMap.getSteps().get(0);
        SQLModel model = new SQLModel(transStep, cgReq);
        model.moveDataToModel();
        SQLCodegen.generateCode(cgReq, classifierMap, model, false);
        SQLCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    public static void generateCode(CodegenRequest cgReq, ClassifierMap classifierMap, SQLModel model, boolean initializeCodegenRequest) throws MdException, RemoteException {
        model.genSQL(initializeCodegenRequest);
    }

    private static void genCodeConditionCheck(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        if (alTriggeredEvents.isEmpty()) {
            return;
        }
        cgReq.addCommentLine(bundle.getString("SQLCodegen.RCCheck.msg.txt"));
        cgReq.addSourceCode("%macro etls_sqlRcCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            String eventRole = lEvent.getEventRole();
            if (!eventRole.equals("Condition1") && !eventRole.equals("Condition2") && !eventRole.equals("Condition3")) continue;
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n\n").indent();
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)oStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend etls_sqlRcCheck; \n").addSourceCode("%etls_sqlRcCheck; \n\n");
    }
}

