/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.ProcessDetailEventListener;
import com.sas.wadmin.pfd.ProcessEventListener;
import com.sas.wadmin.plugins.TransformNoPostIndexAndConstraintCreationInterface;
import com.sas.wadmin.plugins.TransformVersionInterface;
import com.sas.wadmin.plugins.TransformViewInterface;
import com.sas.wadmin.transforms.sql.SQLCodegen;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.visuals.AbstractTransform;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsViewFactory;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.event.ChangeEvent;

public class SQL
extends AbstractTransform
implements ProcessEventListener,
ProcessDetailEventListener,
TransformViewInterface,
TransformNoPostIndexAndConstraintCreationInterface,
TransformVersionInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(SQL.class);
    private ImageIcon m_icon;
    private String m_tooltip;
    private String m_description;
    private String m_name;
    private String m_category;
    private String m_class;
    private static final String ROLE = "SQL";

    public SQL() {
        String className = this.getClass().getName();
        this.m_class = className.substring(className.lastIndexOf(".") + 1);
        this.m_stepView = "com.sas.wadmin.transforms.sql.SQLTransformationStepView";
        this.m_name = bundle.getString(this.m_class + ".Name.txt");
        this.m_description = bundle.getString(this.m_class + ".Description.txt");
        this.m_category = bundle.getString(this.m_class + ".Category.txt");
        this.m_icon = bundle.getImageIcon(this.m_class + ".Transform.image");
        this.m_tooltip = bundle.getString(this.m_class + ".ToolTip.txt");
    }

    @Override
    public void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        SQLCodegen.executeUtility(cgReq, classifierMap);
    }

    @Override
    public String getXML() {
        String sSourceName = bundle.getString("SQL.InputTemplateName.txt");
        String sSourceDesc = bundle.getString("SQL.InputTemplateDesc.txt");
        String sTargetName = bundle.getString("SQL.OutputTemplateName.txt");
        String sTargetDesc = bundle.getString("SQL.OutputTemplateDesc.txt");
        String sXML = "<TransformationStep Name=\"" + bundle.getString(this.m_class + ".TransformationStepName.txt") + "\" TransformRole=\"" + ROLE + "\"><UsingPrototype><Prototype Name=\"PFDTEMPLATE\" ><PrototypeProperties><AssociationProperty Name=\"" + sSourceName + "\" MetadataType=\"INPUT\" Desc=\"" + sSourceDesc + "\" AssociationName=\"ClassifierSources\" Minimum=\"1\" IsVisible=\"1\"/><AssociationProperty Name=\"" + sTargetName + "\" MetadataType=\"OUTPUT\" Desc=\"" + sTargetDesc + "\" AssociationName=\"ClassifierTargets\" Maximum=\"1\" Minimum=\"1\" IsVisible=\"1\"/></PrototypeProperties></Prototype></UsingPrototype><Properties><Property Name=\"Class\" PropertyName=\"Class\" DefaultValue=\"com.sas.wadmin.transforms.sql.SQL\"><OwningType><PropertyType Name=\"String\" SQLType=\"" + 12 + "\" /></OwningType></Property></Properties><PropertySets><PropertySet Name=\"AUTOMAP\"><Extensions><Extension Name=\"AUTOMAP\" Value=\"on\" /></Extensions></PropertySet></PropertySets><Transformations><ClassifierMap Name=\"" + this.m_name + "\" TransformRole =\"" + ROLE + "\" IsActive=\"1\" ><ClassifierTargets><WorkTable Name=\"" + bundle.getString("SQL.WorkTableName.txt") + "\" MemberType=\"" + this.getMemberTypeTargetDefault() + "\" /></ClassifierTargets></ClassifierMap></Transformations></TransformationStep>";
        return sXML;
    }

    @Override
    public String getRemoveXML() {
        String sRemoveXML = "<TransformationStep><UsingPrototype><Prototype><PrototypeProperties><AssociationProperty/></PrototypeProperties></Prototype></UsingPrototype><SuccessorDependencies/><PredecessorDependencies/><Extensions><Extension/></Extensions><PrimaryPropertyGroup><PropertyGroup><Properties><Property/></Properties></PropertyGroup></PrimaryPropertyGroup><SourceCode><TextStore/></SourceCode><Properties/><PropertySets><PropertySet><Properties/><SetProperties/></PropertySet></PropertySets><Transformations><ClassifierMap><PropertySets><PropertySet><SetProperties/><Properties/></PropertySet></PropertySets><Properties/><FeatureMaps/><ClassifierTargets><WorkTable><Columns><Column><SourceFeatureMaps/></Column></Columns></WorkTable></ClassifierTargets><TriggeredEvents><Event><PropertySets><PropertySet><SetProperties><Property><TargetTransformations><FeatureMap><SubstitutionVariables/><SourceCode/><TransformationSources/></FeatureMap></TargetTransformations></Property></SetProperties></PropertySet></PropertySets><SourceTransformations><FeatureMap><SubstitutionVariables/><SourceCode/></FeatureMap><Transformation><SubstitutionVariables/><SourceCode/></Transformation></SourceTransformations></Event></TriggeredEvents><TransformationTargets><PhysicalTable><PropertySet/></PhysicalTable></TransformationTargets></ClassifierMap><TriggeredEvents/></Transformations><TriggeredEvents><Event><PropertySets><PropertySet><SetProperties/><Properties/></PropertySet></PropertySets><Properties/></Event></TriggeredEvents></TransformationStep>";
        return sRemoveXML;
    }

    @Override
    public String getCopyXML() {
        String sCopyXML = "<TransformationStep><UsingPrototype><Prototype><PrototypeProperties/></Prototype></UsingPrototype><SourceCode/><SuccessorDependencies/><PredecessorDependencies/><Properties/><PropertySets><PropertySet><Properties/><SetProperties/></PropertySet></PropertySets><Transformations><ClassifierMap><ClassifierTargets><WorkTable/></ClassifierTargets></ClassifierMap></Transformations></TransformationStep>";
        return sCopyXML;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public Icon getIcon() {
        return this.m_icon;
    }

    @Override
    public String getToolTip() {
        return this.m_tooltip;
    }

    @Override
    public String getCategory() {
        return this.m_category;
    }

    @Override
    public JInternalFrame displayProperties(CMetadata metadataObject) {
        return WsViewFactory.showPropertyView((CMetadata)metadataObject, (String)this.m_stepView, (ClassLoader)this.getClass().getClassLoader()).getFrame();
    }

    @Override
    public void onAdd(ChangeEvent e) {
    }

    @Override
    public void onDelete(ChangeEvent e, CMetadata object) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void onBeforeDelete(ChangeEvent e) {
        try {
            List lObjects = (List)e.getSource();
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                TransformationStep mdTS;
                Object object = lObjects.get(iObject);
                if (object instanceof DataTable) {
                    try {
                        DataTable table = (DataTable)object;
                        AssociationList lCMs = table.getSourceClassifierMaps(false);
                        for (int i = 0; i < lCMs.size(); ++i) {
                            Root cM = (Root)lCMs.get(i);
                            if (!cM.getCMetadataType().equalsIgnoreCase("ClassifierMap") || !((ClassifierMap)cM).getTransformRole().equalsIgnoreCase(ROLE)) continue;
                            AssociationList transSrcs = ((ClassifierMap)cM).getTransformationSources();
                            if (!transSrcs.isEmpty()) {
                                AssociationList lSteps = ((ClassifierMap)cM).getSteps(false);
                                if (lSteps.isEmpty()) continue;
                                TransformationStep mdTS2 = (TransformationStep)lSteps.get(0);
                                SQLModel model = new SQLModel(mdTS2);
                                model.moveDataToModel();
                                SQLStatementInterface statement = model.getStatement();
                                List srcTables = statement.findAllSourceTables(table);
                                for (int j = 0; j < srcTables.size(); ++j) {
                                    SourceTable source = (SourceTable)srcTables.get(j);
                                    ClauseInterface parent = source.getParent();
                                    if (parent instanceof Join) {
                                        Join join = (Join)parent;
                                        SourceTableInterface leftSide = join.getLeftSide();
                                        SourceTableInterface rightSide = join.getRightSide();
                                        SourceTableInterface src = null;
                                        if (leftSide == source) {
                                            src = rightSide;
                                        } else if (rightSide == source) {
                                            src = leftSide;
                                        }
                                        source.remove();
                                        if (src != null) {
                                            Query query = join.getParentQuery();
                                            query.replaceSource(join, src);
                                        }
                                        join.remove();
                                        continue;
                                    }
                                    source.remove();
                                }
                                if (srcTables.isEmpty()) continue;
                                model.moveDataToStore();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
                if (!(object instanceof TransformationStep) || !(mdTS = (TransformationStep)object).getTransformRole().equals(ROLE)) continue;
                SQLModel model = new SQLModel(mdTS);
                try {
                    model.setRunDefaultRelationships(false);
                    model.moveDataToModel();
                    model.dispose();
                    continue;
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public String getMemberTypeTargetDefault() {
        return "VIEW";
    }

    @Override
    public int getNumberOfTargetViewsSupported() {
        return 1;
    }

    @Override
    public String getViewPropertyName() {
        return null;
    }

    @Override
    public int getVersionNumber() {
        return 2;
    }
}

