/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.pfd.ClauseNode;
import com.sas.wadmin.transforms.sql.pfd.QueryPFDModel;
import com.sas.wadmin.transforms.sql.pfd.TableNode;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import com.sas.workspace.visuals.pfd.WsPFDPropertyTab;
import com.sas.workspace.visuals.pfd.WsPFDSelectionListener;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class QueryTab
extends WsPFDPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryTab.class);
    private static String SHOW_COLUMNS_KEY = "QueryTab.ShowColumns";
    private QueryPFDModel m_mdlPFD;
    private Query m_mdlQuery;
    private WsAbstractAction m_actSQL;
    private WsAbstractToggleAction m_actShowColumns;
    private WsAbstractAction m_actSubmit;
    private WsAbstractAction m_actSubmitValidate;
    private WsAbstractAction m_actKill;
    private WsAbstractAction m_actCancel;
    private WsAbstractToggleAction m_actRunAllPrior;

    public QueryTab(Query query) {
        this.m_mdlQuery = query;
        this.m_mdlPFD.setQueryModel(query);
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_create");
    }

    protected void createComponents() {
        super.createComponents();
    }

    protected JPopupMenu createPrimitivePopupMenu(PFDPrimitive prim) {
        JPopupMenu menuPopup = new JPopupMenu();
        if (prim instanceof WsPFDPrimitive) {
            ((WsPFDPrimitive)prim).addPopupMenuItems(menuPopup);
        }
        if (prim instanceof TableNode) {
            menuPopup.addSeparator();
            menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowColumns));
        }
        this.addCommonPopupMenuItems(menuPopup);
        return menuPopup;
    }

    protected void addCanvasPopupMenuItems(JPopupMenu menuPopup) {
        super.addCanvasPopupMenuItems(menuPopup);
        menuPopup.addSeparator();
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowColumns));
        menuPopup.addSeparator();
        if (this.m_actSubmit != null) {
            menuPopup.add((Action)this.m_actSubmit);
        }
        if (this.m_actSubmitValidate != null) {
            menuPopup.add((Action)this.m_actSubmitValidate);
        }
        if (this.m_actCancel != null) {
            menuPopup.add((Action)this.m_actCancel);
        }
        if (this.m_actKill != null) {
            menuPopup.add((Action)this.m_actKill);
        }
        if (this.m_actRunAllPrior != null) {
            menuPopup.addSeparator();
            boolean fState = this.m_mdlQuery.getSQLModel().getRunPriorSteps();
            this.m_actRunAllPrior.setSelected(fState);
            menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actRunAllPrior));
            WorkspaceMenuSupport menusupport = Workspace.getWorkspace().getMenuObject();
            if (menusupport != null) {
                menusupport.getMenuBar().setSelectedItemsState("submitpriorsteps", fState);
            }
        }
    }

    protected WsPFDModel createPFDModel() {
        this.m_mdlPFD = new QueryPFDModel();
        this.m_mdlPFD.setShowColumns(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_COLUMNS_KEY, false));
        return this.m_mdlPFD;
    }

    protected void layoutComponents() {
        super.layoutComponents();
    }

    protected void createActions() {
        super.createActions();
        this.m_actSQL = new SQLAction();
        this.m_actShowColumns = new ShowColumnsAction();
    }

    public void setDefaultAction(Action actDefault) {
        this.m_mdlPFD.setDefaultAction(actDefault);
    }

    public void setSubmitAction(WsAbstractAction actSubmit) {
        this.m_actSubmit = actSubmit;
    }

    public void setRunAllPrior(WsAbstractToggleAction runAll) {
        this.m_actRunAllPrior = runAll;
    }

    public void setSubmitValidateAction(WsAbstractAction actSubmitValidation) {
        this.m_actSubmitValidate = actSubmitValidation;
    }

    public void setKillAction(WsAbstractAction actKill) {
        this.m_actKill = actKill;
    }

    public void setCancelAction(WsAbstractAction actCancel) {
        this.m_actCancel = actCancel;
    }

    public Action getDefaultAction() {
        return this.m_mdlPFD.getDefaultAction();
    }

    protected String getDefaultZoomKey() {
        return "QueryTab.Zoom";
    }

    protected String getDefaultLayoutKey() {
        return "QueryTab.Layout";
    }

    protected String getDefaultBackgroundKey() {
        return "QueryTab.Background";
    }

    protected int getInitialDefaultLayout() {
        return 1;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlPFD.moveDataToModel();
        this.getPFDComponent().updateLayout();
        this.setPrintJobTitle(this.m_mdlQuery.getName());
        this.setGIFFileName(this.m_mdlQuery.getName());
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public boolean validateData() {
        return this.m_mdlQuery.validateData();
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actSQL.setActive(bActive);
        this.m_actShowColumns.setActive(bActive);
        this.m_actSubmit.setActive(bActive);
        this.m_actSubmitValidate.setActive(bActive);
        this.m_actCancel.setActive(bActive);
        this.m_actKill.setActive(bActive);
        this.m_actRunAllPrior.setActive(bActive);
        if (this.m_actSubmit.isEnabled() || this.m_actSubmitValidate.isEnabled()) {
            this.m_actKill.setEnabled(false);
            this.m_actCancel.setEnabled(false);
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_mdlPFD.dispose();
    }

    public void addSelectionListener(WsPFDSelectionListener lsnr) {
        this.getPFDComponent().getSelectionModel().addSelectionListener(lsnr);
    }

    public void removeSelectionListener(WsPFDSelectionListener lsnr) {
        this.getPFDComponent().getSelectionModel().removeSelectionListener(lsnr);
    }

    public void setSelectedClause(ClauseInterface clause) {
        this.getPFDComponent().removeAllPrimitivesFromSelection();
        PFDAbstractNode node = this.m_mdlPFD.getKeyedNode(clause);
        if (node != null) {
            this.getPFDComponent().addPrimitiveToSelection((PFDPrimitive)node);
        }
    }

    public ClauseInterface getSelectedClause() {
        PFDPrimitive[] aSelectedPrimitives = this.getPFDComponent().getSelectedPrimitives();
        if (aSelectedPrimitives.length == 0) {
            return null;
        }
        if (aSelectedPrimitives[0] instanceof ClauseNode) {
            return ((ClauseNode)aSelectedPrimitives[0]).getClause();
        }
        return null;
    }

    public void setSelectedTable(TableInterface table) {
        this.getPFDComponent().removeAllPrimitivesFromSelection();
        PFDAbstractNode node = this.m_mdlPFD.getKeyedNode(table);
        if (node != null) {
            this.getPFDComponent().addPrimitiveToSelection((PFDPrimitive)node);
        }
    }

    public TableInterface getSelectedTable() {
        PFDPrimitive[] aSelectedPrimitives = this.getPFDComponent().getSelectedPrimitives();
        if (aSelectedPrimitives.length == 0) {
            return null;
        }
        if (aSelectedPrimitives[0] instanceof TableNode) {
            return ((TableNode)aSelectedPrimitives[0]).getTable();
        }
        return null;
    }

    private void setShowColumns(boolean bShowColumns) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_COLUMNS_KEY, bShowColumns);
        TableInterface table = this.getSelectedTable();
        this.m_mdlPFD.setShowColumns(bShowColumns);
        if (table != null) {
            this.setSelectedTable(table);
        }
    }

    private class SQLAction
    extends WsAbstractAction {
        public SQLAction() {
            this.setMenuSupportId("sqlmenu");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class ShowColumnsAction
    extends WsAbstractToggleAction {
        public ShowColumnsAction() {
            super(bundle, "QueryTab.Action.ShowColumns", 257);
            this.setSelected(QueryTab.this.m_mdlPFD.isShowColumns());
            this.setMenuSupportId("sqlshowcolumns");
        }

        public void actionPerformed(ActionEvent ev) {
            QueryTab.this.setShowColumns(this.isSelected());
        }
    }
}

