/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.codegen.CodegenException;
import com.sas.codegen.TransformationActivityCG;
import com.sas.editor.LogListHolder;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.wadmin.transforms.sql.AbstractExpressionPropertiesModel;
import com.sas.wadmin.transforms.sql.BaseClausePropertiesModel;
import com.sas.wadmin.transforms.sql.CreatePropertiesModel;
import com.sas.wadmin.transforms.sql.ExpressionPanel;
import com.sas.wadmin.transforms.sql.GroupByPanel;
import com.sas.wadmin.transforms.sql.JoinPropertiesModel;
import com.sas.wadmin.transforms.sql.OrderByPanel;
import com.sas.wadmin.transforms.sql.OutlineTreeModel;
import com.sas.wadmin.transforms.sql.QueryPaletteTreeModel;
import com.sas.wadmin.transforms.sql.QueryTab;
import com.sas.wadmin.transforms.sql.QueryTablePropertiesModel;
import com.sas.wadmin.transforms.sql.SQLMappingsPropertyTab;
import com.sas.wadmin.transforms.sql.SQLPropertiesModel;
import com.sas.wadmin.transforms.sql.SQLTab;
import com.sas.wadmin.transforms.sql.SQLTransformationStepView;
import com.sas.wadmin.transforms.sql.SelectPropertiesModel;
import com.sas.wadmin.transforms.sql.SourceTablePropertiesModel;
import com.sas.wadmin.transforms.sql.SubqueryPropertiesModel;
import com.sas.wadmin.transforms.sql.TableColumnPropertiesModel;
import com.sas.wadmin.transforms.sql.TablePropertiesModel;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.TableViewerPanel;
import com.sas.wadmin.transforms.sql.TargetTablePropertiesModel;
import com.sas.wadmin.transforms.sql.VisualsTab;
import com.sas.wadmin.transforms.sql.model.AbstractExpression;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.GroupBy;
import com.sas.wadmin.transforms.sql.model.Having;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.OrderBy;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLUtil;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.wadmin.visuals.properties.EmptyPropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesTable;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerEvent;
import com.sas.workspace.WsAppServerEventListener;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsSplittableTabbedPane2;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.visuals.SubmitType;
import com.sas.workspace.visuals.WsLogPropertyTab;
import com.sas.workspace.visuals.pfd.WsPFDSelectionEvent;
import com.sas.workspace.visuals.pfd.WsPFDSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class QueryDesignerPanel
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(QueryDesignerPanel.class);
    private JSplitPane m_splMain;
    private JSplitPane m_splOuterVertical;
    private JSplitPane m_splInnerVertical;
    private WsSplittableTabbedPane2 m_spltMainTabs;
    private WATitledPane m_pnlOutline;
    private WATitledPane m_pnlPalette;
    private WATitledPane m_pnlProperties;
    private JScrollPane m_scrOutline;
    private WsTree m_treeOutline;
    private JScrollPane m_scrPalette;
    private WsTree m_treePalette;
    private JScrollPane m_scrProperties;
    private PropertiesTable m_tblProperties;
    private TableViewerPanel m_treeTableViewer;
    private WATitledPane m_pnlTableViewer;
    private VisualsTab m_tabVisuals;
    private SQLTab m_tabSQL;
    private WsLogPropertyTab m_tabLog;
    private SQLModel m_mdlSQL;
    private OutlineTreeModel m_mdlOutline;
    private DefaultTreeModel m_mdlPalette;
    private TableViewTreeModel m_mdlTableTree;
    private WsAbstractToggleAction m_actShowProperties;
    private AbstractAction m_actQueryPaletteDefault;
    private WsAbstractAction m_actSubmit;
    private WsAbstractAction m_actSubmitValidate;
    private WsAbstractToggleAction m_actRunAllPrior;
    private WsAbstractAction m_actKill;
    private WsAbstractAction m_actCancel;
    private boolean m_bLayedOut;
    private boolean m_bPropertiesVisible = true;
    private ClauseInterface m_clauseActive;
    private ClauseInterface m_clauseSelected;
    private TableInterface m_tableSelected;
    private TableColumn m_columnSelected;
    private boolean m_bIgnoreSelectionEvents;
    private boolean m_bActive;
    private WAPropertyTab m_tabActive;
    private WATitledPane m_pnlActivePalette;
    private boolean m_bCancel = false;
    private Map m_mapClauseTabs;
    private Action m_actQueryDefault;
    private WsPFDSelectionListener m_lsnrQuerySelection;
    private QueryChangeListener m_lsnrSQLModel;
    private ClauseRemovalListener m_lsnrClauseRemoval;
    private WsServerRequest m_WsServerRequest;
    private WsAppServer m_WsAppServer;
    private PropertyChangeListener m_lsnrServerRequest;
    private WsAppServerEventListener m_lstnrWsAppServerEvent;
    private SQLTransformationStepView m_view;
    private boolean m_bShowLogWindowOnSubmitFinish = false;
    private boolean m_bValidate = false;

    public QueryDesignerPanel(SQLModel model) {
        this(model, null);
    }

    public QueryDesignerPanel(SQLModel model, SQLTransformationStepView view) {
        this.m_mdlSQL = model;
        this.m_view = view;
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_designer");
        this.initialize();
    }

    protected void initialize() {
        try {
            this.createActions();
            this.m_lsnrQuerySelection = this.createQuerySelectionListener();
            this.m_lsnrClauseRemoval = this.createClauseRemovalListener();
            this.m_mdlSQL.addChangeListener(this.m_lsnrClauseRemoval);
            this.m_WsServerRequest = WsJobSubmissionManager.getInstance().getWsServerRequest(this.m_mdlSQL.getTransformationStep().getFQID());
            if (this.m_WsServerRequest == null) {
                this.m_WsServerRequest = WsJobSubmissionManager.getInstance().makeWsServerRequest((CMetadata)this.m_mdlSQL.getTransformationStep());
            }
            this.m_lsnrServerRequest = this.createServerRequestDataChangedListener();
            this.m_WsServerRequest.addPropertyChangeListener(this.m_lsnrServerRequest);
            this.m_lstnrWsAppServerEvent = this.createWsAppServerEventListener();
            this.m_WsServerRequest.addcWsAppServerEventListener(this.m_lstnrWsAppServerEvent);
            this.createServers();
            this.m_mdlSQL.setWsAppServer(this.m_WsAppServer);
            this.m_mapClauseTabs = new HashMap();
            this.m_mdlOutline = this.createOutlineTreeModel();
            this.m_treeOutline = this.createOutlineTree();
            this.m_scrOutline = new JScrollPane((Component)this.m_treeOutline);
            this.m_pnlOutline = this.createTitledPane(bundle.getString("QueryDesignerPanel.OutlinePanelTitle.txt"), this.m_scrOutline, false);
            this.m_mdlPalette = this.createQueryPaletteTreeModel();
            this.m_treePalette = this.createQueryPaletteTree();
            this.m_scrPalette = new JScrollPane((Component)this.m_treePalette);
            this.m_pnlPalette = this.createTitledPane(bundle.getString("QueryDesignerPanel.PalettePanelTitle.txt"), this.m_scrPalette, false);
            this.m_mdlTableTree = this.createTableViewTreeModel();
            this.m_treeTableViewer = this.createTableViewerPanel();
            this.m_treeTableViewer.allowMultipleSelection();
            this.m_pnlTableViewer = this.createTitledPane(bundle.getString("QueryDesignerPanel.TableViewerPanelTitle.txt"), (JComponent)((Object)this.m_treeTableViewer), false);
            this.m_tblProperties = new PropertiesTable();
            this.m_scrProperties = new JScrollPane((Component)((Object)this.m_tblProperties));
            this.m_pnlProperties = this.createTitledPane("", this.m_scrProperties, true);
            this.m_pnlProperties.getCloseButton().addActionListener(new ClosePropertiesActionListener());
            this.m_tabVisuals = new VisualsTab();
            this.m_tabSQL = this.createSQLTab();
            this.m_tabLog = new WsLogPropertyTab(1);
            this.m_tabLog.setHelpProduct("texteditor");
            this.m_tabLog.setHelpTopic("logspace");
            this.m_spltMainTabs = new WsSplittableTabbedPane2(3, false);
            this.m_spltMainTabs.addTab("", (Component)((Object)this.m_tabVisuals));
            this.m_spltMainTabs.addTab(bundle.getString("QueryDesignerPanel.SQLTabTitle.txt"), (Component)((Object)this.m_tabSQL));
            this.m_spltMainTabs.addTab(bundle.getString("QueryDesignerPanel.LogTabTitle.txt"), (Component)this.m_tabLog);
            this.m_spltMainTabs.addChangeListener((ChangeListener)new TabSelectionListener());
            this.setActiveTab(this.m_tabVisuals);
            this.m_splInnerVertical = this.createSplitPane(0, (JComponent)this.m_pnlPalette, (JComponent)this.m_pnlProperties);
            this.m_splOuterVertical = this.createSplitPane(0, (JComponent)this.m_pnlOutline, this.m_splInnerVertical);
            this.m_splMain = this.createSplitPane(1, this.m_splOuterVertical, (JComponent)this.m_spltMainTabs);
            this.setLayout(new BorderLayout());
            this.add(this.m_splMain, "Center");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private SQLTab createSQLTab() {
        SQLTab newTab = new SQLTab(this.m_mdlSQL);
        newTab.setSubmitAction(this.m_actSubmit);
        newTab.setSubmitValidateAction(this.m_actSubmitValidate);
        newTab.setKillAction(this.m_actKill);
        newTab.setCancelAction(this.m_actCancel);
        newTab.setRunAllPriorStepsAction(this.m_actRunAllPrior);
        return newTab;
    }

    private OutlineTreeModel createOutlineTreeModel() {
        return new OutlineTreeModel(this.m_mdlSQL);
    }

    private WsTree createOutlineTree() {
        WsTree treeOutline = new WsTree((DefaultTreeModel)this.m_mdlOutline);
        treeOutline.setExpandsSelectedPaths(true);
        treeOutline.setScrollsOnExpand(true);
        treeOutline.setEditable(false);
        treeOutline.getSelectionModel().setSelectionMode(1);
        treeOutline.setUserDefaultAction(this.createDefaultOutlineAction());
        treeOutline.addTreeSelectionListener(this.createOutlineSelectionListener());
        this.m_lsnrSQLModel = new QueryModelListener();
        this.m_mdlSQL.addChangeListener(this.m_lsnrSQLModel);
        return treeOutline;
    }

    private AbstractAction createDefaultOutlineAction() {
        return new DefaultOutlineAction();
    }

    private TreeSelectionListener createOutlineSelectionListener() {
        return new OutlineSelectionListener();
    }

    private TablesTreeSelectionListener createTablesTreeSelectionListener() {
        return new TablesTreeSelectionListener();
    }

    private QueryPaletteTreeModel createQueryPaletteTreeModel() {
        return new QueryPaletteTreeModel();
    }

    private WsTree createQueryPaletteTree() {
        WsTree treePalette = new WsTree(this.m_mdlPalette);
        treePalette.setRootVisible(false);
        treePalette.setExpandsSelectedPaths(true);
        treePalette.setScrollsOnExpand(true);
        treePalette.setEditable(false);
        treePalette.setPopupMenuEnabled(false);
        treePalette.setDraggingEnabled(true);
        treePalette.getSelectionModel().setSelectionMode(1);
        treePalette.expand();
        this.m_actQueryPaletteDefault = this.createDefaultQueryPaletteAction();
        treePalette.setUserDefaultAction(this.m_actQueryPaletteDefault);
        return treePalette;
    }

    private AbstractAction createDefaultQueryPaletteAction() {
        return new DefaultQueryPaletteAction();
    }

    private WATitledPane createTitledPane(String sTitle, JComponent cmpContents, boolean bClosable) {
        WATitledPane pnl = new WATitledPane(sTitle, false, false, false, bClosable);
        pnl.setContents((Component)cmpContents);
        return pnl;
    }

    private JSplitPane createSplitPane(int eOrientation, JComponent cmpOne, JComponent cmpTwo) {
        JSplitPane spl = new JSplitPane(eOrientation, cmpOne, cmpTwo);
        spl.setContinuousLayout(true);
        spl.setResizeWeight(0.0);
        spl.setBorder(null);
        return spl;
    }

    private void createActions() {
        this.m_actShowProperties = new ShowPropertiesAction();
        this.m_actQueryDefault = new DefaultQueryTabAction();
        this.m_actSubmit = new cSubmitAction();
        this.m_actSubmitValidate = new cSubmitValidateAction();
        this.m_actRunAllPrior = new cSubmitAllOptionAction();
        this.m_actKill = new cKillAction();
        this.m_actCancel = new cTerminateAction();
    }

    private WsPFDSelectionListener createQuerySelectionListener() {
        return new QuerySelectionListener();
    }

    private ClauseRemovalListener createClauseRemovalListener() {
        return new ClauseRemovalListener();
    }

    private TableViewTreeModel createTableViewTreeModel() {
        TableViewTreeModel model = new TableViewTreeModel(this.m_mdlSQL);
        model.createModelListener();
        return model;
    }

    private TableViewerPanel createTableViewerPanel() {
        TableViewerPanel tvp = new TableViewerPanel(this.m_mdlTableTree);
        tvp.m_treeTables.addTreeSelectionListener((TreeSelectionListener)this.createTablesTreeSelectionListener());
        return tvp;
    }

    public void doLayout() {
        if (!this.m_bLayedOut) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_splInnerVertical.setDividerLocation(appDefaults.getPropertyInt("QueryDesignerPanel.PaletteHeight", 135));
            this.m_splOuterVertical.setDividerLocation(appDefaults.getPropertyInt("QueryDesignerPanel.OutlineHeight", 125));
            this.m_splMain.setDividerLocation(appDefaults.getPropertyInt("QueryDesignerPanel.LeftSideWidth", 150));
            this.m_spltMainTabs.restoreState("QueryDesignerPanel", false);
            this.m_spltMainTabs.setSelectedTab((Component)((Object)this.m_tabVisuals));
            this.setPropertiesVisible(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("QueryDesignerPanel.PropertiesVisible", true));
            this.m_bLayedOut = true;
        }
        super.doLayout();
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setActivePropertiesModel(this.m_mdlSQL.getName(), null);
        this.setListeningForChanges(false);
        this.m_mdlSQL.moveDataToModel();
        this.updateValidateAction(true);
        this.setListeningForChanges(true);
        this.setActiveClause(this.m_mdlSQL.getStatement().getQuery());
        this.setActivePropertiesModel(this.m_mdlSQL.getName(), this.getPropertiesModel(this.m_mdlSQL));
        this.m_tabSQL.moveDataToView();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        WAPropertyTab tabCurrent = this.getActiveVisualsTab();
        if (tabCurrent != null) {
            tabCurrent.moveDataToStore();
        }
        this.m_tabSQL.moveDataToStore();
        this.m_mdlSQL.moveDataToStore();
        this.setDataChanged(false);
        Object[] aTabs = this.m_mapClauseTabs.values().toArray();
        for (int iTab = 0; iTab < aTabs.length; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)aTabs[iTab];
            tab.setDataChanged(false);
        }
        this.setActiveVisualsTab("", null);
    }

    public boolean validateData() {
        this.m_tblProperties.stopCellEditing();
        WAPropertyTab tabCurrent = this.getActiveVisualsTab();
        if (tabCurrent != null) {
            return tabCurrent.validateData();
        }
        return true;
    }

    public void onParentCancel() {
        this.m_bCancel = true;
    }

    public void onParentApply() {
        SQLUtil.updatePFDTables(this.m_mdlSQL, this.m_mdlSQL.getStatement().getQuery());
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (!this.m_bCancel && this.m_mdlSQL.getStatement() != null) {
            SQLUtil.updatePFDTables(this.m_mdlSQL, this.m_mdlSQL.getStatement().getQuery());
        }
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyInt("QueryDesignerPanel.PaletteHeight", this.m_splInnerVertical.getDividerLocation());
        appDefaults.setPropertyInt("QueryDesignerPanel.OutlineHeight", this.m_splOuterVertical.getDividerLocation());
        appDefaults.setPropertyInt("QueryDesignerPanel.LeftSideWidth", this.m_splMain.getDividerLocation());
        this.m_spltMainTabs.saveState("QueryDesignerPanel");
        this.m_tabSQL.saveSettingsAndCleanUp();
        this.m_tabLog.saveSettingsAndCleanUp();
        this.m_mdlTableTree.dispose();
        Object[] aTabs = this.m_mapClauseTabs.values().toArray();
        for (int iTab = 0; iTab < aTabs.length; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)aTabs[iTab];
            tab.saveSettingsAndCleanUp();
        }
        this.m_mdlSQL.removeChangeListener(this.m_lsnrSQLModel);
        this.m_mdlSQL.removeChangeListener(this.m_lsnrClauseRemoval);
        PropertiesModel mdlProperties = this.m_tblProperties.getPropertiesModel();
        if (mdlProperties instanceof BaseClausePropertiesModel) {
            ((BaseClausePropertiesModel)mdlProperties).dispose();
        } else if (mdlProperties instanceof TablePropertiesModel) {
            ((TablePropertiesModel)mdlProperties).dispose();
        } else if (mdlProperties instanceof TableColumnPropertiesModel) {
            ((TableColumnPropertiesModel)mdlProperties).dispose();
        }
        if (this.m_WsServerRequest != null) {
            WsJobSubmissionManager.getInstance().clearServerRequest(this.m_WsServerRequest.getMetadataFQID());
        }
        this.m_bCancel = false;
        this.m_mdlSQL.clearSQL();
        if (this.m_WsAppServer != null) {
            this.m_WsAppServer.dispose();
            this.m_WsAppServer = null;
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tabSQL.setEditable(bEditable);
        Object[] aTabs = this.m_mapClauseTabs.values().toArray();
        for (int iTab = 0; iTab < aTabs.length; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)aTabs[iTab];
            tab.setEditable(bEditable);
        }
        this.m_actQueryPaletteDefault.setEnabled(bEditable);
        this.m_tblProperties.setEditable(bEditable);
        this.m_mdlOutline.setEditable(bEditable);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_bActive = bActive;
        if (this.getActiveTab() != null) {
            this.getActiveTab().updateWorkspaceUIComponents(bActive);
        }
        this.m_tabVisuals.updateWorkspaceUIComponents(bActive);
        this.m_actShowProperties.setActive(bActive);
        this.m_actSubmit.setActive(bActive);
        SubmitType.getInstance().setActive(bActive);
        this.m_actSubmitValidate.setActive(bActive);
        this.m_actCancel.setActive(bActive);
        this.m_actKill.setActive(bActive);
        this.m_actRunAllPrior.setActive(bActive);
    }

    public String getHelpTopic() {
        WAPropertyTab tab = this.getActiveTab();
        if (tab == this.m_tabVisuals) {
            tab = (WAPropertyTab)this.m_tabVisuals.getComponent(0);
        }
        if (tab != null) {
            return tab.getHelpTopic();
        }
        return super.getHelpTopic();
    }

    public String getHelpProduct() {
        WAPropertyTab tab = this.getActiveTab();
        if (tab == this.m_tabVisuals) {
            tab = (WAPropertyTab)this.m_tabVisuals.getComponent(0);
        }
        if (tab != null) {
            return tab.getHelpProduct();
        }
        return super.getHelpProduct();
    }

    private void setSelectedClause(ClauseInterface clause) {
        if (clause == this.m_clauseSelected) {
            return;
        }
        this.m_clauseSelected = clause;
        this.m_tabSQL.setSelectedClause(clause);
        WAPropertyTab tabActive = this.getActiveVisualsTab();
        if (tabActive instanceof QueryTab) {
            ((QueryTab)tabActive).setSelectedClause(clause);
        }
        if (clause == null) {
            return;
        }
        this.setSelectedTable(null);
        this.setSelectedColumn(null);
        this.setActivePropertiesModel(clause.getName(), this.getPropertiesModel(clause));
    }

    private void setSelectedTable(TableInterface table) {
        try {
            if (table == this.m_tableSelected) {
                return;
            }
            this.m_tableSelected = table;
            WAPropertyTab tabActive = this.getActiveVisualsTab();
            if (tabActive instanceof QueryTab) {
                ((QueryTab)tabActive).setSelectedTable(table);
            }
            if (table == null) {
                return;
            }
            this.setSelectedClause(null);
            this.setSelectedColumn(null);
            this.m_treeTableViewer.setSelectedNode(this.m_mdlTableTree.findTableNode(table));
            this.setActivePropertiesModel(table.getDataTable().getName(), this.getPropertiesModel(table));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void setSelectedColumn(TableColumn column) {
        if (column == this.m_columnSelected) {
            return;
        }
        this.m_columnSelected = column;
        if (column == null) {
            return;
        }
        this.setSelectedClause(null);
        this.setSelectedTable(null);
        this.setActivePropertiesModel(column.getName(), this.getPropertiesModel(column));
    }

    private void setActivePropertiesModel(String sTitle, PropertiesModel mdl) {
        if (!this.m_tblProperties.stopCellEditing()) {
            return;
        }
        PropertiesModel mdlProperties = this.m_tblProperties.getPropertiesModel();
        if (mdlProperties instanceof BaseClausePropertiesModel) {
            ((BaseClausePropertiesModel)mdlProperties).dispose();
        } else if (mdlProperties instanceof TablePropertiesModel) {
            ((TablePropertiesModel)mdlProperties).dispose();
        } else if (mdlProperties instanceof TableColumnPropertiesModel) {
            ((TableColumnPropertiesModel)mdlProperties).dispose();
        }
        this.m_pnlProperties.setTitle(bundle.formatString("QueryDesignerPanel.PropertiesPanelTitle.fmt.txt", (Object)sTitle));
        this.m_tblProperties.setPropertiesModel(mdl);
        this.m_tblProperties.scrollRectToVisible(this.m_tblProperties.getCellRect(0, 0, true));
    }

    private PropertiesModel getActivePropertiesModel() {
        return this.m_tblProperties.getPropertiesModel();
    }

    private PropertiesModel getPropertiesModel(Object object) {
        PropertiesModel mdl = this.createPropertiesModel(object);
        mdl.setDisplayErrors(false);
        return mdl;
    }

    private PropertiesModel createPropertiesModel(Object object) {
        if (object instanceof SQLModel) {
            return new SQLPropertiesModel((SQLModel)object);
        }
        if (object instanceof CreateSelect) {
            return new CreatePropertiesModel((CreateSelect)object);
        }
        if (object instanceof SelectResults) {
            return new SelectPropertiesModel((SelectResults)object);
        }
        if (object instanceof Join) {
            return new JoinPropertiesModel((Join)object);
        }
        if (object instanceof TableInterface) {
            return this.createTablePropertiesModel((TableInterface)object);
        }
        if (object instanceof TableColumn) {
            return this.createColumnPropertiesModel((TableColumn)object);
        }
        if (object instanceof AbstractExpression) {
            return new AbstractExpressionPropertiesModel((AbstractExpression)object);
        }
        if (object instanceof SubQuery) {
            return new SubqueryPropertiesModel((SubQuery)object);
        }
        if (object instanceof From) {
            return new EmptyPropertiesModel();
        }
        if (object instanceof ClauseInterface) {
            return new BaseClausePropertiesModel((ClauseInterface)object);
        }
        throw new UnsupportedOperationException("Invalid type from properties model" + object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesModel createTablePropertiesModel(TableInterface table) {
        try {
            RootPropertiesModel mdl = table instanceof SourceTable ? new SourceTablePropertiesModel((SourceTable)table, this.m_WsAppServer) : (table instanceof TargetTable ? (table.getDataTable().getCMetadataType().equals("QueryTable") ? new QueryTablePropertiesModel((TargetTable)table) : new TargetTablePropertiesModel((TargetTable)table, this.m_WsAppServer)) : new TablePropertiesModel(table));
            try {
                SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
                mdl.loadPropertyValues();
                mdl.updatePropertyValues();
                Thread t = new Thread(new cUpdatePropertiesRunnable(mdl));
                t.start();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
            catch (LogicalTypeException lte) {
                MessageUtil.displayMessage((String)lte.getLocalizedMessage(), (int)0);
            }
            finally {
                SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
            }
            return mdl;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesModel createColumnPropertiesModel(TableColumn column) {
        TableColumnPropertiesModel mdl = new TableColumnPropertiesModel(column);
        try {
            SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            mdl.loadPropertyValues();
            mdl.updatePropertyValues();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        catch (LogicalTypeException lte) {
            MessageUtil.displayMessage((String)lte.getLocalizedMessage(), (int)0);
        }
        finally {
            SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
        }
        return mdl;
    }

    protected void navigateToClause(ClauseInterface clause) {
        OutlineTreeModel.ClauseNode node = this.m_mdlOutline.findClauseNode(clause);
        if (node != null) {
            this.m_treeOutline.setSelectedNode((WsTreeNode)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveClause(ClauseInterface clause) {
        if (clause instanceof From) {
            clause = clause.getParentQuery();
        } else if (clause instanceof CreateSelect) {
            clause = ((CreateSelect)clause).getQuery();
        } else if (clause instanceof Join) {
            Join join = (Join)clause;
            String sType = join.getJoinType();
            if (join.useImplicit()) {
                Query query = clause.getParentQuery();
                if ((clause = query.getClause(ClauseType.WHERE)) == null) {
                    clause = query.addClause(ClauseType.WHERE);
                }
            } else if (sType.equals("Cross") || sType.equals("Union")) {
                clause = clause.getParentQuery();
            }
        }
        if (clause == this.m_clauseActive) {
            this.m_spltMainTabs.setSelectedTab((Component)((Object)this.m_tabVisuals));
            return;
        }
        WAPropertyTab tabCurrent = this.getActiveVisualsTab();
        if (tabCurrent != null) {
            if (!tabCurrent.validateData()) {
                return;
            }
            try {
                tabCurrent.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        this.m_clauseActive = clause;
        WAPropertyTab tabNew = (WAPropertyTab)this.m_mapClauseTabs.get(clause);
        if (tabNew == null) {
            try {
                SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
                tabNew = this.createVisualTab(clause);
                tabNew.setEditable(this.isEditable());
                tabNew.setWAUndoManager(this.waum);
                tabNew.moveDataToView();
                this.listenForDataChangesTo((WAPanel)tabNew);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                SwingUtilities.getWindowAncestor((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
            }
            this.m_mapClauseTabs.put(clause, tabNew);
        }
        this.setActiveVisualsTab(clause.getName(), tabNew);
        if (clause instanceof AbstractExpression || clause instanceof GroupBy || clause instanceof OrderBy || clause instanceof SelectResults) {
            this.m_mdlTableTree.setClause(clause);
            this.m_mdlTableTree.moveDataToModel();
            this.setActivePalette(this.m_pnlTableViewer);
            this.m_treeTableViewer.expand();
        } else {
            this.setActivePalette(this.m_pnlPalette);
        }
    }

    public ClauseInterface getActiveClause() {
        return this.m_clauseActive;
    }

    private void setActivePalette(WATitledPane pnlActivePalette) {
        if (this.m_pnlActivePalette == pnlActivePalette) {
            return;
        }
        this.m_pnlActivePalette = pnlActivePalette;
        if (this.isPropertiesVisible()) {
            int y = this.m_splInnerVertical.getDividerLocation();
            this.m_splInnerVertical.setTopComponent((Component)pnlActivePalette);
            this.m_splInnerVertical.setDividerLocation(y);
        } else {
            int y = this.m_splOuterVertical.getDividerLocation();
            this.m_splOuterVertical.setBottomComponent((Component)pnlActivePalette);
            this.m_splOuterVertical.setDividerLocation(y);
        }
    }

    private WATitledPane getActivePalette() {
        return this.m_pnlActivePalette;
    }

    private void setActiveVisualsTab(String sTitle, WAPropertyTab tab) {
        this.m_spltMainTabs.setTitle((Component)((Object)this.m_tabVisuals), sTitle);
        this.m_tabVisuals.updateWorkspaceUIComponents(this.m_bActive);
        this.m_tabVisuals.setContents(tab);
        this.m_spltMainTabs.setSelectedTab((Component)((Object)this.m_tabVisuals));
        if (tab != null) {
            try {
                tab.moveDataToView();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private WAPropertyTab getActiveVisualsTab() {
        return this.m_tabVisuals.getContents();
    }

    private WAPropertyTab createVisualTab(ClauseInterface clause) {
        WAPropertyTab tab = null;
        if (clause instanceof Query) {
            tab = this.createQueryTab((Query)clause);
        } else if (clause instanceof SelectResults) {
            tab = this.createSelectTab((SelectResults)clause);
        } else if (clause instanceof Join) {
            tab = new ExpressionPanel((Join)clause, this);
        } else if (clause instanceof Where) {
            tab = new ExpressionPanel((Where)clause, this);
        } else if (clause instanceof Having) {
            tab = new ExpressionPanel((Having)clause, this);
        } else if (clause instanceof GroupBy) {
            tab = new GroupByPanel((GroupBy)clause, this);
        } else if (clause instanceof OrderBy) {
            tab = new OrderByPanel((OrderBy)clause, this);
        }
        tab.setEditable(this.isEditable());
        return tab;
    }

    private WAPropertyTab createQueryTab(Query query) {
        QueryTab tab = new QueryTab(query);
        tab.addSelectionListener(this.m_lsnrQuerySelection);
        tab.setDefaultAction(this.m_actQueryDefault);
        tab.setSubmitAction(this.m_actSubmit);
        tab.setSubmitValidateAction(this.m_actSubmitValidate);
        tab.setCancelAction(this.m_actCancel);
        tab.setKillAction(this.m_actKill);
        tab.setRunAllPrior(this.m_actRunAllPrior);
        return tab;
    }

    private WAPropertyTab createSelectTab(SelectResults select) {
        SQLMappingsPropertyTab tab = new SQLMappingsPropertyTab(select, null, "SQLQuery", true, false, true, false, true, this);
        return tab;
    }

    private void setActiveTab(WAPropertyTab tabActive) {
        if (tabActive == this.m_tabActive) {
            return;
        }
        if (this.m_tabActive != null && this.m_bActive) {
            this.m_tabActive.updateWorkspaceUIComponents(false);
        }
        this.m_tabActive = tabActive;
        if (this.m_tabActive != null && this.m_bActive) {
            this.m_tabActive.updateWorkspaceUIComponents(true);
        }
    }

    private WAPropertyTab getActiveTab() {
        return this.m_tabActive;
    }

    private void setPropertiesVisible(boolean bVisible) {
        if (this.m_bPropertiesVisible == bVisible) {
            return;
        }
        this.m_bPropertiesVisible = bVisible;
        this.m_actShowProperties.setSelected(bVisible);
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean("QueryDesignerPanel.PropertiesVisible", bVisible);
        if (bVisible) {
            int yOuter = this.m_splOuterVertical.getDividerLocation();
            this.m_splInnerVertical.setTopComponent((Component)this.getActivePalette());
            this.m_splOuterVertical.setBottomComponent(this.m_splInnerVertical);
            this.m_splOuterVertical.setDividerLocation(yOuter);
            this.m_splInnerVertical.setDividerLocation(this.m_splInnerVertical.getDividerLocation());
        } else {
            int y = this.m_splOuterVertical.getDividerLocation();
            this.m_splOuterVertical.setBottomComponent((Component)this.getActivePalette());
            this.m_splOuterVertical.setDividerLocation(y);
        }
    }

    private boolean isPropertiesVisible() {
        return this.m_bPropertiesVisible;
    }

    private void setIgnoreSelectionEvents(boolean bIgnore) {
        this.m_bIgnoreSelectionEvents = bIgnore;
    }

    private boolean ignoreSelectionEvents() {
        return this.m_bIgnoreSelectionEvents;
    }

    private void updateValidateAction(boolean enabled) {
        this.m_actSubmitValidate.setEnabled(enabled && !this.m_mdlSQL.isUserWritten());
    }

    public void updateCodegenActions(boolean bActive) {
        this.m_actSubmit.setActive(bActive);
        SubmitType.getInstance().setActive(bActive);
        this.m_actSubmitValidate.setActive(bActive);
        this.m_actKill.setActive(bActive);
        this.m_actCancel.setActive(bActive);
    }

    protected WsAbstractAction getKillAction() {
        return this.m_actKill;
    }

    protected WsAbstractAction getSubmitAction() {
        return this.m_actSubmit;
    }

    protected WsAbstractAction getCancelAction() {
        return this.m_actCancel;
    }

    protected WsAbstractAction getSubmitValidateAction() {
        return this.m_actSubmitValidate;
    }

    public boolean canClose() {
        try {
            if (this.m_WsServerRequest != null && (this.m_WsServerRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBCANCELINPROGRESS) || this.m_WsServerRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBRUNNING))) {
                String sTitle = this.m_mdlSQL.getTransformationStep() != null ? this.m_mdlSQL.getTransformationStep().getName() + ": " + bundle.getString("QueryDesignerPanel.CanNotCloseTitle.txt") : bundle.getString("QueryDesignerPanel.CanNotCloseTitle.txt");
                String sMessage = this.m_WsServerRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBCANCELINPROGRESS) ? bundle.getString("QueryDesignerPanel.CanNotCloseCancellingMessage.txt") : bundle.getString("QueryDesignerPanel.CanNotCloseRunningMessage.txt");
                MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)1);
                return false;
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    private void createServers() {
        try {
            if (this.m_WsAppServer == null) {
                ServerContext defaultServer = null;
                String defaultServerId = WsAppServer.getDefaultAppServerFQID();
                if (defaultServerId != null) {
                    defaultServer = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject(this.m_mdlSQL.getObjectStore(), "", "ServerContext", defaultServerId);
                }
                try {
                    ServerContext server = TransformationActivityCG.getServerForStep(this.m_mdlSQL.getTransformationStep(), defaultServer, defaultServer, this.m_mdlSQL.getCodegenRequest());
                    this.m_WsAppServer = server != null ? WsAppServer.createAppServer((ServerContext)server) : WsAppServer.createDefaultAppServer();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            if (this.m_WsAppServer == null) {
                return;
            }
            this.m_mdlSQL.setWsAppServer(this.m_WsAppServer);
            if (this.m_WsServerRequest == null) {
                this.m_WsServerRequest = WsJobSubmissionManager.getInstance().getWsServerRequest(this.m_mdlSQL.getTransformationStep().getFQID());
                if (this.m_WsServerRequest == null) {
                    this.m_WsServerRequest = WsJobSubmissionManager.getInstance().makeWsServerRequest((CMetadata)this.m_mdlSQL.getTransformationStep());
                }
                this.m_lsnrServerRequest = this.createServerRequestDataChangedListener();
                this.m_WsServerRequest.addPropertyChangeListener(this.m_lsnrServerRequest);
                this.m_lstnrWsAppServerEvent = this.createWsAppServerEventListener();
                this.m_WsServerRequest.addcWsAppServerEventListener(this.m_lstnrWsAppServerEvent);
            }
            this.m_WsServerRequest.setWsAppServer(this.m_WsAppServer);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void updateViewTitle(String appendText) {
        if (this.m_view != null) {
            String title = this.m_view.getFrameTitle();
            this.m_view.setFrameTitle(title + " : " + appendText);
        }
    }

    public WsAppServerEventListener createWsAppServerEventListener() {
        return new cWsAppServerEventListener();
    }

    private PropertyChangeListener createServerRequestDataChangedListener() {
        return new cServerRequestDataChangedListener();
    }

    private void submitFinished(String sJobStatus) {
        Workspace work = Workspace.getWorkspace();
        this.m_actSubmit.setEnabled(true);
        SubmitType.getInstance().setEnabled(true);
        this.updateValidateAction(true);
        this.m_actCancel.setEnabled(false);
        this.m_actKill.setEnabled(false);
        if (sJobStatus.equals(WsServerRequest.JOBSUCCESSFUL)) {
            this.m_mdlSQL.setViewWorkTables(this.m_WsServerRequest.getPropertyInt("status") == 0 && !this.m_bValidate);
        } else {
            this.m_mdlSQL.setViewWorkTables(false);
        }
        try {
            LogListHolder hldrLog;
            if (this.m_tabLog != null && (hldrLog = this.m_WsServerRequest.getLogText()) != null) {
                this.m_tabLog.appendText(hldrLog);
            }
        }
        catch (WsAppServerFailException wsAppServerFailException) {
            // empty catch block
        }
        if (this.m_bValidate) {
            if (this.m_WsServerRequest != null) {
                WsJobSubmissionManager.getInstance().clearServerRequest(this.m_WsServerRequest.getMetadataFQID());
            }
            this.m_bValidate = false;
        }
        if (this.m_bShowLogWindowOnSubmitFinish) {
            this.m_spltMainTabs.setSelectedTab((Component)this.m_tabLog);
        }
        work.clearStatusText();
    }

    private void showTablePropertiesWindow(TableInterface mdoTable) {
        try {
            try {
                mdoTable.getSQLModel().moveDataToStore();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            MdObjectStore newStore = null;
            DataTable table = mdoTable.getDataTable();
            if (table.getCMetadataType().equals("WorkTable")) {
                newStore = Workspace.getMdFactory().createObjectStore((MdStore)this.m_mdlSQL.getObjectStore());
                newStore.setIsGotToServerForMetadata(false);
            } else {
                newStore = Workspace.getMdFactory().createObjectStore(null, "SQL: PhysicalTable Store");
            }
            CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, null, (CMetadata)table);
            WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.wadmin.visuals.", (String)"View");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void killAppServer() {
        try {
            WsJobSubmissionManager.getInstance().killAppServer(this.m_mdlSQL.getTransformationStep().getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void terminateRunningCode() {
        try {
            WsJobSubmissionManager.getInstance().termWsServerRequestCode(this.m_mdlSQL.getTransformationStep().getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private class ClauseRemovalListener
    implements QueryChangeListener {
        private ClauseRemovalListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            String sAction = ev.getAction();
            if ("ClauseRemoved".equals(sAction)) {
                ClauseInterface clause = ev.getClause();
                WAPropertyTab tab = (WAPropertyTab)QueryDesignerPanel.this.m_mapClauseTabs.get(clause);
                if (tab == null) {
                    return;
                }
                tab.saveSettingsAndCleanUp();
                QueryDesignerPanel.this.m_mapClauseTabs.remove(clause);
            }
        }
    }

    private class ClosePropertiesActionListener
    implements ActionListener {
        private ClosePropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            QueryDesignerPanel.this.setPropertiesVisible(false);
        }
    }

    private class TabSelectionListener
    implements ChangeListener {
        private TabSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            QueryDesignerPanel.this.setActiveTab((WAPropertyTab)QueryDesignerPanel.this.m_spltMainTabs.getSelectedTab());
        }
    }

    private class QueryModelListener
    implements QueryChangeListener {
        private Object m_selection;
        private Object m_parent;

        private QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            TableInterface removedTable;
            ClauseInterface clause;
            String sAction = ev.getAction();
            if ("unknownChanges".equals(sAction) || "ClauseAdded".equals(sAction) || "targetChanged".equals(sAction) || "targetRemoved".equals(sAction) || "SourceChanged".equals(sAction) || "SourceRemoved".equals(sAction) || "LeftSideChanged".equals(sAction) || "RightSideChanged".equals(sAction) || "ExpressionChanged".equals(sAction)) {
                this.saveOutlineSelection();
                try {
                    QueryDesignerPanel.this.m_mdlOutline.moveDataToModel();
                    QueryDesignerPanel.this.m_treeOutline.expand();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                this.restoreOutlineSelection();
            } else if ("ClauseRemoved".equals(sAction)) {
                OutlineTreeModel.ClauseNode nodeClause;
                clause = ev.getClause();
                if (clause == QueryDesignerPanel.this.getActiveClause()) {
                    QueryDesignerPanel.this.setActiveVisualsTab("", null);
                }
                if (clause != null && clause.equals(QueryDesignerPanel.this.m_clauseSelected)) {
                    QueryDesignerPanel.this.setSelectedClause(null);
                    QueryDesignerPanel.this.setActivePropertiesModel(QueryDesignerPanel.this.m_mdlSQL.getName(), QueryDesignerPanel.this.getPropertiesModel(QueryDesignerPanel.this.m_mdlSQL));
                }
                if ((nodeClause = QueryDesignerPanel.this.m_mdlOutline.findClauseNode(clause)) != null) {
                    ClauseInterface clauseSelected;
                    WsTreeNode nodeSelected = QueryDesignerPanel.this.m_treeOutline.getSelectedNode();
                    if (nodeSelected == nodeClause) {
                        QueryDesignerPanel.this.m_treeOutline.setSelectedNode((WsTreeNode)nodeClause.getParent());
                    } else if (nodeSelected instanceof OutlineTreeModel.ClauseNode && (clauseSelected = ((OutlineTreeModel.ClauseNode)nodeSelected).getClause()) instanceof Join) {
                        QueryDesignerPanel.this.setActiveClause(clauseSelected);
                    }
                    QueryDesignerPanel.this.m_mdlOutline.removeNodeFromParent((MutableTreeNode)((Object)nodeClause));
                }
            } else if ("UseImplicitChanged".equals(sAction)) {
                clause = ev.getClause();
                OutlineTreeModel.ClauseNode node = QueryDesignerPanel.this.m_mdlOutline.findClauseNode(clause);
                if (node == QueryDesignerPanel.this.m_treeOutline.getSelectedNode()) {
                    QueryDesignerPanel.this.setActiveClause(clause);
                }
            } else if ("JoinTypeChanged".equals(sAction)) {
                clause = ev.getClause();
                QueryDesignerPanel.this.m_mdlOutline.updateClauseNode(clause);
                PropertiesModel model = QueryDesignerPanel.this.getActivePropertiesModel();
                if (model instanceof JoinPropertiesModel) {
                    QueryDesignerPanel.this.m_pnlProperties.setTitle(bundle.formatString("QueryDesignerPanel.PropertiesPanelTitle.fmt.txt", (Object)ev.getClause().getName()));
                }
                if (QueryDesignerPanel.this.getActiveClause() == clause) {
                    QueryDesignerPanel.this.m_spltMainTabs.setTitle((Component)((Object)QueryDesignerPanel.this.m_tabVisuals), ev.getClause().getName());
                }
            } else if ("AliasChanged".equals(sAction)) {
                TableInterface table = ev.getTable();
                if (table != null) {
                    QueryDesignerPanel.this.m_mdlOutline.updateTableNode(table);
                    QueryDesignerPanel.this.m_mdlTableTree.updateTableNode(table);
                } else {
                    ClauseInterface clause2 = ev.getClause();
                    if (clause2 != null) {
                        QueryDesignerPanel.this.m_mdlOutline.updateClauseNode(clause2);
                    }
                }
            } else if ("DescriptionChanged".equals(sAction)) {
                QueryDesignerPanel.this.m_mdlOutline.updateClauseNode(ev.getClause());
            } else if ("MemberTypeChanged".equals(sAction)) {
                QueryDesignerPanel.this.m_mdlOutline.updateTableNode(ev.getTable());
            } else if ("userWrittenChanged".equals(sAction)) {
                QueryDesignerPanel.this.updateValidateAction(true);
            }
            if (("SourceTableRemoved".equals(sAction) || "SourceRemoved".equals(sAction) || "targetRemoved".equals(sAction)) && (removedTable = ev.getTable()) != null && removedTable.equals(QueryDesignerPanel.this.m_tableSelected)) {
                QueryDesignerPanel.this.setSelectedTable(null);
                QueryDesignerPanel.this.setActivePropertiesModel(QueryDesignerPanel.this.m_mdlSQL.getName(), QueryDesignerPanel.this.getPropertiesModel(QueryDesignerPanel.this.m_mdlSQL));
            }
            if (QueryDesignerPanel.this.isListeningForChanges()) {
                QueryDesignerPanel.this.setDataChanged(true);
            }
        }

        private void saveOutlineSelection() {
            WsTreeNode node = QueryDesignerPanel.this.m_treeOutline.getSelectedNode();
            this.m_selection = this.getObjectFromNode((TreeNode)node);
            if (node != null) {
                this.m_parent = this.getObjectFromNode(node.getParent());
            }
        }

        private Object getObjectFromNode(TreeNode node) {
            if (node == null) {
                return null;
            }
            if (node instanceof OutlineTreeModel.TableNode) {
                return ((OutlineTreeModel.TableNode)((Object)node)).getTable();
            }
            if (node instanceof OutlineTreeModel.ClauseNode) {
                return ((OutlineTreeModel.ClauseNode)((Object)node)).getClause();
            }
            return null;
        }

        private void restoreOutlineSelection() {
            OutlineTreeModel.BaseNode node = null;
            if (this.m_selection instanceof TableInterface) {
                node = QueryDesignerPanel.this.m_mdlOutline.findTableNode((TableInterface)this.m_selection);
            } else if (this.m_selection instanceof ClauseInterface) {
                node = QueryDesignerPanel.this.m_mdlOutline.findClauseNode((ClauseInterface)this.m_selection);
            }
            if (node != null) {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(true);
                try {
                    QueryDesignerPanel.this.m_treeOutline.setSelectedNode((WsTreeNode)node);
                }
                finally {
                    QueryDesignerPanel.this.setIgnoreSelectionEvents(false);
                }
            } else {
                node = this.m_parent instanceof TableInterface ? QueryDesignerPanel.this.m_mdlOutline.findTableNode((TableInterface)this.m_parent) : (this.m_parent instanceof ClauseInterface ? QueryDesignerPanel.this.m_mdlOutline.findClauseNode((ClauseInterface)this.m_parent) : (WsTreeNode)QueryDesignerPanel.this.m_mdlOutline.getRoot());
                QueryDesignerPanel.this.m_treeOutline.setSelectedNode((WsTreeNode)node);
            }
        }
    }

    private class DefaultOutlineAction
    extends AbstractAction {
        private DefaultOutlineAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTreeNode node = QueryDesignerPanel.this.m_treeOutline.getActiveNode();
            if (node == null) {
                return;
            }
            if (node instanceof OutlineTreeModel.TableNode) {
                QueryDesignerPanel.this.showTablePropertiesWindow(((OutlineTreeModel.TableNode)node).getTable());
            }
        }
    }

    private class OutlineSelectionListener
    implements TreeSelectionListener {
        private OutlineSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            if (QueryDesignerPanel.this.ignoreSelectionEvents()) {
                return;
            }
            try {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(true);
                WsTreeNode node = QueryDesignerPanel.this.m_treeOutline.getSelectedNode();
                if (node == null) {
                    return;
                }
                if (node instanceof OutlineTreeModel.ClauseNode) {
                    ClauseInterface clause = ((OutlineTreeModel.ClauseNode)node).getClause();
                    QueryDesignerPanel.this.setActiveClause(clause);
                    QueryDesignerPanel.this.setSelectedClause(clause);
                } else if (node instanceof OutlineTreeModel.TableNode) {
                    TableInterface table = ((OutlineTreeModel.TableNode)node).getTable();
                    QueryDesignerPanel.this.setSelectedTable(table);
                } else if (node == QueryDesignerPanel.this.m_treeOutline.getModel().getRoot()) {
                    QueryDesignerPanel.this.setActiveClause(QueryDesignerPanel.this.m_mdlSQL.getStatement().getQuery());
                    QueryDesignerPanel.this.setSelectedClause(null);
                    QueryDesignerPanel.this.setActivePropertiesModel(QueryDesignerPanel.this.m_mdlSQL.getName(), QueryDesignerPanel.this.getPropertiesModel(QueryDesignerPanel.this.m_mdlSQL));
                }
                QueryDesignerPanel.this.m_treeOutline.setSelectedNode(node);
            }
            finally {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(false);
            }
        }
    }

    private class TablesTreeSelectionListener
    implements TreeSelectionListener {
        private TablesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            if (QueryDesignerPanel.this.ignoreSelectionEvents()) {
                return;
            }
            try {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(true);
                WsTreeNode node = QueryDesignerPanel.this.m_treeTableViewer.getSelectedNode();
                if (node instanceof TableViewTreeModel.cTableNode) {
                    QueryDesignerPanel.this.setSelectedTable(((TableViewTreeModel.cTableNode)node).getTable());
                } else if (node instanceof TableViewTreeModel.cColumnTreeNode) {
                    QueryDesignerPanel.this.setSelectedColumn(((TableViewTreeModel.cColumnTreeNode)node).getTableColumn());
                }
            }
            finally {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(false);
            }
        }
    }

    private class DefaultQueryPaletteAction
    extends AbstractAction {
        private DefaultQueryPaletteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTree tree = (WsTree)ev.getSource();
            WsTreeNode node = tree.getActiveNode();
            ClauseInterface clauseActive = QueryDesignerPanel.this.getActiveClause();
            if (!(clauseActive instanceof Query)) {
                return;
            }
            Query query = (Query)clauseActive;
            if (node != null) {
                Object drag = node.getDragObject();
                if (drag instanceof ClauseType) {
                    ClauseType type = (ClauseType)drag;
                    if (type == ClauseType.SUBQUERY) {
                        return;
                    }
                    ClauseInterface clause = query.addClause(type);
                    if (clause != null) {
                        QueryDesignerPanel.this.setSelectedClause(clause);
                    }
                } else if (drag instanceof JoinType) {
                    String type = ((JoinType)drag).getJoinType();
                    QueryTab tab = (QueryTab)QueryDesignerPanel.this.getActiveVisualsTab();
                    Join join = null;
                    ClauseInterface clause = tab.getSelectedClause();
                    if (clause instanceof Join) {
                        join = query.insertJoin(type, (Join)clause);
                    } else if (clause instanceof SelectResults || clause == null) {
                        join = query.insertJoin(type, query.getFrom().getSource());
                    } else {
                        TableInterface table = tab.getSelectedTable();
                        if (table instanceof SourceTable) {
                            join = query.insertJoin(type, (SourceTable)table);
                        }
                    }
                    if (join != null) {
                        QueryDesignerPanel.this.setSelectedClause(join);
                    }
                }
            }
        }
    }

    private class ShowPropertiesAction
    extends WsAbstractToggleAction {
        public ShowPropertiesAction() {
            this.setMenuSupportId("querydesignerproperties");
            this.setHidable(true);
            this.setSelected(true);
        }

        public void actionPerformed(ActionEvent ev) {
            QueryDesignerPanel.this.setPropertiesVisible(this.isSelected());
        }
    }

    private class DefaultQueryTabAction
    extends AbstractAction {
        private DefaultQueryTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WAPropertyTab tabActive = QueryDesignerPanel.this.getActiveVisualsTab();
            if (tabActive instanceof QueryTab) {
                QueryTab tabQuery = (QueryTab)tabActive;
                ClauseInterface clause = tabQuery.getSelectedClause();
                if (clause != null) {
                    QueryDesignerPanel.this.navigateToClause(clause);
                } else {
                    TableInterface table = tabQuery.getSelectedTable();
                    if (table != null) {
                        QueryDesignerPanel.this.showTablePropertiesWindow(table);
                    }
                }
            }
        }
    }

    private class cSubmitAction
    extends WsAbstractAction {
        public cSubmitAction() {
            super(bundle, "QueryDesignerPanel.Submit", true);
            this.setMenuSupportId("submit");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (QueryDesignerPanel.this.m_WsAppServer == null) {
                QueryDesignerPanel.this.createServers();
            }
            QueryDesignerPanel.this.m_bShowLogWindowOnSubmitFinish = false;
            WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
            if (defaultsFile.getPropertyBoolean("Workspace.ClearLogBeforeSubmit", false) && QueryDesignerPanel.this.m_tabLog != null) {
                QueryDesignerPanel.this.m_tabLog.clear();
            }
            StringBuffer priorCode = null;
            boolean runCode = true;
            if (QueryDesignerPanel.this.m_mdlSQL.getRunPriorSteps()) {
                try {
                    priorCode = QueryDesignerPanel.this.m_mdlSQL.getPriorStepGeneratedCode();
                }
                catch (CodegenException exc) {
                    MessageUtil.displayMessage((String)exc.getMessage(), (String)bundle.getString("QueryDesignerPanel.CodeGenerationPreviousStepError.txt"), (int)0);
                    runCode = false;
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    runCode = false;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            if (runCode) {
                QueryDesignerPanel.this.m_tabSQL.submitCode(QueryDesignerPanel.this.m_WsAppServer, QueryDesignerPanel.this.m_WsServerRequest, false, priorCode);
            } else {
                QueryDesignerPanel.this.updateViewTitle(bundle.getString("QueryDesignerPanel.CodeGenerationFailure.txt"));
            }
        }
    }

    private class cSubmitValidateAction
    extends WsAbstractAction {
        public cSubmitValidateAction() {
            super(bundle, "QueryDesignerPanel.SubmitValidate", true);
            this.setMenuSupportId("submitvalidate");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (QueryDesignerPanel.this.m_WsAppServer == null) {
                QueryDesignerPanel.this.createServers();
            }
            QueryDesignerPanel.this.m_bShowLogWindowOnSubmitFinish = true;
            WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
            if (defaultsFile.getPropertyBoolean("Workspace.ClearLogBeforeSubmit", false) && QueryDesignerPanel.this.m_tabLog != null) {
                QueryDesignerPanel.this.m_tabLog.clear();
            }
            QueryDesignerPanel.this.m_bValidate = true;
            QueryDesignerPanel.this.m_tabSQL.submitCode(QueryDesignerPanel.this.m_WsAppServer, QueryDesignerPanel.this.m_WsServerRequest, true);
        }
    }

    private class cSubmitAllOptionAction
    extends WsAbstractToggleAction {
        public cSubmitAllOptionAction() {
            super(bundle, "QueryDesignerPanel.RunPriorSteps", 545);
            this.setMenuSupportId("submitpriorsteps");
            this.setHidable(true);
            boolean fState = QueryDesignerPanel.this.m_mdlSQL.getRunPriorSteps();
            WorkspaceMenuSupport menu = Workspace.getWorkspace().getMenuObject();
            if (menu != null) {
                menu.getMenuBar().setSelectedItemsState("submitpriorsteps", fState);
            }
            this.setSelected(fState);
        }

        public void actionPerformed(ActionEvent e) {
            boolean fState = !QueryDesignerPanel.this.m_mdlSQL.getRunPriorSteps();
            QueryDesignerPanel.this.m_mdlSQL.setRunPriorSteps(fState);
            WorkspaceMenuSupport menu = Workspace.getWorkspace().getMenuObject();
            if (menu != null) {
                menu.getMenuBar().setSelectedItemsState("submitpriorsteps", fState);
            }
        }
    }

    private class cKillAction
    extends WsAbstractAction {
        public cKillAction() {
            super(bundle, "QueryDesignerPanel.Kill", true);
            this.setMenuSupportId("killjob");
            this.setHidable(true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("QueryDesignerPanel.ConfirmKillMessage.txt"), (String)bundle.getString("QueryDesignerPanel.ConfirmKillTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            if (!QueryDesignerPanel.this.m_WsAppServer.isKilled()) {
                QueryDesignerPanel.this.killAppServer();
            }
        }
    }

    private class cTerminateAction
    extends WsAbstractAction {
        public cTerminateAction() {
            super(bundle, "QueryDesignerPanel.Terminate", true);
            this.setMenuSupportId("terminatejob");
            this.setHidable(true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("QueryDesignerPanel.ConfirmCancelMessage.txt"), (String)bundle.getString("QueryDesignerPanel.ConfirmCancelTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            QueryDesignerPanel.this.terminateRunningCode();
        }
    }

    private class QuerySelectionListener
    implements WsPFDSelectionListener {
        private QuerySelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(WsPFDSelectionEvent ev) {
            if (QueryDesignerPanel.this.ignoreSelectionEvents()) {
                return;
            }
            try {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(true);
                WAPropertyTab tabActive = QueryDesignerPanel.this.getActiveVisualsTab();
                if (tabActive instanceof QueryTab) {
                    QueryTab tabQuery = (QueryTab)tabActive;
                    ClauseInterface clause = tabQuery.getSelectedClause();
                    if (clause != null) {
                        QueryDesignerPanel.this.setSelectedClause(clause);
                    } else {
                        TableInterface table = tabQuery.getSelectedTable();
                        if (table != null) {
                            QueryDesignerPanel.this.setSelectedTable(table);
                        }
                    }
                }
            }
            finally {
                QueryDesignerPanel.this.setIgnoreSelectionEvents(false);
            }
        }
    }

    private class cUpdatePropertiesRunnable
    implements Runnable {
        PropertiesModel m_model;

        public cUpdatePropertiesRunnable(PropertiesModel mdl) {
            this.m_model = mdl;
        }

        @Override
        public void run() {
            this.m_model.startUpdatePropertyThreads();
        }
    }

    protected class cWsAppServerEventListener
    implements WsAppServerEventListener {
        protected cWsAppServerEventListener() {
        }

        public void eventHappened(WsAppServerEvent evt) {
            if (evt.getEventId() == 1) {
                SwingUtilities.invokeLater(new cGetLogRunnable(evt.getListText()));
            }
        }
    }

    private class cServerRequestDataChangedListener
    implements PropertyChangeListener {
        private cServerRequestDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase(WsServerRequest.DISPOSED)) {
                QueryDesignerPanel.this.m_WsServerRequest = null;
                QueryDesignerPanel.this.m_WsAppServer = null;
                return;
            }
            if (e.getPropertyName().equalsIgnoreCase("jobstatus")) {
                try {
                    String sAppServerName = null;
                    if (QueryDesignerPanel.this.m_WsServerRequest != null) {
                        sAppServerName = QueryDesignerPanel.this.m_WsServerRequest.getWsAppServerName();
                    }
                    if (sAppServerName == null) {
                        sAppServerName = "";
                    }
                    QueryDesignerPanel.this.updateViewTitle(e.getNewValue().toString());
                    if (e.getNewValue().equals(WsServerRequest.JOBABORTED) || e.getNewValue().equals(WsServerRequest.JOBERRORED) || e.getNewValue().equals(WsServerRequest.JOBKILLED) || e.getNewValue().equals(WsServerRequest.JOBTERMINATED) || e.getNewValue().equals(WsServerRequest.JOBSUCCESSFUL) || e.getNewValue().equals(WsServerRequest.JOBCANCELLED)) {
                        SwingUtilities.invokeLater(new cSubmitFinishRunnable((String)e.getNewValue()));
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    private class cSubmitFinishRunnable
    implements Runnable {
        private String m_sJobStatus;

        public cSubmitFinishRunnable(String sJobStatus) {
            this.m_sJobStatus = sJobStatus;
        }

        @Override
        public void run() {
            QueryDesignerPanel.this.submitFinished(this.m_sJobStatus);
        }
    }

    protected class cGetLogRunnable
    implements Runnable {
        private LogListHolder m_llhLog;

        public cGetLogRunnable(LogListHolder llhLog) {
            this.m_llhLog = llhLog;
        }

        @Override
        public void run() {
            if (QueryDesignerPanel.this.m_tabLog != null && this.m_llhLog != null) {
                QueryDesignerPanel.this.m_tabLog.appendText(this.m_llhLog);
            }
        }
    }
}

