/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.WorkTable;
import com.sas.rio.MVAResultSet;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListModel;

public class ChooseValuesPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ChooseValuesPanel.class);
    private DualListSelector m_dlsValues;
    private JCheckBox m_cbFormatValues;
    private JLabel m_lblMaxObs;
    private WAIntTextField m_intTxtMaxObs;
    private JButton m_btnGo;
    private Column m_column;
    private WsAppServer m_wsAppServer;
    private DefaultListModel m_listModel;
    private boolean m_bQuoteReturnValues = true;
    private static final int DEFAULT_NUMBER_ROWS = 100;
    private boolean m_bDisposeServer = false;
    private boolean m_bRetrieveSuccessful = true;
    private boolean m_bTableIsView = false;
    private PhysicalTable m_table = null;
    private String m_libraryTableName = null;
    private String m_columnName = null;
    private SASLibrary m_library = null;
    private String m_libref = null;
    private String m_message = "";

    public ChooseValuesPanel(WsAppServer appServer, Column column) {
        this.m_wsAppServer = appServer;
        this.m_column = column;
        this.initialize();
    }

    protected void initialize() {
        this.m_listModel = new DefaultListModel();
        this.m_cbFormatValues = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new cFormattedAction());
        this.m_cbFormatValues.setSelected(true);
        this.m_intTxtMaxObs = new WAIntTextField(false);
        this.m_lblMaxObs = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_intTxtMaxObs, (WAdminResource)bundle, (String)"ChooseValuesPanel.MaximumObservations");
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        int rows = defaultsFile.getPropertyInt("ChooseValuesPanel.NumberOfRows", 100);
        this.m_intTxtMaxObs.setValue(rows);
        this.m_dlsValues = new DualListSelector();
        this.m_dlsValues.setModel((ListModel)this.m_listModel);
        this.m_btnGo = WsUIUtilities.createTextButton((WsAbstractAction)new GoAction());
        try {
            DataTable table = this.m_column.getTable();
            if (!(table instanceof PhysicalTable)) {
                this.m_bRetrieveSuccessful = false;
                this.m_message = bundle.formatString("ChooseValuesPanel.IncorrectTable.Error.txt", (Object)table.getName());
                return;
            }
            this.m_table = (PhysicalTable)this.m_column.getTable();
            this.m_bTableIsView = PFDUtil.isTableView(this.m_table);
            this.m_columnName = DBMSNamesUtil.getQuotedString((String)this.m_column.getSASColumnName(), (DataTable)this.m_table, (boolean)false);
            RelationalSchema schema = this.m_table.getTablePackage();
            if (schema instanceof DatabaseSchema) {
                AssociationList usedPkgs = schema.getUsedByPackages();
                int size = usedPkgs.size();
                for (int i = 0; i < size; ++i) {
                    RelationalSchema temp = (RelationalSchema)usedPkgs.get(i);
                    if (!(temp instanceof SASLibrary)) continue;
                    this.m_library = (SASLibrary)temp;
                }
            } else {
                this.m_library = (SASLibrary)schema;
            }
            if (this.m_library != null) {
                this.m_libref = this.m_library.getLibref();
            } else if (this.m_library == null && this.m_table instanceof WorkTable) {
                this.m_libref = "work";
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ChooseValuesPanel.NoLibrary.Error.txt"), (int)0);
                return;
            }
            String tableName = DBMSNamesUtil.getQuotedString((String)this.m_table.getSASTableName(), (DataTable)this.m_table, (boolean)false);
            this.m_libraryTableName = this.m_libref + "." + tableName;
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            this.m_bRetrieveSuccessful = false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblMaxObs, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_intTxtMaxObs, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 15), 0, 0));
        this.add(this.m_btnGo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add(this.m_cbFormatValues, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_dlsValues, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.setPreferredSize(new Dimension(400, 300));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getColumnValues();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public String getTitle() {
        try {
            return bundle.formatString("ChooseValuesPanel.Title.txt", (Object)(this.m_table.getSASTableName() + "." + this.m_column.getSASColumnName()));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getColumnValues() {
        try {
            StringBuffer code;
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuffer strSetup = new StringBuffer();
            SASCodeGeneration codeGen = new SASCodeGeneration();
            strSetup.append(codeGen.getReturnCodeSetup());
            ParametersModel parmModel = new ParametersModel((Root)this.m_table);
            String parmCode = "";
            if (parmModel.isParameterizedObject() && (code = parmModel.getParameterMacroCode()) != null) {
                parmCode = code.toString();
            }
            if (!this.m_libref.equals("work")) {
                WsAppServer tServer = this.m_wsAppServer;
                this.m_wsAppServer = LibraryUtil.interactiveAccessPath((SASLibrary)this.m_library, (WsAppServer)tServer, (String)parmCode);
                if (!tServer.equals(this.m_wsAppServer)) {
                    this.m_bDisposeServer = true;
                }
            } else {
                this.m_bDisposeServer = false;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            this.m_bRetrieveSuccessful = false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (WsAppServerCodeException exc) {
            MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
            this.m_bRetrieveSuccessful = false;
        }
        catch (WsAppServerFailException exc) {
            MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
            this.m_bRetrieveSuccessful = false;
        }
        catch (WsAppServerLibraryException exc) {
            MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
            this.m_bRetrieveSuccessful = false;
        }
        int maxObs = 0;
        try {
            maxObs = this.m_intTxtMaxObs.getValue2();
        }
        catch (WAIntTextField.IllegalIntegerException exc) {
            MessageUtil.displayMessage((String)exc.getMessage(), (int)0);
        }
        try {
            this.m_wsAppServer.open();
        }
        catch (WsAppServerFailException exc) {
            MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
            this.m_bRetrieveSuccessful = false;
        }
        String tempName = this.m_libraryTableName;
        if (this.m_bTableIsView) {
            SASLogDialog logDialog;
            StringBuffer setup = new StringBuffer();
            setup.append("/* Build a temporary table to read since the table to query is a view */\n").append("data work.etls_temp (keep=").append(this.m_columnName).append(");\n").append("   if (_n_ > ").append(String.valueOf(maxObs)).append(") then stop;\n").append("   set ").append(this.m_libraryTableName).append(";\n").append("run;\n");
            try {
                this.m_wsAppServer.submitSASCode(setup.toString());
            }
            catch (WsAppServerCodeException exc) {
                if (0 == MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0, (int)0)) {
                    logDialog = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("ChooseValuesPanel.SASLogDialog.Title.txt"), true, this.m_wsAppServer);
                    logDialog.show();
                }
                this.m_bRetrieveSuccessful = false;
                return;
            }
            catch (WsAppServerFailException exc) {
                logDialog = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("ChooseValuesPanel.SASLogDialog.Title.txt"), true, this.m_wsAppServer);
                logDialog.show();
                this.m_bRetrieveSuccessful = false;
                return;
            }
            tempName = "work.etls_temp";
        }
        try {
            StringBuffer strSQL = new StringBuffer();
            StringBuffer formatQuery = new StringBuffer();
            StringBuffer informatQuery = new StringBuffer();
            String format = WsColumnMetadataUtil.makeValidFormatName((Column)this.m_column);
            if (format != null && format.length() > 0) {
                formatQuery.append(" format = ").append(format);
            }
            String unFmtStr = "best32.";
            boolean isCharColumn = WsColumnMetadataUtil.isColumnTypeCharacter((Column)this.m_column);
            if (isCharColumn) {
                unFmtStr = "$char.";
            }
            informatQuery.append(" format = ").append(unFmtStr);
            strSQL.append("select distinct ");
            strSQL.append(this.m_columnName);
            strSQL.append(" as val1");
            strSQL.append(formatQuery);
            strSQL.append(", ");
            strSQL.append(this.m_columnName);
            strSQL.append(" as val2");
            strSQL.append(informatQuery);
            strSQL.append(" from ");
            strSQL.append(tempName);
            if (maxObs > -1 && !this.m_bTableIsView) {
                strSQL.append(" (obs=" + String.valueOf(maxObs) + ") ");
            }
            System.out.println(strSQL);
            MVAResultSet resultSet = this.m_wsAppServer.submitSQLStatement(strSQL.toString());
            this.m_listModel.clear();
            while (resultSet.next()) {
                Object formattedValue = resultSet.getObject(1);
                Object unformattedValue = resultSet.getObject(2);
                if (formattedValue == null || unformattedValue == null) continue;
                this.m_listModel.addElement(new ColumnValue(formattedValue.toString(), unformattedValue.toString(), isCharColumn));
            }
            resultSet.close();
        }
        catch (SQLException exc) {
            MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
            this.m_bRetrieveSuccessful = false;
        }
        catch (WsAppServerFailException exc) {
            MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
            this.m_bRetrieveSuccessful = false;
        }
        finally {
            if (this.m_bDisposeServer && this.m_wsAppServer != null) {
                this.m_wsAppServer.dispose();
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean getStatus() {
        return this.m_bRetrieveSuccessful;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        int rows = 100;
        try {
            rows = this.m_intTxtMaxObs.getValue2();
        }
        catch (WAIntTextField.IllegalIntegerException illegalIntegerException) {
            // empty catch block
        }
        defaultsFile.setPropertyInt("ChooseValuesPanel.NumberOfRows", rows);
    }

    public String getMessage() {
        return this.m_message;
    }

    public List getSelectedValues() {
        ArrayList<String> newList = new ArrayList<String>();
        ListModel targetModel = this.m_dlsValues.getTargetModel();
        String format = WsColumnMetadataUtil.makeValidFormatName((Column)this.m_column);
        this.m_bQuoteReturnValues = this.m_cbFormatValues.isSelected() && format != null && format.length() != 0 || WsColumnMetadataUtil.isColumnTypeCharacter((Column)this.m_column);
        int size = targetModel.getSize();
        for (int i = 0; i < size; ++i) {
            if (this.m_bQuoteReturnValues) {
                newList.add("\"" + targetModel.getElementAt(i).toString() + "\"");
                continue;
            }
            newList.add(targetModel.getElementAt(i).toString());
        }
        return newList;
    }

    private String rtrim(String source) {
        return source.replaceAll("\\s+$", "");
    }

    public static List showChooseValuesDialog(WsAppServer appServer, Column column, String helpTopic) {
        ChooseValuesPanel pnl = new ChooseValuesPanel(appServer, column);
        List values = null;
        if (pnl.getStatus()) {
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), pnl.getTitle(), true);
            dialog.setMainPanel((WAPanel)pnl);
            dialog.setResizable(true);
            dialog.setHelpTopic(helpTopic);
            dialog.setHelpProduct("wdb");
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                values = pnl.getSelectedValues();
            }
        } else {
            String message = pnl.getMessage();
            if (message != null && message.length() > 0) {
                MessageUtil.displayMessage((String)message, (int)0);
            }
        }
        return values;
    }

    private void resetModel() {
        this.m_dlsValues.repaint();
    }

    private class cFormattedAction
    extends WsAbstractToggleAction {
        public cFormattedAction() {
            super(bundle, "ChooseValuesPanel.FormattedValues", 32);
        }

        public void actionPerformed(ActionEvent e) {
            ChooseValuesPanel.this.resetModel();
        }
    }

    private class GoAction
    extends WsAbstractAction {
        public GoAction() {
            super(bundle, "ChooseValues.GoAction");
        }

        public void actionPerformed(ActionEvent e) {
            ChooseValuesPanel.this.getColumnValues();
        }
    }

    protected class ColumnValue {
        private String m_formattedValue = "";
        private String m_unFormattedValue = "";
        private boolean m_bCharColumn = true;

        public ColumnValue(String formattedValue, String unFormattedValue, boolean charColumn) {
            this.m_formattedValue = formattedValue;
            this.m_unFormattedValue = unFormattedValue;
            this.m_bCharColumn = charColumn;
        }

        public String toString() {
            String val = "";
            val = ChooseValuesPanel.this.m_cbFormatValues.isSelected() ? this.m_formattedValue : this.m_unFormattedValue;
            return this.m_bCharColumn ? ChooseValuesPanel.this.rtrim(val) : val.trim();
        }
    }
}

