/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.QueryChangeEvent;
import com.sas.wadmin.transforms.sql.model.QueryChangeListener;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class BaseClausePropertiesModel
extends AbstractPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BaseClausePropertiesModel.class);
    private static final String DESCRIPTIONPROPERTY = bundle.getString("BaseClausePropertiesModel.Property.Description.txt");
    private int m_iDescription;
    private static final int PROPERTYCOUNT = 1;
    private ClauseInterface m_clause;
    private SQLModel m_mdlSQL;
    private QueryChangeListener m_lsnrSQLModel;

    public BaseClausePropertiesModel(ClauseInterface clause) {
        this(clause.getSQLModel());
        this.m_clause = clause;
        this.setProperty(this.m_iDescription, DESCRIPTIONPROPERTY, clause.getDescription(), BaseClausePropertiesModel.getDefaultRenderer(), true, BaseClausePropertiesModel.getDefaultEditor());
    }

    public BaseClausePropertiesModel(SQLModel mdlSQL) {
        this.m_mdlSQL = mdlSQL;
        this.m_lsnrSQLModel = new QueryModelListener();
        mdlSQL.addChangeListener(this.m_lsnrSQLModel);
    }

    @Override
    public int getNumberOfProperties() {
        return 1;
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iDescription = this.getNumberOfProperties() - 1;
    }

    @Override
    protected void initializeProperties() {
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty != this.m_iDescription) {
            throw new UnsupportedOperationException("Unknown property index: " + iProperty);
        }
        this.m_clause.setDescription((String)value);
    }

    protected void handleChange(String sAction) {
        if (sAction.equals("DescriptionChanged")) {
            this.setPropertyValueImpl(this.m_iDescription, this.m_clause.getDescription());
        }
    }

    @Override
    public void populate() throws MdException, RemoteException {
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException {
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
    }

    public void dispose() {
        this.m_mdlSQL.removeChangeListener(this.m_lsnrSQLModel);
    }

    private class QueryModelListener
    implements QueryChangeListener {
        private QueryModelListener() {
        }

        @Override
        public void queryChanged(QueryChangeEvent ev) {
            if (ev.getClause() != BaseClausePropertiesModel.this.m_clause) {
                return;
            }
            String sAction = ev.getAction();
            if (sAction == null) {
                return;
            }
            BaseClausePropertiesModel.this.handleChange(sAction);
        }
    }
}

