/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.spdsloader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.SPDSTableLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SPDSTableLoaderLoadTechniquePropertyTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(SPDSTableLoaderLoadTechniquePropertyTab.class);
    private SPDSTableLoaderTransformModel m_object;
    private TableLoaderModelListener m_listener;
    NameValueComboBoxModel m_mdlLoadType;
    protected static String REFRESH_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Refresh.display.option.txt");
    protected static String APPEND_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Append.display.option.txt");
    protected static String UPDATE_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Update.display.option.txt");
    protected static String DROP_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.display.option.txt");
    protected static String TRUNCATE_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.display.option.txt");
    protected static String REMOVE_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.display.option.txt");
    protected cLoadTypeListener m_cmbLoadTypeListener;
    protected JCheckBox m_chkRecreateIndexBefore;
    protected JCheckBox m_chkRecreateIndexAfter;
    protected JCheckBox m_chkParallelIndex;
    protected WAPanel m_panel;
    protected boolean m_hasUniqueKey;
    protected WAPanel m_pnlLoadType;
    protected JLabel m_lblLoadType;
    protected WAComboBox m_cmbLoadType;
    protected WAPanel m_pnlDelete;
    protected ButtonGroup m_bgpDelete;
    protected JRadioButton m_rdoTruncate = null;
    protected JRadioButton m_rdoRemove = null;
    protected JRadioButton m_rdoDrop = null;
    protected WAIntTextField m_txtLimitParallel;
    protected JLabel m_lblLimitParallel;
    protected boolean m_editable;
    private String m_loadValue;

    public SPDSTableLoaderLoadTechniquePropertyTab(SPDSTableLoaderTransformModel obj) {
        this.setName(bundle.getString("SPDSTableLoaderTransformAdapter.LoadTechniquePropertyTab.Title.txt"));
        this.m_object = obj;
        this.m_listener = new TableLoaderModelListener();
        this.m_object.getModel().addModelListener((IModelListener)this.m_listener);
        this.m_mdlLoadType = new NameValueComboBoxModel("SPDSTableLoaderTransformAdapter.LoadType", true);
        this.m_mdlLoadType.addItem("Refresh").addItem("Update").addItem("Append");
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("load_technique_spds_tab");
    }

    public void initialize() {
        try {
            this.m_cmbLoadType = new WAComboBox();
            this.m_lblLoadType = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbLoadType, (WAdminResource)bundle, (String)"SPDSLoaderLoadTechniquePropertyTab.LoadTechnique");
            this.m_cmbLoadType.setSorted(true);
            this.m_cmbLoadTypeListener = new cLoadTypeListener();
            this.m_cmbLoadType.addActionListener((ActionListener)this.m_cmbLoadTypeListener);
            this.listenForDataChangesTo((JComboBox)this.m_cmbLoadType);
            this.m_cmbLoadType.setModel((ComboBoxModel)this.m_mdlLoadType);
            Dimension dim = this.m_cmbLoadType.getPreferredSize();
            dim.width += 2;
            this.m_cmbLoadType.setMinimumSize(dim);
            this.m_cmbLoadType.setPreferredSize(dim);
            this.m_pnlDelete = new WAPanel();
            this.m_pnlDelete.setBorder((Border)new TitledBorder(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.DropTruncate.label.txt")));
            this.m_bgpDelete = new ButtonGroup();
            this.m_rdoTruncate = new JRadioButton(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.display.option.txt"));
            this.m_rdoTruncate.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.Tooltip.txt"));
            this.m_rdoTruncate.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.mnem").charAt(0));
            this.m_rdoTruncate.addActionListener(new DropTableListener());
            this.m_bgpDelete.add(this.m_rdoTruncate);
            this.m_rdoRemove = new JRadioButton(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.display.option.txt"));
            this.m_rdoRemove.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.Tooltip.txt"));
            this.m_rdoRemove.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.mnem").charAt(0));
            this.m_rdoRemove.addActionListener(new DropTableListener());
            this.m_bgpDelete.add(this.m_rdoRemove);
            this.m_rdoDrop = new JRadioButton(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.display.option.txt"));
            this.m_rdoDrop.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.Tooltip.txt"));
            this.m_rdoDrop.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.mnem").charAt(0));
            this.m_rdoDrop.addActionListener(new DropTableListener());
            this.m_bgpDelete.add(this.m_rdoDrop);
            cReplaceTypeListener replaceTypeListener = new cReplaceTypeListener();
            this.m_rdoTruncate.addActionListener(replaceTypeListener);
            this.m_rdoRemove.addActionListener(replaceTypeListener);
            this.m_rdoDrop.addActionListener(replaceTypeListener);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "", 0);
        }
        this.m_rdoTruncate.setSelected(true);
        super.initialize();
        this.m_chkRecreateIndexBefore = new JCheckBox(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexesBefore.label.txt"));
        this.m_chkRecreateIndexBefore.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexesBefore.Tooltip.txt"));
        this.m_chkRecreateIndexBefore.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexesBefore.mnem").charAt(0));
        this.m_chkRecreateIndexBefore.addActionListener(new RecreateIndexBeforeListener());
        this.listenForDataChangesTo(this.m_chkRecreateIndexBefore);
        this.m_chkRecreateIndexAfter = new JCheckBox(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexesAfter.label.txt"));
        this.m_chkRecreateIndexAfter.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexesAfter.Tooltip.txt"));
        this.m_chkRecreateIndexAfter.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexesAfter.mnem").charAt(0));
        this.m_chkRecreateIndexAfter.addActionListener(new RecreateIndexAfterListener());
        this.listenForDataChangesTo(this.m_chkRecreateIndexAfter);
        this.m_chkParallelIndex = new JCheckBox(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.label.txt"));
        this.m_chkParallelIndex.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.Tooltip.txt"));
        this.m_chkParallelIndex.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.mnem").charAt(0));
        this.m_chkParallelIndex.addActionListener(new ParallelIndexListener());
        this.listenForDataChangesTo(this.m_chkRecreateIndexBefore);
        this.listenForDataChangesTo(this.m_chkRecreateIndexAfter);
        this.m_txtLimitParallel = new WAIntTextField();
        this.m_txtLimitParallel.setColumns(3);
        this.m_lblLimitParallel = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtLimitParallel, (WAdminResource)bundle, (String)"SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.Limit");
        this.m_txtLimitParallel.setEnabled(false);
        this.m_txtLimitParallel.setEditable(false);
    }

    public void moveDataToView() throws MdException, RemoteException {
        boolean parallelIndexEnabled;
        this.setListeningForChanges(false);
        this.m_mdlLoadType.setSelectedValue(this.m_object.getLoadType());
        this.m_chkRecreateIndexBefore.setSelected(this.m_object.isDropRecreateIndexesBeforeSet());
        this.m_chkRecreateIndexAfter.setSelected(this.m_object.isDropRecreateIndexesAfterSet());
        this.m_chkParallelIndex.setSelected(this.m_object.isParallelIndexCreationSet());
        boolean bl = parallelIndexEnabled = this.m_object.isDropRecreateIndexesBeforeSet() || this.m_object.isDropRecreateIndexesAfterSet();
        if (parallelIndexEnabled) {
            parallelIndexEnabled = this.isEditable();
        }
        this.m_txtLimitParallel.setEnabled(parallelIndexEnabled);
        this.m_txtLimitParallel.setEditable(this.m_object.isParallelIndexCreationSet() && this.isEditable());
        this.m_chkParallelIndex.setEnabled(parallelIndexEnabled);
        this.m_txtLimitParallel.setValue(this.m_object.getGroupingLimit());
        int iReplaceType = this.m_object.getRefreshType();
        if (iReplaceType == 2) {
            this.m_rdoDrop.setSelected(true);
        } else if (iReplaceType == 0) {
            this.m_rdoTruncate.setSelected(true);
        } else if (iReplaceType == 1) {
            this.m_rdoRemove.setSelected(true);
        }
        String loadType = this.m_object.getLoadType().trim();
        boolean refresh = loadType.equals("Refresh");
        if (refresh) {
            refresh = this.isEditable();
        }
        this.m_rdoTruncate.setEnabled(refresh);
        this.m_rdoDrop.setEnabled(refresh);
        this.m_rdoRemove.setEnabled(refresh);
        ITable[] targetList = this.m_object.getTargetTables();
        ITable targetTable = null;
        if (targetList.length > 0) {
            targetTable = targetList[0];
        }
        if (targetTable == null) {
            this.setEditable(false);
            return;
        }
        this.setEditable(this.isEnabled());
        this.setDataChanged(false);
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_object.setGroupingLimit(this.m_txtLimitParallel.getText());
    }

    public boolean loadTypeChange() {
        boolean refresh = false;
        this.m_loadValue = this.m_object.getLoadType();
        this.m_mdlLoadType.setSelectedValue(this.m_loadValue);
        if (this.m_loadValue.equals("Refresh")) {
            this.m_rdoTruncate.setEnabled(this.m_editable);
            this.m_rdoRemove.setEnabled(this.m_editable);
            this.m_rdoDrop.setEnabled(this.m_editable);
            this.m_chkRecreateIndexBefore.setEnabled(this.m_editable);
            this.m_chkRecreateIndexAfter.setEnabled(this.m_editable);
            if (this.m_editable) {
                refresh = true;
            }
        } else if (this.m_loadValue.equals("Update")) {
            if (this.m_chkRecreateIndexAfter.isSelected()) {
                this.m_chkRecreateIndexAfter.setSelected(false);
                this.m_chkParallelIndex.setEnabled(false);
                this.m_txtLimitParallel.setEnabled(false);
                this.m_txtLimitParallel.setEditable(false);
            }
            this.m_chkRecreateIndexBefore.setEnabled(this.m_editable);
            this.m_chkRecreateIndexAfter.setEnabled(false);
        } else {
            this.m_chkRecreateIndexBefore.setEnabled(this.m_editable);
            this.m_chkRecreateIndexAfter.setEnabled(this.m_editable);
        }
        this.m_rdoTruncate.setEnabled(refresh);
        this.m_rdoRemove.setEnabled(refresh);
        this.m_rdoDrop.setEnabled(refresh);
        return true;
    }

    public void recreateIndexBeforeChange() {
        if (this.m_chkRecreateIndexBefore.isSelected()) {
            this.m_chkParallelIndex.setEnabled(this.m_editable);
        } else {
            this.m_chkParallelIndex.setEnabled(false);
        }
        this.parallelIndexChange();
    }

    public void recreateIndexAfterChange() {
        if (this.m_chkRecreateIndexAfter.isSelected()) {
            this.m_chkParallelIndex.setEnabled(this.m_editable);
        } else {
            this.m_chkParallelIndex.setEnabled(false);
        }
        this.parallelIndexChange();
    }

    public void parallelIndexChange() {
        if (!this.m_chkRecreateIndexAfter.isSelected() && !this.m_chkRecreateIndexBefore.isSelected()) {
            this.m_chkParallelIndex.setEnabled(false);
            this.m_txtLimitParallel.setEnabled(false);
            this.m_txtLimitParallel.setEditable(false);
        } else if (this.m_chkParallelIndex.isSelected()) {
            this.m_txtLimitParallel.setEnabled(this.m_editable);
            this.m_txtLimitParallel.setEditable(this.m_editable);
        } else {
            this.m_txtLimitParallel.setEnabled(false);
            this.m_txtLimitParallel.setEditable(false);
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.m_pnlLoadType = new WAPanel();
        this.m_pnlLoadType.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlLoadType.add((Component)this.m_lblLoadType, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.m_pnlLoadType.add((Component)this.m_cmbLoadType, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel m_pnlIndexes = new JPanel();
        m_pnlIndexes.setLayout(new GridBagLayout());
        m_pnlIndexes.add((Component)this.m_chkRecreateIndexBefore, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlIndexes.add((Component)this.m_chkRecreateIndexAfter, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlIndexes.add((Component)this.m_chkParallelIndex, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlIndexes.add((Component)this.m_lblLimitParallel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        m_pnlIndexes.add((Component)this.m_txtLimitParallel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel m_pnlTechnique = new JPanel();
        m_pnlTechnique.setLayout(new GridBagLayout());
        m_pnlTechnique.add((Component)this.m_rdoTruncate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlTechnique.add((Component)this.m_rdoRemove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlTechnique.add((Component)this.m_rdoDrop, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelete.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlDelete.add((Component)m_pnlTechnique, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelete.add((Component)m_pnlIndexes, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlLoadType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlDelete, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        String loadType = this.m_object.getLoadType().trim();
        boolean refresh = loadType.equals("Refresh");
        if (refresh) {
            refresh = bEditable;
        }
        this.m_cmbLoadType.setEnabled(bEditable);
        this.m_rdoTruncate.setEnabled(refresh);
        this.m_rdoDrop.setEnabled(refresh);
        this.m_rdoRemove.setEnabled(refresh);
        this.m_chkRecreateIndexBefore.setEnabled(bEditable);
        this.m_editable = bEditable;
    }

    public boolean validateData() {
        String loadValue = this.m_object.getLoadType();
        if (loadValue.equals("Update")) {
            IPhysicalTable dataTarget;
            IIndex[] indexList;
            int sz;
            ITable[] targetList = this.m_object.getTargetTables();
            ITable targetTable = null;
            if (targetList.length > 0) {
                targetTable = targetList[0];
            }
            if ((sz = (indexList = (dataTarget = (IPhysicalTable)targetTable).getIndexes()).length) > 0) {
                for (int i = 0; i < sz; ++i) {
                    IIndex index = indexList[i];
                    if (!index.isUnique()) continue;
                    this.m_hasUniqueKey = true;
                    break;
                }
            }
            if (!this.m_hasUniqueKey) {
                MessageUtil.displayMessage((String)bundle.getString("SPDSLoaderLoadTechniquePropertyTab.UpdateUniqueIndexWarning.msg.txt"), (int)0, (int)-1);
                return false;
            }
        }
        if (this.m_object.isRefreshLoadType() && (this.m_object.isRemoveAllRefreshType() || this.m_object.isDropRefreshType()) && !this.m_object.isDropRecreateIndexesAfterSet() && !this.m_object.isDropRecreateIndexesBeforeSet()) {
            MessageUtil.displayMessage((String)bundle.getString("SPDSLoaderLoadTechniquePropertyTab.IndexCreationMustBeSelected.msg.txt"), (int)0, (int)-1);
            return false;
        }
        return true;
    }

    private void handleLoadTypeChanged() {
        this.m_mdlLoadType.setSelectedValue(this.m_object.getLoadType());
    }

    private void handleDropRecreateIndexBeforeChanged() {
        this.m_chkRecreateIndexBefore.setSelected(this.m_object.isDropRecreateIndexesBeforeSet());
    }

    private void handleDropRecreateIndexAfterChanged() {
        this.m_chkRecreateIndexAfter.setSelected(this.m_object.isDropRecreateIndexesAfterSet());
    }

    private void handleParallelIndexCreationChanged() {
        this.m_chkParallelIndex.setSelected(this.m_object.isParallelIndexCreationSet());
    }

    private void handleRefreshTypeChanged() {
        int iReplaceType = this.m_object.getRefreshType();
        if (iReplaceType == 2) {
            this.m_rdoDrop.setSelected(true);
        } else if (iReplaceType == 0) {
            this.m_rdoTruncate.setSelected(true);
        } else if (iReplaceType == 1) {
            this.m_rdoRemove.setSelected(true);
        }
    }

    private void handleGroupingLimitChanged() {
        this.m_txtLimitParallel.setText(String.valueOf(this.m_object.getGroupingLimit()));
    }

    private class TableLoaderModelListener
    implements IModelListener {
        private TableLoaderModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (type.equals("SPDSTableLoaderTransformModel:LoadTypeChanged")) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.handleLoadTypeChanged();
            } else if (type.equals("SPDSTableLoaderTransformModel:DropRecreateIndexesAfterChanged")) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.handleDropRecreateIndexAfterChanged();
            } else if (type.equals("SPDSTableLoaderTransformModel:DropRecreateIndexesBeforeChanged")) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.handleDropRecreateIndexBeforeChanged();
            } else if (type.equals("SPDSTableLoaderTransformModel:ParallelIndexCreationChanged")) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.handleParallelIndexCreationChanged();
            } else if (type.equals("SPDSTableLoaderTransformModel:GroupingLimitChanged")) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.handleGroupingLimitChanged();
            } else if (type.equals("SPDSTableLoaderTransformModel:RefreshTypeChanged")) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.handleRefreshTypeChanged();
            }
        }
    }

    private class NameValueComboBoxModel
    extends DefaultComboBoxModel {
        private String m_bundleKey;
        private boolean m_bSorted = false;

        public NameValueComboBoxModel(String bundleKey, boolean sorted) {
            this.m_bundleKey = bundleKey;
            this.m_bSorted = sorted;
        }

        public NameValueComboBoxModel addItem(String value) {
            String name = bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
            if (name == null) {
                name = "";
            }
            NameValueObject object = new NameValueObject(value, name);
            if (this.m_bSorted) {
                int x;
                int iElement;
                String sObject = object.toString();
                int nElements = this.getSize();
                for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
                }
                super.insertElementAt(object, iElement);
            } else {
                super.addElement(object);
            }
            return this;
        }

        public NameValueComboBoxModel addItemList(List values) {
            for (int t = 0; t < values.size(); ++t) {
                String value = (String)values.get(t);
                String name = bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
                if (name == null) {
                    name = "";
                }
                NameValueObject object = new NameValueObject(value, name);
                if (this.m_bSorted) {
                    int x;
                    int iElement;
                    String sObject = object.toString();
                    int nElements = this.getSize();
                    for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
                    }
                    super.insertElementAt(object, iElement);
                    continue;
                }
                super.addElement(object);
            }
            return this;
        }

        public NameValueComboBoxModel removeItem(String value) {
            String name = bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
            if (name == null) {
                name = "";
            }
            for (int i = 0; i < this.getSize(); ++i) {
                NameValueObject objInd = (NameValueObject)this.getElementAt(i);
                if (!objInd.getValue().equals(value)) continue;
                this.removeElementAt(i);
            }
            return this;
        }

        public String getSelectedValue() {
            if (this.getSelectedItem() instanceof NameValueObject) {
                return ((NameValueObject)this.getSelectedItem()).getValue();
            }
            if (this.getSelectedItem() != null) {
                return this.getSelectedItem().toString();
            }
            return "";
        }

        public void setSelectedValue(String value) {
            String strValue = value;
            for (int i = 0; i < this.getSize(); ++i) {
                NameValueObject n = (NameValueObject)this.getElementAt(i);
                if (!strValue.equals(n.getValue())) continue;
                super.setSelectedItem(n);
                return;
            }
        }

        public void setElementNameAt(int i, String name) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            n.m_name = name;
        }

        public String getElementValueAt(int i) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            return n.m_value;
        }

        public List getValueList() {
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < this.getSize(); ++i) {
                valueList.add(((NameValueObject)this.getElementAt(i)).getValue());
            }
            return valueList;
        }

        public String getBundleKey() {
            return this.m_bundleKey;
        }

        public void setBundleKey(String key) {
            this.m_bundleKey = key;
        }

        private class NameValueObject {
            private String m_name;
            private String m_value;

            public NameValueObject(String value, String name) {
                this.m_name = name;
                this.m_value = value;
            }

            public String toString() {
                return this.m_name;
            }

            public String getName() {
                return this.m_name;
            }

            public String getValue() {
                return this.m_value;
            }
        }
    }

    private class cLoadTypeListener
    implements ActionListener {
        private cLoadTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String value = ((NameValueComboBoxModel)SPDSTableLoaderLoadTechniquePropertyTab.this.m_cmbLoadType.getModel()).getSelectedValue();
            if (value.length() > 0) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setLoadType(value);
                SPDSTableLoaderLoadTechniquePropertyTab.this.loadTypeChange();
            }
        }
    }

    private class DropTableListener
    implements ActionListener {
        private DropTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSTableLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
            if (SPDSTableLoaderLoadTechniquePropertyTab.this.m_rdoDrop.isSelected() || SPDSTableLoaderLoadTechniquePropertyTab.this.m_rdoRemove.isSelected()) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkParallelIndex.setEnabled(true);
            }
            SPDSTableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class cReplaceTypeListener
    implements ActionListener {
        private cReplaceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SPDSTableLoaderLoadTechniquePropertyTab.this.m_rdoTruncate.isSelected()) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setRefreshType(0);
            } else if (SPDSTableLoaderLoadTechniquePropertyTab.this.m_rdoRemove.isSelected()) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setRefreshType(1);
                if (!SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexBefore.isSelected() && !SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexAfter.isSelected()) {
                    SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setDropRecreateIndexesBefore(true);
                }
            } else {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setRefreshType(2);
                if (!SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexBefore.isSelected() && !SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexAfter.isSelected()) {
                    SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setDropRecreateIndexesBefore(true);
                }
            }
            SPDSTableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class RecreateIndexBeforeListener
    implements ActionListener {
        private RecreateIndexBeforeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setDropRecreateIndexesBefore(SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexBefore.isSelected());
            if (SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexBefore.isSelected()) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexAfter.setSelected(false);
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setDropRecreateIndexesAfter(false);
                SPDSTableLoaderLoadTechniquePropertyTab.this.recreateIndexAfterChange();
            }
            SPDSTableLoaderLoadTechniquePropertyTab.this.recreateIndexBeforeChange();
            SPDSTableLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
            SPDSTableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class RecreateIndexAfterListener
    implements ActionListener {
        private RecreateIndexAfterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setDropRecreateIndexesAfter(SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexAfter.isSelected());
            if (SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexAfter.isSelected()) {
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkRecreateIndexBefore.setSelected(false);
                SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setDropRecreateIndexesBefore(false);
                SPDSTableLoaderLoadTechniquePropertyTab.this.recreateIndexBeforeChange();
            }
            SPDSTableLoaderLoadTechniquePropertyTab.this.recreateIndexAfterChange();
            SPDSTableLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
            SPDSTableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class ParallelIndexListener
    implements ActionListener {
        private ParallelIndexListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSTableLoaderLoadTechniquePropertyTab.this.m_object.setParallelIndexCreation(SPDSTableLoaderLoadTechniquePropertyTab.this.m_chkParallelIndex.isSelected());
            SPDSTableLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
            SPDSTableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }
}

