/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sort;

import com.sas.etl.models.job.ISortingTransform;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.transforms.sort.SortColsByTableModel;
import com.sas.wadmin.transforms.sort.SortColsByTreeModel;
import com.sas.wadmin.transforms.sort.SortColsByTreeTableSelector;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTreeCellRenderer;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTable;
import com.sas.workspace.visuals.dualselector.TreeTableSelector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class SASSortByTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(SASSortByTab.class);
    private ISortingTransform m_sortModel;
    private TreeTableSelector m_treeTableSelector;
    private WsTree m_tree;
    private DefaultSelectorTable m_defaultSelectorTable;
    private SortColsByTreeModel m_treeModel;
    private SortColsByTableModel m_tableModel;
    protected int m_iUseColsFromTable;
    private String m_sTargetPanelTitle;
    private JCheckBox m_ckbSortColumns;

    public SASSortByTab(ISortingTransform oSortingTransform, int useColsFromTable) {
        this(oSortingTransform, useColsFromTable, bundle.getString("SASSortByTab.Title.txt"), bundle.getString("SASSortByTab.SelectedColumns.txt"));
    }

    public SASSortByTab(ISortingTransform oSortingTransform, int useColsFromTable, String sTabTitle, String sTargetPanelTitle) {
        this.setName(sTabTitle);
        this.m_sortModel = oSortingTransform;
        this.m_iUseColsFromTable = useColsFromTable;
        this.setTargetPanelLabel(sTargetPanelTitle);
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("sort_by_columns_tab");
        this.setHelpProduct("wdb");
    }

    protected void initialize() {
        this.m_treeModel = new SortColsByTreeModel(this.m_sortModel, this.m_iUseColsFromTable);
        this.m_tree = new WsTree((DefaultTreeModel)((Object)this.m_treeModel));
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.setPopupMenuEnabled(false);
        this.m_tree.setEditable(false);
        this.m_tree.setRootVisible(false);
        this.m_tableModel = new SortColsByTableModel(this.m_sortModel);
        this.m_defaultSelectorTable = new DefaultSelectorTable((WsAbstractTableModel)this.m_tableModel);
        this.m_treeTableSelector = new SortColsByTreeTableSelector((JTree)this.m_tree, (JTable)this.m_defaultSelectorTable);
        this.m_defaultSelectorTable.setRowHeaderVisible(true);
        boolean actionEnabled = this.isEditable();
        this.m_treeTableSelector.setCopyModeEnabled(actionEnabled);
        this.m_treeTableSelector.setCopyModeDuplicatesAllowed(false);
        this.m_treeTableSelector.setTransferAllControlsVisible(false);
        this.m_treeTableSelector.setDragAndDropEnabled(true);
        this.m_treeTableSelector.setParentNodesMoveable(false);
        this.m_treeTableSelector.setTargetControlsVisible(actionEnabled);
        this.m_treeModel.addListenersToTree((JTree)this.m_treeTableSelector.getSourceComponent());
        this.m_treeTableSelector.setModel((TreeModel)((Object)this.m_treeModel));
        this.m_treeTableSelector.setSourceCellRenderer((TreeCellRenderer)new WsDefaultTreeCellRenderer());
        JLabel treeLbl = (JLabel)this.m_treeTableSelector.getTargetLabelComponent();
        treeLbl.setText(Util.getLabelWithoutMnemonic((String)this.getTargetPanelLabel()));
        int targetLabelMnemonicCharacter = Util.getDisplayedMnemonic((String)this.getTargetPanelLabel());
        int targetLabelMnemonicIndex = Util.getDisplayedMnemonicIndex((String)this.getTargetPanelLabel());
        treeLbl.setDisplayedMnemonic(targetLabelMnemonicCharacter);
        treeLbl.setDisplayedMnemonicIndex(targetLabelMnemonicIndex);
        JLabel tblLbl = (JLabel)this.m_treeTableSelector.getSourceLabelComponent();
        tblLbl.setText(Util.getLabelWithoutMnemonic((String)bundle.getString("SASSortByTab.AvailableColumns.txt")));
        int sourceLabelMnemonicCharacter = Util.getDisplayedMnemonic((String)bundle.getString("SASSortByTab.AvailableColumns.txt"));
        int sourceLabelMnemonicIndex = Util.getDisplayedMnemonicIndex((String)bundle.getString("SASSortByTab.AvailableColumns.txt"));
        tblLbl.setDisplayedMnemonic(sourceLabelMnemonicCharacter);
        tblLbl.setDisplayedMnemonicIndex(sourceLabelMnemonicIndex);
        this.m_ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASSortByTab.Checkbox.SortColumns");
        this.m_ckbSortColumns.addActionListener(new cSortColumnsListener());
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_treeTableSelector, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbSortColumns, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return true;
    }

    public void populateStore() {
    }

    public void moveDataToView() throws RemoteException, MdException {
        this.setListeningForChanges(false);
        this.m_tableModel.moveDataToModel();
        this.m_treeModel.moveDataToModel();
        this.m_treeModel.expandAll((JTree)this.m_treeTableSelector.getSourceComponent(), true);
        this.setListeningForChanges(true);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        boolean actionEnabled = this.isEditable();
        this.m_treeTableSelector.setEnabled(actionEnabled);
        this.m_defaultSelectorTable.setEditable(actionEnabled);
    }

    public void saveSettingsAndCleanUp() {
        this.m_tableModel.dispose();
    }

    public String getTargetPanelLabel() {
        return this.m_sTargetPanelTitle;
    }

    public void setTargetPanelLabel(String sTargetPanelLabel) {
        this.m_sTargetPanelTitle = sTargetPanelLabel;
    }

    protected class cSortColumnsListener
    implements ActionListener {
        protected cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SASSortByTab.this.m_treeModel.setSortColumns(SASSortByTab.this.m_ckbSortColumns.isSelected());
        }
    }
}

