/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd1;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.comparetables.ICompareTables;
import com.sas.etl.models.job.transforms.scd.ISCDMaximumKeyGeneration;
import com.sas.etl.models.job.transforms.scd.ISCDType1TransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.scd.ColumnSelectorPanel;
import com.sas.wadmin.transforms.scd.DefineMaxGeneratedKeyPanel;
import com.sas.wadmin.transforms.scd1.NaturalKeyPanel;
import com.sas.wadmin.transforms.scd1.NaturalKeySourceColumnsModel;
import com.sas.wadmin.transforms.scd1.NaturalKeyTargetTableModel;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SurrogateKeyPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(NaturalKeyPanel.class);
    private TitledBorder m_titledBorder;
    private ISCDType1TransformModel m_transformModel;
    private ICompareTables m_CompareTablesModel;
    private ModelListener m_lsnrModel;
    NaturalKeySourceColumnsModel m_leftTableModel;
    NaturalKeyTargetTableModel m_rightTableModel;
    private JCheckBox m_chkGenerateSurrogateKey;
    private JLabel m_surrogateKeyLabel;
    private WATextField m_surrogateKeyTextField;
    private JButton m_surrogateKeyButton;
    private JLabel m_newRecordLabel;
    private WATextField m_newRecordTextField;
    private JButton m_newRecordButton;
    private JButton m_btnMaxKey;
    private FocusListener m_focusListener;
    private ActionListener m_actionListener;
    private WsAbstractToggleAction m_actGenerateSurrogateKey;
    private WsAbstractAction m_actsurrogateKey;
    private WsAbstractAction m_actNewRecord;
    private WsAbstractAction m_actMaxKey;

    public SurrogateKeyPanel(ISCDType1TransformModel transformModel) {
        this.m_transformModel = transformModel;
        this.m_CompareTablesModel = this.m_transformModel.getCompareTablesObject();
        this.initialize();
        this.layoutWidgets();
        this.m_lsnrModel = new ModelListener();
        this.m_transformModel.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        this.setListeningForChanges(false);
    }

    protected void initialize() {
        this.createActions();
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("SurrogateKeyPanel.Title.txt"));
        this.setBorder(this.m_titledBorder);
        WATextArea txtAreaDesc = new WATextArea();
        txtAreaDesc.setBehavior(1);
        txtAreaDesc.setText(bundle.getString("SurrogateKeyPanel.SurrogateKeyDescription.txt"));
        txtAreaDesc.setAutosize(true);
        this.m_chkGenerateSurrogateKey = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actGenerateSurrogateKey);
        this.m_surrogateKeyTextField = new WATextField();
        this.m_surrogateKeyLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_surrogateKeyTextField, (String)bundle.getString("SurrogateKeyPanel.SurrogateKeyColumnLabel.txt"));
        this.m_surrogateKeyTextField.setToolTipText(bundle.getString("SurrogateKeyPanel.SurrogateKeyColumn.Tooltip.txt"));
        this.m_surrogateKeyTextField.setEditable(false);
        this.m_surrogateKeyTextField.setEnabled(false);
        this.m_surrogateKeyButton = WsUIUtilities.createBrowseButton();
        this.m_surrogateKeyButton.setAction((Action)this.m_actsurrogateKey);
        this.m_surrogateKeyButton.setToolTipText(bundle.getString("SurrogateKeyPanel.SurrogateKeyColumn.Tooltip.txt"));
        this.m_focusListener = new TextFieldFocusListener();
        this.m_actionListener = new TextFieldActionListener();
        this.m_newRecordTextField = new WATextField();
        this.m_newRecordLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_newRecordTextField, (String)bundle.getString("SurrogateKeyPanel.NewRecord.txt"));
        this.m_newRecordTextField.setToolTipText(bundle.getString("SurrogateKeyPanel.NewRecord.Tooltip.txt"));
        this.m_newRecordTextField.addFocusListener(this.m_focusListener);
        this.m_newRecordTextField.addActionListener(this.m_actionListener);
        this.m_newRecordButton = WsUIUtilities.createBrowseButton();
        this.m_newRecordButton.setAction((Action)this.m_actNewRecord);
        this.m_newRecordButton.setToolTipText(bundle.getString("SurrogateKeyPanel.NewRecordExpression.Tooltip.txt"));
        this.m_btnMaxKey = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actMaxKey);
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout());
        left.add((Component)this.m_surrogateKeyLabel, "North");
        left.add((Component)this.m_surrogateKeyTextField, "Center");
        left.add((Component)this.m_surrogateKeyButton, "East");
        JPanel right = new JPanel();
        right.setLayout(new BorderLayout());
        right.add((Component)this.m_newRecordLabel, "North");
        right.add((Component)this.m_newRecordTextField, "Center");
        right.add((Component)this.m_newRecordButton, "East");
        this.setLayout(new GridBagLayout());
        this.add((Component)txtAreaDesc, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_chkGenerateSurrogateKey, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(left, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 5), 0, 0));
        this.add(right, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnMaxKey, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
    }

    protected void layoutWidgets() {
    }

    public void setBorderTitle(String title) {
        this.m_titledBorder.setTitle(title);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setSurrogateKeyEnabled(this.m_transformModel.hasSurrogateKey());
        this.m_chkGenerateSurrogateKey.setSelected(this.m_transformModel.hasSurrogateKey());
        IColumn surrogateColumn = this.m_transformModel.getGenerateKeyColumn();
        if (surrogateColumn != null) {
            this.m_surrogateKeyTextField.setText(surrogateColumn.getName());
        }
        this.m_newRecordTextField.setText(this.m_transformModel.getNewGenerateKeyExpressionText());
    }

    public void saveSettingsAndCleanUp() {
        this.m_transformModel.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    protected IColumn[] promptForColumn() {
        if (this.m_CompareTablesModel.getComparisonTable() == null) {
            MessageUtil.displayMessage((String)bundle.getString("SurrogateKeyPanel.NoOutputTable.txt"), (int)1);
            return null;
        }
        String title = bundle.formatString("SurrogateKeyPanel.SelectColumn.Title.txt", (Object)this.m_CompareTablesModel.getComparisonTable().getName());
        ColumnSelectorPanel colSelector = new ColumnSelectorPanel((ITable)this.m_CompareTablesModel.getComparisonTable(), bundle.getString("SurrogateKeyPanel.SelectColumn.Desc.txt"), false);
        ArrayList<IColumn> hiddenColumns = new ArrayList<IColumn>();
        IMapping[] mkMappings = this.m_CompareTablesModel.getMatchKeyMappings();
        for (int i = 0; i < mkMappings.length; ++i) {
            IMapping mkMap = mkMappings[i];
            IColumn[] tCols = mkMap.getTargets();
            if (tCols == null || tCols.length <= 0) continue;
            IColumn tCol = tCols[0];
            hiddenColumns.add(tCol);
        }
        IMapping[] ccMappings = this.m_CompareTablesModel.getCompareColumnsMappings();
        for (int i = 0; i < ccMappings.length; ++i) {
            IMapping ccMap = ccMappings[i];
            IColumn[] tCols = ccMap.getTargets();
            if (tCols == null || tCols.length <= 0) continue;
            IColumn tCol = tCols[0];
            hiddenColumns.add(tCol);
        }
        if (this.m_CompareTablesModel.getComparisonTable().getColumnCount() == hiddenColumns.size()) {
            MessageUtil.displayMessage((String)bundle.getString("SurrogateKeyPanel.NoColumns.txt"), (int)1);
            return null;
        }
        colSelector.hideColumns(hiddenColumns);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)colSelector);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return colSelector.getSelectedColumns();
        }
        return null;
    }

    protected void createActions() {
        this.m_actGenerateSurrogateKey = new cGenerateSurrogateKeyCheckBoxAction();
        this.m_actsurrogateKey = new SurrogateKeyAction();
        this.m_actNewRecord = new NewRecordAction();
        this.m_actMaxKey = new cMaxKeyAction();
    }

    protected void setSurrogateKeyEnabled(boolean enabled) {
        this.m_surrogateKeyButton.setEnabled(enabled);
        if (!enabled) {
            this.m_btnMaxKey.setEnabled(enabled);
            this.m_newRecordButton.setEnabled(enabled);
            this.m_newRecordTextField.setEnabled(enabled);
        } else if (this.m_transformModel.getGenerateKeyColumn() != null) {
            this.m_btnMaxKey.setEnabled(enabled);
            this.m_newRecordButton.setEnabled(enabled);
            this.m_newRecordTextField.setEnabled(enabled);
        } else {
            this.m_btnMaxKey.setEnabled(false);
            this.m_newRecordButton.setEnabled(false);
            this.m_newRecordTextField.setEnabled(false);
        }
    }

    protected void setEnabledStateForButtons(boolean enabled) {
        this.m_btnMaxKey.setEnabled(enabled);
        this.m_newRecordButton.setEnabled(enabled);
        this.m_newRecordTextField.setEnabled(enabled);
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            Object obj1 = ev.getData();
            System.out.println("stop here");
            if (sType == "SCDType1TransformModel:HasSurrgateKeyChanged") {
                boolean bsurrogateKey = ((ISCDType1TransformModel)obj).hasSurrogateKey();
                SurrogateKeyPanel.this.m_chkGenerateSurrogateKey.setSelected(bsurrogateKey);
                SurrogateKeyPanel.this.setSurrogateKeyEnabled(bsurrogateKey);
            }
            if (sType == "SCDType1TransformModel:SurrogateKeyChanged") {
                if (obj1 instanceof IColumn) {
                    SurrogateKeyPanel.this.m_surrogateKeyTextField.setText(((IColumn)obj1).getName());
                } else {
                    SurrogateKeyPanel.this.m_surrogateKeyTextField.setText("");
                }
                SurrogateKeyPanel.this.setEnabledStateForButtons(obj1 instanceof IColumn);
            }
            if (sType == "SCDType1TransformModel:NewSurrogateKeyExpressionTextChanged") {
                if (obj1 instanceof String) {
                    SurrogateKeyPanel.this.m_newRecordTextField.setText((String)obj1);
                } else {
                    SurrogateKeyPanel.this.m_newRecordTextField.setText("");
                }
            }
        }
    }

    private class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (event.getComponent() == SurrogateKeyPanel.this.m_newRecordTextField) {
                SurrogateKeyPanel.this.m_transformModel.setNewGenerateKeyExpressionText(SurrogateKeyPanel.this.m_newRecordTextField.getText());
            }
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == SurrogateKeyPanel.this.m_newRecordTextField) {
                SurrogateKeyPanel.this.m_transformModel.setNewGenerateKeyExpressionText(SurrogateKeyPanel.this.m_newRecordTextField.getText());
            }
        }
    }

    protected class cGenerateSurrogateKeyCheckBoxAction
    extends WsAbstractToggleAction {
        public cGenerateSurrogateKeyCheckBoxAction() {
            super(bundle, "SurrogateKeyPanel.GenerateKey", 0);
        }

        public void actionPerformed(ActionEvent event) {
            SurrogateKeyPanel.this.setSurrogateKeyEnabled(SurrogateKeyPanel.this.m_chkGenerateSurrogateKey.isSelected());
            SurrogateKeyPanel.this.m_transformModel.setHasSurrogateKey(SurrogateKeyPanel.this.m_chkGenerateSurrogateKey.isSelected());
        }
    }

    private class SurrogateKeyAction
    extends WsAbstractAction {
        public SurrogateKeyAction() {
            this.putValue("Name", bundle.getString("SurrogateKeyPanel.Browse.txt"));
        }

        public void actionPerformed(ActionEvent e) {
            IColumn[] compCol = SurrogateKeyPanel.this.promptForColumn();
            if (compCol != null && compCol.length > 0) {
                IColumn col = compCol[0];
                SurrogateKeyPanel.this.m_surrogateKeyTextField.setText(col.getName());
                SurrogateKeyPanel.this.m_transformModel.setGenerateKeyColumn(col);
                SurrogateKeyPanel.this.m_btnMaxKey.setEnabled(true);
                SurrogateKeyPanel.this.m_newRecordButton.setEnabled(true);
                SurrogateKeyPanel.this.m_newRecordTextField.setEnabled(true);
            }
        }
    }

    private class NewRecordAction
    extends WsAbstractAction {
        public NewRecordAction() {
            this.putValue("Name", bundle.getString("SurrogateKeyPanel.Browse.txt"));
        }

        public void actionPerformed(ActionEvent e) {
            String expression = SurrogateKeyPanel.this.m_newRecordTextField.getText();
            ExpressionBuilderTab expressionBuilder = new ExpressionBuilderTab(new IColumn[0], new ITable[]{SurrogateKeyPanel.this.m_transformModel.getTargetTables()[0]}, false);
            expressionBuilder.setExpression(expression);
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SurrogateKeyPanel.ExpressionBuilder.Title.txt"), true, (WAPanel)expressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                SurrogateKeyPanel.this.m_transformModel.setNewGenerateKeyExpressionText(expressionBuilder.getExpression());
            }
            SurrogateKeyPanel.this.m_newRecordTextField.setText(expressionBuilder.getExpression());
            SurrogateKeyPanel.this.m_newRecordTextField.requestFocus();
        }
    }

    protected class cMaxKeyAction
    extends WsAbstractAction {
        public cMaxKeyAction() {
            super(bundle, "SurrogateKeyPanel.MaxKey", 0);
        }

        public void actionPerformed(ActionEvent e) {
            DefineMaxGeneratedKeyPanel keyGenPanel = new DefineMaxGeneratedKeyPanel((ISCDMaximumKeyGeneration)SurrogateKeyPanel.this.m_transformModel);
            ModelUIUtilities.showDialog((IObject)SurrogateKeyPanel.this.m_transformModel, bundle.getString("SurrogateKeyPanel.MaxKeyGenerator.Title.txt"), keyGenPanel);
        }
    }
}

