/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.scd.ISCDType2TransformModel;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.wadmin.transforms.scd.ColumnItem;
import com.sas.wadmin.transforms.scd.OrderedColumnListModel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;

public class Type1ColumnsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(Type1ColumnsTab.class);
    private Type1DualListSelector m_dualListPanel;
    private DefaultListModel m_sourceModel;
    private DefaultListModel m_targetModel;
    private ISCDType2TransformModel m_model;
    private IModelListener m_modelListener;
    private WATextArea m_textDescription;

    public Type1ColumnsTab(ISCDType2TransformModel model) {
        this.m_model = model;
        this.initialize();
        this.setName(bundle.getString("Type1ColumnsTab.Title.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("type_1_columns_tab");
    }

    public void initialize() {
        this.createListeners();
        this.createTextDescription();
        this.createDualListPanel();
        this.layoutComponents();
    }

    protected void createTextDescription() {
        this.m_textDescription = new WATextArea();
        this.m_textDescription.setBehavior(1);
        this.m_textDescription.setText(bundle.getString("Type1ColumnsTab.PanelDesc.txt"));
        this.m_textDescription.setAutosize(true);
    }

    protected void createDualListPanel() {
        this.m_dualListPanel = new Type1DualListSelector();
        this.m_dualListPanel.setCopyModeEnabled(false);
        this.m_dualListPanel.setTargetControlsVisible(true);
        this.m_sourceModel = new OrderedColumnListModel();
        this.m_dualListPanel.setModel(this.m_sourceModel);
        this.m_dualListPanel.setSourceLabel(bundle.getString("Type1ColumnsTab.Left.Label.txt"));
        JLabel label = (JLabel)this.m_dualListPanel.getSourceLabelComponent();
        label.setDisplayedMnemonic(bundle.getString("Type1ColumnsTab.Left.mnem").charAt(0));
        label.setToolTipText(bundle.getString("Type1ColumnsTab.Left.Tooltip.txt"));
        this.m_targetModel = new OrderedColumnListModel();
        this.m_dualListPanel.setTargetModel(this.m_targetModel);
        this.m_dualListPanel.setTargetLabel(bundle.getString("Type1ColumnsTab.Right.Label.txt"));
        label = (JLabel)this.m_dualListPanel.getTargetLabelComponent();
        label.setDisplayedMnemonic(bundle.getString("Type1ColumnsTab.Right.mnem").charAt(0));
        label.setToolTipText(bundle.getString("Type1ColumnsTab.Right.Tooltip.txt"));
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_textDescription, "North");
        this.add((Component)((Object)this.m_dualListPanel), "Center");
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_dualListPanel.setEnabled(bEditable);
    }

    protected void createListeners() {
        this.m_modelListener = this.createModelListener();
        this.m_model.getModel().addModelListener(this.m_modelListener);
    }

    protected IModelListener createModelListener() {
        return new ModelListener();
    }

    public boolean validateData() {
        return true;
    }

    public void moveDataToView() {
        int i;
        this.setListeningForChanges(false);
        this.m_sourceModel.clear();
        this.m_targetModel.clear();
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            return;
        }
        List type1Columns = this.m_model.getType1ColumnsList();
        List<IColumn> targetColumns = Arrays.asList(targets[0].getColumns());
        List specialColumns = this.getSpecialColumns();
        for (i = 0; i < targetColumns.size(); ++i) {
            IColumn column = targetColumns.get(i);
            if (type1Columns.contains(column) || specialColumns.contains(column)) continue;
            this.m_sourceModel.addElement(new ColumnItem(column));
        }
        for (i = 0; i < type1Columns.size(); ++i) {
            this.m_targetModel.addElement(new ColumnItem((IColumn)type1Columns.get(i)));
        }
        this.setListeningForChanges(true);
    }

    private List getSpecialColumns() {
        ArrayList<IColumn> specialColumns = new ArrayList<IColumn>();
        if (this.m_model.isTrackChangesByDates() && this.m_model.getFromDateColumn() != null) {
            specialColumns.add(this.m_model.getFromDateColumn());
        }
        if (this.m_model.isTrackChangesByDates() && this.m_model.getToDateColumn() != null) {
            specialColumns.add(this.m_model.getToDateColumn());
        }
        if (this.m_model.isTrackChangesByVersionNumber() && this.m_model.getVersionColumn() != null) {
            specialColumns.add(this.m_model.getVersionColumn());
        }
        if (this.m_model.isTrackChangesByCurrentIndicator() && this.m_model.getCurrentIndicatorColumn() != null) {
            specialColumns.add(this.m_model.getCurrentIndicatorColumn());
        }
        if (this.m_model.getGenerateKeyColumn() != null) {
            specialColumns.add(this.m_model.getGenerateKeyColumn());
        }
        if (this.m_model.getLoadTimeColumn() != null) {
            specialColumns.add(this.m_model.getLoadTimeColumn());
        }
        specialColumns.addAll(this.m_model.getBusinessKeyColumnsList());
        specialColumns.addAll(this.m_model.getDigestVarsList());
        return specialColumns;
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.getModel().removeModelListener(this.m_modelListener);
    }

    private class Type1DualListSelector
    extends DualListSelector {
        private Type1DualListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            Type1ColumnsTab.this.setListeningForChanges(false);
            List items = fromAdapter.getSelectedItems();
            super.transferItems(fromAdapter, toAdapter);
            try {
                Type1ColumnsTab.this.m_model.getModel().startCompoundUndoable();
                for (int i = 0; i < items.size(); ++i) {
                    ColumnItem item = (ColumnItem)items.get(i);
                    if (fromAdapter == this.sourceAdapter) {
                        Type1ColumnsTab.this.m_model.getType1ColumnsList().add(item.getColumn());
                        continue;
                    }
                    if (fromAdapter != this.targetAdapter) continue;
                    Type1ColumnsTab.this.m_model.getType1ColumnsList().remove(item.getColumn());
                }
            }
            finally {
                Type1ColumnsTab.this.m_model.getModel().endCompoundUndoable();
                Type1ColumnsTab.this.setListeningForChanges(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            Type1ColumnsTab.this.setListeningForChanges(false);
            List items = fromAdapter.getAllMoveableItems();
            super.transferAllItems(fromAdapter, toAdapter);
            try {
                Type1ColumnsTab.this.m_model.getModel().startCompoundUndoable();
                for (int i = 0; i < items.size(); ++i) {
                    ColumnItem item = (ColumnItem)items.get(i);
                    if (fromAdapter == this.sourceAdapter) {
                        Type1ColumnsTab.this.m_model.getType1ColumnsList().add(item.getColumn());
                        continue;
                    }
                    if (fromAdapter != this.targetAdapter) continue;
                    Type1ColumnsTab.this.m_model.getType1ColumnsList().remove(item.getColumn());
                }
            }
            finally {
                Type1ColumnsTab.this.m_model.getModel().endCompoundUndoable();
                Type1ColumnsTab.this.setListeningForChanges(true);
            }
        }
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            IObject object = event.getModelObject();
            if (!Type1ColumnsTab.this.isListeningForChanges()) {
                return;
            }
            if (type == "ModelController:UnknownChanges") {
                Type1ColumnsTab.this.moveDataToView();
                return;
            }
            if (object != Type1ColumnsTab.this.m_model) {
                return;
            }
            if (type == "SCDType2TransformModel:Type1ColumnAdded") {
                IColumn column = (IColumn)event.getData();
                Type1ColumnsTab.this.m_sourceModel.removeElement(new ColumnItem(column));
                Type1ColumnsTab.this.m_targetModel.addElement(new ColumnItem(column));
            } else if (type == "SCDType2TransformModel:Type1ColumnRemoved") {
                IColumn column = (IColumn)event.getData();
                Type1ColumnsTab.this.m_sourceModel.addElement(new ColumnItem(column));
                Type1ColumnsTab.this.m_targetModel.removeElement(new ColumnItem(column));
            }
        }
    }
}

