/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.wadmin.visuals.common.ColumnsTableModel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnSelectorPanel
extends WAPanel {
    protected ITable m_table;
    protected WsTable m_colsTable;
    protected ColumnSelectorTableModel m_colsModel;
    protected JScrollPane m_colsTablePane;
    protected WATextArea m_description;
    protected String m_userDescription;
    protected boolean m_allowMultipleSelections;
    private boolean m_bShowCharacterColumns;
    private boolean m_bShowNumericColumns;
    private List m_hiddenColumns;

    public ColumnSelectorPanel(ITable table) {
        this(table, "", true);
    }

    public ColumnSelectorPanel(ITable table, String desc) {
        this(table, desc, true);
    }

    public ColumnSelectorPanel(ITable table, String desc, boolean allowMultSelections) {
        this(table, desc, allowMultSelections, true, true);
    }

    public ColumnSelectorPanel(ITable table, String desc, boolean allowMultSelections, boolean bShowCharacterColumns, boolean bShowNumericColumns) {
        this.m_table = table;
        this.m_userDescription = desc;
        this.m_allowMultipleSelections = allowMultSelections;
        this.m_hiddenColumns = new ArrayList();
        this.m_bShowCharacterColumns = bShowCharacterColumns;
        this.m_bShowNumericColumns = bShowNumericColumns;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("select_column_win");
    }

    public void initialize() {
        this.m_description = new WATextArea();
        this.m_description.setBehavior(1);
        if (this.m_userDescription != null) {
            this.m_description.setText(this.m_userDescription);
        }
        this.m_description.setAutosize(true);
        this.m_colsModel = new ColumnSelectorTableModel(this.m_table);
        this.m_colsTable = new WsTable((WsAbstractTableModel)this.m_colsModel);
        this.m_colsTable.setAutoResizeMode(4);
        ColumnNameCellRenderer rdrName = new ColumnNameCellRenderer();
        TableColumn colName = this.m_colsTable.getColumnModel().getColumn(0);
        colName.setCellRenderer((TableCellRenderer)((Object)rdrName));
        this.m_colsTable.setEditable(false);
        this.m_colsTable.hideColumn(4);
        this.m_colsTable.hideColumn(5);
        this.m_colsTable.hideColumn(6);
        this.m_colsTable.hideColumn(7);
        this.m_colsTable.hideColumn(8);
        if (this.m_table instanceof IPhysicalTable) {
            this.m_colsTable.removeColumn(9);
            this.m_colsTable.removeColumn(10);
        }
        if (this.m_allowMultipleSelections) {
            this.m_colsTable.getSelectionModel().setSelectionMode(2);
        } else {
            this.m_colsTable.getSelectionModel().setSelectionMode(0);
        }
        this.m_colsTablePane = new JScrollPane((Component)this.m_colsTable);
        this.m_colsTablePane.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_description, "North");
        this.add(this.m_colsTablePane, "Center");
    }

    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated) {
            this.m_colsModel.setStorePopulated(bStorePopulated);
        }
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_colsModel.moveDataToModel();
        this.m_colsTable.selectCell(0, 0);
        this.setListeningForChanges(true);
    }

    public IColumn getSelectedColumn() {
        int[] aSelectedRows = this.m_colsTable.getSelectedRowsFromSelectedCells();
        if (aSelectedRows.length == 0) {
            return null;
        }
        int rowSelected = aSelectedRows[0];
        int modelRow = this.m_colsTable.convertRowIndexToModel(rowSelected);
        IColumn column = this.m_colsModel.getColumnForRow(modelRow);
        return column;
    }

    public IColumn[] getSelectedColumns() {
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        int[] aSelectedRows = this.m_colsTable.getSelectedRowsFromSelectedCells();
        for (int i = 0; i < aSelectedRows.length; ++i) {
            int rowSelected = aSelectedRows[i];
            int modelRow = this.m_colsTable.convertRowIndexToModel(rowSelected);
            IColumn column = this.m_colsModel.getColumnForRow(modelRow);
            columns.add(column);
        }
        return columns.toArray(new IColumn[columns.size()]);
    }

    public boolean validateData() {
        return true;
    }

    public void hideColumns(List columns) {
        if (columns == null) {
            this.m_hiddenColumns.clear();
        } else {
            this.m_hiddenColumns.addAll(columns);
        }
    }

    private class ColumnSelectorTableModel
    extends ColumnsTableModel {
        public ColumnSelectorTableModel(ITable table) {
            super(table);
        }

        @Override
        public void moveDataToModel() {
            this.clear();
            IColumn[] aColumns = ColumnSelectorPanel.this.m_table.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                if (ColumnSelectorPanel.this.m_hiddenColumns.contains(aColumns[iColumn]) || (!ColumnSelectorPanel.this.m_bShowCharacterColumns || aColumns[iColumn].getType() != 0) && (!ColumnSelectorPanel.this.m_bShowNumericColumns || aColumns[iColumn].getType() != 1)) continue;
                ArrayList lValues = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                this.addVisibleValues(aColumns[iColumn], lValues);
                this.addHiddenValues(aColumns[iColumn], lValues);
                this.m_lData.add(lValues);
            }
            this.fireTableModelPopulated();
            this.m_nRowInstances = this.m_lData.size() + 1;
        }
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            IColumn col = ColumnSelectorPanel.this.m_colsModel.getColumnForRow(iRow);
            WsCompoundIcon icon = new WsCompoundIcon();
            icon.addIcon(ColumnUIUtilities.getTypeIcon(col));
            this.setIcon((Icon)icon);
            return this;
        }
    }
}

