/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.visuals.common.ColumnsTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.models.SimpleObject;
import java.util.List;

public class QueueColumnsModel3
extends ColumnsTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnsTableModel2.class);
    public static final int MSGTYPE_COL = 11;
    public static final int MSGLENGTH_COL = 12;
    public static final int MSGFORMAT_COL = 13;
    protected static final int MSGTYPE_WIDTH = 100;
    protected static final int MSGLENGTH_WIDTH = 50;
    protected static final int MSGFORMAT_WIDTH = 100;
    public static final String CHAR = "CHAR";
    public static final String SHORT = "SHORT";
    public static final String LONG = "LONG";
    public static final String DOUBLE = "DOUBLE";
    protected CommonQueueTransformModel m_QueueTransformModel;

    public QueueColumnsModel3(ITable tbl) {
        super(tbl);
    }

    public void setQueueTransform(CommonQueueTransformModel model) {
        this.m_QueueTransformModel = model;
        this.setColumnsEditable(model.isReader() && Workspace.isObjectEditable((SimpleObject)model.getConnectedSourceOrTargetTable()));
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + 3;
    }

    public CommonQueueTransformModel getQueueTransform() {
        return this.m_QueueTransformModel;
    }

    @Override
    public IModelListener createModelListener() {
        return new ModelListener();
    }

    @Override
    protected void createColumnDefinitions() {
        super.createColumnDefinitions();
        String[] saMessageTypes = this.loadMessageTypeValues();
        this.m_aColumns[11] = new WsEnumeratedTableColumn(11, bundle.getString("QueueColumnsTableModel.MsgType.txt"), 100, saMessageTypes, saMessageTypes[3]);
        this.m_aColumns[12] = new WsIntegerTableColumn(12, bundle.getString("QueueColumnsTableModel.MsgLength.txt"), 50, 8, 1, Integer.MAX_VALUE);
        this.m_aColumns[13] = new WsStringTableColumn(13, bundle.getString("QueueColumnsTableModel.MsgFormat.txt"), 100, 200);
    }

    private void setColumnsEditable(boolean bEditable) {
        this.m_aColumns[0].setEditable(bEditable);
        this.m_aColumns[1].setEditable(bEditable);
        this.m_aColumns[3].setEditable(bEditable);
        this.m_aColumns[2].setEditable(bEditable);
        this.m_aColumns[7].setEditable(bEditable);
        this.m_aColumns[8].setEditable(bEditable);
        this.m_aColumns[4].setEditable(bEditable);
        this.m_aColumns[5].setEditable(bEditable);
        this.m_aColumns[6].setEditable(bEditable);
        this.m_aColumns[9].setEditable(bEditable);
        this.m_aColumns[10].setEditable(bEditable);
    }

    protected String[] loadMessageTypeValues() {
        String[] saMessageTypes = new String[]{CHAR, SHORT, LONG, DOUBLE};
        return saMessageTypes;
    }

    public boolean isCellEditable(int iRow, int iCol) {
        String sValue = this.getValueAt(iRow, 11).toString();
        if (iCol == 12 && sValue.compareToIgnoreCase(CHAR) != 0) {
            return false;
        }
        return this.m_aColumns[iCol].isEditable();
    }

    @Override
    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
        if (iCol == 11 || iCol == 12) {
            String sType = (String)this.getValueAt(iRow, 11);
            if (sType.equals(SHORT) || sType.equals(LONG) || sType.equals(DOUBLE)) {
                super.setValueAt("", iRow, 12);
                String sMsgFormat = (String)this.getValueAt(iRow, 11);
                super.setValueAt(sMsgFormat, iRow, 13);
            } else {
                this.m_aColumns[12].setEditable(true);
                String sMsgLength = this.getValueAt(iRow, 12).toString();
                if (sMsgLength.length() == 0) {
                    super.setValueAt(this.getValueAt(iRow, 3), iRow, 12);
                }
                String sMsgFormat = this.getValueAt(iRow, 11) + ",," + this.getValueAt(iRow, 12);
                super.setValueAt(sMsgFormat, iRow, 13);
            }
        }
        String[] aQueueFormats = new String[]{"", "", "", ""};
        aQueueFormats[0] = (String)this.getValueAt(iRow, 11);
        if (this.getValueAt(iRow, 12).toString().length() > 0) {
            aQueueFormats[1] = this.getValueAt(iRow, 12).toString();
        }
        aQueueFormats[2] = (String)this.getValueAt(iRow, 13);
        this.m_QueueTransformModel.setColumnMessageFormats(((IColumn)this.getValueAt(iRow, this.getColumnCount())).getID(), aQueueFormats);
        this.fireTableCellUpdated(iRow, 0);
    }

    @Override
    protected void addVisibleValues(IColumn col, List lValues) {
        super.addVisibleValues(col, lValues);
        String[] messageFormats = this.m_QueueTransformModel.getColumnMessageFormats(col);
        lValues.add(messageFormats[0]);
        lValues.add(messageFormats[1]);
        lValues.add(messageFormats[2]);
    }

    private class ModelListener
    extends ColumnsTableModel.ModelListener
    implements IModelListener {
        private ModelListener() {
            super(QueueColumnsModel3.this);
        }

        @Override
        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            super.modelChanged(ev);
            if (sType == "QueueTransformModel:MessageTypeChanged") {
                CommonQueueTransformModel.MQColumnFormats mqColumnFormat = (CommonQueueTransformModel.MQColumnFormats)obj;
                int iRowIndex = QueueColumnsModel3.this.getRowIndex(mqColumnFormat.getColumnFQID());
                QueueColumnsModel3.this.setValueAt(mqColumnFormat.getTypeValue(), iRowIndex, 11);
            } else if (sType == "QueueTransformModel:MessageLengthChanged") {
                CommonQueueTransformModel.MQColumnFormats mqColumnFormat = (CommonQueueTransformModel.MQColumnFormats)obj;
                int iRowIndex = QueueColumnsModel3.this.getRowIndex(mqColumnFormat.getColumnFQID());
                QueueColumnsModel3.this.setValueAt(mqColumnFormat.getLengthValue(), iRowIndex, 12);
            } else if (sType == "QueueTransformModel:MessageFormatChanged") {
                CommonQueueTransformModel.MQColumnFormats mqColumnFormat = (CommonQueueTransformModel.MQColumnFormats)obj;
                int iRowIndex = QueueColumnsModel3.this.getRowIndex(mqColumnFormat.getColumnFQID());
                QueueColumnsModel3.this.setValueAt(mqColumnFormat.getFormatValue(), iRowIndex, 13);
            }
        }
    }
}

