/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;

public class QueueColumnsCellRenderer
extends WsDefaultTableCellRenderer {
    private static WAdminResource bundleX = WAdminResource.getBundle(ColumnsTableNameCellRenderer.class);
    protected static ImageIcon m_iconBlank = bundleX.getImageIcon("Common.EmptyIcon.image");
    protected static ImageIcon m_iconKey = bundleX.getImageIcon("Common.Key.image");
    protected static ImageIcon m_iconNote = bundleX.getImageIcon("Common.Note.image");
    protected static ImageIcon m_iconExtAttr = bundleX.getImageIcon("Common.ExtAttr.image");
    protected int m_iTypeColumn = 3;
    protected int m_iKeyColumn = 14;
    protected int m_iNotesColumn = 15;
    protected int m_iExtAttrsColumn = 16;
    protected boolean m_bShowTypeIcon = true;
    protected boolean m_bShowKeyIcon = false;
    protected boolean m_bShowNotesIcon = false;
    protected boolean m_bShowExtAttrsIcon = false;

    public void showTypeIcon(boolean bShow) {
        this.m_bShowTypeIcon = bShow;
    }

    public boolean isTypeIconShown() {
        return this.m_bShowTypeIcon;
    }

    public void showKeyIcon(boolean bShow) {
        this.m_bShowKeyIcon = bShow;
    }

    public boolean isKeyIconShown() {
        return this.m_bShowKeyIcon;
    }

    public void showNotesIcon(boolean bShow) {
        this.m_bShowNotesIcon = bShow;
    }

    public boolean isNotesIconShown() {
        return this.m_bShowNotesIcon;
    }

    public void showExtAttrsIcon(boolean bShow) {
        this.m_bShowExtAttrsIcon = bShow;
    }

    public boolean isExtAttrsIconShown() {
        return this.m_bShowExtAttrsIcon;
    }

    public void setTypeColumnIndex(int iTypeColumn) {
        this.m_iTypeColumn = iTypeColumn;
    }

    public int getTypeColumnIndex() {
        return this.m_iTypeColumn;
    }

    public void setKeyColumnIndex(int iKeyColumn) {
        this.m_iKeyColumn = iKeyColumn;
    }

    public int getKeyColumnIndex() {
        return this.m_iKeyColumn;
    }

    public void setNotesColumnIndex(int iNotesColumn) {
        this.m_iNotesColumn = iNotesColumn;
    }

    public int getNotesColumnIndex() {
        return this.m_iNotesColumn;
    }

    public void setExtAttrsColumnIndex(int iExtAttrsColumn) {
        this.m_iExtAttrsColumn = iExtAttrsColumn;
    }

    public int getExtAttrsColumnIndex() {
        return this.m_iExtAttrsColumn;
    }

    public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
        super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
        WsAbstractTableModel mdl = (WsAbstractTableModel)tbl.getModel();
        iRow = ((WsTable)tbl).convertRowIndexToModel(iRow);
        WsCompoundIcon iconCompound = new WsCompoundIcon();
        iconCompound.setIconGap(1);
        if (this.m_bShowKeyIcon) {
            Boolean bKeys = (Boolean)mdl.getValueAt(iRow, this.m_iKeyColumn);
            iconCompound.addIcon((Icon)(bKeys != false ? m_iconKey : m_iconBlank));
        }
        if (this.m_bShowNotesIcon) {
            Boolean bNotes = (Boolean)mdl.getValueAt(iRow, this.m_iNotesColumn);
            iconCompound.addIcon((Icon)(bNotes != false ? m_iconNote : m_iconBlank));
        }
        if (this.m_bShowExtAttrsIcon) {
            Boolean bExtAttrs = (Boolean)mdl.getValueAt(iRow, this.m_iExtAttrsColumn);
            iconCompound.addIcon((Icon)(bExtAttrs != false ? m_iconExtAttr : m_iconBlank));
        }
        if (this.m_bShowTypeIcon) {
            String sType = (String)mdl.getValueAt(iRow, this.m_iTypeColumn);
            iconCompound.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
        }
        if (iconCompound.getIconCount() == 0) {
            this.setIcon(null);
        } else {
            this.setIcon((Icon)iconCompound);
        }
        return this;
    }

    public int getTextOffset() {
        int iOff = 0;
        if (this.m_bShowKeyIcon) {
            iOff += m_iconBlank.getIconWidth() + 1;
        }
        if (this.m_bShowNotesIcon) {
            iOff += m_iconBlank.getIconWidth() + 1;
        }
        if (this.m_bShowExtAttrsIcon) {
            iOff += m_iconBlank.getIconWidth() + 1;
        }
        if (this.m_bShowTypeIcon) {
            iOff += m_iconBlank.getIconWidth() + 1;
        }
        return iOff;
    }

    public Caret getCaretForEditor() {
        return new cCaretForEditor();
    }

    protected class cCaretForEditor
    extends DefaultCaret {
        protected boolean m_bFirst = false;

        public cCaretForEditor() {
            Object o = UIManager.get("TextField.caretBlinkRate");
            if (o != null && o instanceof Integer) {
                this.setBlinkRate((Integer)o);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.getComponent().hasFocus()) {
                e.translatePoint(-QueueColumnsCellRenderer.this.getTextOffset(), 0);
            }
            super.mousePressed(e);
        }
    }
}

