/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.queues.MSMQQueueCodegen;
import com.sas.wadmin.transforms.queues.MSMQQueueModel;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MSMQQueueWriterCodegen
extends MSMQQueueCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(MSMQQueueWriterCodegen.class);
    private static SASCodeGeneration m_attrib;
    private static SASCodeGeneration m_attribVal;

    public MSMQQueueWriterCodegen() {
        Workspace.getDefaultLogger().debug((Object)"This is a Queue Writer..");
    }

    public static void codegen(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep step = null;
        try {
            step = (TransformationStep)classifierMap.getSteps().get(0);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().warn((Object)"incomplete metadata, there needs to be a step..");
            return;
        }
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        MSMQQueueModel model = new MSMQQueueModel(step, "MSMQ", false);
        model.moveDataToModel();
        if (!QueueUtil.hasQueue(classifierMap, true)) {
            throw new CodegenException(bundle.getString("MSMQQWriterCodegen.NoTargetQueue.msg.txt"));
        }
        if (model.isFileMessage()) {
            MSMQQueueWriterCodegen.BuildSendFileCode(cgReq, model);
        } else if (model.isTableMessage()) {
            MSMQQueueWriterCodegen.buildTableSend(cgReq, model, classifierMap);
        } else {
            MSMQQueueWriterCodegen.buildTextMsgSend(cgReq, model);
        }
        MSMQQueueWriterCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    public static void buildTextMap(CodegenRequest cgReq, MSMQQueueModel model, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.BuildMap.notrans"));
        String storage = "REGISTRY";
        if (model.isMapStoreDefined()) {
            storage = model.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("'CHAR,,");
        int val = model.getMessageLength();
        if (val == 0) {
            val = 256;
        }
        cgReq.addSourceCode(String.valueOf(val));
        cgReq.addSourceCode("' );\n");
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQWriterCodegen.BuildMapFailed.notrans"), "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableMap(CodegenRequest cgReq, MSMQQueueModel model, String mapName) throws MdException, RemoteException {
        List columnList = QueueUtil.buildMessageColumnsList(model.getWriterSourceTable());
        if (columnList == null) {
            throw new MdException(bundle.getString("MSMQQWriterCodegen.NoColumns.exception.txt"));
        }
        if (columnList.size() == 0) {
            throw new MdException(bundle.getString("MSMQQWriterCodegen.NoColumns.exception.txt"));
        }
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.BuildMap.notrans"));
        String storage = "REGISTRY";
        if (model.isMapStoreDefined()) {
            storage = model.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, \n");
        cgReq.indent();
        MSMQQueueWriterCodegen.buildColumnFormats(cgReq, columnList);
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQWriterCodegen.BuildMapFailed.notrans"), "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableSend(CodegenRequest cgReq, MSMQQueueModel model, ClassifierMap classifierMap) throws MdException, RemoteException {
        DataTable sourceTable = cgReq.getSourceTable(classifierMap);
        DataTableCG sourceTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        String sourceTableName = sourceTableCG.getDataLocation(cgReq);
        boolean needQuotes = cgReq.getQuoting();
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSourceCode("set ").addSourceCode(sourceTableName).addSourceCode(" end=etls_last;\n");
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getQueueName().trim()).addSourceCode("';\n");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.DataType.notrans"));
        MSMQQueueWriterCodegen.buildDeclarations(cgReq, model);
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        if (model.isTransaction()) {
            cgReq.addSourceCode("length etls_transid 8;\n");
        }
        StringBuffer s_retain = new StringBuffer();
        s_retain.append("retain etls_qid etls_tid");
        if (model.isTransaction()) {
            s_retain.append(" etls_transid");
        }
        s_retain.append(";\n");
        cgReq.addSourceCode("length etls_rc 8;\n\n");
        cgReq.addSourceCode(s_retain.toString());
        cgReq.addSourceCode("if _n_ = 1 then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        MSMQQueueWriterCodegen.buildInit(cgReq);
        MSMQQueueWriterCodegen.buildOpen(cgReq, "DELIVERY", "", model);
        if (model.isQueuePropertiesTurnedOn()) {
            MSMQQueueWriterCodegen.buildVerifyQueueProperties(cgReq, model);
        }
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.LetStatements.notrans"));
        ArrayList parameterList = new ArrayList();
        cgReq.addSourceCode(MSMQQueueWriterCodegen.buildMacroValues(model, parameterList));
        cgReq.addSourceCode("\n");
        int pSize = parameterList.size();
        int scSize = pSize - 1;
        int k = 0;
        if (pSize > 0) {
            cgReq.addSourceCode("retain ");
            for (int i = 0; i < pSize; ++i) {
                cgReq.addSourceCode("etls_").addSourceCode(((String)parameterList.get(i)).toLowerCase());
                if (i == scSize) {
                    cgReq.addSourceCode(";\n");
                    break;
                }
                cgReq.addSourceCode(" ");
                if (++k != 2) continue;
                cgReq.addSourceCode("\n");
                k = 0;
            }
        }
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",");
        }
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueWriterCodegen.buildTableMap(cgReq, model, mapName);
        cgReq.unIndent();
        cgReq.addSourceCode("end;/* if _n_ = 1 */\n");
        MSMQQueueWriterCodegen.buildAttributeList(parameterList, false, m_attrib, m_attribVal);
        m_attrib.addSourceCode("MAP");
        m_attribVal.addSourceCode("\"");
        m_attribVal.addSourceCode(mapName);
        m_attribVal.addSourceCode("\"").addSourceCode(",");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.SendTable.notrans"));
        List columnList = QueueUtil.buildMessageColumnsList(model.getWriterSourceTable());
        cgReq.addSourceCode("call sendmessage( etls_qid, etls_rc,\n");
        cgReq.indent().addSourceCode("'");
        cgReq.addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode(" \n");
        int sz = columnList.size();
        int j = 0;
        for (int i = 0; i < sz; ++i) {
            String[] sArrayQueueFormat = (String[])columnList.get(i);
            String sName = sArrayQueueFormat[0];
            if (needQuotes) {
                cgReq.addSourceCode("\"");
            }
            cgReq.addSourceCode(sName);
            if (needQuotes) {
                cgReq.addSourceCode("\"");
                cgReq.addSourceCode("n");
            }
            if (i < sz - 1) {
                cgReq.addSourceCode(", ");
            }
            if (++j != 2) continue;
            cgReq.addSourceCode("\n");
            j = 0;
        }
        cgReq.addSourceCode(");\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQWriterCodegen.SendFailed.notrans"), "send message", true);
        cgReq.addSourceCode("if (etls_last) then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildCommitTransaction(cgReq, false);
        }
        cgReq.addSourceCode("link term;\n");
        cgReq.unIndent();
        cgReq.addSourceCode("end; /* if (etls_last) */\n");
        cgReq.addSourceCode("return;\n");
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.TermRoutine.notrans"));
        cgReq.addSourceCode("term:\n");
        cgReq.indent();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildFreeTransaction(cgReq);
        }
        MSMQQueueWriterCodegen.buildTerm(cgReq, model.isDebug());
        cgReq.unIndent();
        cgReq.addSourceCode("return; ");
        cgReq.addCommentLine(bundle.getString("MSMQQueueCodegen.TermRoutineEnd.notrans"));
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n");
    }

    protected static void buildDeclarations(CodegenRequest cgReq, MSMQQueueModel model) {
        cgReq.addSourceCode("length etls_mqdebug $ 10;\n");
        if (model.isDebug()) {
            cgReq.addSourceCode("etls_mqdebug=\"YES\";\n");
        } else {
            cgReq.addSourceCode("etls_mqdebug=\"NO\";\n");
        }
    }

    public static void buildTextMsgSend(CodegenRequest cgReq, MSMQQueueModel model) throws MdException, RemoteException {
        QueueUtil.textMessageToMacroVariable(cgReq, model);
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getQueueName().trim()).addSourceCode("';\n");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.DataType.notrans"));
        MSMQQueueWriterCodegen.buildDeclarations(cgReq, model);
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        cgReq.addSourceCode("length etls_rc 8;\n");
        if (model.isTransaction()) {
            cgReq.addSourceCode("length etls_transid 8;\n");
        }
        cgReq.addSourceCode("\n");
        MSMQQueueWriterCodegen.buildInit(cgReq);
        MSMQQueueWriterCodegen.buildOpen(cgReq, "DELIVERY", "", model);
        if (model.isQueuePropertiesTurnedOn()) {
            MSMQQueueWriterCodegen.buildVerifyQueueProperties(cgReq, model);
        }
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.LetStatements.notrans"));
        ArrayList parameterList = new ArrayList();
        cgReq.addSourceCode(MSMQQueueWriterCodegen.buildMacroValues(model, parameterList));
        cgReq.addSourceCode("\n");
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",").addSourceCode(" ");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",").addSourceCode(" ");
        }
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueWriterCodegen.buildTextMap(cgReq, model, mapName);
        MSMQQueueWriterCodegen.buildAttributeList(parameterList, false, m_attrib, m_attribVal);
        m_attrib.addSourceCode("MAP");
        m_attribVal.addSourceCode("\"");
        m_attribVal.addSourceCode(mapName);
        m_attribVal.addSourceCode("\"").addSourceCode(",");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.SendText.notrans"));
        cgReq.addSourceCode("call sendmessage( etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode(" \"&etls_msg\");\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQWriterCodegen.SendFailed.notrans"), "send message");
        cgReq.addSourceCode("\n");
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildCommitTransaction(cgReq);
        }
        MSMQQueueWriterCodegen.buildTerm(cgReq, model.isDebug());
        cgReq.unIndent().addSourceCode("run;\n");
    }

    public static void BuildSendFileCode(CodegenRequest cgReq, MSMQQueueModel model) throws MdException, RemoteException {
        String sFileName = model.getFileName();
        if (sFileName == null || sFileName.length() == 0) {
            throw new CodegenException(bundle.getString("MSMQQWriterCodegen.NoFileSpecified.msg.txt"));
        }
        cgReq.addSourceCode("filename etls_fr '").addSourceCode(sFileName.trim()).addSourceCode("';\n");
        cgReq.addSourceCode("%rcSet(&sysrc);\n");
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.GlobalDefinitions.notrans"));
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getQueueName().trim()).addSourceCode("';\n");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.DataType.notrans"));
        MSMQQueueWriterCodegen.buildDeclarations(cgReq, model);
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        cgReq.addSourceCode("length etls_rc 8;\n\n");
        MSMQQueueWriterCodegen.buildInit(cgReq);
        MSMQQueueWriterCodegen.buildOpen(cgReq, "DELIVERY", "", model);
        if (model.isQueuePropertiesTurnedOn()) {
            MSMQQueueWriterCodegen.buildVerifyQueueProperties(cgReq, model);
        }
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.SendAttachment.notrans"));
        cgReq.addSourceCode("length etls_alist $ 80;\n");
        cgReq.addSourceCode("etls_alist = 'external_bin, fileref, etls_fr';\n");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.LetStatements.notrans"));
        ArrayList parameterList = new ArrayList();
        cgReq.addSourceCode(MSMQQueueWriterCodegen.buildMacroValues(model, parameterList));
        cgReq.addSourceCode("\n");
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        MSMQQueueWriterCodegen.buildAttributeList(parameterList, false, m_attrib, m_attribVal);
        m_attrib.addSourceCode("ATTACHLIST");
        cgReq.addSectionComment(bundle.getString("MSMQQWriterCodegen.SendFile.notrans"));
        cgReq.addSourceCode("call sendmessage( etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode("etls_alist);\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQWriterCodegen.SendFailed.notrans"), "send message");
        cgReq.addSourceCode("\n");
        MSMQQueueWriterCodegen.buildTerm(cgReq, model.isDebug());
        cgReq.unIndent();
        cgReq.unIndent().addSourceCode("run;\n");
    }
}

