/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.queues.MQCLOSE;
import com.sas.wadmin.transforms.queues.MQCONN;
import com.sas.wadmin.transforms.queues.MQGET;
import com.sas.wadmin.transforms.queues.MQGETPARMS;
import com.sas.wadmin.transforms.queues.MQGMO;
import com.sas.wadmin.transforms.queues.MQINQ;
import com.sas.wadmin.transforms.queues.MQMAP;
import com.sas.wadmin.transforms.queues.MQMD;
import com.sas.wadmin.transforms.queues.MQOD;
import com.sas.wadmin.transforms.queues.MQOPEN;
import com.sas.wadmin.transforms.queues.MQOptionsLoader;
import com.sas.wadmin.transforms.queues.MQROOT;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class IBMWSQReaderCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(IBMWSQReaderCodegen.class);
    protected static String ETLS_WSMQ_READER_WORKTABLE = "work.etls_wsmq_tblfromq";

    public static void codegen(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        QueueModel model = new QueueModel((TransformationStep)classifierMap.getSteps().get(0), "IBMWSMQ", true);
        model.moveDataToModel();
        if (!QueueUtil.hasQueue(classifierMap, false)) {
            throw new CodegenException(bundle.getString("IBMWSQReaderCodegen.NoSourceQueue.msg.txt"));
        }
        IBMWSQReaderCodegen.doUWProcess(cgReq, classifierMap, "PreProcess");
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)classifierMap);
        OP.setUsePropertySet(true);
        MQOptionsLoader hmUserInputLoader = new MQOptionsLoader(classifierMap, false);
        HashMap hmUserInput = hmUserInputLoader.getOptions();
        MQROOT.setMQGlobalVariables(cgReq, hmUserInput);
        if (model.isTextMessage()) {
            IBMWSQReaderCodegen.readTextFromQueue(cgReq, classifierMap, model, hmUserInput);
        } else if (model.isTableMessage()) {
            IBMWSQReaderCodegen.readTableFromQueue(cgReq, classifierMap, model, hmUserInput);
        } else if (model.isFileMessage()) {
            IBMWSQReaderCodegen.readFileFromQueue(cgReq, classifierMap, model, hmUserInput);
        } else {
            model.setMessageLength(256);
            model.setTextMessage(true);
            model.moveDataToStore();
            model.moveDataToModel();
            hmUserInputLoader = new MQOptionsLoader(classifierMap, false);
            hmUserInput = hmUserInputLoader.getOptions();
            IBMWSQReaderCodegen.readTextFromQueue(cgReq, classifierMap, model, hmUserInput);
        }
        IBMWSQReaderCodegen.doUWProcess(cgReq, classifierMap, "PostProcess");
        cgReq.genRCSetCall("&syserr");
        if (cgReq.getJobStatus()) {
            cgReq.addCommentLine("* Comment Line for Job status;\n");
            cgReq.addSourceCode("%let etls_recordsBefore = 0; \n");
        }
        IBMWSQReaderCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    private static void readTextFromQueue(CodegenRequest cgReq, ClassifierMap cm, QueueModel model, HashMap hmUserInput) throws MdException, RemoteException {
        String sMacroVar = "etls_qms";
        if (hmUserInput.containsKey("etls_macroname")) {
            sMacroVar = (String)hmUserInput.get("etls_macroname");
        }
        if (sMacroVar == null || sMacroVar.length() == 0) {
            sMacroVar = "etls_qms";
        }
        cgReq.addSourceCode("%let ");
        cgReq.addSourceCode(sMacroVar);
        cgReq.addSourceCode("=;\n");
        cgReq.addSourceCode("data _null_;\n").indent();
        MQROOT mqROOT = new MQROOT(cgReq, false, hmUserInput);
        MQCONN mqconn = new MQCONN(cgReq, false, hmUserInput);
        mqROOT.addLengthForParametersAndOptions();
        MQOD mqod = new MQOD(cgReq, false, hmUserInput);
        MQOPEN mqopen = new MQOPEN(cgReq, false, hmUserInput);
        mqopen.setOption(MQOPEN.INPUT_SHARED);
        MQINQ mqinq = new MQINQ(cgReq, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQGMO mqgmo = new MQGMO(cgReq, false, hmUserInput);
        MQMD mqmd = new MQMD(cgReq, false, hmUserInput);
        mqmd.readFromTransformationInput();
        MQMAP mqmap = new MQMAP(cgReq, false, hmUserInput);
        mqmap.setDescriptors();
        MQGET mqget = new MQGET(cgReq, false, hmUserInput);
        MQGETPARMS mqgetParms = new MQGETPARMS(cgReq, false, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqgmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqget.generateLengthStatements();
        mqgetParms.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqgmo.generateAssignmentStatements();
        mqgmo.generateFunctionCall();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqget.generateAssignmentStatements();
        mqget.generateFunctionCall();
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("etls_desc=\"CHAR,,\" || kcompress(put(etls_rcv_msg_len, 6.));\n");
        cgReq.addSourceCode("call mqmap(etls_hmap, etls_qrc, etls_desc);\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("if ");
        cgReq.addSourceCode("etls_rcv_msg_len");
        cgReq.addSourceCode(" > ");
        cgReq.addSourceCode((String)hmUserInput.get("etls_message_length"));
        cgReq.addSourceCode(" then \ndo;\n");
        cgReq.indent();
        cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.MsgLengthInput.put.notrans") + (String)hmUserInput.get("etls_message_length"), "NOTE:");
        cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.MsgLengthMinimum.put.notrans"), "NOTE:", "etls_rcv_msg_len", false);
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.beginDebug();
            cgReq.addSourceCode("if ");
            cgReq.addSourceCode("etls_rcv_msg_len");
            cgReq.addSourceCode(" <> ");
            cgReq.addSourceCode((String)hmUserInput.get("etls_message_length"));
            cgReq.addSourceCode(" then \ndo;\n");
            cgReq.indent();
            cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.MsgLengthInput.put.notrans") + (String)hmUserInput.get("etls_message_length"), "NOTE:");
            cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.MsgLengthMinimum.put.notrans"), "NOTE:", "etls_rcv_msg_len", false);
            cgReq.unIndent();
            cgReq.addSourceCode("end;\n");
            mqROOT.endDebug();
        }
        cgReq.addSourceCode("if ");
        cgReq.addSourceCode("etls_rcv_msg_len");
        cgReq.addSourceCode(" > 0  then \ndo;\n");
        cgReq.indent();
        mqgetParms.generateAssignmentStatements();
        mqgetParms.generateFunctionCall();
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.MsgToMacro.Comment.notrans"));
        cgReq.addSourceCode("CALL SYMPUT('");
        cgReq.addSourceCode(sMacroVar);
        cgReq.addSourceCode("',");
        cgReq.addSourceCode("etls_read");
        cgReq.addSourceCode(");\n");
        cgReq.addSourceCode("etls_mqexit");
        cgReq.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void readTableFromQueue(CodegenRequest cgReq, ClassifierMap cm, QueueModel model, HashMap hmUserInput) throws MdException, RemoteException {
        String sValue;
        MQROOT mqROOT = new MQROOT(cgReq, false, hmUserInput);
        DataTable targetTable = model.getReaderTargetTable();
        cgReq.genTableDelete(targetTable);
        PhysicalTableCG targetTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        boolean bNeedQuotes = cgReq.getQuoting();
        String targetTableName = targetTableCG.getDataLocation(cgReq);
        AssociationList targetColumnList = targetTable.getColumns();
        if (targetColumnList.size() == 0) {
            String msgString = bundle.formatString("IBMWSQReader.TableWithNoColumns.exception.fmt.txt", (Object)targetTableName);
            throw new MdException(msgString);
        }
        List listMessageColumns = QueueUtil.buildMessageColumnsList(targetTable);
        cgReq.addSourceCode("DATA ");
        cgReq.addSourceCode(targetTableName);
        cgReq.addSourceCode(";\n");
        cgReq.indent();
        mqROOT.addLengthForParametersAndOptions();
        IBMWSQReaderCodegen.readUserInput(cgReq, hmUserInput);
        mqROOT.addBlankLine();
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.Keep.Comment.notrans"));
        cgReq.addSourceCode("keep ");
        cgReq.addSourceCode(cgReq.makeColumnList(targetTable, ""));
        cgReq.addSourceCode(";\n");
        mqROOT.addBlankLine();
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.Attributes.Comment.notrans"));
        SASCodeGeneration cg = new SASCodeGeneration();
        for (int i = 0; i < targetColumnList.size(); ++i) {
            cg.genAttrib((Column)targetColumnList.get(i), true, false, false, true, bNeedQuotes);
        }
        cgReq.addSourceCode(cg.getSource());
        mqROOT.addBlankLine();
        MQCONN mqconn = new MQCONN(cgReq, false, hmUserInput);
        MQOD mqod = new MQOD(cgReq, false, hmUserInput);
        MQOPEN mqopen = new MQOPEN(cgReq, false, hmUserInput);
        mqopen.setOption(MQOPEN.INPUT_SHARED);
        mqopen.setOption(MQOPEN.INQUIRE);
        MQGMO mqgmo = new MQGMO(cgReq, false, hmUserInput);
        MQMD mqmd = new MQMD(cgReq, false, hmUserInput);
        MQMAP mqmap = new MQMAP(cgReq, false, hmUserInput);
        mqmap.setDescriptors(listMessageColumns);
        MQMD mqmd2 = new MQMD(cgReq, false, hmUserInput);
        mqmd2.readFromTransformationInput();
        MQGET mqget = new MQGET(cgReq, false, hmUserInput);
        MQGETPARMS mqgetParms = new MQGETPARMS(cgReq, false, hmUserInput);
        mqgetParms.addDescriptor(listMessageColumns);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqgmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqmd2.generateLengthStatements();
        MQINQ mqinq = new MQINQ(cgReq, false, hmUserInput);
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqget.generateLengthStatements();
        mqgetParms.generateLengthStatements();
        mqROOT.generateRetainStatement();
        cgReq.addSourceCode("if _N_=1 then \ndo;\n");
        cgReq.indent();
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqgmo.generateAssignmentStatements();
        mqgmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        boolean bFreeData = true;
        if (hmUserInput.containsKey("MQFREEDATA") && (sValue = (String)hmUserInput.get("MQFREEDATA")).compareToIgnoreCase("NO") == 0) {
            bFreeData = false;
        }
        if (!bFreeData) {
            mqmap.generateAssignmentStatements();
            mqmap.generateFunctionCall();
        }
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        String sLimit = "100000";
        if (hmUserInput.containsKey("LIMIT_READ")) {
            sLimit = (String)hmUserInput.get("LIMIT_READ");
        }
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        cgReq.addSourceCode("do i=1 to ");
        cgReq.addSourceCode(sLimit.trim());
        cgReq.addSourceCode(";\n");
        cgReq.indent();
        if (bFreeData) {
            mqmap.generateAssignmentStatements();
            mqmap.generateFunctionCall();
        }
        mqmd2.generateAssignmentStatements();
        mqmd2.generateFunctionCall();
        mqget.generateAssignmentStatements();
        mqget.generateFunctionCall();
        mqgetParms.setQuoteCols(bNeedQuotes);
        mqgetParms.generateAssignmentStatements();
        mqgetParms.generateFunctionCall();
        mqgetParms.moveVarsToColumns();
        cgReq.addSourceCode("output;\n");
        mqROOT.freeDataHandles(hmUserInput);
        cgReq.addSourceCode("\n");
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addSourceCode("etls_mqexit");
        cgReq.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void readFileFromQueue(CodegenRequest cgReq, ClassifierMap cm, QueueModel model, HashMap hmUserInput) throws MdException, RemoteException {
        String sGroupMessages = (String)hmUserInput.get("GROUP_MESSAGES");
        boolean bGroupMessages = true;
        if (sGroupMessages != null && sGroupMessages.compareToIgnoreCase("NO") == 0) {
            bGroupMessages = false;
        }
        MQROOT mqROOT = new MQROOT(cgReq, true, hmUserInput);
        if (bGroupMessages) {
            MQROOT.setV51ReceiveMacroVars(cgReq, hmUserInput);
        }
        mqROOT.addBlankLine();
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.ReadFile.Comment.notrans"));
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSourceCode("length etls_streamlen 8;\n");
        mqROOT.addLengthForParametersAndOptions();
        cgReq.addSourceCode("length etls_msgbuf $ ");
        cgReq.addSourceCode((String)hmUserInput.get("etls_message_length"));
        cgReq.addSourceCode(";\n");
        cgReq.addSourceCode("length etls_stream $ ");
        cgReq.addSourceCode((String)hmUserInput.get("etls_message_length"));
        cgReq.addSourceCode(";\n");
        IBMWSQReaderCodegen.readUserInput(cgReq, hmUserInput);
        if (!bGroupMessages) {
            cgReq.addSourceCode("length etls_lencorrid 3.;\n");
            cgReq.addSourceCode("if etls_ui_correlid eq '' then\n");
            cgReq.addSourceCode("   etls_ui_correlid='0' ;\n");
            cgReq.addSourceCode("etls_lencorrid =length(etls_ui_correlid) * (etls_ui_correlid ne '');;\n");
        }
        mqROOT.addBlankLine();
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.ReadFile.Comment.notrans"));
        cgReq.addSourceCode("filename etls_fn1 \"");
        cgReq.addSourceCode((String)hmUserInput.get("etls_filename"));
        cgReq.addSourceCode("\";\n");
        mqROOT.addBlankLine();
        cgReq.addSourceCode("fileid = fopen('etls_fn1', 'o', 0, 'b');\n");
        cgReq.addSourceCode("if( fileid = 0 ) then \ndo;\n");
        cgReq.indent();
        String msgString = bundle.formatString("IBMWSQReaderCodegen.ErrorOpeningFile.put.fmt.notrans", hmUserInput.get("etls_filename"));
        cgReq.genPutStatement(msgString, "ERROR:");
        mqROOT.addExitLine();
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        MQCONN mqconn = new MQCONN(cgReq, false, hmUserInput);
        MQOD mqod = new MQOD(cgReq, false, hmUserInput);
        MQOPEN mqopen = new MQOPEN(cgReq, false, hmUserInput);
        mqopen.setOption(MQOPEN.INPUT_SHARED);
        if (bGroupMessages) {
            mqopen.setOption(MQOPEN.BROWSE);
            mqopen.setOption(MQOPEN.INQUIRE);
        } else {
            mqopen.setOption(MQOPEN.BROWSE);
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQGMO mqgmo = new MQGMO(cgReq, false, hmUserInput);
        mqgmo.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_NEXT);
        if (bGroupMessages) {
            mqgmo.setValue(MQGMO.MATCHOPTIONS, "seqnumber");
        }
        mqgmo.setAction("GEN");
        mqgmo.removeOption(MQGMO.SYNCPOINT);
        MQMD mqmd = new MQMD(cgReq, false, hmUserInput);
        if (bGroupMessages) {
            mqmd.setValue(MQMD.MSGSEQNUMBER, "1");
        }
        MQGET mqget = new MQGET(cgReq, false, hmUserInput);
        MQMD mqmd2 = new MQMD(cgReq, false, hmUserInput);
        mqmd2.setAction("INQ");
        if (bGroupMessages) {
            mqmd2.setMQMDVersion("");
            mqmd2.setParameter(MQMD.MSGTYPE);
            mqmd2.setParameter(MQMD.GROUPID);
            mqmd2.setParameter(MQMD.MSGSEQNUMBER);
            mqmd2.setParameter(MQMD.MSGFLAGS);
        } else {
            mqmd2.setMQMDVersion("2");
            mqmd2.setParameter(MQMD.CORRELID);
            mqmd2.setParameter(MQMD.MSGTYPE);
        }
        MQGMO mqgmo2 = new MQGMO(cgReq, false, hmUserInput);
        if (!bGroupMessages) {
            mqgmo2.setAction("SET");
            mqgmo2.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_NEXT);
            mqgmo2.removeOption(MQGMO.SYNCPOINT);
        }
        MQMAP mqmap = new MQMAP(cgReq, false, hmUserInput);
        mqmap.setDescriptors();
        MQOPEN mqopen2 = new MQOPEN(cgReq, false, hmUserInput);
        if (bGroupMessages) {
            mqopen2.setOption(MQOPEN.INPUT_SHARED);
        } else {
            mqopen2.setOption(MQOPEN.INPUT_SHARED);
            mqopen2.setOption(MQOPEN.BROWSE);
            mqopen2.setObjectHandleVersion("2");
        }
        MQMD mqmd3 = new MQMD(cgReq, false, hmUserInput);
        mqmd3.setMQMDVersion("3");
        mqmd3.setAction("SET");
        if (bGroupMessages) {
            mqmd3.setParameter(MQMD.GROUPID);
            mqmd3.setValue(MQMD.GROUPID, "etls_groupid");
            mqmd3.setCharacterQuoting(MQMD.GROUPID, false);
        } else {
            mqmd3.setParameter(MQMD.MSGID);
            mqmd3.setParameter(MQMD.CORRELID);
            mqmd3.setValue(MQMD.MSGID, "");
            mqmd3.setValue(MQMD.CORRELID, "etls_correlid2");
            mqmd3.setCharacterQuoting(MQMD.CORRELID, false);
        }
        MQGMO mqgmo3 = new MQGMO(cgReq, false, hmUserInput);
        if (bGroupMessages) {
            mqgmo3.setValue(MQGMO.MATCHOPTIONS, "groupid");
            mqgmo3.setValue(MQGMO.OPTIONS, MQGMO.LOGICAL_ORDER + "," + MQGMO.COMPLETE_MSG + "," + MQGMO.ALL_MSGS_AVAILABLE);
        } else {
            mqgmo3.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_FIRST);
            mqgmo3.removeOption(MQGMO.SYNCPOINT);
        }
        mqgmo3.setAction("SET");
        MQGET mqget2 = new MQGET(cgReq, false, hmUserInput);
        if (!bGroupMessages) {
            mqget2.setObjectHandleVersion("2");
        }
        MQGETPARMS mqgetParms = new MQGETPARMS(cgReq, false, hmUserInput);
        mqgetParms.addDescriptorForFileRead();
        MQGMO mqgmo4 = new MQGMO(cgReq, false, hmUserInput);
        mqgmo4.setValue(MQGMO.OPTIONS, MQGMO.MSG_UNDER_CURSOR);
        mqgmo4.setAction("SET");
        MQGET mqget3 = new MQGET(cgReq, false, hmUserInput);
        mqget3.setObjectHandleVersion("2");
        MQGMO mqgmo5 = new MQGMO(cgReq, false, hmUserInput);
        mqgmo5.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_MSG_UNDER_CURSOR);
        mqgmo5.setAction("SET");
        mqgmo5.removeOption(MQGMO.SYNCPOINT);
        MQGET mqget4 = new MQGET(cgReq, false, hmUserInput);
        MQGMO mqgmo6 = new MQGMO(cgReq, false, hmUserInput);
        mqgmo6.setValue(MQGMO.OPTIONS, MQGMO.BROWSE_NEXT);
        mqgmo6.setAction("SET");
        mqgmo6.removeOption(MQGMO.SYNCPOINT);
        MQMD mqmd4 = new MQMD(cgReq, false, hmUserInput);
        mqmd4.setMQMDVersion("4");
        mqmd4.setAction("SET");
        mqmd4.setParameter(MQMD.MSGID);
        mqmd4.setParameter(MQMD.CORRELID);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqgmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqget.generateLengthStatements();
        mqmd2.generateLengthStatements();
        if (!bGroupMessages) {
            // empty if block
        }
        mqmap.generateLengthStatements();
        mqmd3.generateLengthStatements();
        mqgetParms.generateLengthStatements();
        mqmd4.generateLengthStatements();
        cgReq.addSourceCode("etls_CORRELID4=\"\";\n");
        cgReq.addSourceCode("etls_MSGID4=\"\";\n");
        cgReq.addSourceCode("etls_correlid2=\"\";\n");
        MQINQ mqinq = new MQINQ(cgReq, false, hmUserInput);
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqgmo.generateAssignmentStatements();
        mqgmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        if (!bGroupMessages) {
            cgReq.addSourceCode("etls_seqno=0;\n\n");
            cgReq.addSourceCode("etls_recv:\n\n");
        }
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        mqget.generateAssignmentStatements();
        mqget.generateFunctionCall();
        mqmd2.generateAssignmentStatements();
        mqmd2.generateFunctionCall();
        cgReq.addSourceCode("etls_correlid3=etls_correlid2;\n");
        if (!bGroupMessages) {
            mqgmo2.generateAssignmentStatements();
            mqgmo2.generateFunctionCall();
        }
        cgReq.addSourceCode("\n");
        if (bGroupMessages) {
            cgReq.addSourceCode("if ((etls_msgtype=etls_ui_msgtype) or (etls_ui_msgtype = 0)) then \ndo;\n");
        } else {
            cgReq.addSourceCode("if ((etls_msgtype2=etls_ui_msgtype) or (etls_ui_msgtype = 0)) then \ndo;\n");
        }
        cgReq.indent();
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.FileProcessing.Comment.notrans"));
        if (!bGroupMessages) {
            cgReq.addSourceCode("etls_outofseq=0;\n");
            cgReq.addSourceCode("\n");
            cgReq.addSourceCode("if( upcase(substr(etls_ui_correlid,1,etls_lencorrid)) = upcase(substr(etls_correlid2,1,etls_lencorrid)) ) then \ndo;\n").indent();
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.FileBegins.Comment.notrans"));
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.CorrelatingMsg.Comment.notrans"));
            cgReq.addSourceCode("etls_ui_correlid = upcase(substr(etls_correlid2,1,etls_lencorrid));\n");
            cgReq.addSourceCode("\n");
        }
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        if (bGroupMessages) {
            MQCLOSE mqclose = new MQCLOSE(cgReq, false, hmUserInput);
            mqclose.generateSASCode();
        } else {
            cgReq.unIndent();
            cgReq.addSourceCode("end;\n");
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.MsgBelongsTo.Comment.notrans"));
            cgReq.addSourceCode("if( upcase(substr(etls_correlid2,1,etls_lencorrid)) = upcase(etls_ui_correlid) ) then \ndo;\n").indent();
            cgReq.addSourceCode("if( etls_seqno ^= input(substr(etls_correlid2,etls_lencorrid+1,4), hex4.) ) ");
            cgReq.addSourceCode("then \ndo;\n");
            cgReq.indent();
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.MsgOutOfSequence.Comment.notrans"));
            cgReq.addSourceCode("etls_outofseq=1;\n");
        }
        cgReq.addSourceCode("\n");
        mqopen2.generateAssignmentStatements();
        mqopen2.generateFunctionCall();
        if (!bGroupMessages) {
            cgReq.addSourceCode("etls_correlid2 = upcase(etls_ui_correlid);\n");
            cgReq.addSourceCode("substr(etls_correlid2,etls_lencorrid+1,4) = put(etls_seqno, hex4.);\n");
        }
        if (bGroupMessages) {
            mqgmo3.generateAssignmentStatements();
            mqgmo3.generateFunctionCall();
            mqmd3.generateAssignmentStatements();
            mqmd3.generateFunctionCall();
        } else {
            mqmd3.generateAssignmentStatements();
            mqmd3.generateFunctionCall();
            mqgmo3.generateAssignmentStatements();
            mqgmo3.generateFunctionCall();
        }
        if (bGroupMessages) {
            cgReq.addSourceCode("etls_next:;\n");
        }
        mqget2.generateAssignmentStatements();
        mqget2.generateFunctionCall();
        if (bGroupMessages) {
            mqmd2.generateAssignmentStatements();
            mqmd2.generateFunctionCall();
        } else {
            cgReq.unIndent();
            cgReq.addSourceCode("end;\n");
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.IncrementSequence.Comment.notrans"));
            cgReq.addSourceCode("etls_seqno+1;\n");
            cgReq.addSourceCode("\n");
        }
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("etls_desc=\"CHAR,,\" || kcompress(put(etls_rcv_msg_len, 6.));\n");
        cgReq.addSourceCode("call mqmap(etls_hmap, etls_qrc, etls_desc);\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.RetrieveRecord.Comment.notrans"));
        mqgetParms.generateAssignmentStatements();
        mqgetParms.generateFunctionCall();
        mqgetParms = null;
        cgReq.addSourceCode("etls_streamlen = etls_rcv_msg_len;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.beginDebug();
            cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.LenStream.Comment.notrans"), "NOTE:", "etls_rcv_msg_len", false);
            mqROOT.endDebug();
        }
        cgReq.addSourceCode("etls_stream = substr(etls_msgbuf,1);\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.WriteStream.Comment.notrans"));
        cgReq.addSourceCode("rc = fput(fileid, substr(etls_stream,1,etls_streamlen));\n");
        cgReq.addSourceCode("if( rc ) then \ndo;\n");
        cgReq.indent();
        cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.ErrorWriting.Comment.put.notrans"), "ERROR:");
        mqROOT.addExitLine();
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.FlushToDisk.Comment.put.notrans"));
        cgReq.addSourceCode("rc = fwrite(fileid);\n");
        cgReq.addSourceCode("if( rc ) then \ndo;\n");
        cgReq.indent();
        cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.ErrorWritingToFile.Comment.put.notrans"), "ERROR:");
        mqROOT.addExitLine();
        cgReq.unIndent();
        cgReq.addSourceCode("end;\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("\n");
        if (bGroupMessages) {
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.ReceiveUntilLast.Comment.put.notrans"));
            cgReq.addSourceCode("if( (etls_msgflags=&group_mask) AND ");
            cgReq.addSourceCode(" (NOT(etls_msgflags=&last_group_mask)) )");
            cgReq.addSourceCode(" then \ngoto etls_next;\n");
            cgReq.addSourceCode("else \n");
            cgReq.indent();
            mqROOT.addExitLine();
            cgReq.unIndent();
            cgReq.unIndent();
            cgReq.addSourceCode("end;\n");
        } else {
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.RemoveMessageFromQueue.Comment.notrans"));
            mqgmo4.generateAssignmentStatements();
            mqgmo4.generateFunctionCall();
            cgReq.addSourceCode("if( etls_outofseq ) then \ndo;\n").indent();
            mqget3.generateAssignmentStatements();
            mqget3.generateFunctionCall();
            MQCLOSE mqclose2 = new MQCLOSE(cgReq, false, hmUserInput);
            mqclose2.setObjectHandleVersion("2");
            mqclose2.generateSASCode();
            mqclose2 = null;
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.RereadPreviousMsg.Comment.notrans"));
            mqgmo5.generateAssignmentStatements();
            mqgmo5.generateFunctionCall();
            cgReq.addSourceCode("end;\n");
            cgReq.addSourceCode("else \ndo;\n").indent();
            mqget4.generateAssignmentStatements();
            mqget4.generateFunctionCall();
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.BrowseNextMsg.Comment.notrans"));
            mqgmo6.generateAssignmentStatements();
            mqgmo6.generateFunctionCall();
            cgReq.unIndent();
            cgReq.addSourceCode("end;\n").unIndent();
            cgReq.addSourceCode("end;\n").unIndent();
            cgReq.addSourceCode("end;\n").unIndent();
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.FinishedRetrieving.Comment.notrans"));
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.ResetMsgDescriptor.Comment.notrans"));
            cgReq.addSourceCode("etls_s_msgid=\"\";\n");
            cgReq.addSourceCode("etls_s_correlid=\"\";\n");
            mqmd4.generateAssignmentStatements();
            mqmd4.generateFunctionCall();
            cgReq.addSourceCode("goto etls_recv;\n");
        }
        cgReq.addSourceCode("etls_mqexit");
        cgReq.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        cgReq.addCommentLine(bundle.getString("IBMWSQReaderCodegen.CloseFile.Comment.notrans"));
        cgReq.addSourceCode("rc = fclose(fileid);\n");
        cgReq.addSourceCode("if (rc) then ");
        cgReq.indent();
        cgReq.genPutStatement(bundle.getString("IBMWSQReaderCodegen.ErrorClosingFile.Comment.put.notrans"), "ERROR:");
        cgReq.unIndent();
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n").unIndent();
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    public static void readUserInput(CodegenRequest cgReq, HashMap hmUserInput) {
        cgReq.addSourceCode("length etls_ui_msgtype 8;\n");
        if (hmUserInput.containsKey(MQMD.MSGTYPE)) {
            cgReq.addSourceCode("etls_ui_msgtype=");
            cgReq.addSourceCode((String)hmUserInput.get(MQMD.MSGTYPE));
            cgReq.addSourceCode(";\n");
        } else {
            cgReq.addSourceCode("etls_ui_msgtype=8;\n");
        }
        cgReq.addSourceCode("length etls_ui_correlid $48;\n");
        if (hmUserInput.containsKey(MQMD.CORRELID)) {
            cgReq.addSourceCode("etls_ui_correlid=upcase('");
            cgReq.addSourceCode((String)hmUserInput.get(MQMD.CORRELID));
            cgReq.addSourceCode("');\n");
        } else {
            cgReq.addSourceCode("etls_ui_correlid=\"\";\n");
        }
    }

    public static boolean isWriteToLog() {
        return true;
    }

    private static void doUWProcess(CodegenRequest cgReq, ClassifierMap cm, String type) throws MdException, RemoteException {
        AssociationList transList;
        AssociationList stepList = cm.getSteps(false);
        TransformationStep ts = null;
        if (stepList != null) {
            if (stepList.size() > 0) {
                ts = (TransformationStep)stepList.get(0);
            }
        } else {
            return;
        }
        if (type.equals("PreProcess")) {
            transList = ts.getTransformationSources();
        } else if (type.equals("PostProcess")) {
            transList = ts.getTransformationTargets();
        } else {
            return;
        }
        for (int i = 0; i < transList.size(); ++i) {
            Transformation step;
            Root root = (Root)transList.get(i);
            if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equals(type)) continue;
            if (step.getIsActive() != 1) break;
            cgReq.genUWC((AbstractTransformation)step, true);
            break;
        }
    }

    private static void genCodeConditionCheck(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        if (alTriggeredEvents.isEmpty()) {
            return;
        }
        cgReq.addCommentLine(bundle.getString("Codegen.RCCheck.msg.txt"));
        cgReq.addSourceCode("%macro etls_sqlRcCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            String eventRole = lEvent.getEventRole();
            if (!eventRole.equals("Condition1") && !eventRole.equals("Condition2") && !eventRole.equals("Condition3")) continue;
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n\n").indent();
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)oStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend etls_sqlRcCheck; \n").addSourceCode("%etls_sqlRcCheck; \n\n");
    }
}

