/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.miningresults;

import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class MiningResultInfoPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningResultInfoPanel.class);
    JLabel m_name;
    JLabel m_description;
    JLabel m_key;
    JLabel m_modelKey;
    JLabel m_projectKey;
    JLabel m_function;
    JLabel m_algorithm;
    JLabel m_version;
    JLabel m_developer;
    JLabel m_subject;
    WATextField m_nameField;
    WATextArea m_descTextArea;
    WATextField m_keyField;
    WATextField m_modelKeyField;
    WATextField m_projectKeyField;
    WATextField m_functionField;
    WATextField m_algorithmField;
    WATextField m_versionField;
    WATextField m_developerField;
    WATextField m_subjectField;
    JScrollPane m_descPane;
    IMiningResult m_result;
    boolean m_layoutVertical;

    public MiningResultInfoPanel(boolean layoutVertical) {
        this.m_layoutVertical = layoutVertical;
        this.initialize();
        this.layoutWidgets();
        this.setEditable(false);
    }

    protected void initialize() {
        this.m_name = new JLabel(bundle.getString("MiningResultInfoPanel.Name.txt"));
        this.m_description = new JLabel(bundle.getString("MiningResultInfoPanel.Description.txt"));
        this.m_key = new JLabel(bundle.getString("MiningResultInfoPanel.Key.txt"));
        this.m_modelKey = new JLabel(bundle.getString("MiningResultInfoPanel.ModelKey.txt"));
        this.m_projectKey = new JLabel(bundle.getString("MiningResultInfoPanel.ProjectKey.txt"));
        this.m_function = new JLabel(bundle.getString("MiningResultInfoPanel.Function.txt"));
        this.m_algorithm = new JLabel(bundle.getString("MiningResultInfoPanel.Algorithm.txt"));
        this.m_version = new JLabel(bundle.getString("MiningResultInfoPanel.Version.txt"));
        this.m_developer = new JLabel(bundle.getString("MiningResultInfoPanel.Developer.txt"));
        this.m_subject = new JLabel(bundle.getString("MiningResultInfoPanel.Subject.txt"));
        this.m_nameField = new WATextField();
        this.m_descTextArea = new WATextArea();
        this.m_keyField = new WATextField(24);
        this.m_modelKeyField = new WATextField(24);
        this.m_projectKeyField = new WATextField(24);
        this.m_functionField = new WATextField();
        this.m_algorithmField = new WATextField();
        this.m_versionField = new WATextField(16);
        this.m_developerField = new WATextField();
        this.m_subjectField = new WATextField();
        this.m_descPane = new JScrollPane((Component)this.m_descTextArea);
        this.m_descTextArea.setLineWrap(true);
        this.m_descTextArea.setWrapStyleWord(true);
        if (this.m_layoutVertical) {
            this.m_descTextArea.setRows(5);
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_nameField.setEditable(bEditable);
        this.m_keyField.setEditable(bEditable);
        this.m_modelKeyField.setEditable(bEditable);
        this.m_projectKeyField.setEditable(bEditable);
        this.m_functionField.setEditable(bEditable);
        this.m_algorithmField.setEditable(bEditable);
        this.m_versionField.setEditable(bEditable);
        this.m_developerField.setEditable(bEditable);
        this.m_subjectField.setEditable(bEditable);
        if (bEditable) {
            this.m_descTextArea.setBehavior(0);
        } else {
            this.m_descTextArea.setBehavior(2);
        }
    }

    public void setMiningResult(IMiningResult result) throws MdException, RemoteException {
        this.m_result = result;
        this.updateWidgetValues();
    }

    protected void updateWidgetValues() throws MdException, RemoteException {
        if (this.m_result != null) {
            this.m_nameField.setText(this.m_result.getName());
            this.m_descTextArea.setText(this.m_result.getDescription());
            this.m_functionField.setText(this.m_result.getMiningFunction());
            this.m_algorithmField.setText(this.m_result.getMiningAlgorithm());
            this.m_subjectField.setText(this.m_result.getSubject());
            this.m_keyField.setText(this.m_result.getKey());
            this.m_modelKeyField.setText(this.m_result.getModelKey());
            this.m_projectKeyField.setText(this.m_result.getProjectKey());
            this.m_developerField.setText(this.m_result.getDeveloper());
            this.m_versionField.setText(this.m_result.getEMVersion());
        } else {
            this.m_nameField.setText("");
            this.m_descTextArea.setText("");
            this.m_keyField.setText("");
            this.m_modelKeyField.setText("");
            this.m_projectKeyField.setText("");
            this.m_functionField.setText("");
            this.m_algorithmField.setText("");
            this.m_versionField.setText("");
            this.m_developerField.setText("");
            this.m_subjectField.setText("");
        }
    }

    protected void layoutWidgets() {
        if (this.m_layoutVertical) {
            this._layoutWidgetsVertical();
        } else {
            this._layoutWidgetsHorizontal();
        }
    }

    protected void _layoutWidgetsVertical() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets middleLeftInset = new Insets(5, 0, 0, 5);
        Insets middleRightInset = new Insets(5, 0, 0, 0);
        this.layoutLabelComponentPair(gbl, 0, this.m_name, new Insets(0, 0, 0, 5), (Component)this.m_nameField, new Insets(0, 0, 0, 0));
        this.layoutLabelComponentPair(gbl, 1, this.m_description, middleLeftInset, this.m_descPane, middleRightInset);
        this.layoutLabelComponentPair(gbl, 2, this.m_key, middleLeftInset, (Component)this.m_keyField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 3, this.m_modelKey, middleLeftInset, (Component)this.m_modelKeyField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 4, this.m_projectKey, middleLeftInset, (Component)this.m_projectKeyField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 5, this.m_function, middleLeftInset, (Component)this.m_functionField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 6, this.m_algorithm, middleLeftInset, (Component)this.m_algorithmField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 7, this.m_version, middleLeftInset, (Component)this.m_versionField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 8, this.m_developer, middleLeftInset, (Component)this.m_developerField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 9, this.m_subject, middleLeftInset, (Component)this.m_subjectField, middleRightInset);
    }

    protected void layoutLabelComponentPair(GridBagLayout gbl, int yLevel, JLabel label, Insets labelInset, Component component, Insets componentInset) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = yLevel;
        gbc.anchor = 17;
        gbc.insets = labelInset;
        gbl.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = yLevel;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = componentInset;
        gbl.setConstraints(component, gbc);
        this.add(component);
    }

    protected void _layoutWidgetsHorizontal() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets middleLeftInset = new Insets(5, 0, 0, 5);
        Insets middleRightInset = new Insets(5, 0, 0, 0);
        this.layoutLabelComponentPair(gbl, 0, this.m_name, new Insets(0, 0, 0, 5), (Component)this.m_nameField, new Insets(0, 0, 0, 0));
        this.layoutLabelComponentPair(gbl, 1, this.m_description, middleLeftInset, this.m_descPane, middleRightInset);
        this.layoutKeyVersionLine(gbl);
        this.layoutLabelComponentPair(gbl, 3, this.m_modelKey, middleLeftInset, (Component)this.m_modelKeyField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 4, this.m_projectKey, middleLeftInset, (Component)this.m_projectKeyField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 5, this.m_function, middleLeftInset, (Component)this.m_functionField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 6, this.m_algorithm, middleLeftInset, (Component)this.m_algorithmField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 7, this.m_developer, middleLeftInset, (Component)this.m_developerField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 8, this.m_subject, middleLeftInset, (Component)this.m_subjectField, middleRightInset);
    }

    protected void layoutKeyVersionLine(GridBagLayout gbl) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbl.setConstraints(this.m_key, gbc);
        this.add(this.m_key);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbl.setConstraints((Component)this.m_keyField, gbc);
        this.add((Component)this.m_keyField);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbl.setConstraints(this.m_version, gbc);
        this.add(this.m_version);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbl.setConstraints((Component)this.m_versionField, gbc);
        this.add((Component)this.m_versionField);
    }
}

