/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.miningresults;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IRelationalTable;
import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MiningResultColumnsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningResultColumnsTableModel.class);
    public static final int COLUMNNAME_COLUMN = 0;
    public static final int COLUMNDESCR_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int LENGTH_COLUMN = 3;
    public static final int LEVEL_COLUMN = 4;
    public static final int COLUMN_COLUMN = 5;
    public static final int COLUMNNAME_WIDTH = 100;
    public static final int COLUMNDESCR_WIDTH = 110;
    public static final int TYPE_WIDTH = 75;
    public static final int LENGTH_WIDTH = 50;
    public static final int LEVEL_WIDTH = 75;
    protected static final int VISIBLE_COLUMNS = 5;
    protected static final int HIDDEN_COLUMNS = 1;
    protected IMiningResult m_result = null;
    protected IRelationalTable m_dataTable;
    protected List m_inputColumnList;
    protected static String g_sDataCharacterType = WsColumnMetadataUtil.getDataCharacterType();
    protected static String g_sViewCharacterType = WsColumnMetadataUtil.getViewCharacterType();
    protected static String g_sViewNumericType = WsColumnMetadataUtil.getViewNumericType();

    public MiningResultColumnsTableModel() {
        this.createColumnDefinitions();
        this.m_inputColumnList = new ArrayList();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = this.loadTypeValues();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("MiningResultColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("MiningResultColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[2] = new WsEnumeratedTableColumn(2, bundle.getString("MiningResultColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[3] = new WsIntegerTableColumn(3, bundle.getString("MiningResultColumnsTableModel.Length.txt"), 50, 8, 1, Short.MAX_VALUE);
        this.m_aColumns[4] = new WsIntegerTableColumn(4, bundle.getString("MiningResultColumnsTableModel.Level.txt"), 75, 32);
        this.m_aColumns[5] = new WsMetadataTableColumn();
    }

    protected String[] loadTypeValues() {
        String[] saTypes = new String[]{g_sViewCharacterType, g_sViewNumericType};
        return saTypes;
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void setDataTable(IRelationalTable table) {
        this.m_dataTable = table;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        this.m_inputColumnList.clear();
        if (this.m_dataTable == null) {
            return;
        }
        IColumn[] columns = this.m_dataTable.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            IColumn column = columns[i];
            int iType = column.getType();
            String sLevel = column.getLevel();
            ArrayList<Object> rowArray = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            rowArray.add(column.getName());
            rowArray.add(column.getDescription());
            rowArray.add(iType == 0 ? g_sViewCharacterType : g_sViewNumericType);
            rowArray.add(new Integer(column.getLength()));
            rowArray.add(sLevel);
            rowArray.add(column);
            this.m_inputColumnList.add(column);
            this.m_lData.add(rowArray);
        }
        this.fireTableModelPopulated();
    }
}

