/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.miningresults;

import com.sas.editor.CodeEditor;
import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.etl.models.job.transforms.miningresults.impl.MiningResultsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.miningresults.MiningResultColumnsTableModel;
import com.sas.wadmin.transforms.miningresults.MiningResultInfoPanel;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MiningResultAttributesTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningResultAttributesTab.class);
    protected static final int MIN_TABLE_WIDTH = 100;
    protected static final int MIN_TABLE_HEIGHT = 100;
    protected static final int PREF_TABLE_WIDTH = 200;
    protected static final int PREF_TABLE_HEIGHT = 200;
    protected static final int MIN_MAPPINGS_WIDTH = 100;
    protected static final int MIN_MAPPINGS_HEIGHT = 100;
    protected static final int PREF_MAPPINGS_WIDTH = 100;
    protected static final int PREF_MAPPINGS_HEIGHT = 200;
    protected MiningResultsTransformModel m_model;
    protected MiningResultColumnsTableModel m_sourceTableModel;
    protected MiningResultColumnsTableModel m_targetTableModel;
    protected MiningResultInfoPanel m_attributePanel;
    protected WsTable m_sourceTable;
    protected WsTable m_targetTable;
    protected JScrollPane m_sourceScrollPane;
    protected JScrollPane m_targetScrollPane;
    protected JLabel m_inputLabel;
    protected JLabel m_outputLabel;
    protected JButton m_sourceButton;

    public MiningResultAttributesTab(MiningResultsTransformModel model) {
        this.m_model = model;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("model_attributes_tab");
    }

    protected void initialize() {
        this.setName(bundle.getString("MiningResultAttributesTab.Title.txt"));
        this.m_attributePanel = new MiningResultInfoPanel(false);
        this.m_attributePanel.setPreferredSize(new Dimension(200, 250));
        this.m_inputLabel = new JLabel(bundle.getString("MiningResultAttributesTab.Label.Input.txt"));
        this.m_outputLabel = new JLabel(bundle.getString("MiningResultAttributesTab.Label.Output.txt"));
        this.m_sourceButton = new JButton(bundle.getString("MiningResultAttributesTab.Button.Source.txt"));
        this.m_sourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MiningResultAttributesTab.this.displaySource();
            }
        });
        this.createSourceTable();
        this.createOutputTable();
    }

    protected void displaySource() {
        cEditorPanel pnlEditor = new cEditorPanel();
        WAStandardDialog dlgEditor = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("MiningResultAttributesTab.EditorDialog.Title.txt"), true, (WAPanel)pnlEditor);
        dlgEditor.setEditable(false);
        dlgEditor.setResizable(true);
        dlgEditor.show();
    }

    protected void createSourceTable() {
        this.m_sourceTableModel = new MiningResultColumnsTableModel();
        this.m_sourceTable = new WsTable((WsAbstractTableModel)this.m_sourceTableModel);
        this.m_sourceTable.setEditable(false);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(2);
        int iColumnName = this.m_sourceTable.convertColumnIndexToView(0);
        TableColumn colColumnName = this.m_sourceTable.getColumnModel().getColumn(iColumnName);
        colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        this.m_sourceScrollPane = new JScrollPane((Component)this.m_sourceTable);
        this.m_sourceScrollPane.setMinimumSize(new Dimension(100, 100));
        this.m_sourceScrollPane.setPreferredSize(new Dimension(200, 200));
    }

    protected void createOutputTable() {
        this.m_targetTableModel = new MiningResultColumnsTableModel();
        this.m_targetTable = new WsTable((WsAbstractTableModel)this.m_targetTableModel);
        this.m_targetTable.setEditable(false);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(2);
        int iColumnName = this.m_targetTable.convertColumnIndexToView(0);
        TableColumn colColumnName = this.m_targetTable.getColumnModel().getColumn(iColumnName);
        colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        this.m_targetScrollPane = new JScrollPane((Component)this.m_targetTable);
        this.m_targetScrollPane.setMinimumSize(new Dimension(100, 100));
        this.m_targetScrollPane.setPreferredSize(new Dimension(200, 200));
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_attributePanel), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_inputLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.m_outputLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_sourceScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.add(this.m_targetScrollPane, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.add(this.m_sourceButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        IMiningResult miningResult = this.m_model.getMiningResult();
        this.m_attributePanel.setMiningResult(miningResult);
        if (miningResult != null) {
            this.m_sourceTableModel.setDataTable(miningResult.getInputTable());
            this.m_targetTableModel.setDataTable(miningResult.getOutputTable());
        }
        this.m_sourceTableModel.moveDataToModel();
        this.m_targetTableModel.moveDataToModel();
    }

    protected class cEditorPanel
    extends WAPanel {
        protected CodeEditor m_editor;

        public cEditorPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.setHelpProduct("texteditor");
            this.setHelpTopic("editorspace");
            this.m_editor = new CodeEditor((Frame)Workspace.getWorkspace(), Workspace.getWorkspace().getCodeEditorDefaults());
            this.m_editor.setPreferredSize(new Dimension(600, 400));
        }

        protected void layoutWidgets() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_editor, "Center");
        }

        public void moveDataToView() throws MdException, RemoteException {
            if (MiningResultAttributesTab.this.m_model.getMiningResult() == null) {
                return;
            }
            this.m_editor.setText(MiningResultAttributesTab.this.m_model.getMiningResult().getSourceCode());
        }

        public void setEditable(boolean editable) {
            super.setEditable(editable);
            this.m_editor.SetReadOnly(!editable);
        }

        public String getText() {
            return this.m_editor.getText();
        }

        public void setText(String strText) {
            this.m_editor.setText(strText);
        }
    }
}

