/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.loader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.wadmin.transforms.loader.NameValueComboBoxModel;
import com.sas.wadmin.transforms.loader.SourceMatchColumnOrderedListModel;
import com.sas.wadmin.transforms.loader.TargetMatchColumnListModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TableLoader42LoadTechniquePropertyTab
extends WAPropertyTab {
    private static final WAdminResource m_bundle = WAdminResource.getBundle(TableLoader42LoadTechniquePropertyTab.class);
    private WAComboBox m_cmbLoadStyle;
    private WAComboBox m_cmbReplaceType;
    private WAComboBox m_cmbMatchingRows;
    private JCheckBox m_chkNoMissingCheck;
    private WAComboBox m_cmbNewRows;
    private WAComboBox m_cmbConstraintBefore;
    private WAComboBox m_cmbConstraintAfter;
    private WAComboBox m_cmbIndexBefore;
    private WAComboBox m_cmbIndexAfter;
    private WAPanel m_pnlUpdateLayout;
    private CardLayout m_crdUpdateLayout;
    private WAComboBox m_cmbModifyIndex;
    private JCheckBox m_chkModifyIndexMatchFromTop;
    private cMatchColumnsDualListSelector m_dlsColumns;
    protected TableLoaderTransformModel m_model;
    private NameValueComboBoxModel m_mdlLoadStyle;
    private NameValueComboBoxModel m_mdlMatchingRows = null;
    private NameValueComboBoxModel m_mdlNewRows = null;
    private DefaultComboBoxModel m_mdlModifyIndexes = null;
    private NameValueComboBoxModel m_mdlIndexBefore = null;
    private NameValueComboBoxModel m_mdlConstraintBefore = null;
    private NameValueComboBoxModel m_mdlConstraintAfter = null;
    private NameValueComboBoxModel m_mdlIndexAfter = null;
    private NameValueComboBoxModel m_mdlReplaceType = null;
    private DefaultListModel m_adpAvailable;
    private DefaultListModel m_adpSelected;
    private TableLoaderModelListener m_listener;
    private ActionListener m_cmbLoadStyleListener = null;
    private ActionListener m_cmbReplaceTypeListener = null;
    private ActionListener m_cmbMatchingRowsListener = null;
    private ActionListener m_cmbNewRowsListener = null;
    private ActionListener m_chkNoMissingCheckListener = null;
    private ActionListener m_chkModifyIndexMatchFromTopListener = null;
    private ActionListener m_cmbConstraintBeforeListener = null;
    private ActionListener m_cmbConstraintAfterListener = null;
    private ActionListener m_cmbIndexBeforeListener = null;
    private ActionListener m_cmbIndexAfterListener = null;
    private ActionListener m_cmbModifyIndexListener = null;

    public TableLoader42LoadTechniquePropertyTab(TableLoaderTransformModel obj) {
        this.setName(m_bundle.getString("TableLoaderTransformAdapter.LoadTechniquePropertyTab.Title.txt"));
        this.m_model = obj;
        this.m_listener = new TableLoaderModelListener();
        this.m_model.getModel().addModelListener((IModelListener)this.m_listener);
        this.m_mdlLoadStyle = this.getLoadStyleModel(this.m_model);
        this.m_mdlReplaceType = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.ReplaceType", true);
        this.m_mdlMatchingRows = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.MatchingRows", true);
        this.m_mdlNewRows = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.NewRows", true);
        this.m_mdlIndexBefore = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.CIAction", true);
        this.m_mdlIndexAfter = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.CIAction", true);
        this.m_mdlConstraintBefore = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.CIAction", true);
        this.m_mdlConstraintAfter = new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter.CIAction", true);
        this.setHelpTopic("load_technique2_tab");
        this.initialize();
        this.initializeLayout();
        this.initializeModels();
    }

    protected NameValueComboBoxModel createNewComboModel(String name, boolean sorted) {
        return new NameValueComboBoxModel(m_bundle, "TableLoaderTransformAdapter." + name, sorted);
    }

    protected NameValueComboBoxModel getLoadStyleModel(TableLoaderTransformModel model) {
        NameValueComboBoxModel loadStyle = this.createNewComboModel("LoadStyle", true);
        List loadStyles = model.getLoadTechniques();
        for (int i = 0; i < loadStyles.size(); ++i) {
            loadStyle.addItem((String)loadStyles.get(i));
        }
        return loadStyle;
    }

    public void initialize() {
        this.m_cmbLoadStyle = new WAComboBox();
        this.m_cmbLoadStyle.setSorted(true);
        this.m_cmbLoadStyleListener = new cLoadStyleListener();
        this.m_cmbLoadStyle.addActionListener(this.m_cmbLoadStyleListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbLoadStyle);
        this.m_cmbReplaceType = new WAComboBox();
        this.m_cmbReplaceType.setSorted(true);
        this.m_cmbReplaceTypeListener = new cReplaceTypeListener();
        this.m_cmbReplaceType.addActionListener(this.m_cmbReplaceTypeListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbReplaceType);
        this.m_cmbMatchingRows = new WAComboBox();
        this.m_cmbMatchingRowsListener = new cMatchingRowsListener();
        this.m_cmbMatchingRows.addActionListener(this.m_cmbMatchingRowsListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbMatchingRows);
        this.m_chkNoMissingCheck = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"TableLoader.NoMissingCheck", (int)5);
        this.m_chkNoMissingCheckListener = new cNoMissingCheckListener();
        this.m_chkNoMissingCheck.addActionListener(this.m_chkNoMissingCheckListener);
        this.listenForDataChangesTo(this.m_chkNoMissingCheck);
        this.m_cmbNewRows = new WAComboBox();
        this.m_cmbNewRowsListener = new cNewRowsListener();
        this.m_cmbNewRows.addActionListener(this.m_cmbNewRowsListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbNewRows);
        this.m_cmbConstraintBefore = new WAComboBox();
        this.m_cmbConstraintBeforeListener = new cConstraintBeforeListener();
        this.m_cmbConstraintBefore.addActionListener(this.m_cmbConstraintBeforeListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbConstraintBefore);
        this.m_cmbConstraintAfter = new WAComboBox();
        this.m_cmbConstraintAfterListener = new cConstraintAfterListener();
        this.m_cmbConstraintAfter.addActionListener(this.m_cmbConstraintAfterListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbConstraintAfter);
        this.m_cmbIndexBefore = new WAComboBox();
        this.m_cmbIndexBeforeListener = new cIndexBeforeListener();
        this.m_cmbIndexBefore.addActionListener(this.m_cmbIndexBeforeListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbIndexBefore);
        this.m_cmbIndexAfter = new WAComboBox();
        this.m_cmbIndexAfterListener = new cIndexAfterListener();
        this.m_cmbIndexAfter.addActionListener(this.m_cmbIndexAfterListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbIndexAfter);
        this.m_pnlUpdateLayout = new WAPanel();
        this.m_crdUpdateLayout = new CardLayout();
        this.m_cmbModifyIndex = new WAComboBox();
        this.m_cmbModifyIndexListener = new cModifyIndexListener();
        this.m_cmbModifyIndex.addActionListener(this.m_cmbModifyIndexListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbModifyIndex);
        this.m_chkModifyIndexMatchFromTop = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"TableLoader.ModifyIndexMatchFromTop", (int)5);
        this.m_chkModifyIndexMatchFromTopListener = new cModifyIndexMatchFromTopListener();
        this.m_chkModifyIndexMatchFromTop.addActionListener(this.m_chkModifyIndexMatchFromTopListener);
        this.listenForDataChangesTo(this.m_chkModifyIndexMatchFromTop);
        this.m_dlsColumns = new cMatchColumnsDualListSelector();
        this.m_dlsColumns.setPreferredSize(new Dimension(100, 150));
        this.m_adpAvailable = new SourceMatchColumnOrderedListModel();
        this.m_adpSelected = new TargetMatchColumnListModel(this.m_model);
        this.m_dlsColumns.setTargetControlsVisible(true);
        this.m_dlsColumns.setAlternatingSingleButtonStyle(false);
        this.m_dlsColumns.setModel(this.m_adpAvailable);
        this.m_dlsColumns.setSourceCellRenderer(new cListCellRenderer());
        this.m_dlsColumns.setTargetCellRenderer(new cListCellRenderer());
        this.m_dlsColumns.setTargetModel(this.m_adpSelected);
        this.m_dlsColumns.setSourceLabel(m_bundle.getString("TableLoaderLoadTechniquePropertyTab.AvailableColumns.txt"));
        this.m_dlsColumns.getSourceComponent().setToolTipText(m_bundle.getString("TableLoaderLoadTechniquePropertyTab.AvailableColumns.tip"));
        ((JLabel)this.m_dlsColumns.getSourceLabelComponent()).setDisplayedMnemonic(m_bundle.getString("TableLoaderLoadTechniquePropertyTab.AvailableColumns.mnem").charAt(0));
        this.m_dlsColumns.setTargetLabel(m_bundle.getString("TableLoaderLoadTechniquePropertyTab.SelectedColumns.txt"));
        this.m_dlsColumns.getTargetComponent().setToolTipText(m_bundle.getString("TableLoaderLoadTechniquePropertyTab.SelectedColumns.tip"));
        ((JLabel)this.m_dlsColumns.getTargetLabelComponent()).setDisplayedMnemonic(m_bundle.getString("TableLoaderLoadTechniquePropertyTab.SelectedColumns.mnem").charAt(0));
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        this.add(this.createLoadStylePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createReplaceTypePanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createTechniquesPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createConstraintConditionPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createIndexConditionPanel(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createUpdateLayoutPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createResetPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel createLoadStylePanel() {
        JLabel lblLoadStyle = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbLoadStyle, (WAdminResource)m_bundle, (String)"TableLoader.LoadStyle");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(lblLoadStyle);
        panel.add(Box.createHorizontalStrut(5));
        panel.add((Component)this.m_cmbLoadStyle);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    protected JPanel createReplaceTypePanel() {
        JLabel lblReplaceType = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbReplaceType, (WAdminResource)m_bundle, (String)"TableLoader.ReplaceType");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(lblReplaceType);
        panel.add(Box.createHorizontalStrut(5));
        panel.add((Component)this.m_cmbReplaceType);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    protected JPanel createTechniquesPanel() {
        JLabel lblMatchingRows = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbMatchingRows, (WAdminResource)m_bundle, (String)"TableLoader.MatchingRows");
        JLabel lblNewRows = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbNewRows, (WAdminResource)m_bundle, (String)"TableLoader.NewRows");
        JPanel panel = new JPanel();
        panel.setBorder(WsUIUtilities.createTitledBorder((String)m_bundle.getString("TableLoader.Techniques.title.txt")));
        panel.setLayout(new GridBagLayout());
        panel.add((Component)lblMatchingRows, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.m_cmbMatchingRows, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.m_chkNoMissingCheck, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)lblNewRows, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.m_cmbNewRows, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel createConstraintConditionPanel() {
        JLabel lblConstraintBefore = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbConstraintBefore, (WAdminResource)m_bundle, (String)"TableLoader.ConstraintBefore");
        JLabel lblConstraintAfter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbConstraintAfter, (WAdminResource)m_bundle, (String)"TableLoader.ConstraintAfter");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(WsUIUtilities.createTitledBorder((String)m_bundle.getString("TableLoader.AdditionalCActions.title.txt")));
        panel.add((Component)lblConstraintBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.m_cmbConstraintBefore, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)lblConstraintAfter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.m_cmbConstraintAfter, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel createIndexConditionPanel() {
        JLabel lblIndexBefore = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbIndexBefore, (WAdminResource)m_bundle, (String)"TableLoader.IndexBefore");
        JLabel lblIndexAfter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbIndexAfter, (WAdminResource)m_bundle, (String)"TableLoader.IndexAfter");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(WsUIUtilities.createTitledBorder((String)m_bundle.getString("TableLoader.AdditionalIActions.title.txt")));
        panel.add((Component)lblIndexBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.m_cmbIndexBefore, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)lblIndexAfter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.m_cmbIndexAfter, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel createUpdateLayoutPanel() {
        this.m_pnlUpdateLayout.setLayout((LayoutManager)this.m_crdUpdateLayout);
        this.m_pnlUpdateLayout.add((Component)new JPanel(), (Object)"");
        this.m_pnlUpdateLayout.add((Component)this.createMatchByColumnPanel(), (Object)"ModifyByColumn");
        this.m_pnlUpdateLayout.add((Component)this.createModifyUsingIndexPanel(), (Object)"ModifyUsingIndex");
        return this.m_pnlUpdateLayout;
    }

    protected JPanel createModifyUsingIndexPanel() {
        JLabel lblModifyIndex = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbModifyIndex, (WAdminResource)m_bundle, (String)"TableLoader.ModifyUsingIndex");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(WsUIUtilities.createTitledBorder((String)m_bundle.getString("TableLoader.ModifyUsingIndex.title.txt")));
        panel.add((Component)lblModifyIndex, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_cmbModifyIndex, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.m_chkModifyIndexMatchFromTop, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel createMatchByColumnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new CompoundBorder(WsUIUtilities.createTitledBorder((String)m_bundle.getString("TableLoader.MatchColumns.title.txt")), new EmptyBorder(5, 5, 5, 5)));
        panel.add((Component)((Object)this.m_dlsColumns), "Center");
        return panel;
    }

    protected JPanel createResetPanel() {
        JButton btnReset = WsUIUtilities.createTextButton((WsAbstractAction)new cResetDefaultsAction());
        JPanel panel = new JPanel();
        panel.add(btnReset);
        return panel;
    }

    private void initializeModels() {
        this.setListeningForChanges(false);
        this.m_cmbLoadStyle.setModel((ComboBoxModel)this.m_mdlLoadStyle);
        this.handleLoadStyleChanged();
        this.m_cmbReplaceType.setModel((ComboBoxModel)this.m_mdlReplaceType);
        this.handleReplaceTypeChanged();
        this.m_cmbMatchingRows.setModel((ComboBoxModel)this.m_mdlMatchingRows);
        this.handleMatchingRowsChanged();
        this.m_cmbNewRows.setModel((ComboBoxModel)this.m_mdlNewRows);
        this.handleNewRowsChanged();
        this.m_cmbConstraintBefore.setModel((ComboBoxModel)this.m_mdlConstraintBefore);
        this.handleConstraintBeforeChanged();
        this.m_cmbConstraintAfter.setModel((ComboBoxModel)this.m_mdlConstraintAfter);
        this.handleConstraintAfterChanged();
        this.m_cmbIndexBefore.setModel((ComboBoxModel)this.m_mdlIndexBefore);
        this.handleIndexBeforeChanged();
        this.m_cmbIndexAfter.setModel((ComboBoxModel)this.m_mdlIndexAfter);
        this.handleIndexAfterChanged();
        IIndex selectedIndex = this.m_model.getModifyIndex();
        List indexes = this.m_model.getAvailableIndexes();
        int indexOfSelectedIndex = 0;
        String[] indexNames = new String[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            IIndex indexObject = (IIndex)indexes.get(i);
            indexNames[i] = indexObject.getName();
            if (selectedIndex == null || indexObject != selectedIndex) continue;
            indexOfSelectedIndex = i;
        }
        this.m_mdlModifyIndexes = new DefaultComboBoxModel<String>(indexNames);
        this.m_cmbModifyIndex.setModel((ComboBoxModel)this.m_mdlModifyIndexes);
        if (indexOfSelectedIndex != 0) {
            this.m_cmbModifyIndex.setSelectedIndex(indexOfSelectedIndex);
        } else if (this.m_cmbModifyIndex.getItemCount() > 0) {
            this.m_cmbModifyIndex.setSelectedIndex(0);
        }
        this.m_chkNoMissingCheck.setSelected(this.m_model.isNoMissingCheck());
        this.m_chkModifyIndexMatchFromTop.setSelected(this.m_model.isIndexUniqueValue());
        this.setListeningForChanges(true);
    }

    public void setEditable(boolean bEditable) {
        bEditable = bEditable && this.m_model.getDataTargetsCount() > 0;
        this.setReplaceTypeEnabled();
        this.setMatchingRowsEnabled();
        this.setNoMissingCheckEnabled();
        this.m_cmbNewRows.setEnabled(bEditable && this.m_model.isNewRowsEnabled());
        this.m_cmbLoadStyle.setEnabled(bEditable);
        boolean constraintEnabled = false;
        boolean indexEnabled = false;
        if (this.m_model.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.m_model.getDataTargets()[0];
            constraintEnabled = this.m_model.isConstraintEnabled(dataTarget);
            indexEnabled = this.m_model.isIndexEnabled(dataTarget);
        }
        this.m_cmbIndexBefore.setEnabled(bEditable && indexEnabled);
        this.m_cmbIndexAfter.setEnabled(bEditable && indexEnabled);
        this.m_cmbConstraintBefore.setEnabled(bEditable && constraintEnabled);
        this.m_cmbConstraintAfter.setEnabled(bEditable && constraintEnabled);
        this.m_chkModifyIndexMatchFromTop.setEnabled(bEditable);
        this.m_dlsColumns.setEnabled(bEditable);
        this.m_cmbModifyIndex.setEnabled(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_model.getModel().removeModelListener((IModelListener)this.m_listener);
        this.m_cmbLoadStyle.removeActionListener(this.m_cmbLoadStyleListener);
        this.m_cmbMatchingRows.removeActionListener(this.m_cmbMatchingRowsListener);
        this.m_cmbNewRows.removeActionListener(this.m_cmbNewRowsListener);
        this.m_chkNoMissingCheck.removeActionListener(this.m_chkNoMissingCheckListener);
        this.m_cmbConstraintBefore.removeActionListener(this.m_cmbConstraintBeforeListener);
        this.m_cmbIndexBefore.removeActionListener(this.m_cmbIndexBeforeListener);
    }

    private void setMatchingRowsEnabled() {
        boolean bMatchingRowsEnabled = false;
        if (this.m_model.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.m_model.getDataTargets()[0];
            bMatchingRowsEnabled = this.m_model.isMatchingRowsEnabled(dataTarget);
        }
        this.m_cmbMatchingRows.setEnabled(this.isEnabled() && bMatchingRowsEnabled);
    }

    private void setReplaceTypeEnabled() {
        boolean bisReplaceTypeEnabled = false;
        if (this.m_model.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.m_model.getDataTargets()[0];
            bisReplaceTypeEnabled = this.m_model.isReplaceTypeEnabled(dataTarget);
        }
        this.m_cmbReplaceType.setEnabled(this.isEditable() && bisReplaceTypeEnabled);
    }

    private void setNoMissingCheckEnabled() {
        this.m_chkNoMissingCheck.setEnabled(this.isEnabled() && this.m_model.isNoMissingCheckEnabled());
    }

    private void setUpdatePanelVisible() {
        this.m_crdUpdateLayout.show((Container)this.m_pnlUpdateLayout, this.m_model.getModifyType());
    }

    public boolean validateData() {
        ILibrary lib;
        IPhysicalTable dataTarget;
        boolean bSuccess = true;
        boolean noByColumn = this.m_model.getMatchingColumnsList().isEmpty();
        if (this.m_model.getDataTargetsCount() > 0 && this.m_model.getLoadStyle().equalsIgnoreCase("Update")) {
            if ((this.m_model.getNewRows().equalsIgnoreCase("ModifyUsingIndex") || this.m_model.getMatchingRows().equalsIgnoreCase("ModifyUsingIndex")) && this.m_model.getModifyIndex() == null) {
                List indexArray = this.m_model.getAvailableIndexes();
                if (indexArray != null && indexArray.size() > 0) {
                    this.m_model.setModifyIndex((IIndex)indexArray.get(0));
                } else {
                    MessageUtil.displayMessage((String)m_bundle.getString("TableLoaderModel.NoSelectedIndex.Error.txt"), (int)0);
                    return false;
                }
            }
            if (!this.m_model.getNewRows().equalsIgnoreCase("ModifyUsingIndex") && !this.m_model.getMatchingRows().equalsIgnoreCase("ModifyUsingIndex")) {
                if (noByColumn) {
                    MessageUtil.displayMessage((String)m_bundle.getString("TableLoaderModel.NoSelectedColumns.Error.txt"), (int)0);
                    return false;
                }
                if (this.m_model.getMatchingRows().equalsIgnoreCase("SQLSet") && this.m_model.getMatchingColumnsList().isEmpty()) {
                    MessageUtil.displayMessage((String)m_bundle.getString("TableLoaderModel.NoSelectedColumns.Error.txt"), (int)0);
                    return false;
                }
            }
        }
        if (this.m_model.getDataTargetsCount() > 0 && (dataTarget = (IPhysicalTable)this.m_model.getDataTargets()[0]).getDBMSType() != null && dataTarget.getDBMSType().isRereadExposureRequired() && (this.m_model.getNewRows().equalsIgnoreCase("ModifyByColumn") || this.m_model.getMatchingRows().equalsIgnoreCase("ModifyByColumn") && this.m_cmbMatchingRows.isEnabled()) && (lib = dataTarget.getLibrary()) != null) {
            if (lib.isPreAssigned()) {
                MessageUtil.displayMessage((String)m_bundle.getString("TableLoaderModel.PreassignedDBMSLibraryReread.Warning.txt"), (int)1);
            } else {
                MessageUtil.displayMessage((String)m_bundle.getString("TableLoaderModel.DBMSLibraryReread.Warning.txt"), (int)1);
            }
        }
        return bSuccess;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_adpAvailable.clear();
        List lAvlColumns = this.m_model.getAvailableMatchColumns();
        for (int i = 0; i < lAvlColumns.size(); ++i) {
            this.m_adpAvailable.addElement(lAvlColumns.get(i));
        }
        this.m_adpSelected.clear();
        IColumn[] aMatchColumns = this.m_model.getMatchingColumns();
        for (int i = 0; i < aMatchColumns.length; ++i) {
            this.m_adpSelected.addElement(aMatchColumns[i]);
        }
        this.setUpdatePanelVisible();
        this.setEditable(this.isEnabled());
        this.setDataChanged(false);
        this.setListeningForChanges(true);
    }

    private void resetToDefaultValues() {
        this.m_model.resetModelDefaults();
    }

    private void resetCIComboText(NameValueComboBoxModel combo1Mdl, NameValueComboBoxModel combo2Mdl) {
        IPhysicalTable dataTarget;
        boolean isReplacingTable = false;
        if (this.m_model.getDataTargetsCount() > 0 && (dataTarget = (IPhysicalTable)this.m_model.getDataTargets()[0]) != null) {
            isReplacingTable = this.m_model.isReplacingEntireTable();
        }
        if (combo2Mdl == null) {
            for (int i = 0; i < combo1Mdl.getSize(); ++i) {
                String code = combo1Mdl.getElementValueAt(i) + "_*_" + (isReplacingTable ? "NEW" : "OLD");
                combo1Mdl.setElementNameAt(i, this.getCIComboText(code));
            }
        } else {
            for (int i = 0; i < combo2Mdl.getSize(); ++i) {
                String code = combo1Mdl.getSelectedValue() + "_" + combo2Mdl.getElementValueAt(i) + "_" + (isReplacingTable ? "NEW" : "OLD");
                combo2Mdl.setElementNameAt(i, this.getCIComboText(code));
            }
        }
    }

    private String getCIComboText(String codeToFind) {
        String value;
        HashMap<String, String> hMap = new HashMap<String, String>();
        hMap.put("INIT_*_OLD", "OnInit");
        hMap.put("INIT_*_NEW", "OnInitNewTable");
        hMap.put("OFF_*_OLD", "Off");
        hMap.put("ON_*_OLD", "OnFix");
        hMap.put("ASIS_*_OLD", "DoNothing");
        hMap.put("ASIS_*_NEW", "LeaveOff");
        hMap.put("RECREATEASIS_*_OLD", "RecreateAsis");
        hMap.put("INIT_OFF_OLD", "Off");
        hMap.put("INIT_OFF_NEW", "Off");
        hMap.put("INIT_ASIS_OLD", "LeaveOn");
        hMap.put("INIT_ASIS_NEW", "LeaveOn");
        hMap.put("OFF_ON_OLD", "On");
        hMap.put("OFF_ASIS_OLD", "LeaveOff");
        hMap.put("ON_OFF_OLD", "Off");
        hMap.put("ON_ASIS_OLD", "LeaveOn");
        hMap.put("ASIS_INIT_OLD", "OnInit");
        hMap.put("ASIS_INIT_NEW", "OnInitNewTable");
        hMap.put("ASIS_OFF_OLD", "Off");
        hMap.put("ASIS_ON_OLD", "OnFix");
        hMap.put("ASIS_ASIS_OLD", "DoNothing");
        hMap.put("ASIS_ASIS_NEW", "LeaveOff");
        hMap.put("RECREATEASIS_ASIS_OLD", "DoNothing");
        if (hMap.containsKey(codeToFind)) {
            String propName = hMap.get(codeToFind).toString();
            value = m_bundle.getRawString("TableLoaderTransformAdapter.CIComboChoices." + propName + ".txt");
            if (value == null) {
                value = "NF: " + propName;
            }
        } else {
            value = "NF:" + codeToFind;
        }
        return value;
    }

    protected void handleModelChanged(ModelEvent ev) {
        String type = ev.getType();
        if (type.equals("TableLoaderTransformModel:ConstraintAfterChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: CONSTRAINT_AFTER_CHANGED even");
            this.handleConstraintAfterChanged();
        } else if (type.equals("TableLoaderTransformModel:ConstraintBeforeChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: CONSTRAINT_BEFORE_CHANGED even");
            this.handleConstraintBeforeChanged();
        } else if (type.equals("TableLoaderTransformModel:IndexAfterChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: INDEX_AFTER_CHANGED even");
            this.handleIndexAfterChanged();
        } else if (type.equals("TableLoaderTransformModel:IndexBeforeChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: INDEX_BEFORE_CHANGED even");
            this.handleIndexBeforeChanged();
        } else if (type.equals("TableLoaderTransformModel:LoadStyleChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: loadstylechanged even");
            this.handleLoadStyleChanged();
        } else if (type.equals("TableLoaderTransformModel:MatchingRowsChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: MATCHINGROWS_CHANGED even");
            this.handleMatchingRowsChanged();
            this.handleNewRowsChanged();
        } else if (type.equals("TableLoaderTransformModel:NewRowsChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: NEWROWS_CHANGED even");
            this.handleNewRowsChanged();
        } else if (type.equals("TableLoaderTransformModel:NoMissingCheckChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: NOMISSINGCHECK_CHANGED even");
            this.handleNoMissingCheckChanged();
        } else if (type.equals("TableLoaderTransformModel:ReplaceTypeChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: REPLACETYPE_CHANGED even");
            this.handleReplaceTypeChanged();
        } else if (type.equals("TableLoaderTransformModel:MatchColumnAdded")) {
            IColumn column = (IColumn)ev.getData();
            this.m_adpAvailable.removeElement(column);
            this.m_adpSelected.addElement(column);
            this.handleMatchColumnsChanged();
        } else if (type.equals("TableLoaderTransformModel:MatchColumnRemoved")) {
            IColumn column = (IColumn)ev.getData();
            this.m_adpAvailable.addElement(column);
            this.m_adpSelected.removeElement(column);
            this.handleMatchColumnsChanged();
        } else if (type.equals("TableLoaderTransformModel:MatchColumnMoved")) {
            IColumn column = (IColumn)ev.getData();
            int iLoc = this.m_model.getMatchingColumnsList().indexOf(column);
            if (this.m_adpSelected.getElementAt(iLoc) == column) {
                return;
            }
            this.m_adpSelected.removeElement(column);
            this.m_adpSelected.add(iLoc, column);
        } else if (type.equals("TableLoaderTransformModel:IndexUniqueValueChanged")) {
            this.m_chkModifyIndexMatchFromTop.setSelected(this.m_model.isIndexUniqueValue());
        } else if (type.equals("TableLoaderTransformModel:ModifyUsingIndexChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: MODIFYUSINGINDEX_CHANGED even");
            this.handleModifyIndexChanged();
        } else if (type.equals("TableLoaderTransformModel:NoMissingCheckChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: NOMISSINGCHECK_CHANGED even");
            this.handleNoMissingCheckChanged();
        }
    }

    protected void handleLoadStyleChanged() {
        this.setReplaceTypeEnabled();
        this.setMatchingRowsEnabled();
        this.setNoMissingCheckEnabled();
        this.m_chkNoMissingCheck.setSelected(this.m_model.getDefaultNoMissingCheck());
        this.m_mdlLoadStyle.setSelectedValue(this.m_model.getLoadStyle());
        this.setUpdatePanelVisible();
    }

    protected void handleReplaceTypeChanged() {
        this.m_mdlReplaceType.removeAllElements();
        List values = this.m_model.getValidValuesReplaceType();
        this.m_mdlReplaceType.addItemList(values);
        this.m_mdlReplaceType.setSelectedValue(this.m_model.getReplaceType());
        this.setUpdatePanelVisible();
    }

    protected void handleNewRowsChanged() {
        this.m_mdlNewRows.removeAllElements();
        List values = this.m_model.getValidValuesNewRows();
        this.m_mdlNewRows.addItemList(values);
        this.m_mdlNewRows.setSelectedValue(this.m_model.getNewRows());
    }

    protected void handleMatchingRowsChanged() {
        this.setNoMissingCheckEnabled();
        this.m_mdlMatchingRows.removeAllElements();
        List values = this.m_model.getValidValuesMatchingRows();
        this.m_mdlMatchingRows.addItemList(values);
        this.m_mdlMatchingRows.setSelectedValue(this.m_model.getMatchingRows());
        this.setUpdatePanelVisible();
    }

    protected void handleConstraintBeforeChanged() {
        this.m_mdlConstraintBefore.removeAllElements();
        List values = this.m_model.getValidValuesConstraintBefore();
        this.m_mdlConstraintBefore.addItemList(values);
        String sValue = this.m_model.getConstraintBeforeValue();
        if (!values.contains(sValue)) {
            sValue = this.m_model.getDefaultConstraintBefore();
        }
        this.m_mdlConstraintBefore.setSelectedValue(sValue);
        this.resetCIComboText(this.m_mdlConstraintBefore, null);
    }

    protected void handleConstraintAfterChanged() {
        this.m_mdlConstraintAfter.removeAllElements();
        List values = this.m_model.getValidValuesConstraintAfter();
        this.m_mdlConstraintAfter.addItemList(values);
        if (this.m_mdlConstraintAfter.isValueInList(this.m_model.getConstraintAfterValue())) {
            this.m_mdlConstraintAfter.setSelectedValue(this.m_model.getConstraintAfterValue());
        }
        this.resetCIComboText(this.m_mdlConstraintBefore, this.m_mdlConstraintAfter);
    }

    protected void handleIndexBeforeChanged() {
        this.m_mdlIndexBefore.removeAllElements();
        List values = this.m_model.getValidValuesIndexBefore();
        this.m_mdlIndexBefore.addItemList(values);
        String sValue = this.m_model.getIndexBeforeValue();
        if (!values.contains(sValue)) {
            sValue = this.m_model.getDefaultIndexBefore();
        }
        this.m_mdlIndexBefore.setSelectedValue(sValue);
        this.resetCIComboText(this.m_mdlIndexBefore, null);
    }

    protected void handleIndexAfterChanged() {
        this.m_mdlIndexAfter.removeAllElements();
        List values = this.m_model.getValidValuesIndexAfter();
        this.m_mdlIndexAfter.addItemList(values);
        if (this.m_mdlIndexAfter.isValueInList(this.m_model.getIndexAfterValue())) {
            this.m_mdlIndexAfter.setSelectedValue(this.m_model.getIndexAfterValue());
        }
        this.resetCIComboText(this.m_mdlIndexBefore, this.m_mdlIndexAfter);
    }

    protected void handleNoMissingCheckChanged() {
        this.m_chkNoMissingCheck.setSelected(this.m_model.isNoMissingCheck());
    }

    protected void handleMatchColumnsChanged() {
        this.m_chkNoMissingCheck.setSelected(this.m_model.isNoMissingCheck());
    }

    protected void handleModifyIndexChanged() {
        if (this.m_model.getModifyIndex() != null) {
            this.m_mdlModifyIndexes.setSelectedItem(this.m_model.getModifyIndex().getName());
        }
        this.setUpdatePanelVisible();
    }

    private class TableLoaderModelListener
    implements IModelListener {
        private TableLoaderModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!TableLoader42LoadTechniquePropertyTab.this.isListeningForChanges()) {
                return;
            }
            String type = ev.getType();
            if (type == "ModelController:UnknownChanges") {
                TableLoader42LoadTechniquePropertyTab.this.moveDataToView();
                return;
            }
            IObject object = ev.getModelObject();
            if (object != TableLoader42LoadTechniquePropertyTab.this.m_model) {
                return;
            }
            TableLoader42LoadTechniquePropertyTab.this.handleModelChanged(ev);
        }
    }

    private class cLoadStyleListener
    implements ActionListener {
        private cLoadStyleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbLoadStyle.getModel()).getSelectedValue();
            if (value.length() > 0) {
                TableLoader42LoadTechniquePropertyTab.this.m_model.setLoadStyle(value);
            }
        }
    }

    private class cReplaceTypeListener
    implements ActionListener {
        private cReplaceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String value;
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbReplaceType.getModel().getSize() > 0 && (value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbReplaceType.getModel()).getSelectedValue()).length() > 0) {
                TableLoader42LoadTechniquePropertyTab.this.m_model.setReplaceType(value);
            }
        }
    }

    private class cMatchingRowsListener
    implements ActionListener {
        private cMatchingRowsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String value;
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbMatchingRows.getModel().getSize() > 0 && (value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbMatchingRows.getModel()).getSelectedValue()).length() > 0) {
                TableLoader42LoadTechniquePropertyTab.this.m_model.setMatchingRows(value);
            }
        }
    }

    private class cNoMissingCheckListener
    implements ActionListener {
        private cNoMissingCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableLoader42LoadTechniquePropertyTab.this.m_model.setNoMissingCheck(TableLoader42LoadTechniquePropertyTab.this.m_chkNoMissingCheck.isSelected());
            TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
        }
    }

    private class cNewRowsListener
    implements ActionListener {
        private cNewRowsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbNewRows.getModel().getSize() > 0) {
                String value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbNewRows.getModel()).getSelectedValue();
                if (value.length() > 0) {
                    TableLoader42LoadTechniquePropertyTab.this.m_model.setNewRows(value);
                }
                TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cConstraintBeforeListener
    implements ActionListener {
        private cConstraintBeforeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbConstraintBefore.getModel().getSize() > 0) {
                String value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbConstraintBefore.getModel()).getSelectedValue();
                if (value.length() > 0) {
                    TableLoader42LoadTechniquePropertyTab.this.m_model.setConstraintBeforeValue(value);
                }
                TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cConstraintAfterListener
    implements ActionListener {
        private cConstraintAfterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbConstraintAfter.getModel().getSize() > 0) {
                String value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbConstraintAfter.getModel()).getSelectedValue();
                if (value.length() > 0) {
                    TableLoader42LoadTechniquePropertyTab.this.m_model.setConstraintAfterValue(value);
                }
                TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cIndexBeforeListener
    implements ActionListener {
        private cIndexBeforeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbIndexBefore.getModel().getSize() > 0) {
                String value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbIndexBefore.getModel()).getSelectedValue();
                if (value.length() > 0) {
                    TableLoader42LoadTechniquePropertyTab.this.m_model.setIndexBeforeValue(value);
                }
                TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cIndexAfterListener
    implements ActionListener {
        private cIndexAfterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbIndexAfter.getModel().getSize() > 0) {
                String value = ((NameValueComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbIndexAfter.getModel()).getSelectedValue();
                if (value.length() > 0) {
                    TableLoader42LoadTechniquePropertyTab.this.m_model.setIndexAfterValue(value);
                }
                TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cModifyIndexListener
    implements ActionListener {
        private cModifyIndexListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoader42LoadTechniquePropertyTab.this.m_cmbModifyIndex.getModel().getSize() > 0) {
                int iSelectedIndex = ((DefaultComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbModifyIndex.getModel()).getIndexOf(((DefaultComboBoxModel)TableLoader42LoadTechniquePropertyTab.this.m_cmbModifyIndex.getModel()).getSelectedItem());
                if (TableLoader42LoadTechniquePropertyTab.this.m_model.getAvailableIndexes().size() > 0) {
                    IIndex oSelectedIndex = (IIndex)TableLoader42LoadTechniquePropertyTab.this.m_model.getAvailableIndexes().get(iSelectedIndex);
                    TableLoader42LoadTechniquePropertyTab.this.m_model.setModifyIndex(oSelectedIndex);
                }
                TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cModifyIndexMatchFromTopListener
    implements ActionListener {
        private cModifyIndexMatchFromTopListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableLoader42LoadTechniquePropertyTab.this.m_model.setIndexUniqueValue(TableLoader42LoadTechniquePropertyTab.this.m_chkModifyIndexMatchFromTop.isSelected());
            TableLoader42LoadTechniquePropertyTab.this.setUpdatePanelVisible();
        }
    }

    private class cMatchColumnsDualListSelector
    extends DualListSelector {
        private cMatchColumnsDualListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            TableLoader42LoadTechniquePropertyTab.this.setListeningForChanges(false);
            List items = fromAdapter.getSelectedItems();
            super.transferItems(fromAdapter, toAdapter);
            try {
                TableLoader42LoadTechniquePropertyTab.this.m_model.getModel().startCompoundUndoable();
                for (int i = 0; i < items.size(); ++i) {
                    IColumn column = (IColumn)items.get(i);
                    if (fromAdapter == this.sourceAdapter) {
                        TableLoader42LoadTechniquePropertyTab.this.m_model.addMatchingColumn(column);
                        continue;
                    }
                    if (fromAdapter != this.targetAdapter) continue;
                    TableLoader42LoadTechniquePropertyTab.this.m_model.removeMatchingColumn(column);
                }
            }
            finally {
                TableLoader42LoadTechniquePropertyTab.this.m_model.getModel().endCompoundUndoable();
                TableLoader42LoadTechniquePropertyTab.this.setListeningForChanges(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            TableLoader42LoadTechniquePropertyTab.this.setListeningForChanges(false);
            List items = fromAdapter.getAllMoveableItems();
            super.transferAllItems(fromAdapter, toAdapter);
            try {
                TableLoader42LoadTechniquePropertyTab.this.m_model.getModel().startCompoundUndoable();
                for (int i = 0; i < items.size(); ++i) {
                    IColumn column = (IColumn)items.get(i);
                    if (fromAdapter == this.sourceAdapter) {
                        TableLoader42LoadTechniquePropertyTab.this.m_model.addMatchingColumn(column);
                        continue;
                    }
                    if (fromAdapter != this.targetAdapter) continue;
                    TableLoader42LoadTechniquePropertyTab.this.m_model.removeMatchingColumn(column);
                }
            }
            finally {
                TableLoader42LoadTechniquePropertyTab.this.m_model.getModel().endCompoundUndoable();
                TableLoader42LoadTechniquePropertyTab.this.setListeningForChanges(true);
            }
        }

        protected synchronized void moveTargetItem(boolean moveItemUp) {
            TableLoader42LoadTechniquePropertyTab.this.m_model.getModel().startCompoundUndoable();
            try {
                super.moveTargetItem(moveItemUp);
            }
            finally {
                TableLoader42LoadTechniquePropertyTab.this.m_model.getModel().endCompoundUndoable();
            }
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            WsCompoundIcon iconCompound = new WsCompoundIcon();
            iconCompound.setIconGap(1);
            IColumn icol = (IColumn)value;
            this.setText(icol.getName());
            int type = icol.getType();
            String sType = WsColumnMetadataUtil.getDataNumericType();
            if (type == 0) {
                sType = WsColumnMetadataUtil.getDataCharacterType();
            }
            iconCompound.addIcon(WsColumnMetadataUtil.getColumnTypeIcon((String)sType));
            if (iconCompound.getIconCount() == 0) {
                this.setIcon(null);
            } else {
                this.setIcon((Icon)iconCompound);
            }
            return this;
        }
    }

    private class cResetDefaultsAction
    extends WsAbstractAction {
        public cResetDefaultsAction() {
            super(m_bundle, "TableLoader.Reset");
        }

        public void actionPerformed(ActionEvent event) {
            TableLoader42LoadTechniquePropertyTab.this.resetToDefaultValues();
        }
    }
}

